/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.core.util;

import junit.framework.TestCase;
import org.teiid.core.CorePlugin;
import org.teiid.core.util.Assertion;

public class TestAssertion
extends TestCase {
    private static final String TEST_MESSAGE = "This is a test assertion message";

    public TestAssertion(String name) {
        super(name);
    }

    public void testAssertTrueboolean() {
        Assertion.assertTrue((boolean)true);
        try {
            Assertion.assertTrue((boolean)false);
            TestAssertion.fail();
        }
        catch (AssertionError e) {
            String msg = CorePlugin.Util.getString("Assertion.Assertion_failed");
            TestAssertion.assertEquals((String)msg, (String)((Throwable)((Object)e)).getMessage());
        }
    }

    public void testAssertTruebooleanString() {
        Assertion.assertTrue((boolean)true, (String)TEST_MESSAGE);
        try {
            Assertion.assertTrue((boolean)false, (String)TEST_MESSAGE);
            TestAssertion.fail();
        }
        catch (AssertionError e) {
            TestAssertion.assertEquals((String)TEST_MESSAGE, (String)((Throwable)((Object)e)).getMessage());
        }
    }

    public void testFailed() {
        try {
            Assertion.failed(null);
            TestAssertion.fail();
        }
        catch (AssertionError e) {
            TestAssertion.assertEquals((String)"null", (String)((Throwable)((Object)e)).getMessage());
        }
        try {
            Assertion.failed((String)TEST_MESSAGE);
            TestAssertion.fail();
        }
        catch (AssertionError e) {
            TestAssertion.assertEquals((String)TEST_MESSAGE, (String)((Throwable)((Object)e)).getMessage());
        }
    }

    public void testIsEqualbooleanboolean() {
        Assertion.isEqual((boolean)true, (boolean)true);
        Assertion.isEqual((boolean)false, (boolean)false);
        try {
            Assertion.isEqual((boolean)false, (boolean)true);
            TestAssertion.fail();
        }
        catch (AssertionError e) {
            Object[] params = new Object[]{new Boolean(false), new Boolean(true)};
            String msg = CorePlugin.Util.getString("Assertion.isEqual", params);
            TestAssertion.assertEquals((String)msg, (String)((Throwable)((Object)e)).getMessage());
        }
    }

    public void testIsEqualbooleanbooleanString() {
        Assertion.isEqual((boolean)true, (boolean)true, (String)TEST_MESSAGE);
        Assertion.isEqual((boolean)false, (boolean)false, (String)TEST_MESSAGE);
        try {
            Assertion.isEqual((boolean)false, (boolean)true, (String)TEST_MESSAGE);
            TestAssertion.fail();
        }
        catch (AssertionError e) {
            TestAssertion.assertEquals((String)TEST_MESSAGE, (String)((Throwable)((Object)e)).getMessage());
        }
    }

    public void testIsNotEqualbooleanboolean() {
        Assertion.isNotEqual((boolean)false, (boolean)true);
        Assertion.isNotEqual((boolean)true, (boolean)false);
        try {
            Assertion.isNotEqual((boolean)false, (boolean)false);
            TestAssertion.fail();
        }
        catch (AssertionError e) {
            Object[] params = new Object[]{new Boolean(false), new Boolean(false)};
            String msg = CorePlugin.Util.getString("Assertion.isNotEqual", params);
            TestAssertion.assertEquals((String)msg, (String)((Throwable)((Object)e)).getMessage());
        }
    }

    public void testIsNotEqualbooleanbooleanString() {
        Assertion.isNotEqual((boolean)false, (boolean)true, (String)TEST_MESSAGE);
        Assertion.isNotEqual((boolean)true, (boolean)false, (String)TEST_MESSAGE);
        try {
            Assertion.isNotEqual((boolean)false, (boolean)false, (String)TEST_MESSAGE);
            TestAssertion.fail();
        }
        catch (AssertionError e) {
            TestAssertion.assertEquals((String)TEST_MESSAGE, (String)((Throwable)((Object)e)).getMessage());
        }
    }

    public void testIsEqualintint() {
        Assertion.isEqual((int)-1, (int)-1);
        Assertion.isEqual((int)1, (int)1);
        Assertion.isEqual((int)0, (int)0);
        Assertion.isEqual((int)10000, (int)10000);
        try {
            Assertion.isEqual((int)1, (int)-1);
            TestAssertion.fail();
        }
        catch (AssertionError e) {
            Object[] params = new Object[]{new Integer(1), new Integer(-1)};
            String msg = CorePlugin.Util.getString("Assertion.isEqual", params);
            TestAssertion.assertEquals((String)msg, (String)((Throwable)((Object)e)).getMessage());
        }
    }

    public void testIsEqualintintString() {
        Assertion.isEqual((int)-1, (int)-1, (String)TEST_MESSAGE);
        Assertion.isEqual((int)1, (int)1, (String)TEST_MESSAGE);
        Assertion.isEqual((int)0, (int)0, (String)TEST_MESSAGE);
        Assertion.isEqual((int)10000, (int)10000, (String)TEST_MESSAGE);
        try {
            Assertion.isEqual((int)1, (int)-1, (String)TEST_MESSAGE);
            TestAssertion.fail();
        }
        catch (AssertionError e) {
            TestAssertion.assertEquals((String)TEST_MESSAGE, (String)((Throwable)((Object)e)).getMessage());
        }
    }

    public void testIsNotEqualintint() {
        Assertion.isNotEqual((int)-1, (int)-12);
        Assertion.isNotEqual((int)1, (int)-1);
        Assertion.isNotEqual((int)0, (int)1);
        Assertion.isNotEqual((int)10000, (int)-10000);
        try {
            Assertion.isNotEqual((int)1, (int)1);
            TestAssertion.fail();
        }
        catch (AssertionError e) {
            Object[] params = new Object[]{new Integer(1), new Integer(1)};
            String msg = CorePlugin.Util.getString("Assertion.isNotEqual", params);
            TestAssertion.assertEquals((String)msg, (String)((Throwable)((Object)e)).getMessage());
        }
    }

    public void testIsNotEqualintintString() {
        Assertion.isNotEqual((int)-1, (int)-12, (String)TEST_MESSAGE);
        Assertion.isNotEqual((int)1, (int)-1, (String)TEST_MESSAGE);
        Assertion.isNotEqual((int)0, (int)1, (String)TEST_MESSAGE);
        Assertion.isNotEqual((int)10000, (int)-10000, (String)TEST_MESSAGE);
        try {
            Assertion.isNotEqual((int)1, (int)1, (String)TEST_MESSAGE);
            TestAssertion.fail();
        }
        catch (AssertionError e) {
            TestAssertion.assertEquals((String)TEST_MESSAGE, (String)((Throwable)((Object)e)).getMessage());
        }
    }

    public void testIsNonNegativeint() {
        Assertion.isNonNegative((int)1);
        Assertion.isNonNegative((int)13);
        Assertion.isNonNegative((int)0);
        try {
            Assertion.isNonNegative((int)-1);
            TestAssertion.fail();
        }
        catch (AssertionError e) {
            Object[] params = new Object[]{new Integer(-1)};
            String msg = CorePlugin.Util.getString("Assertion.isNonNegative", params);
            TestAssertion.assertEquals((String)msg, (String)((Throwable)((Object)e)).getMessage());
        }
    }

    public void testIsNonNegativeintString() {
        Assertion.isNonNegative((int)1, (String)TEST_MESSAGE);
        Assertion.isNonNegative((int)13, (String)TEST_MESSAGE);
        Assertion.isNonNegative((int)0, (String)TEST_MESSAGE);
        try {
            Assertion.isNonNegative((int)-1, (String)TEST_MESSAGE);
            TestAssertion.fail();
        }
        catch (AssertionError e) {
            TestAssertion.assertEquals((String)TEST_MESSAGE, (String)((Throwable)((Object)e)).getMessage());
        }
    }

    public void testIsNonPositiveint() {
        Assertion.isNonPositive((int)-1);
        Assertion.isNonPositive((int)0);
        Assertion.isNonPositive((int)-100);
        try {
            Assertion.isNonPositive((int)1);
            TestAssertion.fail();
        }
        catch (AssertionError e) {
            Object[] params = new Object[]{new Integer(1)};
            String msg = CorePlugin.Util.getString("Assertion.isNonPositive", params);
            TestAssertion.assertEquals((String)msg, (String)((Throwable)((Object)e)).getMessage());
        }
    }

    public void testIsNonPositiveintString() {
        Assertion.isNonPositive((int)-1, (String)TEST_MESSAGE);
        Assertion.isNonPositive((int)0, (String)TEST_MESSAGE);
        Assertion.isNonPositive((int)-100, (String)TEST_MESSAGE);
        try {
            Assertion.isNonPositive((int)1, (String)TEST_MESSAGE);
            TestAssertion.fail();
        }
        catch (AssertionError e) {
            TestAssertion.assertEquals((String)TEST_MESSAGE, (String)((Throwable)((Object)e)).getMessage());
        }
    }

    public void testIsNegativeint() {
        String msg;
        Object[] params;
        Assertion.isNegative((int)-1);
        Assertion.isNegative((int)-100);
        try {
            Assertion.isNegative((int)1);
            TestAssertion.fail();
        }
        catch (AssertionError e) {
            params = new Object[]{new Integer(1)};
            msg = CorePlugin.Util.getString("Assertion.isNegative", params);
            TestAssertion.assertEquals((String)msg, (String)((Throwable)((Object)e)).getMessage());
        }
        try {
            Assertion.isNegative((int)0);
            TestAssertion.fail();
        }
        catch (AssertionError e) {
            params = new Object[]{new Integer(0)};
            msg = CorePlugin.Util.getString("Assertion.isNegative", params);
            TestAssertion.assertEquals((String)msg, (String)((Throwable)((Object)e)).getMessage());
        }
    }

    public void testIsNegativeintString() {
        Assertion.isNegative((int)-1, (String)TEST_MESSAGE);
        Assertion.isNegative((int)-100, (String)TEST_MESSAGE);
        try {
            Assertion.isNegative((int)1, (String)TEST_MESSAGE);
            TestAssertion.fail();
        }
        catch (AssertionError e) {
            TestAssertion.assertEquals((String)TEST_MESSAGE, (String)((Throwable)((Object)e)).getMessage());
        }
        try {
            Assertion.isNegative((int)0, (String)TEST_MESSAGE);
            TestAssertion.fail();
        }
        catch (AssertionError e) {
            TestAssertion.assertEquals((String)TEST_MESSAGE, (String)((Throwable)((Object)e)).getMessage());
        }
    }

    public void testIsPositiveint() {
        String msg;
        Object[] params;
        Assertion.isPositive((int)1);
        Assertion.isPositive((int)100);
        try {
            Assertion.isPositive((int)-1);
            TestAssertion.fail();
        }
        catch (AssertionError e) {
            params = new Object[]{new Integer(-1)};
            msg = CorePlugin.Util.getString("Assertion.isPositive", params);
            TestAssertion.assertEquals((String)msg, (String)((Throwable)((Object)e)).getMessage());
        }
        try {
            Assertion.isPositive((int)0);
            TestAssertion.fail();
        }
        catch (AssertionError e) {
            params = new Object[]{new Integer(0)};
            msg = CorePlugin.Util.getString("Assertion.isPositive", params);
            TestAssertion.assertEquals((String)msg, (String)((Throwable)((Object)e)).getMessage());
        }
    }

    public void testIsPositiveintString() {
        Assertion.isPositive((int)1, (String)TEST_MESSAGE);
        Assertion.isPositive((int)100, (String)TEST_MESSAGE);
        try {
            Assertion.isPositive((int)-1, (String)TEST_MESSAGE);
            TestAssertion.fail();
        }
        catch (AssertionError e) {
            TestAssertion.assertEquals((String)TEST_MESSAGE, (String)((Throwable)((Object)e)).getMessage());
        }
        try {
            Assertion.isPositive((int)0, (String)TEST_MESSAGE);
            TestAssertion.fail();
        }
        catch (AssertionError e) {
            TestAssertion.assertEquals((String)TEST_MESSAGE, (String)((Throwable)((Object)e)).getMessage());
        }
    }

    public void testIsEquallonglong() {
        Assertion.isEqual((long)-1L, (long)-1L);
        Assertion.isEqual((long)1L, (long)1L);
        Assertion.isEqual((long)0L, (long)0L);
        Assertion.isEqual((long)10000L, (long)10000L);
        try {
            Assertion.isEqual((long)1L, (long)-1L);
            TestAssertion.fail();
        }
        catch (AssertionError e) {
            Object[] params = new Object[]{new Long(1L), new Long(-1L)};
            String msg = CorePlugin.Util.getString("Assertion.isEqual", params);
            TestAssertion.assertEquals((String)msg, (String)((Throwable)((Object)e)).getMessage());
        }
    }

    public void testIsEquallonglongString() {
        Assertion.isEqual((long)-1L, (long)-1L, (String)TEST_MESSAGE);
        Assertion.isEqual((long)1L, (long)1L, (String)TEST_MESSAGE);
        Assertion.isEqual((long)0L, (long)0L, (String)TEST_MESSAGE);
        Assertion.isEqual((long)10000L, (long)10000L, (String)TEST_MESSAGE);
        try {
            Assertion.isEqual((long)1L, (long)-1L, (String)TEST_MESSAGE);
            TestAssertion.fail();
        }
        catch (AssertionError e) {
            TestAssertion.assertEquals((String)TEST_MESSAGE, (String)((Throwable)((Object)e)).getMessage());
        }
    }

    public void testIsNotEquallonglong() {
        Assertion.isNotEqual((long)-1L, (long)-12L);
        Assertion.isNotEqual((long)1L, (long)12L);
        Assertion.isNotEqual((long)0L, (long)-20L);
        Assertion.isNotEqual((long)10000L, (long)-10000L);
        try {
            Assertion.isNotEqual((long)1L, (long)1L);
            TestAssertion.fail();
        }
        catch (AssertionError e) {
            Object[] params = new Object[]{new Long(1L), new Long(1L)};
            String msg = CorePlugin.Util.getString("Assertion.isNotEqual", params);
            TestAssertion.assertEquals((String)msg, (String)((Throwable)((Object)e)).getMessage());
        }
    }

    public void testIsNotEquallonglongString() {
        Assertion.isNotEqual((long)-1L, (long)-12L, (String)TEST_MESSAGE);
        Assertion.isNotEqual((long)1L, (long)12L, (String)TEST_MESSAGE);
        Assertion.isNotEqual((long)0L, (long)-20L, (String)TEST_MESSAGE);
        Assertion.isNotEqual((long)10000L, (long)-10000L, (String)TEST_MESSAGE);
        try {
            Assertion.isNotEqual((long)1L, (long)1L, (String)TEST_MESSAGE);
            TestAssertion.fail();
        }
        catch (AssertionError e) {
            TestAssertion.assertEquals((String)TEST_MESSAGE, (String)((Throwable)((Object)e)).getMessage());
        }
    }

    public void testIsNonNegativelong() {
        Assertion.isNonNegative((long)1L);
        Assertion.isNonNegative((long)13L);
        Assertion.isNonNegative((long)0L);
        try {
            Assertion.isNonNegative((long)-1L);
            TestAssertion.fail();
        }
        catch (AssertionError e) {
            Object[] params = new Object[]{new Long(-1L)};
            String msg = CorePlugin.Util.getString("Assertion.isNonNegative", params);
            TestAssertion.assertEquals((String)msg, (String)((Throwable)((Object)e)).getMessage());
        }
    }

    public void testIsNonNegativelongString() {
        Assertion.isNonNegative((long)1L, (String)TEST_MESSAGE);
        Assertion.isNonNegative((long)13L, (String)TEST_MESSAGE);
        Assertion.isNonNegative((long)0L, (String)TEST_MESSAGE);
        try {
            Assertion.isNonNegative((long)-1L, (String)TEST_MESSAGE);
            TestAssertion.fail();
        }
        catch (AssertionError e) {
            TestAssertion.assertEquals((String)TEST_MESSAGE, (String)((Throwable)((Object)e)).getMessage());
        }
    }

    public void testIsNonPositivelong() {
        Assertion.isNonPositive((long)-1L);
        Assertion.isNonPositive((long)0L);
        Assertion.isNonPositive((long)-100L);
        try {
            Assertion.isNonPositive((long)1L);
            TestAssertion.fail();
        }
        catch (AssertionError e) {
            Object[] params = new Object[]{new Long(1L)};
            String msg = CorePlugin.Util.getString("Assertion.isNonPositive", params);
            TestAssertion.assertEquals((String)msg, (String)((Throwable)((Object)e)).getMessage());
        }
    }

    public void testIsNonPositivelongString() {
        Assertion.isNonPositive((long)-1L, (String)TEST_MESSAGE);
        Assertion.isNonPositive((long)0L, (String)TEST_MESSAGE);
        Assertion.isNonPositive((long)-100L, (String)TEST_MESSAGE);
        try {
            Assertion.isNonPositive((long)1L, (String)TEST_MESSAGE);
            TestAssertion.fail();
        }
        catch (AssertionError e) {
            TestAssertion.assertEquals((String)TEST_MESSAGE, (String)((Throwable)((Object)e)).getMessage());
        }
    }

    public void testIsNegativelong() {
        String msg;
        Object[] params;
        Assertion.isNegative((long)-1L);
        Assertion.isNegative((long)-100L);
        try {
            Assertion.isNegative((long)1L);
            TestAssertion.fail();
        }
        catch (AssertionError e) {
            params = new Object[]{new Long(1L)};
            msg = CorePlugin.Util.getString("Assertion.isNegative", params);
            TestAssertion.assertEquals((String)msg, (String)((Throwable)((Object)e)).getMessage());
        }
        try {
            Assertion.isNegative((long)0L);
            TestAssertion.fail();
        }
        catch (AssertionError e) {
            params = new Object[]{new Long(0L)};
            msg = CorePlugin.Util.getString("Assertion.isNegative", params);
            TestAssertion.assertEquals((String)msg, (String)((Throwable)((Object)e)).getMessage());
        }
    }

    public void testIsNegativelongString() {
        Assertion.isNegative((long)-1L, (String)TEST_MESSAGE);
        Assertion.isNegative((long)-100L, (String)TEST_MESSAGE);
        try {
            Assertion.isNegative((long)1L, (String)TEST_MESSAGE);
            TestAssertion.fail();
        }
        catch (AssertionError e) {
            TestAssertion.assertEquals((String)TEST_MESSAGE, (String)((Throwable)((Object)e)).getMessage());
        }
        try {
            Assertion.isNegative((long)0L, (String)TEST_MESSAGE);
            TestAssertion.fail();
        }
        catch (AssertionError e) {
            TestAssertion.assertEquals((String)TEST_MESSAGE, (String)((Throwable)((Object)e)).getMessage());
        }
    }

    public void testIsPositivelong() {
        String msg;
        Object[] params;
        Assertion.isPositive((long)1L);
        Assertion.isPositive((long)100L);
        try {
            Assertion.isPositive((long)-1L);
            TestAssertion.fail();
        }
        catch (AssertionError e) {
            params = new Object[]{new Long(-1L)};
            msg = CorePlugin.Util.getString("Assertion.isPositive", params);
            TestAssertion.assertEquals((String)msg, (String)((Throwable)((Object)e)).getMessage());
        }
        try {
            Assertion.isPositive((long)0L);
            TestAssertion.fail();
        }
        catch (AssertionError e) {
            params = new Object[]{new Long(0L)};
            msg = CorePlugin.Util.getString("Assertion.isPositive", params);
            TestAssertion.assertEquals((String)msg, (String)((Throwable)((Object)e)).getMessage());
        }
    }

    public void testIsPositivelongString() {
        Assertion.isPositive((long)1L, (String)TEST_MESSAGE);
        Assertion.isPositive((long)100L, (String)TEST_MESSAGE);
        try {
            Assertion.isPositive((long)-1L, (String)TEST_MESSAGE);
            TestAssertion.fail();
        }
        catch (AssertionError e) {
            TestAssertion.assertEquals((String)TEST_MESSAGE, (String)((Throwable)((Object)e)).getMessage());
        }
        try {
            Assertion.isPositive((long)0L, (String)TEST_MESSAGE);
            TestAssertion.fail();
        }
        catch (AssertionError e) {
            TestAssertion.assertEquals((String)TEST_MESSAGE, (String)((Throwable)((Object)e)).getMessage());
        }
    }

    public void testIsNotZeroLengthString() {
        String msg;
        Assertion.isNotZeroLength((String)"This is a string");
        Assertion.isNotZeroLength((String)"   ");
        try {
            Assertion.isNotZeroLength((String)"");
            TestAssertion.fail();
        }
        catch (AssertionError e) {
            msg = CorePlugin.Util.getString("Assertion.isNotZeroLength");
            TestAssertion.assertEquals((String)msg, (String)((Throwable)((Object)e)).getMessage());
        }
        try {
            Assertion.isNotZeroLength(null);
            TestAssertion.fail();
        }
        catch (AssertionError e) {
            msg = CorePlugin.Util.getString("Assertion.isNotNull");
            TestAssertion.assertEquals((String)msg, (String)((Throwable)((Object)e)).getMessage());
        }
    }

    public void testIsNotZeroLengthStringString() {
        Assertion.isNotZeroLength((String)"This is a string", (String)TEST_MESSAGE);
        Assertion.isNotZeroLength((String)"   ", (String)TEST_MESSAGE);
        try {
            Assertion.isNotZeroLength((String)"", (String)TEST_MESSAGE);
            TestAssertion.fail();
        }
        catch (AssertionError e) {
            TestAssertion.assertEquals((String)TEST_MESSAGE, (String)((Throwable)((Object)e)).getMessage());
        }
        try {
            Assertion.isNotZeroLength(null, (String)TEST_MESSAGE);
            TestAssertion.fail();
        }
        catch (AssertionError e) {
            String msg = CorePlugin.Util.getString("Assertion.isNotNull");
            TestAssertion.assertEquals((String)msg, (String)((Throwable)((Object)e)).getMessage());
        }
    }

    public void testIsNullObject() {
        Assertion.isNull(null);
        try {
            Assertion.isNull((Object)"");
            TestAssertion.fail();
        }
        catch (AssertionError e) {
            String msg = CorePlugin.Util.getString("Assertion.isNull");
            TestAssertion.assertEquals((String)msg, (String)((Throwable)((Object)e)).getMessage());
        }
    }

    public void testIsNullObjectString() {
        Assertion.isNull(null, (String)TEST_MESSAGE);
        try {
            Assertion.isNull((Object)"", (String)TEST_MESSAGE);
            TestAssertion.fail();
        }
        catch (AssertionError e) {
            TestAssertion.assertEquals((String)TEST_MESSAGE, (String)((Throwable)((Object)e)).getMessage());
        }
    }

    public void testIsNotNullObject() {
        Assertion.isNotNull((Object)"");
        try {
            Assertion.isNotNull(null);
            TestAssertion.fail();
        }
        catch (AssertionError e) {
            String msg = CorePlugin.Util.getString("Assertion.isNotNull");
            TestAssertion.assertEquals((String)msg, (String)((Throwable)((Object)e)).getMessage());
        }
    }

    public void testIsNotNullObjectString() {
        Assertion.isNotNull((Object)"", (String)TEST_MESSAGE);
        try {
            Assertion.isNotNull(null, (String)TEST_MESSAGE);
            TestAssertion.fail();
        }
        catch (AssertionError e) {
            TestAssertion.assertEquals((String)TEST_MESSAGE, (String)((Throwable)((Object)e)).getMessage());
        }
    }

    public void testIsIdenticalObjectObject() {
        String obj1 = "";
        Integer int1 = new Integer(33);
        Assertion.isIdentical((Object)"", (Object)"");
        Assertion.isIdentical((Object)int1, (Object)int1);
        try {
            Assertion.isIdentical((Object)int1, (Object)"");
            TestAssertion.fail();
        }
        catch (AssertionError e) {
            Object[] params = new Object[]{int1, ""};
            String msg = CorePlugin.Util.getString("Assertion.isIdentical", params);
            TestAssertion.assertEquals((String)msg, (String)((Throwable)((Object)e)).getMessage());
        }
    }

    public void testIsIdenticalObjectObjectString() {
        String obj1 = "";
        Integer int1 = new Integer(33);
        Assertion.isIdentical((Object)"", (Object)"", (String)TEST_MESSAGE);
        Assertion.isIdentical((Object)int1, (Object)int1, (String)TEST_MESSAGE);
        try {
            Assertion.isIdentical((Object)int1, (Object)"", (String)TEST_MESSAGE);
            TestAssertion.fail();
        }
        catch (AssertionError e) {
            TestAssertion.assertEquals((String)TEST_MESSAGE, (String)((Throwable)((Object)e)).getMessage());
        }
    }

    public void testIsEqualObjectObject() {
        String obj1 = "";
        String obj2 = "";
        Integer int1 = new Integer(33);
        Integer int2 = new Integer(33);
        Assertion.isEqual((Object)"", (Object)"");
        Assertion.isEqual((Object)int1, (Object)int2);
        try {
            Assertion.isEqual((Object)int1, (Object)"");
            TestAssertion.fail();
        }
        catch (AssertionError e) {
            Object[] params = new Object[]{int1, ""};
            String msg = CorePlugin.Util.getString("Assertion.isEqual", params);
            TestAssertion.assertEquals((String)msg, (String)((Throwable)((Object)e)).getMessage());
        }
    }

    public void testIsEqualObjectObjectString() {
        String obj1 = "";
        String obj2 = "";
        Integer int1 = new Integer(33);
        Integer int2 = new Integer(33);
        Assertion.isEqual((Object)"", (Object)"", (String)TEST_MESSAGE);
        Assertion.isEqual((Object)int1, (Object)int2, (String)TEST_MESSAGE);
        try {
            Assertion.isEqual((Object)int1, (Object)"", (String)TEST_MESSAGE);
            TestAssertion.fail();
        }
        catch (AssertionError e) {
            TestAssertion.assertEquals((String)TEST_MESSAGE, (String)((Throwable)((Object)e)).getMessage());
        }
    }

    public void testIsInstanceOf() {
        Assertion.isInstanceOf((Object)new Integer(1), Integer.class, (String)"name");
        Assertion.isInstanceOf((Object)"asdfasdf", String.class, (String)"name2");
        try {
            Assertion.isInstanceOf((Object)new Integer(1), Long.class, (String)"name3");
            TestAssertion.fail();
        }
        catch (ClassCastException e) {
            Object[] params = new Object[]{"name3", Long.class, Integer.class.getName()};
            String msg = CorePlugin.Util.getString("Assertion.invalidClassMessage", params);
            TestAssertion.assertEquals((String)msg, (String)e.getMessage());
        }
    }

    public void testIsNotEmptyCollection() {
    }

    public void testIsNotEmptyCollectionString() {
    }

    public void testIsNotEmptyMap() {
    }

    public void testIsNotEmptyMapString() {
    }

    public void testContainsCollectionObject() {
    }

    public void testContainsCollectionObjectString() {
    }

    public void testContainsKeyMapObject() {
    }

    public void testContainsKeyMapObjectString() {
    }
}

