/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.core.util;

import java.io.FileInputStream;
import java.io.FileReader;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.Charset;
import org.junit.Assert;
import org.junit.Test;
import org.teiid.core.util.ReaderInputStream;
import org.teiid.core.util.UnitTestUtil;

public class TestReaderInputStream {
    @Test
    public void testUTF8() throws Exception {
        int value;
        FileInputStream fis = new FileInputStream(UnitTestUtil.getTestDataFile("legal_notice.xml"));
        ReaderInputStream ris = new ReaderInputStream((Reader)new FileReader(UnitTestUtil.getTestDataFile("legal_notice.xml")), Charset.forName("UTF-8"));
        do {
            value = fis.read();
            Assert.assertEquals((long)value, (long)ris.read());
        } while (value != -1);
    }

    @Test
    public void testUTF16() throws Exception {
        String actual = "!?abc";
        ReaderInputStream ris = new ReaderInputStream((Reader)new StringReader(actual), Charset.forName("UTF-16"), 1);
        byte[] result = new byte[actual.length() * 2 + 2];
        ris.read(result);
        String resultString = new String(result, "UTF-16");
        Assert.assertEquals((Object)resultString, (Object)actual);
    }

    @Test
    public void testASCII() throws Exception {
        String actual = "!?abc";
        ReaderInputStream ris = new ReaderInputStream((Reader)new StringReader(actual), Charset.forName("US-ASCII"), 1);
        byte[] result = new byte[actual.length()];
        ris.read(result);
        String resultString = new String(result, "US-ASCII");
        Assert.assertEquals((Object)resultString, (Object)actual);
    }
}

