/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.unittest;

import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.TimeZone;

public class TimestampUtil {
    private static ThreadLocal<Calendar> CAL = new ThreadLocal<Calendar>(){

        @Override
        protected Calendar initialValue() {
            return Calendar.getInstance();
        }
    };

    public static Timestamp createTimestamp(int year, int month, int date, int hour, int minute, int second, int nano) {
        TimestampUtil.primeCalendar();
        CAL.get().set(year + 1900, month, date, hour, minute, second);
        long millis = CAL.get().getTime().getTime();
        Timestamp ts = new Timestamp(millis);
        ts.setNanos(nano);
        return ts;
    }

    public static Date createDate(int year, int month, int date) {
        TimestampUtil.primeCalendar();
        CAL.get().set(year + 1900, month, date);
        return new Date(CAL.get().getTime().getTime());
    }

    public static Time createTime(int hour, int minute, int second) {
        TimestampUtil.primeCalendar();
        CAL.get().set(11, hour);
        CAL.get().set(12, minute);
        CAL.get().set(13, second);
        return new Time(CAL.get().getTime().getTime());
    }

    private static void primeCalendar() {
        CAL.get().setTimeZone(TimeZone.getDefault());
        CAL.get().clear();
    }
}

