/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.connector.metadata.runtime;

import java.util.Properties;
import junit.framework.TestCase;
import org.mockito.Mockito;
import org.teiid.language.Call;
import org.teiid.language.ColumnReference;
import org.teiid.language.DerivedColumn;
import org.teiid.language.NamedTable;
import org.teiid.language.QueryExpression;
import org.teiid.metadata.BaseColumn;
import org.teiid.metadata.Column;
import org.teiid.metadata.Procedure;
import org.teiid.metadata.RuntimeMetadata;
import org.teiid.metadata.Table;
import org.teiid.translator.ExecutionContext;
import org.teiid.translator.ExecutionFactory;
import org.teiid.translator.ProcedureExecution;
import org.teiid.translator.ResultSetExecution;
import org.teiid.translator.TranslatorException;

public class MockConnector
extends ExecutionFactory<Object, Object> {
    public ProcedureExecution createProcedureExecution(Call procedure, ExecutionContext executionContext, RuntimeMetadata metadata, Object connection) throws TranslatorException {
        Properties props = new Properties();
        props.setProperty("customBehaviour", "SkipExecute");
        Procedure metaObject = procedure.getMetadataObject();
        TestCase.assertEquals((String)"AnyModel.ProcedureB", (String)procedure.getProcedureName());
        TestCase.assertEquals((String)"PROC", (String)metaObject.getNameInSource());
        TestCase.assertEquals((Object)props, (Object)metaObject.getProperties());
        ProcedureExecution exec = (ProcedureExecution)Mockito.mock(ProcedureExecution.class);
        Mockito.stub((Object)exec.next()).toReturn(null);
        return exec;
    }

    public ResultSetExecution createResultSetExecution(QueryExpression query, ExecutionContext executionContext, RuntimeMetadata metadata, Object connection) throws TranslatorException {
        Properties groupProps = new Properties();
        groupProps.setProperty("customName", "CustomTableA");
        NamedTable group = (NamedTable)query.getProjectedQuery().getFrom().get(0);
        Table groupMD = group.getMetadataObject();
        TestCase.assertEquals((Object)groupProps, (Object)groupMD.getProperties());
        DerivedColumn symbl = (DerivedColumn)query.getProjectedQuery().getDerivedColumns().get(0);
        ColumnReference element = (ColumnReference)symbl.getExpression();
        Column elementMD = element.getMetadataObject();
        Properties elementProps = new Properties();
        elementProps.setProperty("customPosition", "11");
        TestCase.assertEquals((int)0, (int)elementMD.getLength());
        TestCase.assertEquals((String)"Foo", (String)elementMD.getDefaultValue());
        TestCase.assertEquals((String)"TrimNulls", (String)elementMD.getFormat());
        TestCase.assertEquals(String.class, (Object)elementMD.getJavaType());
        TestCase.assertEquals(null, (String)elementMD.getMaximumValue());
        TestCase.assertEquals(null, (String)elementMD.getMinimumValue());
        TestCase.assertEquals((String)"http://www.w3.org/2001/XMLSchema#anySimpleType", (String)elementMD.getBaseTypeID());
        TestCase.assertEquals((String)"http://www.w3.org/2001/XMLSchema#string", (String)elementMD.getPrimitiveTypeID());
        TestCase.assertEquals((String)"http://www.w3.org/2001/XMLSchema#string", (String)elementMD.getDatatypeID());
        TestCase.assertEquals((String)"COLUMN1", (String)elementMD.getNameInSource());
        TestCase.assertEquals((String)"STR", (String)elementMD.getNativeType());
        TestCase.assertEquals((Object)BaseColumn.NullType.Nullable, (Object)elementMD.getNullType());
        TestCase.assertEquals((int)0, (int)elementMD.getPosition());
        TestCase.assertEquals((int)0, (int)elementMD.getPrecision());
        TestCase.assertEquals((int)0, (int)elementMD.getScale());
        TestCase.assertEquals((Object)Column.SearchType.Searchable, (Object)elementMD.getSearchType());
        TestCase.assertEquals((boolean)false, (boolean)elementMD.isAutoIncremented());
        TestCase.assertEquals((boolean)true, (boolean)elementMD.isCaseSensitive());
        TestCase.assertEquals((Object)elementProps, (Object)elementMD.getProperties());
        DerivedColumn symbl2 = (DerivedColumn)query.getProjectedQuery().getDerivedColumns().get(1);
        ColumnReference element2 = (ColumnReference)symbl2.getExpression();
        Column elementMD2 = element2.getMetadataObject();
        Properties elementProps2 = new Properties();
        elementProps2.setProperty("customPosition", "12");
        TestCase.assertEquals((int)10, (int)elementMD2.getLength());
        TestCase.assertEquals((String)"23", (String)elementMD2.getDefaultValue());
        TestCase.assertEquals((String)"YesFormat", (String)elementMD2.getFormat());
        TestCase.assertEquals(Integer.class, (Object)elementMD2.getJavaType());
        TestCase.assertEquals((String)"1", (String)elementMD2.getMaximumValue());
        TestCase.assertEquals((String)"100", (String)elementMD2.getMinimumValue());
        TestCase.assertEquals((String)"http://www.w3.org/2001/XMLSchema#long", (String)elementMD2.getBaseTypeID());
        TestCase.assertEquals((String)"http://www.w3.org/2001/XMLSchema#decimal", (String)elementMD2.getPrimitiveTypeID());
        TestCase.assertEquals((String)"http://www.w3.org/2001/XMLSchema#int", (String)elementMD2.getDatatypeID());
        TestCase.assertEquals((String)"COLUMN2", (String)elementMD2.getNameInSource());
        TestCase.assertEquals((String)"INT", (String)elementMD2.getNativeType());
        TestCase.assertEquals((Object)BaseColumn.NullType.No_Nulls, (Object)elementMD2.getNullType());
        TestCase.assertEquals((int)1, (int)elementMD2.getPosition());
        TestCase.assertEquals((int)0, (int)elementMD2.getPrecision());
        TestCase.assertEquals((int)10, (int)elementMD2.getScale());
        TestCase.assertEquals((Object)Column.SearchType.Searchable, (Object)elementMD2.getSearchType());
        TestCase.assertEquals((boolean)true, (boolean)elementMD2.isAutoIncremented());
        TestCase.assertEquals((boolean)false, (boolean)elementMD2.isCaseSensitive());
        TestCase.assertEquals((Object)elementProps2, (Object)elementMD2.getProperties());
        ResultSetExecution exec = (ResultSetExecution)Mockito.mock(ResultSetExecution.class);
        Mockito.stub((Object)exec.next()).toReturn(null);
        return exec;
    }
}

