/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.connector.metadata.runtime;

import java.util.List;
import junit.framework.TestCase;
import org.teiid.cdk.api.TranslationUtility;
import org.teiid.core.util.UnitTestUtil;
import org.teiid.language.Call;
import org.teiid.language.ColumnReference;
import org.teiid.language.DerivedColumn;
import org.teiid.language.NamedTable;
import org.teiid.language.Select;
import org.teiid.metadata.Column;
import org.teiid.metadata.Procedure;
import org.teiid.metadata.ProcedureParameter;
import org.teiid.metadata.Table;

public class TestMetadataObject
extends TestCase {
    private static TranslationUtility CONNECTOR_METADATA_UTILITY = TestMetadataObject.createTranslationUtility(TestMetadataObject.getTestVDBName());

    public TestMetadataObject(String name) {
        super(name);
    }

    private static String getTestVDBName() {
        return UnitTestUtil.getTestDataPath() + "/ConnectorMetadata.vdb";
    }

    public static TranslationUtility createTranslationUtility(String vdbName) {
        return new TranslationUtility(vdbName);
    }

    public Table getGroupID(String groupName, TranslationUtility transUtil) {
        Select query = (Select)transUtil.parseCommand("SELECT 1 FROM " + groupName);
        NamedTable group = (NamedTable)query.getFrom().get(0);
        return group.getMetadataObject();
    }

    public void helpTestGroupID(String fullGroupName, String shortGroupName, int elementCount, TranslationUtility transUtil) throws Exception {
        Table groupID = this.getGroupID(fullGroupName, transUtil);
        TestMetadataObject.assertEquals((String)fullGroupName, (String)groupID.getFullName());
        TestMetadataObject.assertEquals((String)shortGroupName, (String)groupID.getName());
        List children = groupID.getColumns();
        TestMetadataObject.assertEquals((int)elementCount, (int)children.size());
        for (Column element : children) {
            TestMetadataObject.assertEquals((Object)groupID, (Object)element.getParent());
            TestMetadataObject.assertTrue((boolean)element.getFullName().startsWith(groupID.getFullName()));
        }
    }

    public void testGroupID() throws Exception {
        this.helpTestGroupID("ConnectorMetadata.TestTable", "TestTable", 7, CONNECTOR_METADATA_UTILITY);
    }

    public void testGroupID_longName() throws Exception {
        this.helpTestGroupID("ConnectorMetadata.TestCatalog.TestSchema.TestTable2", "TestCatalog.TestSchema.TestTable2", 1, CONNECTOR_METADATA_UTILITY);
    }

    public Column getElementID(String groupName, String elementName, TranslationUtility transUtil) {
        Select query = (Select)transUtil.parseCommand("SELECT " + elementName + " FROM " + groupName);
        DerivedColumn symbol = (DerivedColumn)query.getDerivedColumns().get(0);
        ColumnReference element = (ColumnReference)symbol.getExpression();
        return element.getMetadataObject();
    }

    public void helpTestElementID(String groupName, String elementName, TranslationUtility transUtil) throws Exception {
        Column elementID = this.getElementID(groupName, elementName, transUtil);
        TestMetadataObject.assertEquals((String)(groupName + "." + elementName), (String)elementID.getFullName());
        TestMetadataObject.assertEquals((String)elementName, (String)elementID.getName());
        TestMetadataObject.assertNotNull((Object)elementID.getParent());
        TestMetadataObject.assertEquals((String)groupName, (String)elementID.getParent().getFullName());
    }

    public void testElementID() throws Exception {
        this.helpTestElementID("ConnectorMetadata.TestTable", "TestNameInSource", CONNECTOR_METADATA_UTILITY);
    }

    public void testElementID_longName() throws Exception {
        this.helpTestElementID("ConnectorMetadata.TestCatalog.TestSchema.TestTable2", "TestCol", CONNECTOR_METADATA_UTILITY);
    }

    public Procedure getProcedureID(String procName, int inputParamCount, TranslationUtility transUtil) {
        StringBuffer sql = new StringBuffer("EXEC ");
        sql.append(procName);
        sql.append("(");
        for (int i = 0; i < inputParamCount; ++i) {
            sql.append("null");
            if (i >= inputParamCount - 1) continue;
            sql.append(", ");
        }
        sql.append(")");
        Call proc = (Call)transUtil.parseCommand(sql.toString());
        return proc.getMetadataObject();
    }

    public void helpTestProcedureID(String procName, String shortName, int inputParamCount, String[] paramNames, String rsParamName, TranslationUtility transUtil) throws Exception {
        Procedure procID = this.getProcedureID(procName, inputParamCount, transUtil);
        TestMetadataObject.assertEquals((String)procName, (String)procID.getFullName());
        TestMetadataObject.assertEquals((String)shortName, (String)procID.getName());
        List children = procID.getParameters();
        int i = 0;
        for (ProcedureParameter childID : children) {
            TestMetadataObject.assertEquals((Object)procID, (Object)childID.getParent());
            TestMetadataObject.assertTrue((String)(childID.getFullName() + " " + procID.getFullName()), (boolean)childID.getFullName().startsWith(procID.getFullName()));
            TestMetadataObject.assertEquals((String)paramNames[i++], (String)childID.getName());
        }
        if (rsParamName != null) {
            TestMetadataObject.assertEquals((String)rsParamName, (String)procID.getResultSet().getName());
        } else {
            TestMetadataObject.assertNull((Object)procID.getResultSet());
        }
    }

    public void testProcedureID() throws Exception {
        String[] paramNames = new String[]{"InParam", "OutParam", "InOutParam", "ReturnParam"};
        this.helpTestProcedureID("ConnectorMetadata.TestProc1", "TestProc1", 2, paramNames, null, CONNECTOR_METADATA_UTILITY);
    }

    public void testProcedureID_resultSet() throws Exception {
        String[] paramNames = new String[]{"Param1"};
        this.helpTestProcedureID("ConnectorMetadata.TestProc2", "TestProc2", 1, paramNames, "RSParam", CONNECTOR_METADATA_UTILITY);
    }

    public void testProcedureID_longName() throws Exception {
        this.helpTestProcedureID("ConnectorMetadata.TestCatalog.TestSchema.TestProc", "TestCatalog.TestSchema.TestProc", 0, new String[0], null, CONNECTOR_METADATA_UTILITY);
    }
}

