/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.dqp.internal.process;

import java.util.List;
import junit.framework.TestCase;
import org.teiid.dqp.message.RequestID;
import org.teiid.metadata.TransformationMetadata;
import org.teiid.metadata.index.VDBMetadataFactory;
import org.teiid.query.analysis.AnalysisRecord;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.optimizer.QueryOptimizer;
import org.teiid.query.optimizer.TestOptimizer;
import org.teiid.query.optimizer.capabilities.CapabilitiesFinder;
import org.teiid.query.processor.ProcessorDataManager;
import org.teiid.query.processor.ProcessorPlan;
import org.teiid.query.processor.TestProcessor;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.util.CommandContext;

public abstract class BaseQueryTest
extends TestCase {
    public BaseQueryTest(String name) {
        super(name);
    }

    public static TransformationMetadata createMetadata(String vdbFile) {
        return VDBMetadataFactory.getVDBMetadata((String)vdbFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doProcess(QueryMetadataInterface metadata, String sql, CapabilitiesFinder capFinder, ProcessorDataManager dataManager, List[] expectedResults, boolean debug) throws Exception {
        CommandContext context = this.createCommandContext();
        context.setProcessDebug(debug);
        Command command = TestOptimizer.helpGetCommand((String)sql, (QueryMetadataInterface)metadata, null);
        AnalysisRecord analysisRecord = new AnalysisRecord(false, debug);
        ProcessorPlan plan = null;
        try {
            plan = QueryOptimizer.optimizePlan((Command)command, (QueryMetadataInterface)metadata, null, (CapabilitiesFinder)capFinder, (AnalysisRecord)analysisRecord, (CommandContext)this.createCommandContext());
        }
        finally {
            if (debug) {
                System.out.println(analysisRecord.getDebugLog());
            }
        }
        TestProcessor.doProcess((ProcessorPlan)plan, (ProcessorDataManager)dataManager, (List[])expectedResults, (CommandContext)context);
    }

    protected CommandContext createCommandContext() {
        CommandContext context = new CommandContext((Object)new RequestID(), "test", "user", "myvdb", 1);
        return context;
    }
}

