/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.systemmodel;

import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.teiid.core.util.UnitTestUtil;
import org.teiid.jdbc.AbstractMMQueryTestCase;
import org.teiid.jdbc.FakeServer;
import org.teiid.jdbc.TestMMDatabaseMetaData;

public class TestSystemVirtualModel
extends AbstractMMQueryTestCase {
    private static final String VDB = "PartsSupplier";

    public TestSystemVirtualModel() {
        this.DELIMITER = "\t";
    }

    @Before
    public void setUp() throws Exception {
        FakeServer server = new FakeServer();
        server.deployVDB(VDB, UnitTestUtil.getTestDataPath() + "/PartsSupplier.vdb");
        this.internalConnection = server.createConnection("jdbc:teiid:PartsSupplier");
    }

    @Ignore(value="ODBC support to be readded")
    @Test
    public void testDefect23534() {
        String[] expected = new String[]{"SCOPE[short]\tCOLUMN_NAME[string]\tDATA_TYPE[short]\tTYPE_NAME[string]\tPRECISION[integer]\tLENGTH[integer]\tSCALE[integer]\tPSEUDO_COLUMN[short]"};
        this.executeAndAssertResults("SELECT OA_SCOPE as \"SCOPE\" , COLUMN_NAME,  DATA_TYPE, TYPE_NAME, OA_PRECISION as \"PRECISION\", OA_LENGTH as \"LENGTH\", OA_SCALE as \"SCALE\", PSEUDO_COLUMN FROM SYS.ODBC.OA_COLUMNS  WHERE TABLE_NAME = N'AUTHORS' AND TABLE_OWNER = N's1' AND (OA_COLUMNTYPE = 2 OR OA_COLUMNTYPE = 3) AND (OA_SCOPE is null OR OA_SCOPE >= 1) AND (OA_NULLABLE = 0 OR OA_NULLABLE = 1) ORDER BY \"SCOPE\"", expected);
    }

    protected void checkResult(String testName, String query) throws Exception {
        this.execute(query);
        TestMMDatabaseMetaData.compareResultSet("TestSystemVirtualModel/" + testName, this.internalResultSet);
    }

    @Test
    public void testModels() throws Exception {
        this.checkResult("testSchemas", "select* from SYS.Schemas order by Name");
    }

    @Test
    public void testKeys() throws Exception {
        this.checkResult("testKeys", "select* from SYS.Keys order by Name");
    }

    @Test
    public void testGroups() throws Exception {
        this.checkResult("testTables", "select* from SYS.Tables order by Name");
    }

    @Test
    public void testDataTypes() throws Exception {
        this.checkResult("testDataTypes", "select * from SYS.DataTypes order by name");
    }

    @Test
    public void testProcedureParams() throws Exception {
        this.checkResult("testProcedureParams", "select * from SYS.ProcedureParams order by Name");
    }

    @Test
    public void testProcedures() throws Exception {
        this.checkResult("testProcedures", "select* from SYS.Procedures order by Name");
    }

    @Test
    public void testProperties() {
        String[] expected = new String[]{"Name[string]\tValue[string]\tUID[string]"};
        this.executeAndAssertResults("select* from SYS.Properties", expected);
    }

    @Test
    public void testVirtualDatabase() {
        String[] expected = new String[]{"Name[string]\tVersion[string]\t", "PartsSupplier\t1"};
        this.executeAndAssertResults("select* from SYS.VirtualDatabases", expected);
    }

    @Test
    public void testKeyColumns() throws Exception {
        this.checkResult("testKeyColumns", "select* from SYS.KeyColumns order by Name, KeyName");
    }

    @Test
    public void testVDBResourcePathsProcedure() {
        String[] expected = new String[]{"ResourcePath[string]\tisBinary[boolean]", "/parts/partsmd/PartsSupplier.xmi\tfalse", "/ConfigurationInfo.def\tfalse", "/MetaMatrix-VdbManifestModel.xmi\tfalse"};
        this.execute("exec getVDBResourcePaths()", new Object[0]);
        this.assertResults(expected);
    }

    @Test
    public void testColumns() throws Exception {
        this.checkResult("testColumns", "select* from SYS.Columns order by Name");
    }

    @Test
    public void testTableType() {
        String[] expected = new String[]{"Type[string]\t", "Table"};
        this.executeAndAssertResults("select distinct Type from SYS.Tables order by Type", expected);
    }

    @Test
    public void testTableIsSystem() throws Exception {
        this.checkResult("testTableIsSystem", "select Name from SYS.Tables where IsSystem = 'false' order by Name");
    }

    @Ignore(value="ODBC support to be readded")
    @Test
    public void test_OA_PROC() {
        String[] expected = new String[]{"OA_QUALIFIER[string]\tOA_OWNER[string]\tOA_NAME[string]\tNUM_INPUT_PARAMS[integer]\tNUM_OUTPUT_PARAMS[integer]\tNUM_RESULT_SETS[integer]\tREMARKS[string]\tPROCEDURE_TYPE[short]", "PartsSupplier\tSystem\tdescribe\t0\t0\t0\tnull\t1", "PartsSupplier\tSystem\tgetBinaryVDBResource\t0\t0\t0\tnull\t1", "PartsSupplier\tSystem\tgetCharacterVDBResource\t0\t0\t0\tnull\t1", "PartsSupplier\tSystem\tgetUpdatedCharacterVDBResource\t0\t0\t0\tnull\t1", "PartsSupplier\tSystem\tgetVDBResourcePaths\t0\t0\t0\tnull\t1"};
        this.executeAndAssertResults("select* FROM SYS.ODBC.OA_PROC", expected);
    }

    @Ignore(value="ODBC support to be readded")
    @Test
    public void test_OA_PROCCOLUMNS() {
        String[] expected = new String[]{"OA_QUALIFIER[string]\tOA_OWNER[string]\tOA_NAME[string]\tCOLUMN_NAME[string]\tOA_COLUMNTYPE[short]\tDATA_TYPE[short]\tTYPE_NAME[string]\tOA_PRECISION[integer]\tOA_LENGTH[integer]\tOA_RADIX[integer]\tOA_SCALE[integer]\tOA_NULLABLE[short]\tOA_SCOPE[short]\tREMARKS[string]", "PartsSupplier\tSystem\tdescribe\tDescription\t0\t12\tVARCHAR\t128\t128\t10\t0\t0\t0\t", "PartsSupplier\tSystem\tdescribe\tentity\t0\t12\tVARCHAR\t0\t0\t10\t0\t0\t0\t", "PartsSupplier\tSystem\tgetBinaryVDBResource\tVdbResource\t0\t12\tVARCHAR\t0\t0\t10\t0\t1\t0\t", "PartsSupplier\tSystem\tgetBinaryVDBResource\tresourcePath\t0\t12\tVARCHAR\t50\t50\t10\t0\t0\t0\t", "PartsSupplier\tSystem\tgetCharacterVDBResource\tVdbResource\t0\t12\tVARCHAR\t0\t0\t10\t0\t1\t0\t", "PartsSupplier\tSystem\tgetCharacterVDBResource\tresourcePath\t0\t12\tVARCHAR\t50\t50\t10\t0\t0\t0\t", "PartsSupplier\tSystem\tgetUpdatedCharacterVDBResource\tVdbResource\t0\t12\tVARCHAR\t0\t0\t10\t0\t1\t0\t", "PartsSupplier\tSystem\tgetUpdatedCharacterVDBResource\tresourcePath\t0\t12\tVARCHAR\t50\t50\t10\t0\t0\t0\t", "PartsSupplier\tSystem\tgetUpdatedCharacterVDBResource\ttokenReplacements\t0\t12\tVARCHAR\t0\t0\t10\t0\t0\t0\t", "PartsSupplier\tSystem\tgetUpdatedCharacterVDBResource\ttokens\t0\t12\tVARCHAR\t0\t0\t10\t0\t0\t0\t", "PartsSupplier\tSystem\tgetVDBResourcePaths\tResourcePath\t0\t12\tVARCHAR\t50\t50\t10\t0\t1\t0\t", "PartsSupplier\tSystem\tgetVDBResourcePaths\tisBinary\t0\t5\tSMALLINT\t1\t1\t10\t0\t1\t0"};
        this.executeAndAssertResults("select* FROM SYS.ODBC.OA_PROCCOLUMNS ORDER BY OA_NAME, COLUMN_NAME ", expected);
    }

    @Ignore(value="ODBC support to be readded")
    @Test
    public void testOATYPES() {
        String[] expected = new String[]{"TYPE_NAME[string]\tDATA_TYPE[short]\tPRECISION[integer]\tLITERAL_PREFIX[string]\tLITERAL_SUFFIX[string]\tCREATE_PARAMS[string]\tNULLABLE[short]\tCASE_SENSITIVE[short]\tSEARCHABLE[short]\tUNSIGNED_ATTRIBUTE[short]\tMONEY[short]\tAUTO_INCREMENT[short]\tLOCAL_TYPE_NAME[string]\tMINIMUM_SCALE[short]\tMAXIMUM_SCALE[short]"};
        this.executeAndAssertResults("select TYPE_NAME, DATA_TYPE, OA_PRECISION as PRECISION, LITERAL_PREFIX, LITERAL_SUFFIX,  CREATE_PARAMS, OA_NULLABLE as NULLABLE, CASE_SENSITIVE, OA_SEARCHABLE as SEARCHABLE,  UNSIGNED_ATTRIB as UNSIGNED_ATTRIBUTE, OA_MONEY as MONEY, AUTO_INCREMENT, LOCAL_TYPE_NAME,  MINIMUM_SCALE, MAXIMUM_SCALE  FROM SYS.ODBC.OA_TYPES  WHERE DATA_TYPE = -6", expected);
    }

    @Ignore(value="ODBC support to be readded")
    @Test
    public void testOACOLUMNSAll() {
        String[] expected = new String[]{"TABLE_QUALIFIER[string]\tTABLE_OWNER[string]\tTABLE_NAME[string]\tCOLUMN_NAME[string]\tDATA_TYPE[short]\tTYPE_NAME[string]\tOA_LENGTH[integer]\tOA_PRECISION[integer]\tOA_SCALE[integer]\tOA_RADIX[integer]\tOA_NULLABLE[short]\tOA_SCOPE[short]\tPSEUDO_COLUMN[short]\tOA_COLUMNTYPE[short]\tREMARKS[string]", "PartsSupplier\tPartsSupplier/PARTSSUPPLIER\tPARTS\tPART_COLOR\t12\tVARCHAR\t30\t0\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tPartsSupplier/PARTSSUPPLIER\tPARTS\tPART_ID\t12\tVARCHAR\t4\t0\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tPartsSupplier/PARTSSUPPLIER\tPARTS\tPART_NAME\t12\tVARCHAR\t255\t0\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tPartsSupplier/PARTSSUPPLIER\tPARTS\tPART_WEIGHT\t12\tVARCHAR\t255\t0\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tPartsSupplier/PARTSSUPPLIER\tSHIP_VIA\tSHIPPER_ID\t5\tSMALLINT\t0\t2\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tPartsSupplier/PARTSSUPPLIER\tSHIP_VIA\tSHIPPER_NAME\t12\tVARCHAR\t30\t0\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tPartsSupplier/PARTSSUPPLIER\tSTATUS\tSTATUS_ID\t5\tSMALLINT\t0\t2\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tPartsSupplier/PARTSSUPPLIER\tSTATUS\tSTATUS_NAME\t12\tVARCHAR\t30\t0\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tPartsSupplier/PARTSSUPPLIER\tSUPPLIER\tSUPPLIER_CITY\t12\tVARCHAR\t30\t0\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tPartsSupplier/PARTSSUPPLIER\tSUPPLIER\tSUPPLIER_ID\t12\tVARCHAR\t10\t0\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tPartsSupplier/PARTSSUPPLIER\tSUPPLIER\tSUPPLIER_NAME\t12\tVARCHAR\t30\t0\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tPartsSupplier/PARTSSUPPLIER\tSUPPLIER\tSUPPLIER_STATE\t12\tVARCHAR\t2\t0\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tPartsSupplier/PARTSSUPPLIER\tSUPPLIER\tSUPPLIER_STATUS\t5\tSMALLINT\t0\t2\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tPartsSupplier/PARTSSUPPLIER\tSUPPLIER_PARTS\tPART_ID\t12\tVARCHAR\t4\t0\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tPartsSupplier/PARTSSUPPLIER\tSUPPLIER_PARTS\tQUANTITY\t5\tSMALLINT\t0\t3\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tPartsSupplier/PARTSSUPPLIER\tSUPPLIER_PARTS\tSHIPPER_ID\t5\tSMALLINT\t0\t2\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tPartsSupplier/PARTSSUPPLIER\tSUPPLIER_PARTS\tSUPPLIER_ID\t12\tVARCHAR\t10\t0\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tDataTypeElementProperties\tDataTypeElementName\t12\tVARCHAR\t255\t255\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tDataTypeElementProperties\tDataTypeName\t12\tVARCHAR\t100\t100\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tDataTypeElementProperties\tName\t12\tVARCHAR\t50\t50\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tDataTypeElementProperties\tUID\t12\tVARCHAR\t50\t50\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tDataTypeElementProperties\tValue\t12\tVARCHAR\t255\t255\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tDataTypeElements\tDataTypeName\t12\tVARCHAR\t100\t100\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tDataTypeElements\tElementLength\t4\tINTEGER\t10\t10\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tDataTypeElements\tName\t12\tVARCHAR\t255\t255\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tDataTypeElements\tPosition\t4\tINTEGER\t10\t10\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tDataTypeElements\tScale\t4\tINTEGER\t10\t10\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tDataTypeElements\tUID\t12\tVARCHAR\t50\t50\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tDataTypeProperties\tDataType\t12\tVARCHAR\t100\t100\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tDataTypeProperties\tName\t12\tVARCHAR\t50\t50\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tDataTypeProperties\tUID\t12\tVARCHAR\t50\t50\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tDataTypeProperties\tValue\t12\tVARCHAR\t255\t255\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tDataTypes\tBaseType\t12\tVARCHAR\t64\t64\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem\tDataTypes\tDescription\t12\tVARCHAR\t255\t255\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem\tDataTypes\tIsAutoIncremented\t5\tSMALLINT\t1\t1\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tDataTypes\tIsCaseSensitive\t5\tSMALLINT\t1\t1\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tDataTypes\tIsPhysical\t5\tSMALLINT\t1\t1\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem\tDataTypes\tIsSigned\t5\tSMALLINT\t1\t1\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tDataTypes\tIsStandard\t5\tSMALLINT\t1\t1\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem\tDataTypes\tJavaClass\t12\tVARCHAR\t500\t500\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tDataTypes\tName\t12\tVARCHAR\t100\t100\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tDataTypes\tNullType\t12\tVARCHAR\t20\t20\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tDataTypes\tPrecision\t4\tINTEGER\t10\t10\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tDataTypes\tRadix\t4\tINTEGER\t10\t10\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem\tDataTypes\tRuntimeType\t12\tVARCHAR\t64\t64\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem\tDataTypes\tScale\t4\tINTEGER\t10\t10\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem\tDataTypes\tSearchType\t12\tVARCHAR\t20\t20\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tDataTypes\tTypeLength\t4\tINTEGER\t10\t10\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tDataTypes\tTypeName\t12\tVARCHAR\t100\t100\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tDataTypes\tUID\t12\tVARCHAR\t50\t50\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tElementProperties\tElementName\t12\tVARCHAR\t255\t255\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tElementProperties\tElementUpperName\t12\tVARCHAR\t255\t255\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tElementProperties\tGroupFullName\t12\tVARCHAR\t2048\t2048\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tElementProperties\tGroupName\t12\tVARCHAR\t255\t255\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tElementProperties\tGroupUpperName\t12\tVARCHAR\t255\t255\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tElementProperties\tModelName\t12\tVARCHAR\t255\t255\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tElementProperties\tName\t12\tVARCHAR\t255\t255\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tElementProperties\tUID\t12\tVARCHAR\t50\t50\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tElementProperties\tValue\t12\tVARCHAR\t255\t255\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tElements\tCharOctetLength\t4\tINTEGER\t10\t10\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem\tElements\tDataType\t12\tVARCHAR\t100\t100\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tElements\tDefaultValue\t12\tVARCHAR\t255\t255\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem\tElements\tDescription\t12\tVARCHAR\t255\t255\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem\tElements\tElementLength\t4\tINTEGER\t10\t10\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tElements\tFormat\t12\tVARCHAR\t255\t255\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem\tElements\tGroupFullName\t12\tVARCHAR\t2048\t2048\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tElements\tGroupName\t12\tVARCHAR\t255\t255\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tElements\tGroupUpperName\t12\tVARCHAR\t255\t255\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tElements\tIsAutoIncremented\t5\tSMALLINT\t1\t1\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tElements\tIsCaseSensitive\t5\tSMALLINT\t1\t1\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tElements\tIsCurrency\t5\tSMALLINT\t1\t1\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tElements\tIsLengthFixed\t5\tSMALLINT\t1\t1\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tElements\tIsSigned\t5\tSMALLINT\t1\t1\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tElements\tJavaClass\t12\tVARCHAR\t500\t500\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tElements\tMaxRange\t12\tVARCHAR\t50\t50\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem\tElements\tMinRange\t12\tVARCHAR\t50\t50\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem\tElements\tModelName\t12\tVARCHAR\t255\t255\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tElements\tName\t12\tVARCHAR\t255\t255\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tElements\tNameInSource\t12\tVARCHAR\t255\t255\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem\tElements\tNullType\t12\tVARCHAR\t20\t20\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tElements\tPosition\t4\tINTEGER\t10\t10\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tElements\tPrecision\t4\tINTEGER\t10\t10\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tElements\tRadix\t4\tINTEGER\t10\t10\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tElements\tScale\t4\tINTEGER\t10\t10\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tElements\tSearchType\t12\tVARCHAR\t20\t20\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tElements\tSupportsSelect\t5\tSMALLINT\t1\t1\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tElements\tSupportsUpdates\t5\tSMALLINT\t1\t1\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tElements\tUID\t12\tVARCHAR\t50\t50\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tElements\tUpperName\t12\tVARCHAR\t255\t255\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tGroupProperties\tGroupFullName\t12\tVARCHAR\t2048\t2048\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tGroupProperties\tGroupName\t12\tVARCHAR\t255\t255\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tGroupProperties\tGroupUpperName\t12\tVARCHAR\t255\t255\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tGroupProperties\tModelName\t12\tVARCHAR\t255\t255\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tGroupProperties\tName\t12\tVARCHAR\t255\t255\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tGroupProperties\tUID\t12\tVARCHAR\t50\t50\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tGroupProperties\tValue\t12\tVARCHAR\t255\t255\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tGroups\tCardinality\t4\tINTEGER\t10\t10\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tGroups\tDescription\t12\tVARCHAR\t255\t255\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem\tGroups\tFullName\t12\tVARCHAR\t2048\t2048\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tGroups\tIsMaterialized\t5\tSMALLINT\t0\t0\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tGroups\tIsPhysical\t5\tSMALLINT\t1\t1\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tGroups\tIsSystem\t5\tSMALLINT\t1\t1\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem\tGroups\tModelName\t12\tVARCHAR\t255\t255\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tGroups\tName\t12\tVARCHAR\t255\t255\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tGroups\tNameInSource\t12\tVARCHAR\t255\t255\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem\tGroups\tSupportsUpdates\t5\tSMALLINT\t1\t1\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tGroups\tType\t12\tVARCHAR\t20\t20\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tGroups\tUID\t12\tVARCHAR\t50\t50\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tGroups\tUpperName\t12\tVARCHAR\t255\t255\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tKeyElements\tGroupFullName\t12\tVARCHAR\t2048\t2048\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tKeyElements\tGroupName\t12\tVARCHAR\t255\t255\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tKeyElements\tGroupUpperName\t12\tVARCHAR\t255\t255\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tKeyElements\tKeyName\t12\tVARCHAR\t255\t255\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem\tKeyElements\tKeyType\t12\tVARCHAR\t20\t20\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tKeyElements\tModelName\t12\tVARCHAR\t255\t255\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tKeyElements\tName\t12\tVARCHAR\t255\t255\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tKeyElements\tPosition\t4\tINTEGER\t10\t10\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem\tKeyElements\tRefKeyUID\t12\tVARCHAR\t50\t50\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem\tKeyElements\tUID\t12\tVARCHAR\t50\t50\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tKeyProperties\tGroupFullName\t12\tVARCHAR\t2048\t2048\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tKeyProperties\tGroupName\t12\tVARCHAR\t255\t255\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tKeyProperties\tGroupUpperName\t12\tVARCHAR\t255\t255\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tKeyProperties\tKeyName\t12\tVARCHAR\t255\t0\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem\tKeyProperties\tModelName\t12\tVARCHAR\t255\t255\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tKeyProperties\tName\t12\tVARCHAR\t255\t0\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem\tKeyProperties\tUID\t12\tVARCHAR\t50\t50\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tKeyProperties\tValue\t12\tVARCHAR\t255\t0\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem\tKeys\tDescription\t12\tVARCHAR\t255\t255\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem\tKeys\tGroupFullName\t12\tVARCHAR\t2048\t2048\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tKeys\tGroupName\t12\tVARCHAR\t255\t255\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tKeys\tGroupUpperName\t12\tVARCHAR\t255\t255\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tKeys\tIsIndexed\t5\tSMALLINT\t1\t1\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tKeys\tModelName\t12\tVARCHAR\t255\t255\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tKeys\tName\t12\tVARCHAR\t255\t255\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tKeys\tNameInSource\t12\tVARCHAR\t255\t255\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem\tKeys\tRefKeyUID\t12\tVARCHAR\t50\t50\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem\tKeys\tType\t12\tVARCHAR\t20\t20\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tKeys\tUID\t12\tVARCHAR\t50\t50\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tModelProperties\tModelName\t12\tVARCHAR\t255\t255\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tModelProperties\tName\t12\tVARCHAR\t255\t255\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tModelProperties\tUID\t12\tVARCHAR\t50\t50\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tModelProperties\tValue\t12\tVARCHAR\t255\t255\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tModels\tDescription\t12\tVARCHAR\t255\t255\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem\tModels\tIsPhysical\t5\tSMALLINT\t1\t1\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tModels\tMaxSetSize\t4\tINTEGER\t10\t10\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tModels\tName\t12\tVARCHAR\t255\t255\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tModels\tPrimaryMetamodelURI\t12\tVARCHAR\t255\t255\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tModels\tSupportsDistinct\t5\tSMALLINT\t1\t1\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tModels\tSupportsJoin\t5\tSMALLINT\t1\t1\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tModels\tSupportsOrderBy\t5\tSMALLINT\t1\t1\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tModels\tSupportsOuterJoin\t5\tSMALLINT\t1\t1\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tModels\tSupportsWhereAll\t5\tSMALLINT\t1\t1\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tModels\tUID\t12\tVARCHAR\t50\t50\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tProcedureParams\tDataType\t12\tVARCHAR\t25\t25\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tProcedureParams\tModelName\t12\tVARCHAR\t255\t255\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tProcedureParams\tName\t12\tVARCHAR\t255\t255\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tProcedureParams\tNullType\t12\tVARCHAR\t10\t10\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tProcedureParams\tOptional\t5\tSMALLINT\t1\t1\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tProcedureParams\tPosition\t4\tINTEGER\t10\t10\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tProcedureParams\tPrecision\t4\tINTEGER\t10\t10\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tProcedureParams\tProcedureName\t12\tVARCHAR\t255\t255\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tProcedureParams\tRadix\t4\tINTEGER\t10\t10\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tProcedureParams\tScale\t4\tINTEGER\t10\t10\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tProcedureParams\tType\t12\tVARCHAR\t100\t100\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tProcedureParams\tTypeLength\t4\tINTEGER\t10\t10\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tProcedureProperties\tModelName\t12\tVARCHAR\t255\t255\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tProcedureProperties\tName\t12\tVARCHAR\t255\t255\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tProcedureProperties\tProcedureName\t12\tVARCHAR\t255\t255\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tProcedureProperties\tUID\t12\tVARCHAR\t50\t50\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tProcedureProperties\tValue\t12\tVARCHAR\t255\t255\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tProcedures\tDescription\t12\tVARCHAR\t255\t225\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem\tProcedures\tFullName\t12\tVARCHAR\t2048\t2048\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tProcedures\tModelName\t12\tVARCHAR\t255\t255\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tProcedures\tModelUID\t12\tVARCHAR\t50\t50\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tProcedures\tName\t12\tVARCHAR\t255\t255\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tProcedures\tNameInSource\t12\tVARCHAR\t255\t255\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem\tProcedures\tReturnsResults\t5\tSMALLINT\t1\t1\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tProcedures\tUID\t12\tVARCHAR\t50\t50\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tVirtualDatabases\tName\t12\tVARCHAR\t255\t255\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem\tVirtualDatabases\tVersion\t12\tVARCHAR\t50\t50\t0\t10\t0\t0\t0\t0\tnull", "PartsSupplier\tSystem/JDBC\tReferenceKeyColumns\tDEFERRABILITY\t4\tINTEGER\t10\t10\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem/JDBC\tReferenceKeyColumns\tDELETE_RULE\t4\tINTEGER\t10\t10\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem/JDBC\tReferenceKeyColumns\tFKCOLUMN_NAME\t12\tVARCHAR\t255\t255\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem/JDBC\tReferenceKeyColumns\tFKTABLE_CAT\t12\tVARCHAR\t1\t1\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem/JDBC\tReferenceKeyColumns\tFKTABLE_NAME\t12\tVARCHAR\t255\t255\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem/JDBC\tReferenceKeyColumns\tFKTABLE_SCHEM\t12\tVARCHAR\t255\t255\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem/JDBC\tReferenceKeyColumns\tFK_NAME\t12\tVARCHAR\t255\t255\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem/JDBC\tReferenceKeyColumns\tKEY_SEQ\t5\tSMALLINT\t5\t5\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem/JDBC\tReferenceKeyColumns\tPKCOLUMN_NAME\t12\tVARCHAR\t255\t255\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem/JDBC\tReferenceKeyColumns\tPKTABLE_CAT\t12\tVARCHAR\t1\t1\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem/JDBC\tReferenceKeyColumns\tPKTABLE_NAME\t12\tVARCHAR\t255\t255\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem/JDBC\tReferenceKeyColumns\tPKTABLE_SCHEM\t12\tVARCHAR\t255\t255\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem/JDBC\tReferenceKeyColumns\tPK_NAME\t12\tVARCHAR\t255\t255\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem/JDBC\tReferenceKeyColumns\tUPDATE_RULE\t4\tINTEGER\t10\t10\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem/ODBC\tOA_COLUMNS\tCOLUMN_NAME\t12\tVARCHAR\t128\t128\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem/ODBC\tOA_COLUMNS\tDATA_TYPE\t5\tSMALLINT\t5\t5\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem/ODBC\tOA_COLUMNS\tOA_COLUMNTYPE\t5\tSMALLINT\t5\t5\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem/ODBC\tOA_COLUMNS\tOA_LENGTH\t4\tINTEGER\t10\t10\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem/ODBC\tOA_COLUMNS\tOA_NULLABLE\t5\tSMALLINT\t5\t5\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem/ODBC\tOA_COLUMNS\tOA_PRECISION\t4\tINTEGER\t10\t10\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem/ODBC\tOA_COLUMNS\tOA_RADIX\t4\tINTEGER\t10\t10\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem/ODBC\tOA_COLUMNS\tOA_SCALE\t4\tINTEGER\t10\t10\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem/ODBC\tOA_COLUMNS\tOA_SCOPE\t5\tSMALLINT\t5\t5\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem/ODBC\tOA_COLUMNS\tPSEUDO_COLUMN\t5\tSMALLINT\t5\t5\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem/ODBC\tOA_COLUMNS\tREMARKS\t12\tVARCHAR\t254\t254\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem/ODBC\tOA_COLUMNS\tTABLE_NAME\t12\tVARCHAR\t128\t128\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem/ODBC\tOA_COLUMNS\tTABLE_OWNER\t12\tVARCHAR\t128\t128\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem/ODBC\tOA_COLUMNS\tTABLE_QUALIFIER\t12\tVARCHAR\t128\t128\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem/ODBC\tOA_COLUMNS\tTYPE_NAME\t12\tVARCHAR\t100\t100\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem/ODBC\tOA_FKEYS\tDELETE_RULE\t5\tSMALLINT\t5\t5\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem/ODBC\tOA_FKEYS\tFKCOLUMN_NAME\t12\tVARCHAR\t128\t128\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem/ODBC\tOA_FKEYS\tFKTABLE_NAME\t12\tVARCHAR\t128\t128\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem/ODBC\tOA_FKEYS\tFKTABLE_OWNER\t12\tVARCHAR\t128\t128\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem/ODBC\tOA_FKEYS\tFKTABLE_QUALIFIER\t12\tVARCHAR\t128\t128\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem/ODBC\tOA_FKEYS\tFK_NAME\t12\tVARCHAR\t128\t128\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem/ODBC\tOA_FKEYS\tKEY_SEQ\t5\tSMALLINT\t5\t5\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem/ODBC\tOA_FKEYS\tPKCOLUMN_NAME\t12\tVARCHAR\t128\t128\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem/ODBC\tOA_FKEYS\tPKTABLE_NAME\t12\tVARCHAR\t128\t128\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem/ODBC\tOA_FKEYS\tPKTABLE_OWNER\t12\tVARCHAR\t128\t128\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem/ODBC\tOA_FKEYS\tPKTABLE_QUALIFIER\t12\tVARCHAR\t128\t128\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem/ODBC\tOA_FKEYS\tPK_NAME\t12\tVARCHAR\t128\t128\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem/ODBC\tOA_FKEYS\tUPDATE_RULE\t5\tSMALLINT\t5\t5\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem/ODBC\tOA_PROC\tNUM_INPUT_PARAMS\t4\tINTEGER\t10\t10\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem/ODBC\tOA_PROC\tNUM_OUTPUT_PARAMS\t4\tINTEGER\t10\t10\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem/ODBC\tOA_PROC\tNUM_RESULT_SETS\t4\tINTEGER\t10\t10\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem/ODBC\tOA_PROC\tOA_NAME\t12\tVARCHAR\t128\t128\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem/ODBC\tOA_PROC\tOA_OWNER\t12\tVARCHAR\t128\t128\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem/ODBC\tOA_PROC\tOA_QUALIFIER\t12\tVARCHAR\t128\t128\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem/ODBC\tOA_PROC\tPROCEDURE_TYPE\t5\tSMALLINT\t5\t5\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem/ODBC\tOA_PROC\tREMARKS\t12\tVARCHAR\t254\t254\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem/ODBC\tOA_PROCCOLUMNS\tCOLUMN_NAME\t12\tVARCHAR\t128\t128\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem/ODBC\tOA_PROCCOLUMNS\tDATA_TYPE\t5\tSMALLINT\t5\t5\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem/ODBC\tOA_PROCCOLUMNS\tOA_COLUMNTYPE\t5\tSMALLINT\t5\t5\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem/ODBC\tOA_PROCCOLUMNS\tOA_LENGTH\t4\tINTEGER\t10\t10\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem/ODBC\tOA_PROCCOLUMNS\tOA_NAME\t12\tVARCHAR\t128\t128\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem/ODBC\tOA_PROCCOLUMNS\tOA_NULLABLE\t5\tSMALLINT\t5\t5\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem/ODBC\tOA_PROCCOLUMNS\tOA_OWNER\t12\tVARCHAR\t128\t128\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem/ODBC\tOA_PROCCOLUMNS\tOA_PRECISION\t4\tINTEGER\t10\t10\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem/ODBC\tOA_PROCCOLUMNS\tOA_QUALIFIER\t12\tVARCHAR\t128\t128\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem/ODBC\tOA_PROCCOLUMNS\tOA_RADIX\t4\tINTEGER\t10\t10\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem/ODBC\tOA_PROCCOLUMNS\tOA_SCALE\t4\tINTEGER\t10\t10\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem/ODBC\tOA_PROCCOLUMNS\tOA_SCOPE\t5\tSMALLINT\t5\t5\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem/ODBC\tOA_PROCCOLUMNS\tREMARKS\t12\tVARCHAR\t254\t254\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem/ODBC\tOA_PROCCOLUMNS\tTYPE_NAME\t12\tVARCHAR\t100\t100\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem/ODBC\tOA_STATISTICS\tCOLUMN_NAME\t12\tVARCHAR\t128\t128\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem/ODBC\tOA_STATISTICS\tFILTER_CONDITIONS\t12\tVARCHAR\t128\t128\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem/ODBC\tOA_STATISTICS\tINDEX_NAME\t12\tVARCHAR\t128\t128\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem/ODBC\tOA_STATISTICS\tINDEX_QUALIFIER\t12\tVARCHAR\t128\t128\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem/ODBC\tOA_STATISTICS\tNON_UNIQUE\t5\tSMALLINT\t5\t5\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem/ODBC\tOA_STATISTICS\tOA_CARDINALITY\t12\tVARCHAR\t10\t10\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem/ODBC\tOA_STATISTICS\tOA_COLLATION\t12\tVARCHAR\t128\t128\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem/ODBC\tOA_STATISTICS\tOA_PAGES\t12\tVARCHAR\t10\t10\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem/ODBC\tOA_STATISTICS\tOA_TYPE\t5\tSMALLINT\t5\t5\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem/ODBC\tOA_STATISTICS\tSEQ_IN_INDEX\t5\tSMALLINT\t5\t5\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem/ODBC\tOA_STATISTICS\tTABLE_NAME\t12\tVARCHAR\t128\t128\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem/ODBC\tOA_STATISTICS\tTABLE_OWNER\t12\tVARCHAR\t128\t128\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem/ODBC\tOA_STATISTICS\tTABLE_QUALIFIER\t12\tVARCHAR\t128\t128\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem/ODBC\tOA_TABLES\tREMARKS\t12\tVARCHAR\t254\t254\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem/ODBC\tOA_TABLES\tTABLE_NAME\t12\tVARCHAR\t128\t128\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem/ODBC\tOA_TABLES\tTABLE_OWNER\t12\tVARCHAR\t128\t128\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem/ODBC\tOA_TABLES\tTABLE_QUALIFIER\t12\tVARCHAR\t128\t128\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem/ODBC\tOA_TABLES\tTABLE_TYPE\t12\tVARCHAR\t128\t128\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem/ODBC\tOA_TYPES\tAUTO_INCREMENT\t5\tSMALLINT\t5\t5\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem/ODBC\tOA_TYPES\tCASE_SENSITIVE\t5\tSMALLINT\t5\t5\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem/ODBC\tOA_TYPES\tCREATE_PARAMS\t12\tVARCHAR\t10\t10\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem/ODBC\tOA_TYPES\tDATA_TYPE\t5\tSMALLINT\t5\t5\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem/ODBC\tOA_TYPES\tLITERAL_PREFIX\t12\tVARCHAR\t10\t10\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem/ODBC\tOA_TYPES\tLITERAL_SUFFIX\t12\tVARCHAR\t10\t10\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem/ODBC\tOA_TYPES\tLOCAL_TYPE_NAME\t12\tVARCHAR\t128\t128\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem/ODBC\tOA_TYPES\tMAXIMUM_SCALE\t5\tSMALLINT\t5\t5\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem/ODBC\tOA_TYPES\tMINIMUM_SCALE\t5\tSMALLINT\t5\t5\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem/ODBC\tOA_TYPES\tOA_MONEY\t5\tSMALLINT\t5\t5\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem/ODBC\tOA_TYPES\tOA_NULLABLE\t5\tSMALLINT\t5\t5\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem/ODBC\tOA_TYPES\tOA_PRECISION\t4\tINTEGER\t10\t10\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem/ODBC\tOA_TYPES\tOA_SEARCHABLE\t5\tSMALLINT\t5\t5\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem/ODBC\tOA_TYPES\tTYPE_NAME\t12\tVARCHAR\t100\t100\t0\t10\t1\t0\t0\t0\tnull", "PartsSupplier\tSystem/ODBC\tOA_TYPES\tUNSIGNED_ATTRIB\t5\tSMALLINT\t5\t5\t0\t10\t1\t0\t0\t0\tnull"};
        this.executeAndAssertResults("select* FROM SYS.ODBC.OA_COLUMNS ORDER BY TABLE_QUALIFIER, TABLE_OWNER, TABLE_NAME, COLUMN_NAME", expected);
    }

    @Ignore(value="ODBC support to be readded")
    @Test
    public void testOATYPESAll() {
        String[] expected = new String[]{"TYPE_NAME[string]\tDATA_TYPE[short]\tOA_PRECISION[integer]\tLITERAL_PREFIX[string]\tLITERAL_SUFFIX[string]\tCREATE_PARAMS[string]\tOA_NULLABLE[short]\tCASE_SENSITIVE[short]\tOA_SEARCHABLE[short]\tUNSIGNED_ATTRIB[short]\tOA_MONEY[short]\tAUTO_INCREMENT[short]\tMINIMUM_SCALE[short]\tMAXIMUM_SCALE[short]\tLOCAL_TYPE_NAME[string]", "CHAR\t1\t2147483647\t'\t'\tnull\t1\t1\t3\t0\t0\t0\tnull\tnull\tCHAR", "DATE\t9\t10\t{d '\t'}\tnull\t1\t0\t2\t0\t0\t0\tnull\tnull\tDATE", "DOUBLE\t8\t15\tnull\tnull\tnull\t1\t0\t2\t0\t0\t0\tnull\tnull\tDOUBLE", "FLOAT\t6\t15\tnull\tnull\tnull\t1\t0\t2\t0\t0\t0\tnull\tnull\tFLOAT", "INTEGER\t4\t10\tnull\tnull\tnull\t1\t0\t2\t0\t0\t0\tnull\tnull\tINTEGER", "LONGVARBINARY\t-4\t2147483647\t0x\tnull\tnull\t1\t0\t0\t0\t0\t0\tnull\tnull\tnull", "NUMERIC\t2\t32\tnull\tnull\tnull\t1\t0\t2\t0\t0\t0\t0\t32\tNUMERIC", "REAL\t7\t7\tnull\tnull\tnull\t1\t0\t2\t0\t0\t0\tnull\tnull\tREAL", "SMALLINT\t5\t5\tnull\tnull\tnull\t1\t0\t2\t0\t0\t0\tnull\tnull\tSMALLINT", "TIME\t10\t8\t{t '\t'}\tnull\t1\t0\t2\t0\t0\t0\tnull\tnull\tTIME", "TIMESTAMP\t11\t19\t{ts '\t'}\tnull\t1\t0\t2\t0\t0\t0\tnull\tnull\tTIMESTAMP", "VARCHAR\t12\t2147483647\t'\t'\tnull\t1\t1\t3\t0\t0\t0\tnull\tnull\tVARCHAR"};
        this.executeAndAssertResults("select* FROM SYS.ODBC.OA_TYPES ORDER BY TYPE_NAME", expected);
    }

    @Ignore(value="ODBC support to be readded")
    @Test
    public void testOAFKEYS() {
        String[] expected = new String[]{"PKTABLE_QUALIFIER[string]\tPKTABLE_OWNER[string]\tPKTABLE_NAME[string]\tPKCOLUMN_NAME[string]\tFKTABLE_QUALIFIER[string]\tFKTABLE_OWNER[string]\tFKTABLE_NAME[string]\tFKCOLUMN_NAME[string]\tKEY_SEQ[short]\tUPDATE_RULE[short]\tDELETE_RULE[short]\tFK_NAME[string]\tPK_NAME[string]", "PartsSupplier\tPartsSupplier/PARTSSUPPLIER\tPARTS\tPART_ID\tPartsSupplier\tPartsSupplier/PARTSSUPPLIER\tnull\tnull\t1\tnull\tnull\tnull\tPK_PARTS", "PartsSupplier\tPartsSupplier/PARTSSUPPLIER\tPARTS\tPART_ID\tPartsSupplier\tPartsSupplier/PARTSSUPPLIER\tSUPPLIER_PARTS\tPART_ID\t1\tnull\tnull\tFK_SPLIER_PRTS_PRTS\tPK_PARTS", "PartsSupplier\tPartsSupplier/PARTSSUPPLIER\tSHIP_VIA\tSHIPPER_ID\tPartsSupplier\tPartsSupplier/PARTSSUPPLIER\tnull\tnull\t1\tnull\tnull\tnull\tPK_SHIP_VIA", "PartsSupplier\tPartsSupplier/PARTSSUPPLIER\tSTATUS\tSTATUS_ID\tPartsSupplier\tPartsSupplier/PARTSSUPPLIER\tnull\tnull\t1\tnull\tnull\tnull\tPK_STATUS", "PartsSupplier\tPartsSupplier/PARTSSUPPLIER\tSTATUS\tSTATUS_ID\tPartsSupplier\tPartsSupplier/PARTSSUPPLIER\tSUPPLIER\tSUPPLIER_STATUS\t1\tnull\tnull\tFK_SPLIER_STATS\tPK_STATUS", "PartsSupplier\tPartsSupplier/PARTSSUPPLIER\tSUPPLIER\tSUPPLIER_ID\tPartsSupplier\tPartsSupplier/PARTSSUPPLIER\tnull\tnull\t1\tnull\tnull\tnull\tPK_SUPPLIER", "PartsSupplier\tPartsSupplier/PARTSSUPPLIER\tSUPPLIER\tSUPPLIER_ID\tPartsSupplier\tPartsSupplier/PARTSSUPPLIER\tSUPPLIER_PARTS\tSUPPLIER_ID\t1\tnull\tnull\tFK_SPLY_PRTS_SPLY\tPK_SUPPLIER", "PartsSupplier\tPartsSupplier/PARTSSUPPLIER\tSUPPLIER_PARTS\tSUPPLIER_ID\tPartsSupplier\tPartsSupplier/PARTSSUPPLIER\tnull\tnull\t1\tnull\tnull\tnull\tPK_SUPPLIER_PARTS", "PartsSupplier\tPartsSupplier/PARTSSUPPLIER\tSUPPLIER_PARTS\tPART_ID\tPartsSupplier\tPartsSupplier/PARTSSUPPLIER\tnull\tnull\t2\tnull\tnull\tnull\tPK_SUPPLIER_PARTS"};
        this.executeAndAssertResults("select* FROM SYS.ODBC.OA_FKEYS ORDER BY PK_NAME, KEY_SEQ", expected);
    }

    @Ignore(value="ODBC support to be readded")
    @Test
    public void testOASTATISTICS() {
        String[] expected = new String[]{"TABLE_QUALIFIER[string]\tTABLE_OWNER[string]\tTABLE_NAME[string]\tNON_UNIQUE[short]\tINDEX_QUALIFIER[string]\tINDEX_NAME[string]\tOA_TYPE[short]\tSEQ_IN_INDEX[short]\tCOLUMN_NAME[string]\tOA_COLLATION[string]\tOA_CARDINALITY[string]\tOA_PAGES[string]\tFILTER_CONDITIONS[string]", "PartsSupplier\tPartsSupplier/PARTSSUPPLIER\tPARTS\t0\t\tPK_PARTS\t3\t1\tPART_ID\tnull\tnull\tnull", "PartsSupplier\tPartsSupplier/PARTSSUPPLIER\tSHIP_VIA\t0\t\tPK_SHIP_VIA\t3\t1\tSHIPPER_ID\tnull\tnull\tnull\t", "PartsSupplier\tPartsSupplier/PARTSSUPPLIER\tSTATUS\t0\t\tPK_STATUS\t3\t1\tSTATUS_ID\tnull\tnull\tnull\t", "PartsSupplier\tPartsSupplier/PARTSSUPPLIER\tSUPPLIER\t1\t\tFK_SPLIER_STATS\t3\t1\tSUPPLIER_STATUS\tnull\tnull\tnull\t", "PartsSupplier\tPartsSupplier/PARTSSUPPLIER\tSUPPLIER\t0\t\tPK_SUPPLIER\t3\t1\tSUPPLIER_ID\tnull\tnull\tnull\t", "PartsSupplier\tPartsSupplier/PARTSSUPPLIER\tSUPPLIER_PARTS\t1\t\tFK_SPLIER_PRTS_PRTS\t3\t1\tPART_ID\tnull\tnull\tnull\t", "PartsSupplier\tPartsSupplier/PARTSSUPPLIER\tSUPPLIER_PARTS\t1\t\tFK_SPLY_PRTS_SPLY\t3\t1\tSUPPLIER_ID\tnull\tnull\tnull\t", "PartsSupplier\tPartsSupplier/PARTSSUPPLIER\tSUPPLIER_PARTS\t0\t\tPK_SUPPLIER_PARTS\t3\t2\tPART_ID\tnull\tnull\tnull\t", "PartsSupplier\tPartsSupplier/PARTSSUPPLIER\tSUPPLIER_PARTS\t0\t\tPK_SUPPLIER_PARTS\t3\t1\tSUPPLIER_ID\tnull\tnull\tnull\t"};
        this.executeAndAssertResults("select* FROM SYS.ODBC.OA_STATISTICS order by TABLE_NAME, INDEX_NAME, COLUMN_NAME", expected);
    }

    @Test
    public void testDefect12064() {
        String[] expected = new String[]{"KeyName[string]\tRefKeyUID[string]\t", "PK_PARTS\tnull", "PK_SHIP_VIA\tnull", "PK_STATUS\tnull", "PK_SUPPLIER\tnull", "PK_SUPPLIER_PARTS\tnull", "PK_SUPPLIER_PARTS\tnull"};
        this.executeAndAssertResults("select KeyName, RefKeyUID FROM SYS.KeyColumns WHERE RefKeyUID IS NULL order by KeyName", expected);
    }

    @Test
    public void testReferenceKeyColumns() throws Exception {
        this.checkResult("testReferenceKeyColumns", "select* FROM SYS.ReferenceKeyColumns order by PKTABLE_NAME");
    }

    @Test
    public void testVirtualLookup() {
        String[] expected = new String[]{"expr[string]", "null"};
        this.executeAndAssertResults("select lookup('SYS.KeyColumns', 'RefKeyUID', 'KeyName', 'PK_PARTS')", expected);
    }
}

