/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.test.framework.exception;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.teiid.core.util.ExceptionUtil;

public class QueryTestFailedException
extends Exception
implements Serializable {
    private static final long serialVersionUID = -4824998416118801290L;
    private String code;
    private Throwable child;
    private String msg;

    public static String getClassShortName(Class<?> cls) {
        if (cls == null) {
            return "";
        }
        String className = cls.getName();
        return className.substring(className.lastIndexOf(46) + 1);
    }

    public QueryTestFailedException() {
    }

    public QueryTestFailedException(String message) {
        this.setMessage(message, null);
    }

    public QueryTestFailedException(String code, String message) {
        this.setMessage(message, null);
        this.setCode(code);
    }

    public QueryTestFailedException(Throwable e) {
        this.msg = e instanceof InvocationTargetException ? ((InvocationTargetException)e).getTargetException().getMessage() : (e == null ? null : e.getMessage());
        this.setChild(e);
    }

    public QueryTestFailedException(Throwable e, String message) {
        this.setChild(e);
        this.setMessage(message, null);
    }

    public QueryTestFailedException(Throwable e, String code, String message) {
        this.setChild(e);
        this.setMessage(message, null);
        this.setCode(code);
    }

    public Throwable getChild() {
        return this.child;
    }

    public String getCode() {
        return this.code;
    }

    public String getFormattedMessage(Throwable throwable, int level) {
        return (level != 0 ? "\n" + level + " " : "") + "[" + QueryTestFailedException.getClassShortName(throwable.getClass()) + "]" + (this.code != null ? ' ' + this.code + ": " : "") + (throwable.getMessage() == null ? "" : throwable.getMessage());
    }

    public String getFullMessage() {
        return ExceptionUtil.getLinkedMessages((Throwable)this, (int)0);
    }

    @Override
    public String getMessage() {
        return this.msg;
    }

    public void setChild(Throwable child) {
        this.child = child instanceof InvocationTargetException ? ((InvocationTargetException)child).getTargetException() : child;
    }

    public void setCode(String code) {
        this.code = code;
    }

    private void setMessage(String message, List parameters) {
        if (message == null) {
            this.msg = message;
        } else {
            String msg = message;
            int len = msg.length();
            if (msg.startsWith("<") && len >= 2) {
                this.msg = msg.substring(1, len - 1);
            } else {
                this.msg = msg;
                this.setCode(message);
            }
        }
    }

    @Override
    public String toString() {
        return this.getFullMessage();
    }
}

