/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.common.buffer;

import java.sql.Clob;
import java.util.Arrays;
import java.util.List;
import javax.sql.rowset.serial.SerialClob;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.teiid.common.buffer.BatchManager;
import org.teiid.common.buffer.FileStore;
import org.teiid.common.buffer.LobManager;
import org.teiid.common.buffer.TupleBatch;
import org.teiid.common.buffer.TupleBuffer;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.types.ClobType;
import org.teiid.core.types.DataTypeManager;
import org.teiid.query.sql.symbol.ElementSymbol;

public class TestTupleBuffer {
    @Test
    public void testForwardOnly() throws Exception {
        ElementSymbol x = new ElementSymbol("x");
        x.setType(DataTypeManager.DefaultDataClasses.INTEGER);
        List<ElementSymbol> schema = Arrays.asList(x);
        TupleBuffer tb = new TupleBuffer((BatchManager)new FakeBatchManager(), "x", schema, null, 32);
        tb.setForwardOnly(true);
        tb.addTuple(Arrays.asList(1));
        TupleBatch batch = tb.getBatch(1);
        Assert.assertTrue((!batch.getTerminationFlag() ? 1 : 0) != 0);
        Assert.assertEquals((long)1L, (long)batch.getBeginRow());
        try {
            tb.getBatch(1);
            Assert.fail((String)"expected exception");
        }
        catch (AssertionError e) {
            // empty catch block
        }
        tb.addTuple(Arrays.asList(1));
        tb.close();
        batch = tb.getBatch(2);
        Assert.assertTrue((boolean)batch.getTerminationFlag());
        Assert.assertEquals((long)2L, (long)batch.getBeginRow());
    }

    @Test
    public void testLobHandling() throws Exception {
        ElementSymbol x = new ElementSymbol("x");
        x.setType(DataTypeManager.DefaultDataClasses.CLOB);
        List<ElementSymbol> schema = Arrays.asList(x);
        TupleBuffer tb = new TupleBuffer((BatchManager)new FakeBatchManager(), "x", schema, LobManager.getLobIndexes(schema), 32);
        ClobType c = new ClobType((Clob)new SerialClob(new char[0]));
        TupleBatch batch = new TupleBatch(1, new List[]{Arrays.asList(c)});
        tb.addTupleBatch(batch, false);
        Assert.assertNotNull((Object)tb.getLobReference(c.getReferenceStreamId()));
    }

    private final class FakeBatchManager
    implements BatchManager {
        private FakeBatchManager() {
        }

        public void remove() {
        }

        public BatchManager.ManagedBatch createManagedBatch(final TupleBatch batch, boolean softCache) throws TeiidComponentException {
            return new BatchManager.ManagedBatch(){

                public void remove() {
                }

                public TupleBatch getBatch(boolean cache, String[] types) throws TeiidComponentException {
                    return batch;
                }
            };
        }

        public FileStore createStorage(String prefix) {
            return (FileStore)Mockito.mock(FileStore.class);
        }
    }
}

