/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.core.id;

import java.util.Collection;
import junit.framework.TestCase;
import org.teiid.core.id.IDGenerator;
import org.teiid.core.id.IntegerIDFactory;
import org.teiid.core.id.InvalidIDException;
import org.teiid.core.id.ObjectID;
import org.teiid.core.id.ObjectIDFactory;

public class TestIDGenerator
extends TestCase {
    private static final String DEFAULT_FACTORY_PROTOCOL = "mmuuid";
    private IDGenerator generator;
    private IDGenerator generatorWithDefault;
    private IDGenerator generatorWithBuiltIns;

    public TestIDGenerator(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.generator = new IDGenerator();
        this.generatorWithDefault = new IDGenerator();
        this.generatorWithDefault.addFactory((ObjectIDFactory)new IntegerIDFactory());
        this.generatorWithDefault.setDefaultFactory("mmint");
        this.generatorWithBuiltIns = new IDGenerator();
        this.generatorWithBuiltIns.addBuiltInFactories();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.generator = null;
        this.generatorWithDefault = null;
        this.generatorWithBuiltIns = null;
    }

    public void helpTestDefaultFactoryAccessors(IDGenerator gen) {
        if (gen.hasDefaultFactory() != (gen.getDefaultFactory() != null)) {
            TestIDGenerator.fail((String)("The hasDefaultFactory returned " + gen.hasDefaultFactory() + " but getDefaultFactory returned " + gen.getDefaultFactory()));
        }
    }

    public void helpTestGetFactory(IDGenerator gen, String protocol, boolean shouldSucceed) {
        ObjectIDFactory factory = gen.getFactory(protocol);
        if (factory == null && shouldSucceed) {
            TestIDGenerator.fail((String)("Unable to find factory for protocol " + protocol));
        }
        if (factory != null && !shouldSucceed) {
            TestIDGenerator.fail((String)("Unexpectedly found factory for protocol " + protocol));
        }
    }

    public void helpTestGetDefaultFactory(IDGenerator gen, String protocolOrNull) {
        ObjectIDFactory factory = gen.getDefaultFactory();
        if (factory == null && protocolOrNull != null) {
            TestIDGenerator.fail((String)"Unable to find default factory");
        }
        if (factory != null && protocolOrNull == null) {
            TestIDGenerator.fail((String)"Unexpectedly found default factory");
        }
        if (factory != null && !factory.getProtocol().equals(protocolOrNull)) {
            TestIDGenerator.fail((String)("Default factory had protocol " + factory.getProtocol() + " but should have been " + protocolOrNull));
        }
    }

    public void helpTestRemoveFactory(IDGenerator gen, String protocol, boolean shouldSucceed) {
        boolean shouldFind = false;
        Collection factories = gen.getFactories();
        for (ObjectIDFactory factory : factories) {
            if (!factory.getProtocol().equals(protocol)) continue;
            shouldFind = true;
        }
        boolean actuallyRemoved = gen.removeFactory(protocol);
        if (shouldFind != actuallyRemoved) {
            if (shouldFind) {
                TestIDGenerator.fail((String)"Found factory via iteration but not by removal");
            } else {
                TestIDGenerator.fail((String)"Didn't find factory via iteration but one was removed");
            }
        }
        if (!actuallyRemoved && shouldSucceed) {
            TestIDGenerator.fail((String)("Unable to remove factory for protocol " + protocol));
        }
        if (actuallyRemoved && !shouldSucceed) {
            TestIDGenerator.fail((String)("Unexpectedly removed factory for protocol " + protocol));
        }
    }

    public void testDefaultFactoryUponConstruction() {
        if (this.generator.getDefaultFactory() == null) {
            TestIDGenerator.fail((String)"The IDGenerator should have a default factory upon construction");
        }
    }

    public void testDefaultFactoryAccessorsUponConstruction() {
        this.helpTestDefaultFactoryAccessors(this.generator);
    }

    public void testDefaultFactoryAccessorsAfterSettingDefault() {
        this.helpTestDefaultFactoryAccessors(this.generatorWithDefault);
    }

    public void testBuiltInFactoriesUponConstruction() {
        Collection factories = this.generator.getFactories();
        if (factories.size() != 1) {
            TestIDGenerator.fail((String)("Found " + factories.size() + " factories, but expected 1"));
        }
    }

    public void testBuiltInFactories() {
        Collection factories = this.generatorWithBuiltIns.getFactories();
        if (factories.size() != 4) {
            TestIDGenerator.fail((String)("Found " + factories.size() + " factories, but expected 4"));
        }
        this.generatorWithBuiltIns.addBuiltInFactories();
        this.generatorWithBuiltIns.addBuiltInFactories();
        Collection factories2 = this.generatorWithBuiltIns.getFactories();
        if (factories2.size() != 4) {
            TestIDGenerator.fail((String)("Found " + factories2.size() + " factories, but expected 4"));
        }
        this.helpTestGetFactory(this.generatorWithBuiltIns, "mmint", true);
        this.helpTestGetFactory(this.generatorWithBuiltIns, "strid", true);
        this.helpTestGetFactory(this.generatorWithBuiltIns, "mmlong", true);
        this.helpTestGetFactory(this.generatorWithBuiltIns, DEFAULT_FACTORY_PROTOCOL, true);
        this.helpTestGetFactory(this.generatorWithBuiltIns, "bogus id", false);
    }

    public void testCreatingIDWithoutDefaultFactory() {
        try {
            this.generator.create();
        }
        catch (IllegalArgumentException e) {
            TestIDGenerator.fail((String)"Should have been able to create an ObjectID using a generator (there is a default factory)");
        }
    }

    public void testCreatingIDWithDefaultFactory() {
        this.generatorWithDefault.create();
    }

    public void testSerializingIDWithStandardDelim() throws InvalidIDException {
        ObjectID guid = this.generatorWithDefault.create();
        String str1 = this.generatorWithDefault.toString(guid);
        String str2 = this.generatorWithDefault.toString(guid, ':');
        String str3 = this.generatorWithDefault.toString(guid, '/');
        TestIDGenerator.assertEquals((String)str1, (String)str2);
        ObjectID guid1 = this.generatorWithDefault.stringToObject(str1);
        ObjectID guid2 = this.generatorWithDefault.stringToObject(str2);
        ObjectID guid3 = this.generatorWithDefault.stringToObject(str3);
        ObjectID guid1a = this.generatorWithDefault.stringToObject(str1, ':');
        ObjectID guid2a = this.generatorWithDefault.stringToObject(str2, ':');
        ObjectID guid3a = this.generatorWithDefault.stringToObject(str3, '/');
        TestIDGenerator.assertEquals((Object)guid, (Object)guid1);
        TestIDGenerator.assertEquals((Object)guid, (Object)guid2);
        TestIDGenerator.assertEquals((Object)guid, (Object)guid3);
        TestIDGenerator.assertEquals((Object)guid, (Object)guid1a);
        TestIDGenerator.assertEquals((Object)guid, (Object)guid2a);
        TestIDGenerator.assertEquals((Object)guid, (Object)guid3a);
    }

    public void testCreatingIDWithDefaultBuiltInFactory() {
        this.generatorWithBuiltIns.create();
    }

    public void testCreatingIDWithDefaultBuiltInFactoryAndSpecifyingProtocol() {
        this.generatorWithBuiltIns.create("strid");
    }

    public void testCreatingIDWithDefaultBuiltInFactoryAndSpecifyingInvalidProtocol() {
        try {
            this.generator.create("This is a protocol that won't match");
            TestIDGenerator.fail((String)"Should have failed to create an ObjectID using an unknown protocol");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testCreatingIDWithDefaultBuiltInFactoryAndSpecifyingNullProtocol() {
        try {
            this.generator.create(null);
            TestIDGenerator.fail((String)"Should have failed to create an ObjectID using a null protocol");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testCreatingIDWithDefaultBuiltInFactoryAndSpecifyingZeroLengthProtocol() {
        try {
            this.generator.create("");
            TestIDGenerator.fail((String)"Should have failed to create an ObjectID using a zero-length protocol");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testRemovingFactories() {
        Collection factories = this.generatorWithBuiltIns.getFactories();
        if (factories.size() != 4) {
            TestIDGenerator.fail((String)("Found " + factories.size() + " factories, but expected 4"));
        }
        this.helpTestRemoveFactory(this.generatorWithBuiltIns, "mmint", true);
        this.helpTestRemoveFactory(this.generatorWithBuiltIns, "strid", true);
        this.helpTestRemoveFactory(this.generatorWithBuiltIns, "mmlong", true);
        this.helpTestRemoveFactory(this.generatorWithBuiltIns, "mmint", false);
        this.helpTestRemoveFactory(this.generatorWithBuiltIns, DEFAULT_FACTORY_PROTOCOL, true);
        this.helpTestRemoveFactory(this.generatorWithBuiltIns, "bogus id", false);
    }

    public void testSettingDefaultFactoryByProtocol() {
        IDGenerator gen = new IDGenerator();
        IntegerIDFactory factory = new IntegerIDFactory();
        this.helpTestGetDefaultFactory(gen, DEFAULT_FACTORY_PROTOCOL);
        gen.addFactory((ObjectIDFactory)factory);
        this.helpTestGetDefaultFactory(gen, DEFAULT_FACTORY_PROTOCOL);
        gen.setDefaultFactory("mmint");
        this.helpTestGetDefaultFactory(gen, "mmint");
    }

    public void testSettingDefaultFactoryByReference() {
        IDGenerator gen = new IDGenerator();
        IntegerIDFactory factory = new IntegerIDFactory();
        this.helpTestGetDefaultFactory(gen, DEFAULT_FACTORY_PROTOCOL);
        gen.addFactory((ObjectIDFactory)factory);
        this.helpTestGetDefaultFactory(gen, DEFAULT_FACTORY_PROTOCOL);
        gen.setDefaultFactory((ObjectIDFactory)factory);
        this.helpTestGetDefaultFactory(gen, "mmint");
    }
}

