/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.core.id;

import junit.framework.TestCase;
import org.teiid.core.id.InvalidIDException;
import org.teiid.core.id.ParsedObjectID;

public class TestParsedObjectID
extends TestCase {
    private static final String EMPTY_STRING = "";
    private static final String PROTOCOL = "SomeProtocol";
    private static final String REMAINDER = "Some remainder";
    private static final String NON_DELIM_CHARS = " !@#$%^&*()01234567890-=_+`~abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ{}|[]]\\;'\"<>?,./\t\n\r";
    private static final String[] PARSABLE_IDS = new String[]{"p123:abcdef", "p123: abcdef", " p123 :abcdef", " p123 : abcdef ", " p123 : abc def ", " p123 : a : b", " p123:a:b", " !@#$%^&*()01234567890-=_+`~abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ{}|[]]\\;'\"<>?,./\t\n\r: !@#$%^&*()01234567890-=_+`~abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ{}|[]]\\;'\"<>?,./\t\n\r", ":"};
    private static final String[] NOT_PARSABLE_IDS = new String[]{"no delimiter", "", null};
    private ParsedObjectID parsedID;
    private ParsedObjectID parsedIDWithNullProtocol;
    private ParsedObjectID parsedIDWithNullRemainder;
    private ParsedObjectID parsedIDWithZeroLengthProtocol;
    private ParsedObjectID parsedIDWithZeroLengthRemainder;

    public TestParsedObjectID(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.parsedID = new ParsedObjectID(PROTOCOL, REMAINDER);
        this.parsedIDWithNullProtocol = new ParsedObjectID(null, REMAINDER);
        this.parsedIDWithNullRemainder = new ParsedObjectID(PROTOCOL, null);
        this.parsedIDWithZeroLengthProtocol = new ParsedObjectID(EMPTY_STRING, REMAINDER);
        this.parsedIDWithZeroLengthRemainder = new ParsedObjectID(PROTOCOL, EMPTY_STRING);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.parsedID = null;
        this.parsedIDWithNullProtocol = null;
        this.parsedIDWithNullRemainder = null;
        this.parsedIDWithZeroLengthProtocol = null;
        this.parsedIDWithZeroLengthRemainder = null;
    }

    public void helpTestParsable(String str, String expectedProtocol, boolean shouldSucceed) {
        ParsedObjectID p;
        block4: {
            p = null;
            try {
                p = expectedProtocol == null ? ParsedObjectID.parsedStringifiedObjectID((String)str) : ParsedObjectID.parsedStringifiedObjectID((String)str, (String)expectedProtocol);
                if (!shouldSucceed) {
                    TestParsedObjectID.fail((String)("Unexpectedly succeeded in parsing string " + str));
                }
            }
            catch (InvalidIDException e) {
                if (!shouldSucceed) break block4;
                throw new RuntimeException(e);
            }
        }
        if (shouldSucceed && expectedProtocol != null && !p.getProtocol().equals(expectedProtocol)) {
            TestParsedObjectID.fail((String)("Result of getProtocol() on parsed string didn't match expected protocol " + expectedProtocol));
        }
    }

    public void helpTestGetProtocol(ParsedObjectID id, String protocol) {
        TestParsedObjectID.assertEquals((String)protocol, (String)id.getProtocol());
    }

    public void helpTestGetRemainder(ParsedObjectID id, String remainder) {
        TestParsedObjectID.assertEquals((String)remainder, (String)id.getRemainder());
    }

    public void testGetProtocol() {
        this.helpTestGetProtocol(this.parsedID, PROTOCOL);
    }

    public void testGetRemainder() {
        this.helpTestGetRemainder(this.parsedID, REMAINDER);
    }

    public void testGetProtocolWhenConstructedWithNullProtocol() {
        this.helpTestGetProtocol(this.parsedIDWithNullProtocol, null);
    }

    public void testGetRemainderWhenConstructedWithNullProtocol() {
        this.helpTestGetRemainder(this.parsedIDWithNullProtocol, REMAINDER);
    }

    public void testGetProtocolWhenConstructedWithNullRemainder() {
        this.helpTestGetProtocol(this.parsedIDWithNullRemainder, PROTOCOL);
    }

    public void testGetRemainderWhenConstructedWithNullRemainder() {
        this.helpTestGetRemainder(this.parsedIDWithNullRemainder, null);
    }

    public void testGetProtocolWhenConstructedWithZeroLengthProtocol() {
        this.helpTestGetProtocol(this.parsedIDWithZeroLengthProtocol, EMPTY_STRING);
    }

    public void testGetRemainderWhenConstructedWithZeroLengthProtocol() {
        this.helpTestGetRemainder(this.parsedIDWithZeroLengthProtocol, REMAINDER);
    }

    public void testGetProtocolWhenConstructedWithZeroLengthRemainder() {
        this.helpTestGetProtocol(this.parsedIDWithZeroLengthRemainder, PROTOCOL);
    }

    public void testGetRemainderWhenConstructedWithZeroLengthRemainder() {
        this.helpTestGetRemainder(this.parsedIDWithZeroLengthRemainder, EMPTY_STRING);
    }

    public void testParsingParsables() {
        for (int i = 0; i < PARSABLE_IDS.length; ++i) {
            String parsableString = PARSABLE_IDS[i];
            this.helpTestParsable(parsableString, null, true);
        }
    }

    public void testParsingNotParsables() {
        for (int i = 0; i < NOT_PARSABLE_IDS.length; ++i) {
            String parsableString = NOT_PARSABLE_IDS[i];
            this.helpTestParsable(parsableString, null, false);
        }
    }
}

