/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.core.id;

import java.util.Collection;
import java.util.HashSet;
import junit.framework.TestCase;
import org.teiid.core.id.InvalidIDException;
import org.teiid.core.id.ObjectID;
import org.teiid.core.id.UUID;
import org.teiid.core.id.UUIDFactory;

public class TestUUIDFactory
extends TestCase {
    private static final int NGEN = 10000;
    static UUIDFactory generator = new UUIDFactory();

    private void helpTestGen(int nGen) {
        UUID uuid = null;
        for (int j = 0; j < Math.min(nGen, 63); ++j) {
            uuid = (UUID)generator.create();
            TestUUIDFactory.checkStringToObject(uuid);
        }
    }

    private void helpTestDuplicates(int nGen) {
        UUID uuid = null;
        HashSet<UUID> uuids = new HashSet<UUID>();
        for (int k = 0; k < nGen; ++k) {
            uuid = (UUID)generator.create();
            TestUUIDFactory.assertTrue((String)("UUID '" + uuid + "' is a duplicate!"), (!uuids.contains(uuid) ? 1 : 0) != 0);
            uuids.add(uuid);
        }
    }

    public static void checkStringToObject(UUID id1) {
        String uuidString = id1.exportableForm();
        UUID id2 = null;
        try {
            id2 = (UUID)UUID.stringToObject((String)uuidString);
        }
        catch (InvalidIDException e) {
            TestUUIDFactory.fail((String)("Could not convert UUID exportable form '" + uuidString + "' to UUID: " + e.getMessage()));
        }
        TestUUIDFactory.assertTrue((String)("UUID '" + id1 + "' conversion to string and back failed: " + "most significant part did not match."), (UUID.getPart1((ObjectID)id1) == UUID.getPart1((ObjectID)id2) ? 1 : 0) != 0);
        TestUUIDFactory.assertTrue((String)("UUID '" + id1 + "' conversion to string and back failed: " + "least significant part did not match."), (UUID.getPart2((ObjectID)id1) == UUID.getPart2((ObjectID)id2) ? 1 : 0) != 0);
    }

    public void helpCheckVariant(Collection objectIDs, int expectedVariant) {
        for (ObjectID uuid : objectIDs) {
            TestUUIDFactory.helpCheckVariant(uuid, expectedVariant);
        }
    }

    public void helpCheckVersion(Collection objectIDs, int expectedVersion) {
        for (ObjectID uuid : objectIDs) {
            TestUUIDFactory.helpCheckVersion(uuid, expectedVersion);
        }
    }

    public static void helpCheckVariant(ObjectID uuid, int expectedVariant) {
        if (UUID.getVariant((ObjectID)uuid) != expectedVariant) {
            TestUUIDFactory.fail((String)("UUID '" + uuid + "' variant ('" + UUID.getVariant((ObjectID)uuid) + "') does not match the expected variant " + expectedVariant));
        }
    }

    public static void helpCheckVersion(ObjectID uuid, int expectedVersion) {
        if (UUID.getVersion((ObjectID)uuid) != expectedVersion) {
            TestUUIDFactory.fail((String)("UUID '" + uuid + "' version ('" + UUID.getVersion((ObjectID)uuid) + "') does not match the expected version " + expectedVersion));
        }
    }

    public void testGen() {
        this.helpTestGen(10000);
    }

    public void testDuplicates() {
        this.helpTestDuplicates(10000);
    }

    public void testVariant() {
        ObjectID uuid = generator.create();
        int variant = UUID.getVariant((ObjectID)uuid);
        if (variant != 2) {
            TestUUIDFactory.fail((String)("The variant " + variant + " doesn't match expected value of " + 2));
        }
    }

    public void testVersion() {
        ObjectID uuid = generator.create();
        int version = UUID.getVersion((ObjectID)uuid);
        if (version != 4) {
            TestUUIDFactory.fail((String)("The version " + version + " doesn't match expected value of " + 4));
        }
    }
}

