/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.dqp.message;

import java.io.Serializable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;
import org.teiid.client.ResultsMessage;
import org.teiid.client.metadata.ParameterInfo;
import org.teiid.client.plan.PlanNode;
import org.teiid.core.util.UnitTestUtil;

public class TestResultsMessage
extends TestCase {
    public TestResultsMessage(String name) {
        super(name);
    }

    public static ResultsMessage example() {
        ResultsMessage message = new ResultsMessage();
        message.setColumnNames(new String[]{"A", "B", "C", "D"});
        message.setDataTypes(new String[]{"biginteger", "biginteger", "biginteger", "biginteger"});
        message.setFinalRow(200);
        message.setFirstRow(1);
        message.setLastRow(100);
        ArrayList<ParameterInfo> parameters = new ArrayList<ParameterInfo>();
        parameters.add(new ParameterInfo(1, 0));
        parameters.add(new ParameterInfo(5, 5));
        message.setParameters(parameters);
        PlanNode planDescs = new PlanNode("test");
        planDescs.addProperty("key1", "val1");
        planDescs.addProperty("key2", "val2");
        planDescs.addProperty("key3", "val3");
        planDescs.addProperty("key4", "val4");
        message.setPlanDescription(planDescs);
        ArrayList<BigInteger> results = new ArrayList<BigInteger>();
        results.add(new BigInteger("100"));
        results.add(new BigInteger("200"));
        results.add(new BigInteger("300"));
        results.add(new BigInteger("400"));
        message.setResults(new List[]{results});
        ArrayList<Exception> warnings = new ArrayList<Exception>();
        warnings.add(new Exception("warning1"));
        warnings.add(new Exception("warning2"));
        message.setWarnings(warnings);
        return message;
    }

    public void testSerialize() throws Exception {
        ResultsMessage message = TestResultsMessage.example();
        ResultsMessage copy = (ResultsMessage)UnitTestUtil.helpSerialize((Serializable)message);
        TestResultsMessage.assertNotNull((Object)copy.getColumnNames());
        TestResultsMessage.assertEquals((int)4, (int)copy.getColumnNames().length);
        TestResultsMessage.assertEquals((String)"A", (String)copy.getColumnNames()[0]);
        TestResultsMessage.assertEquals((String)"B", (String)copy.getColumnNames()[1]);
        TestResultsMessage.assertEquals((String)"C", (String)copy.getColumnNames()[2]);
        TestResultsMessage.assertEquals((String)"D", (String)copy.getColumnNames()[3]);
        TestResultsMessage.assertNotNull((Object)copy.getDataTypes());
        TestResultsMessage.assertEquals((int)4, (int)copy.getDataTypes().length);
        TestResultsMessage.assertEquals((String)"biginteger", (String)copy.getDataTypes()[0]);
        TestResultsMessage.assertEquals((String)"biginteger", (String)copy.getDataTypes()[1]);
        TestResultsMessage.assertEquals((String)"biginteger", (String)copy.getDataTypes()[2]);
        TestResultsMessage.assertEquals((String)"biginteger", (String)copy.getDataTypes()[3]);
        TestResultsMessage.assertEquals((int)200, (int)copy.getFinalRow());
        TestResultsMessage.assertEquals((int)1, (int)copy.getFirstRow());
        TestResultsMessage.assertEquals((int)100, (int)copy.getLastRow());
        TestResultsMessage.assertNotNull((Object)copy.getParameters());
        TestResultsMessage.assertEquals((int)2, (int)copy.getParameters().size());
        ParameterInfo info1 = (ParameterInfo)copy.getParameters().get(0);
        TestResultsMessage.assertEquals((int)1, (int)info1.getType());
        TestResultsMessage.assertEquals((int)0, (int)info1.getNumColumns());
        ParameterInfo info2 = (ParameterInfo)copy.getParameters().get(1);
        TestResultsMessage.assertEquals((int)5, (int)info2.getType());
        TestResultsMessage.assertEquals((int)5, (int)info2.getNumColumns());
        TestResultsMessage.assertNotNull((Object)copy.getPlanDescription());
        TestResultsMessage.assertEquals((int)4, (int)copy.getPlanDescription().getProperties().size());
        TestResultsMessage.assertNotNull((Object)copy.getResults());
        TestResultsMessage.assertEquals((int)1, (int)copy.getResults().length);
        TestResultsMessage.assertNotNull((Object)copy.getResults()[0]);
        TestResultsMessage.assertEquals((int)4, (int)copy.getResults()[0].size());
        TestResultsMessage.assertEquals((Object)new BigInteger("100"), copy.getResults()[0].get(0));
        TestResultsMessage.assertEquals((Object)new BigInteger("200"), copy.getResults()[0].get(1));
        TestResultsMessage.assertEquals((Object)new BigInteger("300"), copy.getResults()[0].get(2));
        TestResultsMessage.assertEquals((Object)new BigInteger("400"), copy.getResults()[0].get(3));
        TestResultsMessage.assertNotNull((Object)copy.getWarnings());
        TestResultsMessage.assertEquals((int)2, (int)copy.getWarnings().size());
        TestResultsMessage.assertEquals(Exception.class, copy.getWarnings().get(0).getClass());
        TestResultsMessage.assertEquals((String)"warning1", (String)((Exception)copy.getWarnings().get(0)).getMessage());
        TestResultsMessage.assertEquals(Exception.class, copy.getWarnings().get(1).getClass());
        TestResultsMessage.assertEquals((String)"warning2", (String)((Exception)copy.getWarnings().get(1)).getMessage());
    }
}

