/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.optimizer.xml;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collection;
import junit.framework.TestCase;
import org.teiid.query.mapping.xml.MappingDocument;
import org.teiid.query.mapping.xml.MappingNode;
import org.teiid.query.mapping.xml.MappingOutputter;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.optimizer.xml.XMLPlanner;
import org.teiid.query.processor.xml.TestXMLProcessor;
import org.teiid.query.sql.LanguageObject;
import org.teiid.query.sql.lang.Query;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.query.sql.visitor.GroupCollectorVisitor;
import org.teiid.query.unittest.FakeMetadataFacade;

public class TestMarkExcludeVisitor
extends TestCase {
    void helpTest(String sql, String expected) throws Exception {
        FakeMetadataFacade metadata = TestXMLProcessor.exampleMetadataCached();
        Query query = (Query)TestXMLProcessor.helpGetCommand(sql, (QueryMetadataInterface)metadata);
        Collection groups = GroupCollectorVisitor.getGroups((LanguageObject)query, (boolean)true);
        GroupSymbol group = (GroupSymbol)groups.iterator().next();
        MappingDocument docOrig = (MappingDocument)metadata.getMappingNode(metadata.getGroupID(group.getName()));
        MappingDocument doc = (MappingDocument)docOrig.clone();
        doc = XMLPlanner.preMarkExcluded((Query)query, (MappingDocument)doc);
        XMLPlanner.removeExcluded((MappingNode)doc);
        MappingOutputter out = new MappingOutputter();
        StringWriter sw = new StringWriter();
        out.write(doc, new PrintWriter(sw));
        String actual = sw.toString();
        expected = expected.replaceAll("\\s*<", "<");
        TestMarkExcludeVisitor.assertEquals((String)expected, (String)actual);
    }

    public void testAttribute() throws Exception {
        String expected = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><xmlMapping><documentEncoding>UTF-8</documentEncoding><formattedDocument>true</formattedDocument>   <mappingNode>       <name>Catalogs</name>       <includeAlways>false</includeAlways>       <mappingNode>           <name>Catalog</name>           <includeAlways>false</includeAlways>           <mappingNode>               <name>Items</name>               <includeAlways>false</includeAlways>                   <mappingNode>                       <name>Item</name>                       <maxOccurs>-1</maxOccurs>                       <source>xmltest.group.items</source>                       <includeAlways>false</includeAlways>                       <mappingNode>                           <name>ItemID</name>                           <nodeType>attribute</nodeType>                           <symbol>xmltest.group.items.itemNum</symbol>                           <includeAlways>false</includeAlways>                       </mappingNode>                   </mappingNode>           </mappingNode>       </mappingNode>   </mappingNode></xmlMapping>";
        this.helpTest("SELECT Catalogs.Catalog.Items.Item.@ItemID FROM xmltest.doc9", expected);
    }

    public void testGroupNode() throws Exception {
        String expected = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><xmlMapping><documentEncoding>UTF-8</documentEncoding><formattedDocument>true</formattedDocument>   <mappingNode>       <name>Catalogs</name>       <includeAlways>false</includeAlways>       <mappingNode>           <name>Catalog</name>           <includeAlways>false</includeAlways>           <mappingNode>               <name>Items</name>               <includeAlways>false</includeAlways>               <mappingNode>                   <name>Item</name>                   <maxOccurs>-1</maxOccurs>                   <source>xmltest.group.items</source>                   <includeAlways>false</includeAlways>                   <mappingNode>                       <name>Suppliers</name>                       <includeAlways>false</includeAlways>                       <mappingNode>                           <name>Supplier</name>                           <maxOccurs>-1</maxOccurs>                           <source>xmltest.suppliers</source>                           <includeAlways>false</includeAlways>                           <mappingNode>                               <name>SupplierID</name>                               <nodeType>attribute</nodeType>                               <symbol>xmltest.suppliers.supplierNum</symbol>                               <includeAlways>false</includeAlways>                           </mappingNode>                           <mappingNode>                               <name>Name</name>                               <symbol>xmltest.suppliers.supplierName</symbol>                               <includeAlways>false</includeAlways>                           </mappingNode>                           <mappingNode>                               <name>Zip</name>                               <symbol>xmltest.suppliers.supplierZipCode</symbol>                               <includeAlways>false</includeAlways>                           </mappingNode>                           <mappingNode>                               <name>Orders</name>                               <includeAlways>false</includeAlways>                               <mappingNode>                                   <name>Order</name>                                   <maxOccurs>-1</maxOccurs>                                   <source>xmltest.orders</source>                                   <includeAlways>false</includeAlways>                                   <mappingNode>                                       <name>OrderID</name>                                       <nodeType>attribute</nodeType>                                       <symbol>xmltest.orders.orderNum</symbol>                                       <includeAlways>false</includeAlways>                                   </mappingNode>                                   <mappingNode>                                       <name>OrderDate</name>                                       <symbol>xmltest.orders.orderDate</symbol>                                       <includeAlways>false</includeAlways>                                   </mappingNode>                                   <mappingNode>                                       <name>OrderQuantity</name>                                       <symbol>xmltest.orders.orderQty</symbol>                                       <includeAlways>false</includeAlways>                                   </mappingNode>                                   <mappingNode>                                       <name>OrderStatus</name>                                       <minOccurs>0</minOccurs>                                       <symbol>xmltest.orders.orderStatus</symbol>                                       <includeAlways>false</includeAlways>                                   </mappingNode>                               </mappingNode>                           </mappingNode>                       </mappingNode>                   </mappingNode>               </mappingNode>           </mappingNode>       </mappingNode>   </mappingNode></xmlMapping>";
        this.helpTest("SELECT Catalogs.Catalog.Items.Item.Suppliers.Supplier.* FROM xmltest.doc9", expected);
        this.helpTest("SELECT Supplier.* FROM xmltest.doc9", expected);
    }

    public void testElements() throws Exception {
        String expected = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><xmlMapping><documentEncoding>UTF-8</documentEncoding><formattedDocument>true</formattedDocument>   <mappingNode>       <name>Catalogs</name>       <includeAlways>false</includeAlways>       <mappingNode>           <name>Catalog</name>           <includeAlways>false</includeAlways>           <mappingNode>               <name>Items</name>               <includeAlways>false</includeAlways>               <mappingNode>                   <name>Item</name>                   <maxOccurs>-1</maxOccurs>                   <source>xmltest.group.items</source>                   <includeAlways>false</includeAlways>                   <mappingNode>                       <name>ItemID</name>                       <nodeType>attribute</nodeType>                       <symbol>xmltest.group.items.itemNum</symbol>                       <includeAlways>false</includeAlways>                   </mappingNode>                   <mappingNode>                       <name>Suppliers</name>                       <includeAlways>false</includeAlways>                       <mappingNode>                           <name>Supplier</name>                           <maxOccurs>-1</maxOccurs>                           <source>xmltest.suppliers</source>                           <includeAlways>false</includeAlways>                           <mappingNode>                               <name>SupplierID</name>                               <nodeType>attribute</nodeType>                               <symbol>xmltest.suppliers.supplierNum</symbol>                               <includeAlways>false</includeAlways>                           </mappingNode>                           <mappingNode>                               <name>Orders</name>                               <includeAlways>false</includeAlways>                               <mappingNode>                                   <name>Order</name>                                   <maxOccurs>-1</maxOccurs>                                   <source>xmltest.orders</source>                                   <includeAlways>false</includeAlways>                                   <mappingNode>                                       <name>OrderID</name>                                       <nodeType>attribute</nodeType>                                       <symbol>xmltest.orders.orderNum</symbol>                                       <includeAlways>false</includeAlways>                                   </mappingNode>                                   <mappingNode>                                       <name>OrderQuantity</name>                                       <symbol>xmltest.orders.orderQty</symbol>                                       <includeAlways>false</includeAlways>                                   </mappingNode>                               </mappingNode>                           </mappingNode>                       </mappingNode>                   </mappingNode>               </mappingNode>           </mappingNode>       </mappingNode>   </mappingNode></xmlMapping>";
        this.helpTest("SELECT OrderQuantity, SupplierID, ItemID, OrderID FROM xmltest.doc9 ORDER BY Catalogs.Catalog.Items.Item.Suppliers.Supplier.SupplierID ASC, OrderID DESC, Catalogs.Catalog.Items.Item.ItemID DESC", expected);
    }

    public void testSelectAll() throws Exception {
        String expected = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><xmlMapping><documentEncoding>UTF-8</documentEncoding><formattedDocument>true</formattedDocument>   <mappingNode>       <name>Catalogs</name>       <includeAlways>false</includeAlways>       <mappingNode>           <name>Catalog</name>           <includeAlways>false</includeAlways>           <mappingNode>               <name>Items</name>               <includeAlways>false</includeAlways>               <mappingNode>                   <name>Item</name>                   <maxOccurs>-1</maxOccurs>                   <source>xmltest.group.items</source>                   <includeAlways>false</includeAlways>                   <mappingNode>                       <name>ItemID</name>                       <nodeType>attribute</nodeType>                       <symbol>xmltest.group.items.itemNum</symbol>                       <includeAlways>false</includeAlways>                   </mappingNode>                   <mappingNode>                       <name>Name</name>                       <symbol>xmltest.group.items.itemName</symbol>                       <includeAlways>false</includeAlways>                   </mappingNode>                   <mappingNode>                       <name>Quantity</name>                       <symbol>xmltest.group.items.itemQuantity</symbol>                       <includeAlways>false</includeAlways>                   </mappingNode>                   <mappingNode>                       <name>Suppliers</name>                       <includeAlways>false</includeAlways>                       <mappingNode>                           <name>Supplier</name>                           <maxOccurs>-1</maxOccurs>                           <source>xmltest.suppliers</source>                           <includeAlways>false</includeAlways>                           <mappingNode>                               <name>SupplierID</name>                               <nodeType>attribute</nodeType>                               <symbol>xmltest.suppliers.supplierNum</symbol>                               <includeAlways>false</includeAlways>                           </mappingNode>                           <mappingNode>                               <name>Name</name>                               <symbol>xmltest.suppliers.supplierName</symbol>                               <includeAlways>false</includeAlways>                           </mappingNode>                           <mappingNode>                               <name>Zip</name>                               <symbol>xmltest.suppliers.supplierZipCode</symbol>                               <includeAlways>false</includeAlways>                           </mappingNode>                           <mappingNode>                               <name>Orders</name>                               <includeAlways>false</includeAlways>                               <mappingNode>                                   <name>Order</name>                                   <maxOccurs>-1</maxOccurs>                                   <source>xmltest.orders</source>                                   <includeAlways>false</includeAlways>                                   <mappingNode>                                       <name>OrderID</name>                                       <nodeType>attribute</nodeType>                                       <symbol>xmltest.orders.orderNum</symbol>                                       <includeAlways>false</includeAlways>                                   </mappingNode>                                   <mappingNode>                                       <name>OrderDate</name>                                       <symbol>xmltest.orders.orderDate</symbol>                                       <includeAlways>false</includeAlways>                                   </mappingNode>                                   <mappingNode>                                       <name>OrderQuantity</name>                                       <symbol>xmltest.orders.orderQty</symbol>                                       <includeAlways>false</includeAlways>                                   </mappingNode>                                   <mappingNode>                                       <name>OrderStatus</name>                                       <minOccurs>0</minOccurs>                                       <symbol>xmltest.orders.orderStatus</symbol>                                       <includeAlways>false</includeAlways>                                   </mappingNode>                               </mappingNode>                           </mappingNode>                       </mappingNode>                   </mappingNode>               </mappingNode>           </mappingNode>       </mappingNode>   </mappingNode></xmlMapping>";
        this.helpTest("SELECT * FROM xmltest.doc9", expected);
    }
}

