/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.processor;

import java.util.ArrayList;
import java.util.List;
import org.teiid.common.buffer.BlockedException;
import org.teiid.common.buffer.TupleSource;
import org.teiid.core.TeiidComponentException;

public class FakeTupleSource
implements TupleSource {
    private List elements;
    private List[] tuples;
    private int index = 0;
    private List expectedSymbols;
    private int[] columnMap;
    private boolean blockOnce;

    public FakeTupleSource(List elements, List[] tuples) {
        this.elements = elements;
        this.tuples = tuples;
    }

    public FakeTupleSource(List elements, List[] tuples, List expectedSymbols, int[] columnMap) {
        this.elements = elements;
        this.tuples = tuples;
        this.expectedSymbols = expectedSymbols;
        this.columnMap = columnMap;
    }

    public List getSchema() {
        List theElements = null;
        theElements = this.expectedSymbols != null ? this.expectedSymbols : this.elements;
        return theElements;
    }

    public void openSource() throws TeiidComponentException {
        this.index = 0;
    }

    public List nextTuple() throws TeiidComponentException {
        if (this.blockOnce) {
            this.blockOnce = false;
            throw BlockedException.INSTANCE;
        }
        if (this.index < this.tuples.length) {
            List tuple = this.tuples[this.index++];
            if (this.expectedSymbols == null) {
                return tuple;
            }
            ArrayList mappedTuple = new ArrayList(this.expectedSymbols.size());
            for (int i = 0; i < this.columnMap.length; ++i) {
                int colIndex = this.columnMap[i];
                if (colIndex >= 0) {
                    mappedTuple.add(tuple.get(colIndex));
                    continue;
                }
                mappedTuple.add(null);
            }
            return mappedTuple;
        }
        return null;
    }

    public void closeSource() {
    }

    public void setBlockOnce() {
        this.blockOnce = true;
    }

    public static class FakeComponentException
    extends TeiidComponentException {
    }
}

