/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.processor;

import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Executor;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.teiid.cache.CacheFactory;
import org.teiid.cache.DefaultCacheFactory;
import org.teiid.common.buffer.BufferManager;
import org.teiid.common.buffer.BufferManagerFactory;
import org.teiid.core.TeiidProcessingException;
import org.teiid.dqp.internal.process.QueryProcessorFactoryImpl;
import org.teiid.dqp.internal.process.SessionAwareCache;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.metadata.TempMetadataAdapter;
import org.teiid.query.optimizer.capabilities.CapabilitiesFinder;
import org.teiid.query.optimizer.capabilities.DefaultCapabilitiesFinder;
import org.teiid.query.processor.HardcodedDataManager;
import org.teiid.query.processor.ProcessorDataManager;
import org.teiid.query.processor.ProcessorPlan;
import org.teiid.query.processor.QueryProcessor;
import org.teiid.query.processor.TestProcessor;
import org.teiid.query.tempdata.TempTableDataManager;
import org.teiid.query.tempdata.TempTableStore;
import org.teiid.query.unittest.RealMetadataFactory;
import org.teiid.query.util.CommandContext;

public class TestMaterialization {
    private TempMetadataAdapter metadata;
    private TempTableDataManager dataManager;
    private TempTableStore tempStore;
    private TempTableStore globalStore;
    private ProcessorPlan previousPlan;
    private HardcodedDataManager hdm;

    @Before
    public void setUp() {
        this.tempStore = new TempTableStore("1");
        this.globalStore = new TempTableStore("SYSTEM");
        this.metadata = new TempMetadataAdapter(RealMetadataFactory.exampleMaterializedView(), this.tempStore.getMetadataStore());
        this.hdm = new HardcodedDataManager();
        this.hdm.addData("SELECT matsrc.x FROM matsrc", new List[]{Arrays.asList(new String[]{null}), Arrays.asList("one"), Arrays.asList("two"), Arrays.asList("three")});
        this.hdm.addData("SELECT mattable.info.e1, mattable.info.e2 FROM mattable.info", new List[]{Arrays.asList("a", 1), Arrays.asList("a", 2)});
        this.hdm.addData("SELECT mattable.info.e2, mattable.info.e1 FROM mattable.info", new List[]{Arrays.asList(1, "a"), Arrays.asList(2, "a")});
        BufferManager bm = BufferManagerFactory.getStandaloneBufferManager();
        SessionAwareCache cache = new SessionAwareCache();
        cache.setBufferManager(bm);
        Executor executor = new Executor(){

            @Override
            public void execute(Runnable command) {
                command.run();
            }
        };
        this.dataManager = new TempTableDataManager((ProcessorDataManager)this.hdm, bm, executor, cache, cache, (CacheFactory)new DefaultCacheFactory());
    }

    private void execute(String sql, List<?> ... expectedResults) throws Exception {
        CommandContext cc = TestProcessor.createCommandContext();
        cc.setTempTableStore(this.tempStore);
        cc.setGlobalTableStore(this.globalStore);
        cc.setMetadata((QueryMetadataInterface)this.metadata);
        DefaultCapabilitiesFinder finder = new DefaultCapabilitiesFinder();
        this.previousPlan = TestProcessor.helpGetPlan(TestProcessor.helpParse(sql), (QueryMetadataInterface)this.metadata, (CapabilitiesFinder)finder, cc);
        cc.setQueryProcessorFactory((QueryProcessor.ProcessorFactory)new QueryProcessorFactoryImpl(BufferManagerFactory.getStandaloneBufferManager(), (ProcessorDataManager)this.dataManager, (CapabilitiesFinder)finder, null, (QueryMetadataInterface)this.metadata));
        TestProcessor.doProcess(this.previousPlan, (ProcessorDataManager)this.dataManager, expectedResults, cc);
    }

    @Test
    public void testPopulate() throws Exception {
        this.execute("SELECT * from vgroup3 where x = 'one'", Arrays.asList("one", "zne"));
        Assert.assertEquals((long)1L, (long)this.hdm.getCommandHistory().size());
        this.execute("SELECT * from vgroup3 where x is null", Arrays.asList(null, null));
        Assert.assertEquals((long)1L, (long)this.hdm.getCommandHistory().size());
    }

    @Test(expected=TeiidProcessingException.class)
    public void testCodeTableResponseException() throws Exception {
        this.execute("select lookup('mattable.info', 'e2', 'e1', 'a')", new List[0]);
    }

    @Test
    public void testCodeTable() throws Exception {
        this.execute("select lookup('mattable.info', 'e1', 'e2', 5)", Arrays.asList(new String[]{null}));
        Assert.assertEquals((long)1L, (long)this.hdm.getCommandHistory().size());
        this.execute("select lookup('mattable.info', 'e1', 'e2', 1)", Arrays.asList("a"));
        Assert.assertEquals((long)1L, (long)this.hdm.getCommandHistory().size());
    }

    @Test
    public void testTtl() throws Exception {
        this.execute("SELECT * from vgroup4 where x = 'one'", Arrays.asList("one"));
        Assert.assertEquals((long)1L, (long)this.hdm.getCommandHistory().size());
        this.execute("SELECT * from vgroup4 where x is null", Arrays.asList(new String[]{null}));
        Assert.assertEquals((long)1L, (long)this.hdm.getCommandHistory().size());
        Thread.sleep(150L);
        this.execute("SELECT * from vgroup4 where x is null", Arrays.asList(new String[]{null}));
        Assert.assertEquals((long)2L, (long)this.hdm.getCommandHistory().size());
    }

    @Test
    public void testProcedureCache() throws Exception {
        this.execute("call sp1('one')", Arrays.asList("one"));
        Assert.assertEquals((long)1L, (long)this.hdm.getCommandHistory().size());
        this.execute("call sp1('one')", Arrays.asList("one"));
        Assert.assertEquals((long)1L, (long)this.hdm.getCommandHistory().size());
        this.execute("call sp1('one') option nocache sp.sp1", Arrays.asList("one"));
        Assert.assertEquals((long)2L, (long)this.hdm.getCommandHistory().size());
        this.execute("call sp1(null)", new List[0]);
        Assert.assertEquals((long)3L, (long)this.hdm.getCommandHistory().size());
        this.execute("call sp1(null)", new List[0]);
        Assert.assertEquals((long)3L, (long)this.hdm.getCommandHistory().size());
    }

    @Test
    public void testCoveringSecondaryIndex() throws Exception {
        this.execute("SELECT * from vgroup3 where y in ('zne', 'zwo') order by y desc", Arrays.asList("two", "zwo"), Arrays.asList("one", "zne"));
        this.execute("SELECT * from vgroup3 where y is null", Arrays.asList(null, null));
    }

    @Test
    public void testNonCoveringSecondaryIndex() throws Exception {
        this.execute("SELECT * from vgroup5 where y in ('zne', 'zwo') order by y desc", Arrays.asList("two", "zwo", 1), Arrays.asList("one", "zne", 1));
        this.execute("SELECT * from vgroup5 where y is null", Arrays.asList(null, null, 1));
        this.execute("SELECT * from vgroup5 where y is null and z = 2", new List[0]);
    }

    @Test
    public void testNonCoveringSecondaryIndexWithoutPrimaryKey() throws Exception {
        this.execute("SELECT * from vgroup6 where y in ('zne', 'zwo') order by y desc", Arrays.asList("two", "zwo"), Arrays.asList("one", "zne"));
        this.execute("SELECT * from vgroup6 where y is null", Arrays.asList(null, null));
    }

    @Test
    public void testPrimaryKeyOnOtherColumn() throws Exception {
        this.execute("SELECT * from vgroup7 where y is null", Arrays.asList("1", null, 1));
    }
}

