/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.processor.relational;

import java.util.Arrays;
import junit.framework.TestCase;
import org.teiid.common.buffer.BufferManager;
import org.teiid.common.buffer.BufferManagerFactory;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.parser.QueryParser;
import org.teiid.query.processor.FakeDataManager;
import org.teiid.query.processor.ProcessorDataManager;
import org.teiid.query.processor.TestProcessor;
import org.teiid.query.processor.relational.AccessNode;
import org.teiid.query.processor.relational.RelationalNodeUtil;
import org.teiid.query.resolver.TestResolver;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.lang.CompoundCriteria;
import org.teiid.query.sql.lang.IsNullCriteria;
import org.teiid.query.sql.lang.Query;
import org.teiid.query.sql.lang.SetClauseList;
import org.teiid.query.sql.lang.Update;
import org.teiid.query.sql.symbol.Constant;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.query.unittest.FakeMetadataFactory;
import org.teiid.query.util.CommandContext;

public class TestAccessNode
extends TestCase {
    private void helpTestOpen(Command command, String expectedCommand, boolean shouldRegisterRequest) throws Exception {
        AccessNode node = new AccessNode(1);
        node.setCommand(command);
        CommandContext context = new CommandContext();
        context.setProcessorID((Object)"processorID");
        BufferManager bm = BufferManagerFactory.getStandaloneBufferManager();
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        node.initialize(context, bm, (ProcessorDataManager)dataManager);
        node.setShouldEvaluateExpressions(true);
        node.open();
        if (shouldRegisterRequest) {
            TestAccessNode.assertEquals(Arrays.asList(expectedCommand), dataManager.getQueries());
        } else {
            TestAccessNode.assertEquals((int)0, (int)dataManager.getQueries().size());
        }
    }

    public void testOpen_Defect16059() throws Exception {
        Query query = (Query)TestResolver.helpResolve("SELECT e1, e2 FROM pm1.g1 WHERE e2 = 5 AND ? IS NULL", (QueryMetadataInterface)FakeMetadataFactory.example1Cached(), null);
        IsNullCriteria nullCrit = (IsNullCriteria)((CompoundCriteria)query.getCriteria()).getCriteria(1);
        nullCrit.setExpression((Expression)new Constant(null));
        this.helpTestOpen((Command)query, "SELECT e1, e2 FROM pm1.g1 WHERE e2 = 5", true);
    }

    public void testOpen_Defect16059_2() throws Exception {
        Query query = (Query)TestResolver.helpResolve("SELECT e1, e2 FROM pm1.g1 WHERE e2 = 5 AND ? IS NOT NULL", (QueryMetadataInterface)FakeMetadataFactory.example1Cached(), null);
        IsNullCriteria nullCrit = (IsNullCriteria)((CompoundCriteria)query.getCriteria()).getCriteria(1);
        nullCrit.setExpression((Expression)new Constant(null));
        this.helpTestOpen((Command)query, null, false);
    }

    public void testExecCount() throws Exception {
        AccessNode node = new AccessNode(1);
        Query query = (Query)TestResolver.helpResolve("SELECT e1, e2 FROM pm1.g1 WHERE e2 = 5", (QueryMetadataInterface)FakeMetadataFactory.example1Cached(), null);
        node.setCommand((Command)query);
        CommandContext context = new CommandContext();
        context.setProcessorID((Object)"processorID");
        BufferManager bm = BufferManagerFactory.getStandaloneBufferManager();
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        node.initialize(context, bm, (ProcessorDataManager)dataManager);
        node.open();
        TestAccessNode.assertEquals(Arrays.asList("SELECT e1, e2 FROM pm1.g1 WHERE e2 = 5"), dataManager.getQueries());
    }

    public void testShouldExecuteUpdate() throws Exception {
        Update update = new Update();
        update.setGroup(new GroupSymbol("test"));
        update.addChange(new ElementSymbol("e1"), (Expression)new Constant((Object)"1"));
        TestAccessNode.assertTrue((boolean)RelationalNodeUtil.shouldExecute((Command)update, (boolean)false));
        update.setChangeList(new SetClauseList());
        TestAccessNode.assertFalse((boolean)RelationalNodeUtil.shouldExecute((Command)update, (boolean)false));
    }

    public void testShouldExecuteLimitZero() throws Exception {
        Query query = (Query)QueryParser.getQueryParser().parseCommand("SELECT e1, e2 FROM pm1.g1 LIMIT 0");
        TestAccessNode.assertFalse((boolean)RelationalNodeUtil.shouldExecute((Command)query, (boolean)false));
    }
}

