/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.resolver;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import org.teiid.api.exception.query.QueryMetadataException;
import org.teiid.api.exception.query.QueryParserException;
import org.teiid.api.exception.query.QueryResolverException;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.types.DataTypeManager;
import org.teiid.query.mapping.relational.QueryNode;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.metadata.TempMetadataAdapter;
import org.teiid.query.metadata.TempMetadataStore;
import org.teiid.query.parser.QueryParser;
import org.teiid.query.resolver.ProcedureContainerResolver;
import org.teiid.query.resolver.QueryResolver;
import org.teiid.query.resolver.TestResolver;
import org.teiid.query.resolver.util.ResolverUtil;
import org.teiid.query.sql.LanguageObject;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.lang.GroupContext;
import org.teiid.query.sql.lang.Insert;
import org.teiid.query.sql.lang.ProcedureContainer;
import org.teiid.query.sql.proc.AssignmentStatement;
import org.teiid.query.sql.proc.Block;
import org.teiid.query.sql.proc.CommandStatement;
import org.teiid.query.sql.proc.CreateUpdateProcedureCommand;
import org.teiid.query.sql.proc.LoopStatement;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.query.sql.visitor.ElementCollectorVisitor;
import org.teiid.query.unittest.FakeMetadataFacade;
import org.teiid.query.unittest.FakeMetadataFactory;
import org.teiid.query.unittest.FakeMetadataObject;

public class TestProcedureResolving {
    private QueryMetadataInterface exampleStoredProcedure(String procedure) {
        FakeMetadataFacade metadata = FakeMetadataFactory.example1();
        FakeMetadataObject pm1 = metadata.getStore().findObject("pm1", "Model");
        FakeMetadataObject rs2 = FakeMetadataFactory.createResultSet("pm1.rs1", pm1, new String[]{"e1"}, new String[]{"string"});
        FakeMetadataObject rs2p1 = FakeMetadataFactory.createParameter("ret", 1, 5, "object", rs2);
        FakeMetadataObject rs2p2 = FakeMetadataFactory.createParameter("in", 2, 1, "string", null);
        QueryNode sq2n1 = new QueryNode("pm1.sq1", procedure);
        FakeMetadataObject sq1 = FakeMetadataFactory.createVirtualProcedure("pm1.sq1", pm1, Arrays.asList(rs2p1, rs2p2), sq2n1);
        metadata.getStore().addObject(rs2);
        metadata.getStore().addObject(sq1);
        return metadata;
    }

    private void helpFailUpdateProcedure(String procedure, String userUpdateStr, String procedureType) {
        this.helpFailUpdateProcedure(procedure, userUpdateStr, procedureType, null);
    }

    private void helpFailUpdateProcedure(String procedure, String userUpdateStr, String procedureType, String msg) {
        try {
            this.helpResolveUpdateProcedure(procedure, userUpdateStr, procedureType);
            Assert.fail((String)"Expected a QueryResolverException but got none.");
        }
        catch (QueryResolverException ex) {
            if (msg != null) {
                Assert.assertEquals((Object)msg, (Object)ex.getMessage());
            }
        }
        catch (TeiidComponentException e) {
            throw new RuntimeException(e);
        }
        catch (QueryParserException e) {
            throw new RuntimeException(e);
        }
    }

    public static Map getProcedureExternalMetadata(GroupSymbol virtualGroup, QueryMetadataInterface metadata) throws QueryMetadataException, TeiidComponentException {
        HashMap<GroupSymbol, List> externalMetadata = new HashMap<GroupSymbol, List>();
        List elements = ResolverUtil.resolveElementsInGroup((GroupSymbol)virtualGroup, (QueryMetadataInterface)metadata);
        externalMetadata.put(virtualGroup, elements);
        TempMetadataStore tms = new TempMetadataStore();
        TempMetadataAdapter tma = new TempMetadataAdapter(metadata, tms);
        GroupContext gc = ProcedureContainerResolver.createChildMetadata((TempMetadataStore)tms, (QueryMetadataInterface)metadata, (GroupSymbol)virtualGroup);
        for (GroupSymbol symbol : gc.getAllGroups()) {
            externalMetadata.put(symbol, ResolverUtil.resolveElementsInGroup((GroupSymbol)symbol, (QueryMetadataInterface)tma));
        }
        return externalMetadata;
    }

    @Test
    public void testDefect13029_CorrectlySetUpdateProcedureTempGroupIDs() throws Exception {
        StringBuffer proc = new StringBuffer("CREATE VIRTUAL PROCEDURE").append("\nBEGIN").append("\nDECLARE string var1;").append("\nvar1 = '';").append("\n  LOOP ON (SELECT pm1.g1.e1 FROM pm1.g1) AS loopCursor").append("\n  BEGIN").append("\n    LOOP ON (SELECT pm1.g2.e1 FROM pm1.g2 WHERE loopCursor.e1 = pm1.g2.e1) AS loopCursor2").append("\n    BEGIN").append("\n      var1 = CONCAT(var1, CONCAT(' ', loopCursor2.e1));").append("\n    END").append("\n  END").append("\nEND");
        String userUpdateStr = "UPDATE vm1.g1 SET e1='x'";
        CreateUpdateProcedureCommand command = this.helpResolveUpdateProcedure(proc.toString(), userUpdateStr, "updateProcedure");
        Map tempIDs = command.getTemporaryMetadata();
        Assert.assertNotNull((Object)tempIDs);
        Assert.assertNull(tempIDs.get("LOOPCURSOR"));
        Assert.assertNull(tempIDs.get("LOOPCURSOR2"));
        Command subCommand = (Command)command.getSubCommands().get(0);
        tempIDs = subCommand.getTemporaryMetadata();
        Assert.assertNotNull((Object)tempIDs);
        Assert.assertNull(tempIDs.get("LOOPCURSOR"));
        Assert.assertNull(tempIDs.get("LOOPCURSOR2"));
        subCommand = (Command)command.getSubCommands().get(1);
        tempIDs = subCommand.getTemporaryMetadata();
        Assert.assertNotNull((Object)tempIDs);
        Assert.assertNotNull(tempIDs.get("LOOPCURSOR"));
        Assert.assertNull(tempIDs.get("LOOPCURSOR2"));
    }

    private CreateUpdateProcedureCommand helpResolveUpdateProcedure(String procedure, String userUpdateStr, String procedureType) throws QueryParserException, QueryResolverException, TeiidComponentException {
        FakeMetadataFacade metadata = FakeMetadataFactory.exampleUpdateProc(procedureType, procedure);
        return this.resolveProcedure(userUpdateStr, (QueryMetadataInterface)metadata);
    }

    private CreateUpdateProcedureCommand resolveProcedure(String userUpdateStr, QueryMetadataInterface metadata) throws QueryParserException, QueryResolverException, TeiidComponentException, QueryMetadataException {
        ProcedureContainer userCommand = (ProcedureContainer)QueryParser.getQueryParser().parseCommand(userUpdateStr);
        QueryResolver.resolveCommand((Command)userCommand, (QueryMetadataInterface)metadata);
        metadata = new TempMetadataAdapter(metadata, new TempMetadataStore(userCommand.getTemporaryMetadata()));
        return (CreateUpdateProcedureCommand)QueryResolver.expandCommand((ProcedureContainer)userCommand, (QueryMetadataInterface)metadata, null);
    }

    private void helpResolveException(String userUpdateStr, QueryMetadataInterface metadata, String msg) throws QueryParserException, TeiidComponentException {
        try {
            this.helpResolve(userUpdateStr, metadata);
        }
        catch (QueryResolverException e) {
            Assert.assertEquals((Object)msg, (Object)e.getMessage());
        }
    }

    private CreateUpdateProcedureCommand helpResolve(String userUpdateStr, QueryMetadataInterface metadata) throws QueryParserException, QueryResolverException, TeiidComponentException {
        return this.resolveProcedure(userUpdateStr, metadata);
    }

    @Test
    public void testDefect23257() throws Exception {
        CreateUpdateProcedureCommand command = this.helpResolve("EXEC pm5.vsp59()", (QueryMetadataInterface)FakeMetadataFactory.example1Cached());
        CommandStatement cs = (CommandStatement)command.getBlock().getStatements().get(1);
        Insert insert = (Insert)cs.getCommand();
        Assert.assertEquals((Object)DataTypeManager.DefaultDataClasses.SHORT, (Object)((Expression)insert.getValues().get(1)).getType());
    }

    @Test
    public void testProcedureScoping() throws Exception {
        StringBuffer proc = new StringBuffer("CREATE PROCEDURE").append("\nBEGIN").append("\n  declare integer e1 = 1;").append("\n  e1 = e1;").append("\n  LOOP ON (SELECT pm1.g1.e1 FROM pm1.g1) AS loopCursor").append("\n  BEGIN").append("\n    variables.e1 = convert(e1, integer);").append("\n  END").append("\nEND");
        String userUpdateStr = "UPDATE vm1.g1 SET e1='x'";
        CreateUpdateProcedureCommand command = this.helpResolveUpdateProcedure(proc.toString(), userUpdateStr, "updateProcedure");
        Block block = command.getBlock();
        AssignmentStatement assStmt = (AssignmentStatement)block.getStatements().get(1);
        Assert.assertEquals((Object)"VARIABLES", (Object)assStmt.getVariable().getGroupSymbol().getCanonicalName());
        Assert.assertEquals((Object)"VARIABLES", (Object)((ElementSymbol)assStmt.getValue()).getGroupSymbol().getCanonicalName());
        Block inner = ((LoopStatement)block.getStatements().get(2)).getBlock();
        assStmt = (AssignmentStatement)inner.getStatements().get(0);
        ElementSymbol value = (ElementSymbol)ElementCollectorVisitor.getElements((LanguageObject)assStmt.getValue(), (boolean)false).iterator().next();
        Assert.assertEquals((Object)"LOOPCURSOR", (Object)value.getGroupSymbol().getCanonicalName());
    }

    @Test
    public void testCreateUpdateProcedure4() {
        String procedure = "CREATE PROCEDURE  ";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "DECLARE boolean var1;\n";
        procedure = procedure + "if(var1 =1);\n";
        procedure = procedure + "var1 = Select pm1.g1.e2 from pm1.g1;\n";
        procedure = procedure + "END\n";
        String userUpdateStr = "UPDATE vm1.g1 SET e1='x'";
        this.helpFailUpdateProcedure(procedure, userUpdateStr, "updateProcedure");
    }

    @Test
    public void testCreateUpdateProcedure5() {
        String procedure = "CREATE PROCEDURE  ";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "DECLARE boolean var1;\n";
        procedure = procedure + "var1 = var1 + var1;\n";
        procedure = procedure + "var1 = Select pm1.g1.e2 from pm1.g1 whwre var1 = var1+var1;\n";
        procedure = procedure + "END\n";
        String userUpdateStr = "UPDATE vm1.g1 SET e1='x'";
        this.helpFailUpdateProcedure(procedure, userUpdateStr, "updateProcedure");
    }

    @Test
    public void testCreateUpdateProcedure6() {
        String procedure = "CREATE PROCEDURE  ";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "DECLARE integer var1;\n";
        procedure = procedure + "if(var1 =1)\n";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "DECLARE boolean var1;\n";
        procedure = procedure + "Select pm1.g1.e2 from pm1.g1 where var1 = pm1.g1.e3;\n";
        procedure = procedure + "END\n";
        procedure = procedure + "END\n";
        String userUpdateStr = "UPDATE vm1.g1 SET e1='x'";
        this.helpFailUpdateProcedure(procedure, userUpdateStr, "updateProcedure", "Variable var1 was previously declared.");
    }

    @Test
    public void testCreateUpdateProcedure7() throws Exception {
        String procedure = "CREATE PROCEDURE  ";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "DECLARE integer var1;\n";
        procedure = procedure + "if(var1 =1)\n";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "DECLARE boolean var2;\n";
        procedure = procedure + "Select pm1.g1.e2 from pm1.g1 where var1 = pm1.g1.e1;\n";
        procedure = procedure + "END\n";
        procedure = procedure + "END\n";
        String userUpdateStr = "UPDATE vm1.g1 SET e1='x'";
        this.helpResolveUpdateProcedure(procedure, userUpdateStr, "updateProcedure");
    }

    @Test
    public void testCreateUpdateProcedure8() {
        String procedure = "CREATE PROCEDURE  ";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "DECLARE integer var1;\n";
        procedure = procedure + "if(var1 =1)\n";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "DECLARE integer var2;\n";
        procedure = procedure + "Select pm1.g1.e2 from pm1.g1 where var1 = pm1.g1.e1;\n";
        procedure = procedure + "END\n";
        procedure = procedure + "var2 = 1\n";
        procedure = procedure + "END\n";
        String userUpdateStr = "UPDATE vm1.g1 SET e1='x'";
        this.helpFailUpdateProcedure(procedure, userUpdateStr, "updateProcedure");
    }

    @Test
    public void testCreateUpdateProcedure9() {
        String procedure = "CREATE PROCEDURE  ";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "DECLARE integer var1;\n";
        procedure = procedure + "if(var1 =1)\n";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "DECLARE boolean var1;\n";
        procedure = procedure + "Select pm1.g1.e2 from pm1.g1 where var1 = pm1.g1.e3;\n";
        procedure = procedure + "END\n";
        procedure = procedure + "var1 = var1 +1;\n";
        procedure = procedure + "END\n";
        String userUpdateStr = "UPDATE vm1.g1 SET e1='x'";
        this.helpFailUpdateProcedure(procedure, userUpdateStr, "updateProcedure");
    }

    @Test
    public void testCreateUpdateProcedure10() throws Exception {
        String procedure = "CREATE PROCEDURE  ";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "DECLARE integer var1;\n";
        procedure = procedure + "ROWS_UPDATED = Select pm1.g1.e2 from pm1.g1;\n";
        procedure = procedure + "UPDATE pm1.g1 SET pm1.g1.e1 = INPUTS.e1, pm1.g1.e2 = var1;\n";
        procedure = procedure + "ROWS_UPDATED = ROWS_UPDATED + var1;\n";
        procedure = procedure + "END\n";
        String userUpdateStr = "UPDATE vm1.g1 SET e1='x'";
        this.helpResolveUpdateProcedure(procedure, userUpdateStr, "updateProcedure");
    }

    @Test
    public void testCreateUpdateProcedure11() throws Exception {
        String procedure = "CREATE PROCEDURE  ";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "DECLARE integer var1;\n";
        procedure = procedure + "ROWS_UPDATED = Select pm1.g1.e2 from pm1.g1;\n";
        procedure = procedure + "UPDATE pm1.g1 SET pm1.g1.e1 = INPUTS.e1, pm1.g1.e2 = var1;\n";
        procedure = procedure + "END\n";
        String userUpdateStr = "UPDATE vm1.g1 SET e1='x'";
        this.helpResolveUpdateProcedure(procedure, userUpdateStr, "updateProcedure");
    }

    @Test
    public void testCreateUpdateProcedure12() throws Exception {
        String procedure = "CREATE PROCEDURE  ";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "DECLARE integer var1;\n";
        procedure = procedure + "Select pm1.g1.e2, INPUTS.e2 from pm1.g1;\n";
        procedure = procedure + "UPDATE pm1.g1 SET pm1.g1.e1 = INPUTS.e1, pm1.g1.e2 = INPUTS.e2;\n";
        procedure = procedure + "END\n";
        String userUpdateStr = "UPDATE vm1.g1 SET e1='x'";
        this.helpResolveUpdateProcedure(procedure, userUpdateStr, "updateProcedure");
    }

    @Test
    public void testCreateUpdateProcedure14() throws Exception {
        String procedure = "CREATE PROCEDURE  ";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "DECLARE integer var1;\n";
        procedure = procedure + "if(CHANGING.e1 = 'true')\n";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "Select pm1.g1.e2, INPUTS.e2 from pm1.g1;\n";
        procedure = procedure + "UPDATE pm1.g1 SET pm1.g1.e1 = INPUTS.e1, pm1.g1.e2 = INPUTS.e2;\n";
        procedure = procedure + "END\n";
        procedure = procedure + "END\n";
        String userUpdateStr = "UPDATE vm1.g1 SET e1='x'";
        this.helpResolveUpdateProcedure(procedure, userUpdateStr, "updateProcedure");
    }

    @Test
    public void testCreateUpdateProcedure15() throws Exception {
        String procedure = "CREATE PROCEDURE  ";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "DECLARE integer var1;\n";
        procedure = procedure + "if(CHANGING.e1='false' and INPUTS.e1=1)\n";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "Select pm1.g1.e2, INPUTS.e2 from pm1.g1;\n";
        procedure = procedure + "UPDATE pm1.g1 SET pm1.g1.e1 = INPUTS.e1, pm1.g1.e2 = INPUTS.e2;\n";
        procedure = procedure + "END\n";
        procedure = procedure + "END\n";
        String userUpdateStr = "UPDATE vm1.g1 SET e1='x'";
        this.helpResolveUpdateProcedure(procedure, userUpdateStr, "updateProcedure");
    }

    @Test
    public void testCreateUpdateProcedure16() throws Exception {
        String procedure = "CREATE PROCEDURE  ";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "DECLARE integer var1;\n";
        procedure = procedure + "if(CHANGING.e4 ='true' and INPUTS.e2=1 or var1 < 30)\n";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "Select pm1.g1.e2, INPUTS.e2 from pm1.g1;\n";
        procedure = procedure + "UPDATE pm1.g1 SET pm1.g1.e1 = INPUTS.e1, pm1.g1.e2 = INPUTS.e2;\n";
        procedure = procedure + "END\n";
        procedure = procedure + "END\n";
        String userUpdateStr = "UPDATE vm1.g1 SET e1='x'";
        this.helpResolveUpdateProcedure(procedure, userUpdateStr, "updateProcedure");
    }

    @Test
    public void testCreateUpdateProcedure17() {
        String procedure = "CREATE PROCEDURE  ";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "if(CHANGING.e4 = {d'2000-01-01'})\n";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "Select pm1.g1.e2, INPUTS.e2 from pm1.g1;\n";
        procedure = procedure + "END\n";
        procedure = procedure + "END\n";
        String userUpdateStr = "UPDATE vm1.g1 SET e1='x'";
        this.helpFailUpdateProcedure(procedure, userUpdateStr, "updateProcedure", "Error Code:ERR.015.008.0027 Message:The expressions in this criteria are being compared but are of differing types (boolean and date) and no implicit conversion is available:  CHANGING.e4 = {d'2000-01-01'}");
    }

    @Test
    public void testCreateUpdateProcedure18() throws Exception {
        String procedure = "CREATE PROCEDURE  ";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "DECLARE integer var1;\n";
        procedure = procedure + "ROWS_UPDATED = Select pm1.g1.e2 from pm1.g1 where HAS CRITERIA ON (vm1.g1.e1, vm1.g1.e1);\n";
        procedure = procedure + "UPDATE pm1.g1 SET pm1.g1.e1 = 'x', pm1.g1.e2 = var1;\n";
        procedure = procedure + "END\n";
        String userUpdateStr = "UPDATE vm1.g1 SET e1='x'";
        this.helpResolveUpdateProcedure(procedure, userUpdateStr, "updateProcedure");
    }

    @Test
    public void testCreateUpdateProcedure19() throws Exception {
        String procedure = "CREATE PROCEDURE  ";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "DECLARE integer var1;\n";
        procedure = procedure + "if(HAS CRITERIA ON (vm1.g1.e1, vm1.g1.e1))\n";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "ROWS_UPDATED = Select pm1.g1.e2 from pm1.g1 where HAS CRITERIA ON (vm1.g1.e1, vm1.g1.e1);\n";
        procedure = procedure + "UPDATE pm1.g1 SET pm1.g1.e1 = 'x', pm1.g1.e2 = var1;\n";
        procedure = procedure + "END\n";
        procedure = procedure + "END\n";
        String userUpdateStr = "UPDATE vm1.g1 SET e1='x'";
        this.helpResolveUpdateProcedure(procedure, userUpdateStr, "updateProcedure");
    }

    @Test
    public void testCreateUpdateProcedure20() throws Exception {
        String procedure = "CREATE PROCEDURE  ";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "DECLARE integer var1;\n";
        procedure = procedure + "ROWS_UPDATED = Select pm1.g1.e2 from pm1.g1 where Translate CRITERIA WITH (vm1.g1.e1 = 1, vm1.g1.e1 = 2);\n";
        procedure = procedure + "UPDATE pm1.g1 SET pm1.g1.e1 = 'x', pm1.g1.e2 = var1;\n";
        procedure = procedure + "END\n";
        String userUpdateStr = "UPDATE vm1.g1 SET e1='x'";
        this.helpResolveUpdateProcedure(procedure, userUpdateStr, "updateProcedure");
    }

    @Test
    public void testCreateUpdateProcedure21() throws Exception {
        String procedure = "CREATE PROCEDURE  ";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "DECLARE integer var1;\n";
        procedure = procedure + "ROWS_UPDATED = Select pm1.g1.e2 from pm1.g1 where Translate CRITERIA WITH (vm1.g1.e1 = 1, vm1.g1.e1 = 2);\n";
        procedure = procedure + "UPDATE pm1.g1 SET pm1.g1.e1 = 'x', pm1.g1.e2 = INPUTS.e2;\n";
        procedure = procedure + "END\n";
        String userUpdateStr = "UPDATE vm1.g1 SET e1='x'";
        this.helpResolveUpdateProcedure(procedure, userUpdateStr, "updateProcedure");
    }

    @Test
    public void testCreateUpdateProcedure22() {
        String procedure = "CREATE PROCEDURE  ";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "var3 = var2+var1;\n";
        procedure = procedure + "var2 = Select pm1.g1.e2 from pm1.g1 where Translate CRITERIA WITH (vm1.g1.e1 = 1, vm1.g1.e1 = 2);\n";
        procedure = procedure + "UPDATE pm1.g1 SET pm1.g1.e1 = 'x', pm1.g1.e2 = INPUTS.e2;\n";
        procedure = procedure + "END\n";
        String userUpdateStr = "UPDATE vm1.g1 SET e1='x'";
        this.helpFailUpdateProcedure(procedure, userUpdateStr, "updateProcedure");
    }

    @Test
    public void testCreateUpdateProcedure23() {
        String procedure = "CREATE PROCEDURE  ";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "DECLARE struct var1;\n";
        procedure = procedure + "var1 = Select pm1.g1.e2 from pm1.g1 where Translate CRITERIA WITH (vm1.g1.e1 = 1, vm1.g1.e1 = 2);\n";
        procedure = procedure + "UPDATE pm1.g1 SET pm1.g1.e1 = 'x', pm1.g1.e2 = INPUTS.e2;\n";
        procedure = procedure + "END\n";
        String userUpdateStr = "UPDATE vm1.g1 SET e1='x'";
        this.helpFailUpdateProcedure(procedure, userUpdateStr, "updateProcedure");
    }

    @Test
    public void testCreateUpdateProcedure24() {
        String procedure = "CREATE PROCEDURE  ";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "DECLARE integer var2.var1;\n";
        procedure = procedure + "END\n";
        String userUpdateStr = "UPDATE vm1.g1 SET e1='x'";
        this.helpFailUpdateProcedure(procedure, userUpdateStr, "updateProcedure");
    }

    @Test
    public void testCreateUpdateProcedure26() throws Exception {
        String procedure = "CREATE PROCEDURE  ";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "DECLARE integer VARIABLES.var1;\n";
        procedure = procedure + "END\n";
        String userUpdateStr = "UPDATE vm1.g1 SET e1='x'";
        this.helpResolveUpdateProcedure(procedure, userUpdateStr, "updateProcedure");
    }

    @Test
    public void testCreateUpdateProcedure27() {
        String procedure = "CREATE PROCEDURE  ";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "DECLARE integer VARIABLES.var1.var2;\n";
        procedure = procedure + "END\n";
        String userUpdateStr = "UPDATE vm1.g1 SET e1='x'";
        this.helpFailUpdateProcedure(procedure, userUpdateStr, "updateProcedure");
    }

    @Test
    public void testCreateUpdateProcedure28() {
        String procedure = "CREATE PROCEDURE  ";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "var1 = Select pm1.g1.e2 from pm1.g1;\n";
        procedure = procedure + "END\n";
        String userUpdateStr = "UPDATE vm1.g1 SET e1='x'";
        this.helpFailUpdateProcedure(procedure, userUpdateStr, "updateProcedure");
    }

    @Test
    public void testCreateUpdateProcedure29() {
        String procedure = "CREATE PROCEDURE  ";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "var1 = 1;\n";
        procedure = procedure + "END\n";
        String userUpdateStr = "UPDATE vm1.g1 SET e1='x'";
        this.helpFailUpdateProcedure(procedure, userUpdateStr, "updateProcedure");
    }

    @Test
    public void testCreateUpdateProcedure30() {
        String procedure = "CREATE PROCEDURE  ";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "Declare integer var1;\n";
        procedure = procedure + "var1 = 'x' + ROWS_UPDATED;\n";
        procedure = procedure + "END\n";
        String userUpdateStr = "UPDATE vm1.g1 SET e1='x'";
        this.helpFailUpdateProcedure(procedure, userUpdateStr, "updateProcedure");
    }

    @Test
    public void testCreateUpdateProcedure31() {
        String procedure = "CREATE PROCEDURE  ";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "Declare integer var1;\n";
        procedure = procedure + "var1 = 'x' + ROWS_UPDATED;\n";
        procedure = procedure + "END\n";
        String userUpdateStr = "UPDATE vm1.g1 SET e1='x'";
        this.helpFailUpdateProcedure(procedure, userUpdateStr, "updateProcedure");
    }

    @Test
    public void testCreateUpdateProcedure32() throws Exception {
        String procedure = "CREATE PROCEDURE  ";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "Declare integer var1;\n";
        procedure = procedure + "Select var1 from pm1.g1;\n";
        procedure = procedure + "END\n";
        String userUpdateStr = "UPDATE vm1.g1 SET e1='x'";
        this.helpResolveUpdateProcedure(procedure, userUpdateStr, "updateProcedure");
    }

    @Test
    public void testCreateUpdateProcedure33() {
        String procedure = "CREATE PROCEDURE  ";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "DECLARE integer var1;\n";
        procedure = procedure + "if(var1 =1)\n";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "DECLARE timestamp var1;\n";
        procedure = procedure + "Select pm1.g1.e2 from pm1.g1 where var1 = pm1.g1.e2;\n";
        procedure = procedure + "END\n";
        procedure = procedure + "var1 = var1 +1;\n";
        procedure = procedure + "END\n";
        String userUpdateStr = "UPDATE vm1.g1 SET e1='x'";
        this.helpFailUpdateProcedure(procedure, userUpdateStr, "updateProcedure");
    }

    @Test
    public void testCreateUpdateProcedure34() {
        String procedure = "CREATE PROCEDURE  ";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "DECLARE integer var1;\n";
        procedure = procedure + "if(pm1.g1.e2 =1 and var1=1)\n";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "Select pm1.g1.e2 from pm1.g1;\n";
        procedure = procedure + "END\n";
        procedure = procedure + "END\n";
        String userUpdateStr = "UPDATE vm1.g1 SET e1='x'";
        this.helpFailUpdateProcedure(procedure, userUpdateStr, "updateProcedure", "Symbol pm1.g1.e2 is specified with an unknown group context");
    }

    @Test
    public void testCreateUpdateProcedure35() throws Exception {
        String procedure = "CREATE PROCEDURE  ";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "DECLARE integer var1;\n";
        procedure = procedure + "if(HAS CRITERIA ON (vm1.g1.e1) and var1=1)\n";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "Select pm1.g1.e2 from pm1.g1;\n";
        procedure = procedure + "END\n";
        procedure = procedure + "END\n";
        String userUpdateStr = "UPDATE vm1.g1 SET e1='x'";
        this.helpResolveUpdateProcedure(procedure, userUpdateStr, "updateProcedure");
    }

    @Test
    public void testCreateUpdateProcedure36() {
        String procedure = "CREATE PROCEDURE  ";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "DECLARE integer var1;\n";
        procedure = procedure + "if(pm1.g1.e2 =1 and var1=1)\n";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "Select pm1.g1.e2 from pm1.g1;\n";
        procedure = procedure + "END\n";
        procedure = procedure + "END\n";
        String userUpdateStr = "UPDATE vm1.g1 SET e1='x'";
        this.helpFailUpdateProcedure(procedure, userUpdateStr, "updateProcedure");
    }

    @Test
    public void testCreateUpdateProcedure37() throws Exception {
        String procedure = "CREATE PROCEDURE  ";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "DECLARE integer var1;\n";
        procedure = procedure + "if(TRANSLATE CRITERIA ON (vm1.g1.e1) WITH (vm1.g1.e1 = 1))\n";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "Select pm1.g1.e2 from pm1.g1;\n";
        procedure = procedure + "END\n";
        procedure = procedure + "END\n";
        String userUpdateStr = "UPDATE vm1.g1 SET e1='x'";
        this.helpResolveUpdateProcedure(procedure, userUpdateStr, "updateProcedure");
    }

    @Test
    public void testCreateUpdateProcedure38() {
        String procedure = "CREATE PROCEDURE  ";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "DECLARE integer var1;\n";
        procedure = procedure + "Select pm1.g1.e1 from pm1.g1 where Translate CRITERIA WITH (pm1.g1.e2 = var1);\n";
        procedure = procedure + "END\n";
        String userUpdateStr = "UPDATE vm1.g1 SET e1='x'";
        this.helpFailUpdateProcedure(procedure, userUpdateStr, "updateProcedure");
    }

    @Test
    public void testCreateUpdateProcedure39() {
        String procedure = "CREATE PROCEDURE  ";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "DECLARE integer var1;\n";
        procedure = procedure + "if(pm1.g1.e2 =1 and var1=1)\n";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "Select pm1.g1.e2 from pm1.g1;\n";
        procedure = procedure + "END\n";
        procedure = procedure + "END\n";
        String userUpdateStr = "UPDATE vm1.g1 SET e1='x'";
        this.helpFailUpdateProcedure(procedure, userUpdateStr, "updateProcedure");
    }

    @Test
    public void testCreateUpdateProcedure40() throws Exception {
        String procedure = "CREATE PROCEDURE  ";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "DECLARE integer var1;\n";
        procedure = procedure + "if(TRANSLATE CRITERIA ON (e1) WITH (g1.e1 = 1))\n";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "Select pm1.g1.e2 from pm1.g1;\n";
        procedure = procedure + "END\n";
        procedure = procedure + "END\n";
        String userUpdateStr = "UPDATE vm1.g1 SET e1='x'";
        this.helpResolveUpdateProcedure(procedure, userUpdateStr, "updateProcedure");
    }

    @Test
    public void testCreateUpdateProcedure41() throws Exception {
        String procedure = "CREATE PROCEDURE  ";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "DECLARE integer var1;\n";
        procedure = procedure + "if(HAS CRITERIA ON (e1))\n";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "Select pm1.g1.e2 from pm1.g1 where TRANSLATE CRITERIA ON (e1) WITH (g1.e1 = 1);\n";
        procedure = procedure + "END\n";
        procedure = procedure + "END\n";
        String userUpdateStr = "UPDATE vm1.g1 SET e1='x'";
        this.helpResolveUpdateProcedure(procedure, userUpdateStr, "updateProcedure");
    }

    @Test
    public void testCreateUpdateProcedure42() throws Exception {
        String procedure = "CREATE PROCEDURE  ";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "DECLARE integer var1;\n";
        procedure = procedure + "if(HAS CRITERIA ON (e1))\n";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "Select pm1.g1.e2 from pm1.g1 where TRANSLATE CRITERIA ON (e1) WITH (g1.e1 = 1);\n";
        procedure = procedure + "END\n";
        procedure = procedure + "END\n";
        String userUpdateStr = "UPDATE vm1.g1 SET e1='x'";
        this.helpResolveUpdateProcedure(procedure, userUpdateStr, "updateProcedure");
    }

    @Test
    public void testCreateUpdateProcedure43() throws Exception {
        String procedure = "CREATE PROCEDURE  ";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "DECLARE integer var1;\n";
        procedure = procedure + "Select pm1.g1.e2 from pm1.g1 where TRANSLATE CRITERIA ON (e1) WITH (g1.e1 = 1);\n";
        procedure = procedure + "END\n";
        FakeMetadataFacade metadata = FakeMetadataFactory.exampleUpdateProc("updateProcedure", procedure);
        Command procCommand = QueryParser.getQueryParser().parseCommand(procedure);
        GroupSymbol virtualGroup = new GroupSymbol("vm1.g1");
        virtualGroup.setMetadataID(metadata.getGroupID("vm1.g1"));
        Map externalMetadata = TestProcedureResolving.getProcedureExternalMetadata(virtualGroup, (QueryMetadataInterface)metadata);
        QueryResolver.buildExternalGroups((Map)externalMetadata, (Command)procCommand);
        QueryResolver.resolveCommand((Command)procCommand, (QueryMetadataInterface)metadata);
    }

    @Test
    public void testCreateUpdateProcedure44() throws Exception {
        String procedure = "CREATE PROCEDURE ";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "if(INPUTS.e1 = 10)\n";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "Select pm1.g1.e2, INPUTS.e2 from pm1.g1;\n";
        procedure = procedure + "END\n";
        procedure = procedure + "END\n";
        String userUpdateStr = "INSERT into vm1.g1 (e1) values('x')";
        this.helpResolveUpdateProcedure(procedure, userUpdateStr, "insertProcedure");
    }

    @Test
    public void testCreateUpdateProcedure45() throws Exception {
        String procedure = "CREATE PROCEDURE ";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "if(INPUTS.e1 = 10)\n";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "Select pm1.g1.e2, INPUTS.e2 from pm1.g1;\n";
        procedure = procedure + "END\n";
        procedure = procedure + "END\n";
        Command procCommand = QueryParser.getQueryParser().parseCommand(procedure);
        FakeMetadataFacade metadata = FakeMetadataFactory.exampleUpdateProc("insertProcedure", procedure);
        GroupSymbol virtualGroup = new GroupSymbol("vm1.g1");
        virtualGroup.setMetadataID(metadata.getGroupID("vm1.g1"));
        Map externalMetadata = TestProcedureResolving.getProcedureExternalMetadata(virtualGroup, (QueryMetadataInterface)metadata);
        QueryResolver.buildExternalGroups((Map)externalMetadata, (Command)procCommand);
        QueryResolver.resolveCommand((Command)procCommand, (QueryMetadataInterface)metadata);
    }

    @Test
    public void testCreateUpdateProcedure46() throws Exception {
        String procedure = "CREATE PROCEDURE  ";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "UPDATE pm1.g1 SET pm1.g1.e1 = INPUTS.e1;\n";
        procedure = procedure + "END\n";
        Command procCommand = QueryParser.getQueryParser().parseCommand(procedure);
        FakeMetadataFacade metadata = FakeMetadataFactory.exampleUpdateProc("updateProcedure", procedure);
        GroupSymbol virtualGroup = new GroupSymbol("vm1.g1");
        virtualGroup.setMetadataID(metadata.getGroupID("vm1.g1"));
        Map externalMetadata = TestProcedureResolving.getProcedureExternalMetadata(virtualGroup, (QueryMetadataInterface)metadata);
        QueryResolver.buildExternalGroups((Map)externalMetadata, (Command)procCommand);
        QueryResolver.resolveCommand((Command)procCommand, (QueryMetadataInterface)metadata);
    }

    @Test
    public void testCreateUpdateProcedure47() throws Exception {
        String procedure = "CREATE PROCEDURE  ";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "DECLARE integer var1;\n";
        procedure = procedure + "if(HAS CRITERIA ON (e1))\n";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "Select pm1.g1.e2 from pm1.g1 where TRANSLATE CRITERIA ON (e1) WITH (vm1.g1.e1 = pm1.g1.e1);\n";
        procedure = procedure + "END\n";
        procedure = procedure + "END\n";
        String userUpdateStr = "UPDATE vm1.g1 SET e1='x'";
        this.helpResolveUpdateProcedure(procedure, userUpdateStr, "updateProcedure");
    }

    @Test
    public void testCreateUpdateProcedure48() {
        String procedure = "CREATE PROCEDURE  ";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "DECLARE integer var1;\n";
        procedure = procedure + "Select pm1.g1.e1 from pm1.g1 where Translate CRITERIA WITH (vm1.g1.e1 = 1, INPUTS.e2 = 2);\n";
        procedure = procedure + "END\n";
        String userUpdateStr = "UPDATE vm1.g1 SET e1='x'";
        this.helpFailUpdateProcedure(procedure, userUpdateStr, "updateProcedure");
    }

    @Test
    public void testCreateUpdateProcedure49() {
        String procedure = "CREATE PROCEDURE  ";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "Select pm1.g1.e1 from pm1.g1 where Translate CRITERIA WITH (vm1.g1.e1 = pm1.g2.e1);\n";
        procedure = procedure + "END\n";
        String userUpdateStr = "UPDATE vm1.g1 SET e1='x'";
        this.helpFailUpdateProcedure(procedure, userUpdateStr, "updateProcedure");
    }

    @Test
    public void testCreateUpdateProcedure50() {
        String procedure = "CREATE PROCEDURE  ";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "DECLARE integer var1;\n";
        procedure = procedure + "if(HAS CRITERIA ON (vm1.g1.E1, vm1.g1.e1, INPUTS.e1))\n";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "END\n";
        procedure = procedure + "ROWS_UPDATED =0;\n";
        procedure = procedure + "END\n";
        String userUpdateStr = "UPDATE vm1.g1 SET e1='x'";
        this.helpFailUpdateProcedure(procedure, userUpdateStr, "updateProcedure");
    }

    @Test
    public void testCreateUpdateProcedure51() {
        String procedure = "CREATE PROCEDURE  ";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "DECLARE integer var1;\n";
        procedure = procedure + "var1=1;\n";
        procedure = procedure + "Select pm1.g1.e1 from pm1.g1 where Translate CRITERIA WITH (vm1.g1.e2 = var1+vm1.g1.e2, vm1.g1.e1 = 2);\n";
        procedure = procedure + "ROWS_UPDATED =0;\n";
        procedure = procedure + "END\n";
        String userUpdateStr = "UPDATE vm1.g1 SET e1='x'";
        this.helpFailUpdateProcedure(procedure, userUpdateStr, "updateProcedure");
    }

    @Test
    public void testCreateUpdateProcedure52() {
        String procedure = "CREATE PROCEDURE  ";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "DECLARE integer var1;\n";
        procedure = procedure + "Select pm1.g1.e1 from pm1.g1 where Translate CRITERIA WITH (var1 = vm1.g1.e2, vm1.g1.e1 = 2);\n";
        procedure = procedure + "ROWS_UPDATED =0;\n";
        procedure = procedure + "END\n";
        String userUpdateStr = "UPDATE vm1.g1 SET e1='x'";
        this.helpFailUpdateProcedure(procedure, userUpdateStr, "updateProcedure");
    }

    @Test
    public void testCreateUpdateProcedure53() {
        String procedure = "CREATE PROCEDURE  ";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "DECLARE integer var1;\n";
        procedure = procedure + "var1 = INPUTS.e4;";
        procedure = procedure + "ROWS_UPDATED =0;\n";
        procedure = procedure + "END\n";
        String userUpdateStr = "UPDATE vm1.g1 SET e1='x'";
        this.helpFailUpdateProcedure(procedure, userUpdateStr, "updateProcedure");
    }

    @Test
    public void testCreateUpdateProcedure54() throws Exception {
        String procedure = "CREATE PROCEDURE  ";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "DECLARE string var1;\n";
        procedure = procedure + "var1 = 1+1;";
        procedure = procedure + "ROWS_UPDATED =0;\n";
        procedure = procedure + "END\n";
        String userUpdateStr = "UPDATE vm1.g1 SET e1='x'";
        this.helpResolveUpdateProcedure(procedure, userUpdateStr, "updateProcedure");
    }

    @Test
    public void testCreateUpdateProcedure55() throws Exception {
        String procedure = "CREATE PROCEDURE  ";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "DECLARE string var1;\n";
        procedure = procedure + "var1 = 1+ROWS_UPDATED;";
        procedure = procedure + "ROWS_UPDATED =0;\n";
        procedure = procedure + "END\n";
        String userUpdateStr = "UPDATE vm1.g1 SET e1='x'";
        this.helpResolveUpdateProcedure(procedure, userUpdateStr, "updateProcedure");
    }

    @Test
    public void testCreateUpdateProcedure56() throws Exception {
        String procedure = "CREATE PROCEDURE  ";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "DECLARE string var1;\n";
        procedure = procedure + "var1 = 1+ROWS_UPDATED;";
        procedure = procedure + "ROWS_UPDATED =0;\n";
        procedure = procedure + "END\n";
        TestResolver.helpResolveException(procedure, (QueryMetadataInterface)FakeMetadataFactory.example1Cached(), "Error Code:ERR.015.008.0012 Message:Unable to resolve update procedure as the virtual group context is ambiguous.");
    }

    @Test
    public void testDefect14912_CreateUpdateProcedure57_FunctionWithElementParamInAssignmentStatement() {
        String procedure = "CREATE PROCEDURE  ";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "DECLARE string var1;\n";
        procedure = procedure + "var1 = badFunction(badElement);";
        procedure = procedure + "ROWS_UPDATED =0;\n";
        procedure = procedure + "END\n";
        String userCommand = "UPDATE vm1.g1 SET e1='x'";
        this.helpFailUpdateProcedure(procedure, userCommand, "updateProcedure", "Element \"badElement\" is not defined by any relevant group.");
    }

    @Test
    public void testCase4624() {
        String procedure = "CREATE PROCEDURE  ";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "VARIABLES.ROWS_UPDATED = 0;\n";
        procedure = procedure + "DECLARE boolean var1;\n";
        procedure = procedure + "var1 = {b'false'};\n";
        procedure = procedure + "IF(var1 = {b 'true'})\n";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "SELECT Rack_ID, RACK_MDT_TYPE INTO #racks FROM Bert_MAP.BERT3.RACK;\n";
        procedure = procedure + "END\n";
        procedure = procedure + "END\n";
        String userCommand = "UPDATE vm1.g1 SET e1='x'";
        this.helpFailUpdateProcedure(procedure, userCommand, "updateProcedure", "Group does not exist: Bert_MAP.BERT3.RACK");
    }

    @Test
    public void testCase5474() throws Exception {
        String procedure = "CREATE VIRTUAL PROCEDURE  ";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "DECLARE integer VARIABLES.NLEVELS;\n";
        procedure = procedure + "VARIABLES.NLEVELS = SELECT COUNT(*) FROM (SELECT oi.e1 AS Col1, oi.e2 AS Col2, oi.e3 FROM pm1.g2 AS oi) AS TOBJ, pm2.g2 AS TModel WHERE TModel.e3 = TOBJ.e3;\n";
        procedure = procedure + "END\n";
        TestResolver.helpResolve(procedure, (QueryMetadataInterface)FakeMetadataFactory.example1Cached(), null);
    }

    @Test
    public void testIssue174102() throws Exception {
        String procedure = "CREATE VIRTUAL PROCEDURE  \n";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "DECLARE string crit = 'WHERE pm1.sq2.in = \"test\"';\n";
        procedure = procedure + "CREATE LOCAL TEMPORARY TABLE #TTable (e1 string);";
        procedure = procedure + "EXECUTE STRING ('SELECT e1 FROM pm1.sq2 ' || crit ) AS e1 string INTO #TTable;\n";
        procedure = procedure + "END\n";
        TestResolver.helpResolve(procedure, (QueryMetadataInterface)FakeMetadataFactory.example1Cached(), null);
    }

    @Test
    public void testIssue174519() throws Exception {
        String procedure = "CREATE VIRTUAL PROCEDURE  \n";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "DECLARE string VARIABLES.l_in = pm1.sq1.in;\n";
        procedure = procedure + "INSERT INTO #temp \n";
        procedure = procedure + "SELECT pm1.sq3.e1 FROM pm1.sq3 WHERE pm1.sq3.in = VARIABLES.l_in;\n";
        procedure = procedure + "END\n";
        QueryMetadataInterface metadata = this.exampleStoredProcedure(procedure);
        this.helpResolveException("EXEC pm1.sq1(1)", metadata, "Error Code:ERR.015.008.0010 Message:INSERT statement must have the same number of elements and values specified.  This statement has 0 elements and 0 values.");
    }

    @Test
    public void testDeclareStatement() {
        String procedure = "CREATE PROCEDURE  ";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "DECLARE integer VARIABLES.var1 = VARIABLES.var1;\n";
        procedure = procedure + "ROWS_UPDATED =0;\n";
        procedure = procedure + "END\n";
        String userUpdateStr = "UPDATE vm1.g1 SET e1='x'";
        this.helpFailUpdateProcedure(procedure, userUpdateStr, "updateProcedure");
    }

    @Test
    public void testDynamicIntoInProc() throws Exception {
        String userUpdateStr = "UPDATE vm1.g1 SET e1='x'";
        StringBuffer procedure = new StringBuffer("CREATE PROCEDURE  ").append("BEGIN\n").append("execute string 'SELECT e1, e2, e3, e4 FROM pm1.g2' as e1 string, e2 string, e3 string, e4 string INTO #myTempTable;\n").append("select e1 from #myTempTable;\n").append("ROWS_UPDATED =0;\n").append("END\n");
        this.helpResolveUpdateProcedure(procedure.toString(), userUpdateStr, "updateProcedure");
    }

    @Test
    public void testDynamicStatement() throws Exception {
        String userUpdateStr = "UPDATE vm1.g1 SET e1='x'";
        StringBuffer procedure = new StringBuffer("CREATE PROCEDURE  ").append("BEGIN\n").append("execute string 'SELECT e1, e2, e3, e4 FROM pm1.g2';\n").append("ROWS_UPDATED =0;\n").append("END\n");
        this.helpResolveUpdateProcedure(procedure.toString(), userUpdateStr, "updateProcedure");
    }

    @Test
    public void testDynamicStatementType() {
        String userUpdateStr = "UPDATE vm1.g1 SET e1='x'";
        StringBuffer procedure = new StringBuffer("CREATE PROCEDURE  ").append("BEGIN\n").append("DECLARE object VARIABLES.X = null;\n").append("execute string VARIABLES.X;\n").append("ROWS_UPDATED =0;\n").append("END\n");
        this.helpFailUpdateProcedure(procedure.toString(), userUpdateStr, "updateProcedure");
    }

    @Test
    public void testCreateUpdateProcedure1() throws Exception {
        String procedure = "CREATE PROCEDURE  ";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "DECLARE integer var1;\n";
        procedure = procedure + "var1 = Select pm1.g1.e2 from pm1.g1;\n";
        procedure = procedure + "UPDATE pm1.g1 SET pm1.g1.e1 = 1, pm1.g1.e2 = var1;\n";
        procedure = procedure + "END\n";
        String userUpdateStr = "UPDATE vm1.g1 SET e1=1";
        this.helpResolveUpdateProcedure(procedure, userUpdateStr, "updateProcedure");
    }

    @Test
    public void testCreateUpdateProcedure3() throws Exception {
        String procedure = "CREATE PROCEDURE  ";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "DECLARE integer var1;\n";
        procedure = procedure + "if(var1 =1)\n";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "END\n";
        procedure = procedure + "END\n";
        String userUpdateStr = "UPDATE vm1.g1 SET e1='x'";
        this.helpResolveUpdateProcedure(procedure, userUpdateStr, "updateProcedure");
    }

    @Test
    public void testSelectIntoInProc() throws Exception {
        StringBuffer procedure = new StringBuffer("CREATE PROCEDURE  ").append("BEGIN\n").append("SELECT e1, e2, e3, e4 INTO pm1.g1 FROM pm1.g2;\n").append("ROWS_UPDATED =0;\n").append("END\n");
        String userUpdateStr = "UPDATE vm1.g1 SET e1='x'";
        this.helpResolveUpdateProcedure(procedure.toString(), userUpdateStr, "updateProcedure");
        procedure = new StringBuffer("CREATE PROCEDURE  ").append("BEGIN\n").append("SELECT e1, e2, e3, e4 INTO #myTempTable FROM pm1.g2;\n").append("ROWS_UPDATED =0;\n").append("END\n");
        this.helpResolveUpdateProcedure(procedure.toString(), userUpdateStr, "updateProcedure");
    }

    @Test
    public void testSelectIntoInProcNoFrom() throws Exception {
        StringBuffer procedure = new StringBuffer("CREATE PROCEDURE  ").append("BEGIN\n").append("SELECT 'a', 19, {b'true'}, 13.999 INTO pm1.g1;\n").append("ROWS_UPDATED =0;\n").append("END\n");
        String userUpdateStr = "UPDATE vm1.g1 SET e1='x'";
        this.helpResolveUpdateProcedure(procedure.toString(), userUpdateStr, "updateProcedure");
        procedure = new StringBuffer("CREATE PROCEDURE  ").append("BEGIN\n").append("SELECT 'a', 19, {b'true'}, 13.999 INTO #myTempTable;\n").append("ROWS_UPDATED =0;\n").append("END\n");
        this.helpResolveUpdateProcedure(procedure.toString(), userUpdateStr, "updateProcedure");
    }

    @Test
    public void testDeclareRowsUpdated() {
        String procedure = "CREATE PROCEDURE  ";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "DECLARE integer rows_updated;\n";
        procedure = procedure + "ROWS_UPDATED =0;\n";
        procedure = procedure + "END\n";
        String userUpdateStr = "UPDATE vm1.g1 SET e1='x'";
        this.helpFailUpdateProcedure(procedure, userUpdateStr, "updateProcedure", "Variable rows_updated was previously declared.");
    }

    @Test
    public void testAssignInput() {
        String procedure = "CREATE PROCEDURE  ";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "DECLARE integer var1;\n";
        procedure = procedure + "INPUTS.e1 = Select pm1.g1.e1 from pm1.g1;\n";
        procedure = procedure + "ROWS_UPDATED =0;\n";
        procedure = procedure + "END\n";
        String userUpdateStr = "UPDATE vm1.g1 SET e1='x'";
        this.helpFailUpdateProcedure(procedure, userUpdateStr, "updateProcedure", "Element symbol \"INPUTS.e1\" cannot be assigned a value.  Only declared VARIABLES can be assigned values.");
    }

    @Test
    public void testAssignChanging() {
        String procedure = "CREATE PROCEDURE  ";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "DECLARE integer var1;\n";
        procedure = procedure + "CHANGING.e1 = Select pm1.g1.e1 from pm1.g1;\n";
        procedure = procedure + "ROWS_UPDATED =0;\n";
        procedure = procedure + "END\n";
        String userUpdateStr = "UPDATE vm1.g1 SET e1='x'";
        this.helpFailUpdateProcedure(procedure, userUpdateStr, "updateProcedure", "Element symbol \"CHANGING.e1\" cannot be assigned a value.  Only declared VARIABLES can be assigned values.");
    }

    @Test
    public void testVariableInInsert() {
        String procedure = "CREATE PROCEDURE  ";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "DECLARE integer var1;\n";
        procedure = procedure + "Insert into pm1.g1 (pm1.g1.e2, var1) values (1, 2);\n";
        procedure = procedure + "ROWS_UPDATED =0;\n";
        procedure = procedure + "END\n";
        String userQuery = "UPDATE vm1.g3 SET x='x' where e3= 1";
        this.helpFailUpdateProcedure(procedure, userQuery, "updateProcedure", "Column variables do not reference columns on group \"pm1.g1\": [Unable to resolve 'var1': Element \"var1\" is not defined by any relevant group.]");
    }

    @Test
    public void testVariableInInsert2() {
        String procedure = "CREATE PROCEDURE  ";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "DECLARE integer var1;\n";
        procedure = procedure + "Insert into pm1.g1 (pm1.g1.e2, INPUTS.x) values (1, 2);\n";
        procedure = procedure + "ROWS_UPDATED =0;\n";
        procedure = procedure + "END\n";
        String userQuery = "UPDATE vm1.g3 SET x='x' where e3= 1";
        this.helpFailUpdateProcedure(procedure, userQuery, "updateProcedure", "Column variables do not reference columns on group \"pm1.g1\": [Unable to resolve 'INPUTS.x': Symbol INPUTS.x is specified with an unknown group context]");
    }

    @Test
    public void testVariableInInsert3() throws Exception {
        String procedure = "CREATE PROCEDURE  ";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "DECLARE integer e2;\n";
        procedure = procedure + "Insert into pm1.g1 (e2) values (1);\n";
        procedure = procedure + "ROWS_UPDATED =0;\n";
        procedure = procedure + "END\n";
        String userQuery = "UPDATE vm1.g3 SET x='x' where e3= 1";
        this.helpResolveUpdateProcedure(procedure, userQuery, "updateProcedure");
    }

    @Test
    public void testAmbigousInput() {
        String procedure = "CREATE PROCEDURE  ";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "select e1;\n";
        procedure = procedure + "END\n";
        String userUpdateStr = "UPDATE vm1.g1 SET e1='x'";
        this.helpFailUpdateProcedure(procedure, userUpdateStr, "updateProcedure", "Element \"e1\" is ambiguous, it exists in two or more groups.");
    }

    @Test
    public void testLoopRedefinition() {
        StringBuffer proc = new StringBuffer("CREATE PROCEDURE").append("\nBEGIN").append("\n  declare string var1;").append("\n  LOOP ON (SELECT pm1.g1.e1 FROM pm1.g1) AS loopCursor").append("\n  BEGIN").append("\n    LOOP ON (SELECT pm1.g2.e1 FROM pm1.g2 WHERE loopCursor.e1 = pm1.g2.e1) AS loopCursor").append("\n    BEGIN").append("\n      var1 = CONCAT(var1, CONCAT(' ', loopCursor.e1));").append("\n    END").append("\n  END").append("\n  END");
        String userUpdateStr = "UPDATE vm1.g1 SET e1='x'";
        this.helpFailUpdateProcedure(proc.toString(), userUpdateStr, "updateProcedure", "Nested Loop can not use the same cursor name as that of its parent.");
    }

    @Test
    public void testTempGroupElementShouldNotBeResolable() {
        StringBuffer proc = new StringBuffer("CREATE PROCEDURE").append("\nBEGIN").append("\n  select 1 as a into #temp;").append("\n  select #temp.a from pm1.g1;").append("\nEND");
        String userUpdateStr = "UPDATE vm1.g1 SET e1='x'";
        this.helpFailUpdateProcedure(proc.toString(), userUpdateStr, "updateProcedure", "Symbol #temp.a is specified with an unknown group context");
    }

    @Test
    public void testTempGroupElementShouldNotBeResolable1() {
        StringBuffer proc = new StringBuffer("CREATE PROCEDURE").append("\nBEGIN").append("\n  select 1 as a into #temp;").append("\n  insert into #temp (a) values (#temp.a);").append("\nEND");
        String userUpdateStr = "UPDATE vm1.g1 SET e1='x'";
        this.helpFailUpdateProcedure(proc.toString(), userUpdateStr, "updateProcedure", "Symbol #temp.a is specified with an unknown group context");
    }

    @Test
    public void testProcedureCreate() throws Exception {
        StringBuffer proc = new StringBuffer("CREATE PROCEDURE").append("\nBEGIN").append("\n  create local temporary table t1 (e1 string);").append("\n  select e1 from t1;").append("\n  create local temporary table t1 (e1 string, e2 integer);").append("\n  select e2 from t1;").append("\nEND");
        String userUpdateStr = "UPDATE vm1.g1 SET e1='x'";
        this.helpResolveUpdateProcedure(proc.toString(), userUpdateStr, "updateProcedure");
    }

    @Test
    public void testProcedureCreate1() {
        StringBuffer proc = new StringBuffer("CREATE PROCEDURE").append("\nBEGIN").append("\n  LOOP ON (SELECT pm1.g1.e1 FROM pm1.g1) AS loopCursor").append("\n  BEGIN").append("\n  create local temporary table loopCursor (e1 string);").append("\nEND").append("\nEND");
        String userUpdateStr = "UPDATE vm1.g1 SET e1='x'";
        this.helpFailUpdateProcedure(proc.toString(), userUpdateStr, "updateProcedure", "Cannot create temporary table \"loopCursor\". A table with the same name already exists.");
    }

    @Test
    public void testProcedureCreateDrop() {
        StringBuffer proc = new StringBuffer("CREATE PROCEDURE").append("\nBEGIN").append("\n drop table t1;").append("\n  create local temporary table t1 (e1 string);").append("\nEND");
        String userUpdateStr = "UPDATE vm1.g1 SET e1='x'";
        this.helpFailUpdateProcedure(proc.toString(), userUpdateStr, "updateProcedure", "Group does not exist: t1");
    }

    @Test
    public void testProcedureCreateDrop1() throws Exception {
        StringBuffer proc = new StringBuffer("CREATE PROCEDURE").append("\nBEGIN").append("\n  create local temporary table t1 (e1 string);").append("\n  drop table t1;").append("\nEND");
        String userUpdateStr = "UPDATE vm1.g1 SET e1='x'";
        this.helpResolveUpdateProcedure(proc.toString(), userUpdateStr, "updateProcedure");
    }

    @Test
    public void testCreateAfterImplicitTempTable() throws Exception {
        StringBuffer proc = new StringBuffer("CREATE PROCEDURE").append("\nBEGIN").append("\n  select e1 into #temp from pm1.g1;").append("\n  create local temporary table #temp (e1 string);").append("\nEND");
        String userUpdateStr = "UPDATE vm1.g1 SET e1='x'";
        this.helpResolveUpdateProcedure(proc.toString(), userUpdateStr, "updateProcedure");
    }

    @Test
    public void testInsertAfterCreate() throws Exception {
        StringBuffer proc = new StringBuffer("CREATE PROCEDURE").append("\nBEGIN").append("\n  create local temporary table #temp (e1 string, e2 string);").append("\n  insert into #temp (e1) values ('a');").append("\nEND");
        String userUpdateStr = "UPDATE vm1.g1 SET e1='x'";
        this.helpResolveUpdateProcedure(proc.toString(), userUpdateStr, "updateProcedure");
    }

    @Test
    public void testDefect16451() {
        String procedure = "CREATE PROCEDURE  ";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "Select pm1.g1.e2 from pm1.g1 where e1 = INPUTS.e1;\n";
        procedure = procedure + "ROWS_UPDATED = 0;";
        procedure = procedure + "END\n";
        String userUpdateStr = "delete from vm1.g1 where e1='x'";
        this.helpFailUpdateProcedure(procedure, userUpdateStr, "deleteProcedure", "Symbol INPUTS.e1 is specified with an unknown group context");
    }

    @Test
    public void testInvalidVirtualProcedure3() throws Exception {
        this.helpResolveException("EXEC pm1.vsp18()", (QueryMetadataInterface)FakeMetadataFactory.example1Cached(), "Group does not exist: temptable");
    }

    @Test
    public void testCreateUpdateProcedure2() {
        String procedure = "CREATE PROCEDURE  ";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "DECLARE boolean var1;\n";
        procedure = procedure + "ROWS_UPDATED = UPDATE pm1.g1 SET pm1.g1.e4 = convert(var1, string), pm1.g1.e1 = var1;\n";
        procedure = procedure + "END\n";
        String userUpdateStr = "UPDATE vm1.g1 SET e1=1";
        this.helpFailUpdateProcedure(procedure, userUpdateStr, "updateProcedure", "Error Code:ERR.015.008.0041 Message:Cannot set symbol 'pm1.g1.e4' with expected type double to expression 'convert(var1, string)'");
    }

    @Test
    public void testInvalidInputInUpdate() {
        String procedure = "CREATE PROCEDURE  ";
        procedure = procedure + "BEGIN\n";
        procedure = procedure + "DECLARE integer var1;\n";
        procedure = procedure + "Select pm1.g1.e2, INPUTS.e2 from pm1.g1;\n";
        procedure = procedure + "ROWS_UPDATED = UPDATE pm1.g1 SET pm1.g1.e1 = INPUTS.e1, pm1.g1.e2 = INPUTS.e1;\n";
        procedure = procedure + "END\n";
        String userUpdateStr = "UPDATE vm1.g1 SET e1='x'";
        this.helpFailUpdateProcedure(procedure, userUpdateStr, "updateProcedure", "Error Code:ERR.015.008.0041 Message:Cannot set symbol 'pm1.g1.e2' with expected type integer to expression 'INPUTS.e1'");
    }

    @Test
    public void testVirtualProcedure() throws Exception {
        this.helpResolve("EXEC pm1.vsp1()", (QueryMetadataInterface)FakeMetadataFactory.example1Cached());
    }

    @Test
    public void testVirtualProcedure2() throws Exception {
        this.helpResolve("EXEC pm1.vsp14()", (QueryMetadataInterface)FakeMetadataFactory.example1Cached());
    }

    @Test
    public void testVirtualProcedurePartialParameterReference() throws Exception {
        this.helpResolve("EXEC pm1.vsp58(5)", (QueryMetadataInterface)FakeMetadataFactory.example1Cached());
    }

    @Test
    public void testVirtualProcedureInvalid1() throws Exception {
        this.helpResolveException("EXEC pm1.vsp32()", (QueryMetadataInterface)FakeMetadataFactory.example1Cached(), "Cursor names cannot begin with \"#\" as that indicates the name of a temporary table: #mycursor.");
    }

    @Test
    public void testVirtualProcedureWithOrderBy() throws Exception {
        this.helpResolve("EXEC pm1.vsp29()", (QueryMetadataInterface)FakeMetadataFactory.example1Cached());
    }

    @Test
    public void testVirtualProcedureWithTempTableAndOrderBy() throws Exception {
        this.helpResolve("EXEC pm1.vsp33()", (QueryMetadataInterface)FakeMetadataFactory.example1Cached());
    }

    @Test
    public void testVirtualProcedureWithConstAndOrderBy() throws Exception {
        this.helpResolve("EXEC pm1.vsp34()", (QueryMetadataInterface)FakeMetadataFactory.example1Cached());
    }

    @Test
    public void testVirtualProcedureWithNoFromAndOrderBy() throws Exception {
        this.helpResolve("EXEC pm1.vsp28()", (QueryMetadataInterface)FakeMetadataFactory.example1Cached());
    }

    @Test
    public void testInvalidVirtualProcedure2() throws Exception {
        this.helpResolveException("EXEC pm1.vsp12()", (QueryMetadataInterface)FakeMetadataFactory.example1Cached(), "Symbol mycursor.e2 is specified with an unknown group context");
    }

    @Test
    public void testLoopRedefinition2() throws Exception {
        this.helpResolveException("EXEC pm1.vsp11()", (QueryMetadataInterface)FakeMetadataFactory.example1Cached(), "Nested Loop can not use the same cursor name as that of its parent.");
    }

    @Test
    public void testVariableResolutionWithIntervening() throws Exception {
        StringBuffer proc = new StringBuffer("CREATE VIRTUAL PROCEDURE").append("\nBEGIN").append("\n  declare string x;").append("\n  x = '1';").append("\n  declare string y;").append("\n  y = '1';").append("\nEND");
        TestResolver.helpResolve(proc.toString(), (QueryMetadataInterface)FakeMetadataFactory.example1Cached(), null);
    }

    @Test
    public void testVDBQualified() throws Exception {
        this.helpResolve("EXEC myvdb.pm1.vsp29()", (QueryMetadataInterface)FakeMetadataFactory.example1Cached());
    }
}

