/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.rewriter;

import java.util.ArrayList;
import java.util.Iterator;
import org.junit.Assert;
import org.junit.Test;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.parser.QueryParser;
import org.teiid.query.resolver.QueryResolver;
import org.teiid.query.rewriter.QueryRewriter;
import org.teiid.query.rewriter.TestQueryRewriter;
import org.teiid.query.sql.LanguageObject;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.lang.OrderBy;
import org.teiid.query.sql.lang.Query;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.ExpressionSymbol;
import org.teiid.query.sql.symbol.SingleElementSymbol;
import org.teiid.query.sql.visitor.ElementCollectorVisitor;
import org.teiid.query.unittest.FakeMetadataFactory;
import org.teiid.query.unittest.FakeMetadataObject;

public class TestOrderByRewrite {
    private static Command getCommand(String sql) throws TeiidComponentException, TeiidProcessingException {
        Command command = QueryParser.getQueryParser().parseCommand(sql);
        QueryResolver.resolveCommand((Command)command, (QueryMetadataInterface)FakeMetadataFactory.example1Cached());
        return QueryRewriter.rewrite((Command)command, (QueryMetadataInterface)FakeMetadataFactory.example1Cached(), null);
    }

    private void helpCheckElements(OrderBy langObj, String[] elementNames, String[] elementIDs) {
        ArrayList elements = new ArrayList();
        Iterator i = langObj.getSortKeys().iterator();
        while (i.hasNext()) {
            ElementCollectorVisitor.getElements((LanguageObject)((LanguageObject)i.next()), elements);
        }
        Assert.assertEquals((String)"Wrong number of elements: ", (long)elementNames.length, (long)elements.size());
        for (int i2 = 0; i2 < elements.size(); ++i2) {
            ElementSymbol symbol = (ElementSymbol)elements.get(i2);
            Assert.assertEquals((String)"Element name does not match: ", (Object)elementNames[i2].toUpperCase(), (Object)symbol.getName().toUpperCase());
            FakeMetadataObject elementID = (FakeMetadataObject)symbol.getMetadataID();
            Assert.assertNotNull((String)("ElementSymbol " + symbol + " was not resolved and has no metadataID"), (Object)elementID);
            Assert.assertEquals((String)"ElementID name does not match: ", (Object)elementIDs[i2].toUpperCase(), (Object)elementID.getName().toUpperCase());
        }
    }

    private void helpCheckExpressionsSymbols(OrderBy langObj, String[] functionsNames) {
        int expCount = 0;
        for (SingleElementSymbol ses : langObj.getSortKeys()) {
            if (!(ses instanceof ExpressionSymbol)) continue;
            Assert.assertEquals((String)"Expression Symbols does not match: ", (Object)functionsNames[expCount++], (Object)ses.toString());
        }
        Assert.assertEquals((String)"Wrong number of Symbols: ", (long)functionsNames.length, (long)expCount);
    }

    @Test
    public void testNumberedOrderBy1() throws Exception {
        Query resolvedQuery = (Query)TestOrderByRewrite.getCommand("SELECT pm1.g1.e1, e2, e3 as x, (5+2) as y FROM pm1.g1 ORDER BY 3, 4, 1, 2");
        this.helpCheckElements(resolvedQuery.getOrderBy(), new String[]{"pm1.g1.e3", "pm1.g1.e1", "pm1.g1.e2"}, new String[]{"pm1.g1.e3", "pm1.g1.e1", "pm1.g1.e2"});
        this.helpCheckExpressionsSymbols(resolvedQuery.getOrderBy(), new String[0]);
    }

    @Test
    public void testNumberedOrderBy1_1() throws Exception {
        Query resolvedQuery = (Query)TestOrderByRewrite.getCommand("SELECT pm1.g1.e1, e2, e3 as x, (5 + e4) FROM pm1.g1 ORDER BY 3, 4, 1, 2");
        this.helpCheckElements(resolvedQuery.getOrderBy(), new String[]{"pm1.g1.e3", "pm1.g1.e4", "pm1.g1.e1", "pm1.g1.e2"}, new String[]{"pm1.g1.e3", "pm1.g1.e4", "pm1.g1.e1", "pm1.g1.e2"});
        this.helpCheckExpressionsSymbols(resolvedQuery.getOrderBy(), new String[]{"(5.0 + e4)"});
    }

    @Test
    public void testNumberedOrderBy1_2() throws Exception {
        Query resolvedQuery = (Query)TestOrderByRewrite.getCommand("SELECT pm1.g1.e1, e2, concat(e3,'x'), concat(e2, 5) FROM pm1.g1 ORDER BY 3, 4, 1, 2");
        this.helpCheckElements(resolvedQuery.getOrderBy(), new String[]{"pm1.g1.e3", "pm1.g1.e2", "pm1.g1.e1", "pm1.g1.e2"}, new String[]{"pm1.g1.e3", "pm1.g1.e2", "pm1.g1.e1", "pm1.g1.e2"});
        this.helpCheckExpressionsSymbols(resolvedQuery.getOrderBy(), new String[]{"concat(e3, 'x')", "concat(e2, '5')"});
    }

    @Test
    public void testNumberedOrderBy1_3() throws Exception {
        Query resolvedQuery = (Query)TestOrderByRewrite.getCommand("SELECT pm1.g1.e1, avg(e2), e3, concat(e2, 5) FROM pm1.g1 ORDER BY 3, 4, 1, 2");
        this.helpCheckElements(resolvedQuery.getOrderBy(), new String[]{"pm1.g1.e3", "pm1.g1.e2", "pm1.g1.e1", "pm1.g1.e2"}, new String[]{"pm1.g1.e3", "pm1.g1.e2", "pm1.g1.e1", "pm1.g1.e2"});
        this.helpCheckExpressionsSymbols(resolvedQuery.getOrderBy(), new String[]{"concat(e2, '5')", "AVG(e2)"});
    }

    @Test
    public void testNumberedOrderBy1_4() throws Exception {
        String sql = "select e1, (select e2 from pm4.g1) from pm4.g2 X order by 2";
        Query resolvedQuery = (Query)TestOrderByRewrite.getCommand(sql);
        this.helpCheckExpressionsSymbols(resolvedQuery.getOrderBy(), new String[]{"(SELECT e2 FROM pm4.g1)"});
    }

    @Test
    public void testOrderBy1() throws Exception {
        Query resolvedQuery = (Query)TestOrderByRewrite.getCommand("SELECT pm1.g1.e1, e2, e3 as x, (5+2) as y FROM pm1.g1 ORDER BY x, y, pm1.g1.e1, e2");
        this.helpCheckElements(resolvedQuery.getOrderBy(), new String[]{"pm1.g1.e3", "pm1.g1.e1", "pm1.g1.e2"}, new String[]{"pm1.g1.e3", "pm1.g1.e1", "pm1.g1.e2"});
    }

    @Test
    public void testOrderBy2() throws Exception {
        Query resolvedQuery = (Query)TestOrderByRewrite.getCommand("SELECT * FROM pm1.g1 ORDER BY e1");
        this.helpCheckElements(resolvedQuery.getOrderBy(), new String[]{"pm1.g1.e1"}, new String[]{"pm1.g1.e1"});
    }

    @Test
    public void testOrderBy3() throws Exception {
        Query resolvedQuery = (Query)TestOrderByRewrite.getCommand("SELECT * FROM pm1.g1 ORDER BY pm1.g1.e1");
        this.helpCheckElements(resolvedQuery.getOrderBy(), new String[]{"pm1.g1.e1"}, new String[]{"pm1.g1.e1"});
    }

    @Test
    public void testOrderBy4() throws Exception {
        Query resolvedQuery = (Query)TestOrderByRewrite.getCommand("SELECT e1 FROM pm1.g1 ORDER BY pm1.g1.e1");
        this.helpCheckElements(resolvedQuery.getOrderBy(), new String[]{"pm1.g1.e1"}, new String[]{"pm1.g1.e1"});
    }

    @Test
    public void testOrderBy5() throws Exception {
        Query resolvedQuery = (Query)TestOrderByRewrite.getCommand("SELECT e1 FROM pm1.g1 ORDER BY e1");
        this.helpCheckElements(resolvedQuery.getOrderBy(), new String[]{"pm1.g1.e1"}, new String[]{"pm1.g1.e1"});
    }

    @Test
    public void testOrderBy6() throws Exception {
        Query resolvedQuery = (Query)TestOrderByRewrite.getCommand("SELECT e1 FROM pm1.g1 AS x ORDER BY e1");
        this.helpCheckElements(resolvedQuery.getOrderBy(), new String[]{"x.e1"}, new String[]{"pm1.g1.e1"});
    }

    @Test
    public void testOrderBy7() throws Exception {
        Query resolvedQuery = (Query)TestOrderByRewrite.getCommand("SELECT e1 FROM pm1.g1 AS x ORDER BY x.e1");
        this.helpCheckElements(resolvedQuery.getOrderBy(), new String[]{"x.e1"}, new String[]{"pm1.g1.e1"});
    }

    @Test
    public void testOrderBy8() throws Exception {
        Query resolvedQuery = (Query)TestOrderByRewrite.getCommand("SELECT x.e1 FROM pm1.g1 AS x ORDER BY e1");
        this.helpCheckElements(resolvedQuery.getOrderBy(), new String[]{"x.e1"}, new String[]{"pm1.g1.e1"});
    }

    @Test
    public void testOrderBy9() throws Exception {
        Query resolvedQuery = (Query)TestOrderByRewrite.getCommand("SELECT x.e1 FROM pm1.g1 AS x ORDER BY x.e1");
        this.helpCheckElements(resolvedQuery.getOrderBy(), new String[]{"x.e1"}, new String[]{"pm1.g1.e1"});
    }

    @Test
    public void testOrderBy10() throws Exception {
        Query resolvedQuery = (Query)TestOrderByRewrite.getCommand("SELECT a.e1, b.e1 FROM pm1.g1 AS a, pm1.g1 AS b ORDER BY a.e1");
        this.helpCheckElements(resolvedQuery.getOrderBy(), new String[]{"a.e1"}, new String[]{"pm1.g1.e1"});
    }

    @Test
    public void testOrderBy11() throws Exception {
        Query resolvedQuery = (Query)TestOrderByRewrite.getCommand("SELECT a.e1, b.e1 FROM pm1.g1 AS a, pm1.g1 AS b ORDER BY b.e1");
        this.helpCheckElements(resolvedQuery.getOrderBy(), new String[]{"b.e1"}, new String[]{"pm1.g1.e1"});
    }

    @Test
    public void testOrderBy12() throws Exception {
        Query resolvedQuery = (Query)TestOrderByRewrite.getCommand("SELECT a.e1, pm1.g1.e1 FROM pm1.g1 AS a, pm1.g1 ORDER BY a.e1");
        this.helpCheckElements(resolvedQuery.getOrderBy(), new String[]{"a.e1"}, new String[]{"pm1.g1.e1"});
    }

    @Test
    public void testOrderBy13() throws Exception {
        Query resolvedQuery = (Query)TestOrderByRewrite.getCommand("SELECT a.e1, pm1.g1.e1 FROM pm1.g1 AS a, pm1.g1 ORDER BY pm1.g1.e1");
        this.helpCheckElements(resolvedQuery.getOrderBy(), new String[]{"pm1.g1.e1"}, new String[]{"pm1.g1.e1"});
    }

    @Test
    public void testOrderBy14() throws Exception {
        Query resolvedQuery = (Query)TestOrderByRewrite.getCommand("SELECT a.e1 as x, pm1.g1.e1 as y FROM pm1.g1 AS a, pm1.g1 ORDER BY x");
        this.helpCheckElements(resolvedQuery.getOrderBy(), new String[]{"a.e1"}, new String[]{"pm1.g1.e1"});
    }

    @Test
    public void testOrderBy15() throws Exception {
        Query resolvedQuery = (Query)TestOrderByRewrite.getCommand("SELECT a.e1 as x, pm1.g1.e1 as y FROM pm1.g1 AS a, pm1.g1 ORDER BY y");
        this.helpCheckElements(resolvedQuery.getOrderBy(), new String[]{"pm1.g1.e1"}, new String[]{"pm1.g1.e1"});
    }

    @Test
    public void testNumberedOrderBy2() throws Exception {
        Query resolvedQuery = (Query)TestOrderByRewrite.getCommand("SELECT * FROM pm1.g1 ORDER BY 1");
        this.helpCheckElements(resolvedQuery.getOrderBy(), new String[]{"pm1.g1.e1"}, new String[]{"pm1.g1.e1"});
    }

    @Test
    public void testNumberedOrderBy3() throws Exception {
        Query resolvedQuery = (Query)TestOrderByRewrite.getCommand("SELECT * FROM pm1.g1 ORDER BY 1");
        this.helpCheckElements(resolvedQuery.getOrderBy(), new String[]{"pm1.g1.e1"}, new String[]{"pm1.g1.e1"});
    }

    @Test
    public void testNumberedOrderBy4() throws Exception {
        Query resolvedQuery = (Query)TestOrderByRewrite.getCommand("SELECT e1 FROM pm1.g1 ORDER BY 1");
        this.helpCheckElements(resolvedQuery.getOrderBy(), new String[]{"pm1.g1.e1"}, new String[]{"pm1.g1.e1"});
    }

    @Test
    public void testNumberedOrderBy5() throws Exception {
        Query resolvedQuery = (Query)TestOrderByRewrite.getCommand("SELECT x.e1 FROM pm1.g1 AS x ORDER BY 1");
        this.helpCheckElements(resolvedQuery.getOrderBy(), new String[]{"x.e1"}, new String[]{"pm1.g1.e1"});
    }

    @Test
    public void testNumberedOrderBy8() throws Exception {
        Query resolvedQuery = (Query)TestOrderByRewrite.getCommand("SELECT a.e1 as x, pm1.g1.e1 as y FROM pm1.g1 AS a, pm1.g1 ORDER BY 1");
        this.helpCheckElements(resolvedQuery.getOrderBy(), new String[]{"a.e1"}, new String[]{"pm1.g1.e1"});
    }

    @Test
    public void testDefect10729() throws Exception {
        Query resolvedQuery = (Query)TestOrderByRewrite.getCommand("SELECT pm1.g1.e1 FROM pm1.g1 ORDER BY g1.e1");
        this.helpCheckElements(resolvedQuery.getOrderBy(), new String[]{"pm1.g1.e1"}, new String[]{"pm1.g1.e1"});
    }

    @Test
    public void testDefect10729a() throws Exception {
        Query resolvedQuery = (Query)TestOrderByRewrite.getCommand("SELECT pm1.g1.e1 FROM pm1.g1 ORDER BY e1");
        this.helpCheckElements(resolvedQuery.getOrderBy(), new String[]{"pm1.g1.e1"}, new String[]{"pm1.g1.e1"});
    }

    @Test
    public void testAliasedOrderBy_ConstantElement() throws Exception {
        Query resolvedQuery = (Query)TestOrderByRewrite.getCommand("SELECT 0 AS SOMEINT, pm1.g1.e1 as y FROM pm1.g1 ORDER BY y, SOMEINT");
        this.helpCheckElements(resolvedQuery.getOrderBy(), new String[]{"pm1.g1.e1"}, new String[]{"pm1.g1.e1"});
    }

    @Test
    public void testOrderByExpression() throws Exception {
        Query resolvedQuery = (Query)TestOrderByRewrite.getCommand("SELECT 0 AS SOMEINT, pm1.g1.e2 as y FROM pm1.g1 ORDER BY e2 || e1, e3");
        Assert.assertEquals((Object)"SELECT X.SOMEINT, X.y FROM (SELECT 0 AS SOMEINT, pm1.g1.e2 AS y, (e2 || e1) AS EXPR1, e3 FROM pm1.g1) AS X ORDER BY X.EXPR1, X.e3", (Object)resolvedQuery.toString());
    }

    @Test
    public void testRewiteOrderBy() {
        TestQueryRewriter.helpTestRewriteCommand("SELECT 1+1 as a FROM pm1.g1 order by a", "SELECT 2 AS a FROM pm1.g1");
    }

    @Test
    public void testRewiteOrderBy1() {
        TestQueryRewriter.helpTestRewriteCommand("SELECT 1+1 as a FROM pm1.g1 union select pm1.g2.e1 from pm1.g2 order by a", "SELECT '2' AS a FROM pm1.g1 UNION SELECT pm1.g2.e1 FROM pm1.g2 ORDER BY a");
    }

    @Test
    public void testOrderByDuplicateRemoval() {
        String sql = "SELECT pm1.g1.e1, pm1.g1.e1 as c1234567890123456789012345678901234567890, pm1.g1.e2 FROM pm1.g1 ORDER BY c1234567890123456789012345678901234567890, e2, e1 ";
        TestQueryRewriter.helpTestRewriteCommand(sql, "SELECT pm1.g1.e1, pm1.g1.e1 AS c1234567890123456789012345678901234567890, pm1.g1.e2 FROM pm1.g1 ORDER BY c1234567890123456789012345678901234567890, pm1.g1.e2");
    }
}

