/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.sql.lang;

import junit.framework.TestCase;
import org.teiid.core.util.UnitTestUtil;
import org.teiid.query.sql.lang.MatchCriteria;
import org.teiid.query.sql.symbol.Constant;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;

public class TestMatchCriteria
extends TestCase {
    public TestMatchCriteria(String name) {
        super(name);
    }

    public static MatchCriteria example(String element, String str) {
        MatchCriteria crit = new MatchCriteria();
        crit.setLeftExpression((Expression)new ElementSymbol(element));
        crit.setRightExpression((Expression)new Constant((Object)str));
        return crit;
    }

    public static MatchCriteria example(String str) {
        MatchCriteria crit = new MatchCriteria();
        crit.setLeftExpression((Expression)new ElementSymbol("m.g1.e1"));
        crit.setRightExpression((Expression)new Constant((Object)str));
        return crit;
    }

    public static MatchCriteria example(String str, char escapeChar) {
        MatchCriteria crit = new MatchCriteria();
        crit.setLeftExpression((Expression)new ElementSymbol("m.g1.e1"));
        crit.setRightExpression((Expression)new Constant((Object)str));
        crit.setEscapeChar(escapeChar);
        return crit;
    }

    public void testEquals1() {
        MatchCriteria c1 = TestMatchCriteria.example("abc");
        MatchCriteria c2 = TestMatchCriteria.example("abc");
        TestMatchCriteria.assertTrue((String)("Equivalent match criteria don't compare as equal: " + c1 + ", " + c2), (boolean)c1.equals((Object)c2));
    }

    public void testEquals2() {
        MatchCriteria c1 = TestMatchCriteria.example("abc", '#');
        c1.setNegated(true);
        MatchCriteria c2 = TestMatchCriteria.example("abc", '#');
        c2.setNegated(true);
        TestMatchCriteria.assertTrue((String)("Equivalent match criteria don't compare as equal: " + c1 + ", " + c2), (boolean)c1.equals((Object)c2));
    }

    public void testEquals3() {
        MatchCriteria c1 = TestMatchCriteria.example("abc", '#');
        c1.setNegated(true);
        MatchCriteria c2 = (MatchCriteria)c1.clone();
        TestMatchCriteria.assertTrue((String)("Equivalent match criteria don't compare as equal: " + c1 + ", " + c2), (boolean)c1.equals((Object)c2));
    }

    public void testEquals4() {
        MatchCriteria c1 = TestMatchCriteria.example("abc");
        MatchCriteria c2 = TestMatchCriteria.example("abc", '#');
        TestMatchCriteria.assertTrue((String)("Different match criteria compare as equal: " + c1 + ", " + c2), (!c1.equals((Object)c2) ? 1 : 0) != 0);
    }

    public void testEquals5() {
        MatchCriteria c1 = TestMatchCriteria.example("e1", "abc");
        MatchCriteria c2 = TestMatchCriteria.example("e2", "abc");
        TestMatchCriteria.assertTrue((String)("Different match criteria compare as equal: " + c1 + ", " + c2), (!c1.equals((Object)c2) ? 1 : 0) != 0);
    }

    public void testSelfEquivalence() {
        MatchCriteria c1 = TestMatchCriteria.example("abc");
        int equals = 0;
        UnitTestUtil.helpTestEquivalence((int)equals, (Object)c1, (Object)c1);
    }

    public void testEquivalence() {
        MatchCriteria c1 = TestMatchCriteria.example("abc");
        MatchCriteria c2 = TestMatchCriteria.example("abc");
        int equals = 0;
        UnitTestUtil.helpTestEquivalence((int)equals, (Object)c1, (Object)c2);
    }

    public void testCloneEquivalence() {
        MatchCriteria c1 = TestMatchCriteria.example("abc");
        MatchCriteria c2 = (MatchCriteria)c1.clone();
        int equals = 0;
        UnitTestUtil.helpTestEquivalence((int)equals, (Object)c1, (Object)c2);
    }

    public void testNonEquivalence1() {
        MatchCriteria c1 = TestMatchCriteria.example("e1", "abc");
        MatchCriteria c2 = TestMatchCriteria.example("ozzy", '#');
        int equals = -1;
        UnitTestUtil.helpTestEquivalence((int)equals, (Object)c1, (Object)c2);
    }

    public void testNonEquivalence2() {
        MatchCriteria c1 = TestMatchCriteria.example("abc", '#');
        c1.setNegated(true);
        MatchCriteria c2 = TestMatchCriteria.example("abc", '#');
        c2.setNegated(false);
        int equals = -1;
        UnitTestUtil.helpTestEquivalence((int)equals, (Object)c1, (Object)c2);
    }
}

