/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.unittest;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.teiid.api.exception.query.QueryMetadataException;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.types.DataTypeManager;
import org.teiid.core.util.ArgCheck;
import org.teiid.core.util.Assertion;
import org.teiid.query.function.FunctionLibrary;
import org.teiid.query.mapping.relational.QueryNode;
import org.teiid.query.mapping.xml.MappingBaseNode;
import org.teiid.query.mapping.xml.MappingDocument;
import org.teiid.query.mapping.xml.MappingNode;
import org.teiid.query.mapping.xml.MappingVisitor;
import org.teiid.query.mapping.xml.Navigator;
import org.teiid.query.metadata.BasicQueryMetadata;
import org.teiid.query.metadata.StoredProcedureInfo;
import org.teiid.query.sql.lang.SPParameter;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.unittest.FakeMetadataFactory;
import org.teiid.query.unittest.FakeMetadataObject;
import org.teiid.query.unittest.FakeMetadataStore;

public class FakeMetadataFacade
extends BasicQueryMetadata {
    private FakeMetadataStore store;
    private FunctionLibrary functionLibrary;

    public FakeMetadataFacade(FakeMetadataStore store) {
        this.store = store;
        this.functionLibrary = FakeMetadataFactory.SFM.getSystemFunctionLibrary();
    }

    public FakeMetadataFacade(FakeMetadataStore store, FunctionLibrary funcLibrary) {
        this.store = store;
        this.functionLibrary = funcLibrary;
    }

    public FakeMetadataStore getStore() {
        return this.store;
    }

    public Object getElementID(String elementName) throws TeiidComponentException, QueryMetadataException {
        Assertion.isNotNull((Object)elementName);
        FakeMetadataObject obj = this.store.findObject(elementName, "Element");
        if (obj == null) {
            throw new QueryMetadataException("Element '" + elementName + "' not found.");
        }
        return obj;
    }

    public Object getGroupID(String groupName) throws TeiidComponentException, QueryMetadataException {
        Assertion.isNotNull((Object)groupName);
        FakeMetadataObject result = this.store.findObject(groupName, "Group");
        if (result == null) {
            throw new QueryMetadataException("Group '" + groupName + "' not found.");
        }
        return result;
    }

    public Collection getGroupsForPartialName(String partialGroupName) throws TeiidComponentException, QueryMetadataException {
        if (partialGroupName == null) {
            throw new QueryMetadataException("Group name cannot be null");
        }
        String qualifiedPartialPart = "." + partialGroupName;
        List groupNames = this.store.findObjects("Group", "dummy", null);
        ArrayList<String> correctGroups = new ArrayList<String>();
        Iterator groupIter = groupNames.iterator();
        while (groupIter.hasNext()) {
            String groupName = ((FakeMetadataObject)groupIter.next()).getName();
            if (!groupName.toLowerCase().endsWith(qualifiedPartialPart.toLowerCase())) continue;
            correctGroups.add(groupName);
        }
        return correctGroups;
    }

    public Object getModelID(Object groupOrElementID) throws TeiidComponentException, QueryMetadataException {
        ArgCheck.isInstanceOf(FakeMetadataObject.class, (Object)groupOrElementID);
        FakeMetadataObject obj = (FakeMetadataObject)groupOrElementID;
        return obj.getProperty("model");
    }

    public String getInsertPlan(Object groupID) throws TeiidComponentException, QueryMetadataException {
        ArgCheck.isInstanceOf(FakeMetadataObject.class, (Object)groupID);
        FakeMetadataObject obj = (FakeMetadataObject)groupID;
        return (String)obj.getProperty("insertProcedure");
    }

    public String getUpdatePlan(Object groupID) throws TeiidComponentException, QueryMetadataException {
        ArgCheck.isInstanceOf(FakeMetadataObject.class, (Object)groupID);
        FakeMetadataObject obj = (FakeMetadataObject)groupID;
        return (String)obj.getProperty("updateProcedure");
    }

    public String getDeletePlan(Object groupID) throws TeiidComponentException, QueryMetadataException {
        ArgCheck.isInstanceOf(FakeMetadataObject.class, (Object)groupID);
        FakeMetadataObject obj = (FakeMetadataObject)groupID;
        return (String)obj.getProperty("deleteProcedure");
    }

    public String getFullName(Object metadataID) throws TeiidComponentException, QueryMetadataException {
        ArgCheck.isInstanceOf(FakeMetadataObject.class, (Object)metadataID);
        return ((FakeMetadataObject)metadataID).getName();
    }

    public List getElementIDsInGroupID(Object groupID) throws TeiidComponentException, QueryMetadataException {
        ArgCheck.isInstanceOf(FakeMetadataObject.class, (Object)groupID);
        List ids = this.store.findObjects("Element", "group", groupID);
        Collections.sort(ids);
        return ids;
    }

    public Object getGroupIDForElementID(Object elementID) throws TeiidComponentException, QueryMetadataException {
        ArgCheck.isInstanceOf(FakeMetadataObject.class, (Object)elementID);
        FakeMetadataObject element = (FakeMetadataObject)elementID;
        return element.getProperty("group");
    }

    public String getElementType(Object elementID) throws TeiidComponentException, QueryMetadataException {
        ArgCheck.isInstanceOf(FakeMetadataObject.class, (Object)elementID);
        FakeMetadataObject element = (FakeMetadataObject)elementID;
        return (String)element.getProperty("type");
    }

    public Object getDefaultValue(Object elementID) throws TeiidComponentException, QueryMetadataException {
        ArgCheck.isInstanceOf(FakeMetadataObject.class, (Object)elementID);
        return ((FakeMetadataObject)elementID).getDefaultValue();
    }

    public boolean isVirtualGroup(Object groupID) throws TeiidComponentException, QueryMetadataException {
        ArgCheck.isInstanceOf(FakeMetadataObject.class, (Object)groupID);
        FakeMetadataObject group = (FakeMetadataObject)groupID;
        return Boolean.TRUE.equals(group.getProperty("isVirtual"));
    }

    public boolean isVirtualModel(Object modelID) throws TeiidComponentException, QueryMetadataException {
        ArgCheck.isInstanceOf(FakeMetadataObject.class, (Object)modelID);
        FakeMetadataObject model = (FakeMetadataObject)modelID;
        return (Boolean)model.getProperty("isVirtual");
    }

    public QueryNode getVirtualPlan(Object groupID) throws TeiidComponentException, QueryMetadataException {
        ArgCheck.isInstanceOf(FakeMetadataObject.class, (Object)groupID);
        FakeMetadataObject group = (FakeMetadataObject)groupID;
        QueryNode queryNode = (QueryNode)group.getProperty("plan");
        if (queryNode.getQuery() == null) {
            throw new QueryMetadataException("no query");
        }
        return queryNode;
    }

    public boolean modelSupports(Object modelID, int supportConstant) throws TeiidComponentException, QueryMetadataException {
        ArgCheck.isInstanceOf(FakeMetadataObject.class, (Object)modelID);
        switch (supportConstant) {
            default: 
        }
        throw new QueryMetadataException("Unknown model support constant: " + supportConstant);
    }

    public boolean groupSupports(Object groupID, int groupConstant) throws TeiidComponentException, QueryMetadataException {
        ArgCheck.isInstanceOf(FakeMetadataObject.class, (Object)groupID);
        FakeMetadataObject group = (FakeMetadataObject)groupID;
        Boolean supports = null;
        switch (groupConstant) {
            case 0: {
                supports = (Boolean)group.getProperty("supUpdate");
                break;
            }
            default: {
                throw new QueryMetadataException("Unknown group support constant: " + groupConstant);
            }
        }
        return supports;
    }

    public boolean elementSupports(Object elementID, int elementConstant) throws TeiidComponentException, QueryMetadataException {
        ArgCheck.isInstanceOf(FakeMetadataObject.class, (Object)elementID);
        FakeMetadataObject element = (FakeMetadataObject)elementID;
        Boolean supports = null;
        switch (elementConstant) {
            case 4: {
                supports = (Boolean)element.getProperty("supNull");
                break;
            }
            case 10: {
                supports = Boolean.FALSE;
                break;
            }
            case 2: {
                supports = (Boolean)element.getProperty("supCompare");
                break;
            }
            case 1: {
                supports = (Boolean)element.getProperty("supLike");
                break;
            }
            case 0: {
                supports = (Boolean)element.getProperty("supSelect");
                break;
            }
            case 5: {
                supports = (Boolean)element.getProperty("supUpdate");
                break;
            }
            case 7: {
                Object defaultValue = element.getProperty("supDefaultvalue");
                if (defaultValue == null) {
                    supports = Boolean.FALSE;
                    break;
                }
                if (defaultValue instanceof Boolean) {
                    supports = (Boolean)defaultValue;
                    break;
                }
                supports = Boolean.TRUE;
                break;
            }
            case 8: {
                supports = (Boolean)element.getProperty("supAutoIncrement");
                break;
            }
            case 9: {
                supports = (Boolean)element.getProperty("caseSensitive");
                break;
            }
            case 11: {
                supports = (Boolean)element.getProperty("signed");
                break;
            }
            default: {
                throw new QueryMetadataException("Unknown element support constant: " + elementConstant);
            }
        }
        if (supports != null) {
            return supports;
        }
        return false;
    }

    public int getMaxSetSize(Object modelID) throws TeiidComponentException, QueryMetadataException {
        ArgCheck.isInstanceOf(FakeMetadataObject.class, (Object)modelID);
        FakeMetadataObject model = (FakeMetadataObject)modelID;
        Integer maxSetSize = (Integer)model.getProperty("maxSetSize");
        if (maxSetSize == null) {
            return 100;
        }
        return maxSetSize;
    }

    public String getFullElementName(String fullGroupName, String shortElementName) throws TeiidComponentException, QueryMetadataException {
        Assertion.isNotNull((Object)fullGroupName);
        Assertion.isNotNull((Object)shortElementName);
        return fullGroupName + "." + shortElementName;
    }

    public String getShortElementName(String fullElementName) throws TeiidComponentException, QueryMetadataException {
        Assertion.isNotNull((Object)fullElementName);
        int index = fullElementName.lastIndexOf(".");
        if (index >= 0) {
            return fullElementName.substring(index + 1);
        }
        return fullElementName;
    }

    public String getGroupName(String fullElementName) throws TeiidComponentException, QueryMetadataException {
        Assertion.isNotNull((Object)fullElementName);
        int index = fullElementName.lastIndexOf(".");
        if (index >= 0) {
            return fullElementName.substring(0, index);
        }
        return null;
    }

    public StoredProcedureInfo getStoredProcedureInfoForProcedure(String fullyQualifiedProcedureName) throws TeiidComponentException, QueryMetadataException {
        Assertion.isNotNull((Object)fullyQualifiedProcedureName);
        FakeMetadataObject procedureID = this.store.findObject(fullyQualifiedProcedureName, "Procedure");
        if (procedureID == null) {
            throw new QueryMetadataException("Unknown stored procedure: " + fullyQualifiedProcedureName);
        }
        StoredProcedureInfo procInfo = new StoredProcedureInfo();
        procInfo.setProcedureID((Object)procedureID);
        procInfo.setModelID(procedureID.getProperty("model"));
        procInfo.setQueryPlan((QueryNode)procedureID.getProperty("plan"));
        procInfo.setProcedureCallableName((String)procedureID.getProperty("callableName"));
        procInfo.setUpdateCount(((Integer)procedureID.getProperty("updateCount", new Integer(-1))).intValue());
        List params = (List)procedureID.getProperty("params");
        ArrayList<SPParameter> paramInfos = new ArrayList<SPParameter>(params.size());
        for (FakeMetadataObject param : params) {
            String name = param.getName();
            if (name.indexOf(".") < 0) {
                name = procedureID.getName() + "." + name;
            }
            int index = (Integer)param.getProperty("index");
            int direction = (Integer)param.getProperty("direction");
            String dataTypeName = (String)param.getProperty("type");
            Class dataTypeClass = DataTypeManager.getDataTypeClass((String)dataTypeName);
            SPParameter paramInfo = new SPParameter(index, direction, name);
            paramInfo.setParameterType(direction);
            paramInfo.setMetadataID((Object)param);
            if (direction == 5) {
                paramInfo.setClassType(ResultSet.class);
            } else {
                paramInfo.setClassType(dataTypeClass);
            }
            FakeMetadataObject resultSet = (FakeMetadataObject)param.getProperty("isRS");
            if (resultSet != null) {
                for (ElementSymbol col : (List)resultSet.getProperty("columns")) {
                    paramInfo.addResultSetColumn(col.getName(), col.getType(), col.getMetadataID());
                }
            }
            paramInfos.add(paramInfo);
        }
        procInfo.setParameters(paramInfos);
        return procInfo;
    }

    public Collection getIndexesInGroup(Object groupID) throws TeiidComponentException, QueryMetadataException {
        return this.getTypeOfKeysInGroup(groupID, FakeMetadataObject.TYPE_INDEX);
    }

    public Collection getUniqueKeysInGroup(Object groupID) throws TeiidComponentException, QueryMetadataException {
        return this.getTypeOfKeysInGroup(groupID, FakeMetadataObject.TYPE_PRIMARY_KEY);
    }

    public Collection getForeignKeysInGroup(Object groupID) throws TeiidComponentException, QueryMetadataException {
        return this.getTypeOfKeysInGroup(groupID, FakeMetadataObject.TYPE_FOREIGN_KEY);
    }

    public Object getPrimaryKeyIDForForeignKeyID(Object foreignKeyID) throws TeiidComponentException, QueryMetadataException {
        ArgCheck.isInstanceOf(FakeMetadataObject.class, (Object)foreignKeyID);
        FakeMetadataObject keyObj = (FakeMetadataObject)foreignKeyID;
        return keyObj.getProperty("referencedKey");
    }

    public List getElementIDsInIndex(Object index) throws TeiidComponentException, QueryMetadataException {
        ArgCheck.isInstanceOf(FakeMetadataObject.class, (Object)index);
        FakeMetadataObject keyObj = (FakeMetadataObject)index;
        return (List)keyObj.getProperty("keyElements");
    }

    public List getElementIDsInKey(Object keyID) throws TeiidComponentException, QueryMetadataException {
        ArgCheck.isInstanceOf(FakeMetadataObject.class, (Object)keyID);
        FakeMetadataObject keyObj = (FakeMetadataObject)keyID;
        return (List)keyObj.getProperty("keyElements");
    }

    public Collection getAccessPatternsInGroup(Object groupID) throws TeiidComponentException, QueryMetadataException {
        return this.getTypeOfKeysInGroup(groupID, FakeMetadataObject.TYPE_ACCESS_PATTERN);
    }

    private Collection getTypeOfKeysInGroup(Object groupID, Integer KEY_TYPE) {
        ArgCheck.isInstanceOf(FakeMetadataObject.class, (Object)groupID);
        FakeMetadataObject group = (FakeMetadataObject)groupID;
        Collection keys = (Collection)group.getProperty("keys");
        if (keys == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<FakeMetadataObject> keysOfType = new ArrayList<FakeMetadataObject>(keys.size());
        for (FakeMetadataObject key : keys) {
            if (!KEY_TYPE.equals(key.getProperty("keyType"))) continue;
            keysOfType.add(key);
        }
        return keysOfType;
    }

    public List getElementIDsInAccessPattern(Object accessPattern) throws TeiidComponentException, QueryMetadataException {
        ArgCheck.isInstanceOf(FakeMetadataObject.class, (Object)accessPattern);
        FakeMetadataObject accessPatternObj = (FakeMetadataObject)accessPattern;
        return (List)accessPatternObj.getProperty("keyElements");
    }

    public MappingNode getMappingNode(Object groupID) throws TeiidComponentException, QueryMetadataException {
        ArgCheck.isInstanceOf(FakeMetadataObject.class, (Object)groupID);
        FakeMetadataObject group = (FakeMetadataObject)groupID;
        MappingDocument doc = (MappingDocument)group.getProperty("plan");
        doc.setName(this.getFullName(groupID));
        return doc;
    }

    public boolean isXMLGroup(Object groupID) throws TeiidComponentException, QueryMetadataException {
        ArgCheck.isInstanceOf(FakeMetadataObject.class, (Object)groupID);
        FakeMetadataObject group = (FakeMetadataObject)groupID;
        Object plan = group.getProperty("plan");
        if (plan == null) {
            return false;
        }
        return plan instanceof MappingNode;
    }

    public String getVirtualDatabaseName() throws TeiidComponentException, QueryMetadataException {
        return "myvdb";
    }

    public boolean isTemporaryTable(Object groupID) throws TeiidComponentException, QueryMetadataException {
        ArgCheck.isInstanceOf(FakeMetadataObject.class, (Object)groupID);
        FakeMetadataObject group = (FakeMetadataObject)groupID;
        Boolean isTemp = (Boolean)group.getProperty("temp");
        return isTemp != null && isTemp.equals(Boolean.TRUE);
    }

    public Collection getXMLTempGroups(Object groupID) throws TeiidComponentException, QueryMetadataException {
        ArgCheck.isInstanceOf(FakeMetadataObject.class, (Object)groupID);
        MappingDocument mappingDoc = (MappingDocument)((FakeMetadataObject)groupID).getProperty("plan");
        List tempGroups = this.resolveGroups(this.getStagingTables(mappingDoc));
        return tempGroups;
    }

    List getStagingTables(MappingDocument doc) {
        final ArrayList tables = new ArrayList();
        MappingVisitor visitor = new MappingVisitor(){

            public void visit(MappingBaseNode baseNode) {
                if (baseNode.getStagingTables() != null) {
                    tables.addAll(baseNode.getStagingTables());
                }
            }
        };
        doc.acceptVisitor((MappingVisitor)new Navigator(true, visitor));
        return tables;
    }

    private List resolveGroups(List groupNames) throws QueryMetadataException, TeiidComponentException {
        if (groupNames != null && !groupNames.isEmpty()) {
            ArrayList<Object> tempGroups = new ArrayList<Object>();
            for (int i = 0; i < groupNames.size(); ++i) {
                tempGroups.add(this.getGroupID((String)groupNames.get(i)));
            }
            return tempGroups;
        }
        return Collections.EMPTY_LIST;
    }

    public int getCardinality(Object groupID) throws TeiidComponentException, QueryMetadataException {
        ArgCheck.isInstanceOf(FakeMetadataObject.class, (Object)groupID);
        Integer cardinality = (Integer)((FakeMetadataObject)groupID).getProperty("cardinality");
        if (cardinality != null) {
            return cardinality;
        }
        return 0;
    }

    public String getNameInSource(Object metadataID) throws TeiidComponentException, QueryMetadataException {
        ArgCheck.isInstanceOf(FakeMetadataObject.class, (Object)metadataID);
        return (String)((FakeMetadataObject)metadataID).getProperty("nameInSource");
    }

    public Properties getExtensionProperties(Object metadataID) throws TeiidComponentException, QueryMetadataException {
        ArgCheck.isInstanceOf(FakeMetadataObject.class, (Object)metadataID);
        return ((FakeMetadataObject)metadataID).getExtensionProps();
    }

    public int getElementLength(Object elementID) throws TeiidComponentException, QueryMetadataException {
        ArgCheck.isInstanceOf(FakeMetadataObject.class, (Object)elementID);
        FakeMetadataObject element = (FakeMetadataObject)elementID;
        return Integer.parseInt((String)element.getProperty("length"));
    }

    public int getPosition(Object elementID) throws TeiidComponentException, QueryMetadataException {
        ArgCheck.isInstanceOf(FakeMetadataObject.class, (Object)elementID);
        FakeMetadataObject element = (FakeMetadataObject)elementID;
        return (Integer)element.getProperty("index") + 1;
    }

    public int getPrecision(Object elementID) throws TeiidComponentException, QueryMetadataException {
        ArgCheck.isInstanceOf(FakeMetadataObject.class, (Object)elementID);
        FakeMetadataObject element = (FakeMetadataObject)elementID;
        String precision = (String)element.getProperty("precision");
        if (precision == null) {
            return 0;
        }
        return Integer.parseInt(precision);
    }

    public int getRadix(Object elementID) throws TeiidComponentException, QueryMetadataException {
        ArgCheck.isInstanceOf(FakeMetadataObject.class, (Object)elementID);
        FakeMetadataObject element = (FakeMetadataObject)elementID;
        String radix = (String)element.getProperty("radix");
        if (radix == null) {
            return 0;
        }
        return Integer.parseInt(radix);
    }

    public int getScale(Object elementID) throws TeiidComponentException, QueryMetadataException {
        ArgCheck.isInstanceOf(FakeMetadataObject.class, (Object)elementID);
        FakeMetadataObject element = (FakeMetadataObject)elementID;
        String scale = (String)element.getProperty("scale");
        if (scale == null) {
            return 0;
        }
        return Integer.parseInt(scale);
    }

    public String getNativeType(Object elementID) throws TeiidComponentException, QueryMetadataException {
        ArgCheck.isInstanceOf(FakeMetadataObject.class, (Object)elementID);
        FakeMetadataObject element = (FakeMetadataObject)elementID;
        String nativeType = (String)element.getProperty("nativeType");
        if (nativeType == null) {
            return "";
        }
        return nativeType;
    }

    public boolean hasMaterialization(Object groupID) throws TeiidComponentException, QueryMetadataException {
        ArgCheck.isInstanceOf(FakeMetadataObject.class, (Object)groupID);
        FakeMetadataObject group = (FakeMetadataObject)groupID;
        return group.getProperty("matGroup") != null;
    }

    public Object getMaterialization(Object groupID) throws TeiidComponentException, QueryMetadataException {
        ArgCheck.isInstanceOf(FakeMetadataObject.class, (Object)groupID);
        FakeMetadataObject group = (FakeMetadataObject)groupID;
        return group.getProperty("matGroup");
    }

    public Object getMaterializationStage(Object groupID) throws TeiidComponentException, QueryMetadataException {
        ArgCheck.isInstanceOf(FakeMetadataObject.class, (Object)groupID);
        FakeMetadataObject group = (FakeMetadataObject)groupID;
        return group.getProperty("matStage");
    }

    public Object getMaximumValue(Object elementID) throws TeiidComponentException, QueryMetadataException {
        ArgCheck.isInstanceOf(FakeMetadataObject.class, (Object)elementID);
        FakeMetadataObject element = (FakeMetadataObject)elementID;
        return element.getProperty("maxValue");
    }

    public Object getMinimumValue(Object elementID) throws TeiidComponentException, QueryMetadataException {
        ArgCheck.isInstanceOf(FakeMetadataObject.class, (Object)elementID);
        FakeMetadataObject element = (FakeMetadataObject)elementID;
        return element.getProperty("minValue");
    }

    public int getDistinctValues(Object elementID) throws TeiidComponentException, QueryMetadataException {
        ArgCheck.isInstanceOf(FakeMetadataObject.class, (Object)elementID);
        FakeMetadataObject element = (FakeMetadataObject)elementID;
        Integer val = (Integer)element.getProperty("distinctValues");
        if (val != null) {
            return val;
        }
        return -1;
    }

    public int getNullValues(Object elementID) throws TeiidComponentException, QueryMetadataException {
        ArgCheck.isInstanceOf(FakeMetadataObject.class, (Object)elementID);
        FakeMetadataObject element = (FakeMetadataObject)elementID;
        Integer val = (Integer)element.getProperty("nullValues");
        if (val != null) {
            return val;
        }
        return -1;
    }

    public List getXMLSchemas(Object groupID) throws TeiidComponentException, QueryMetadataException {
        ArgCheck.isInstanceOf(FakeMetadataObject.class, (Object)groupID);
        FakeMetadataObject group = (FakeMetadataObject)groupID;
        return (List)group.getProperty("xmlSchemas");
    }

    public boolean isProcedure(Object elementID) {
        ArgCheck.isInstanceOf(FakeMetadataObject.class, (Object)elementID);
        FakeMetadataObject element = (FakeMetadataObject)elementID;
        return "Procedure".equals(element.getType());
    }

    public byte[] getBinaryVDBResource(String resourcePath) throws TeiidComponentException, QueryMetadataException {
        return "ResourceContents".getBytes();
    }

    public String getCharacterVDBResource(String resourcePath) throws TeiidComponentException, QueryMetadataException {
        return "ResourceContents";
    }

    public String[] getVDBResourcePaths() throws TeiidComponentException, QueryMetadataException {
        return new String[]{"my/resource/path"};
    }

    public String getModeledType(Object elementID) throws TeiidComponentException, QueryMetadataException {
        ArgCheck.isInstanceOf(FakeMetadataObject.class, (Object)elementID);
        FakeMetadataObject element = (FakeMetadataObject)elementID;
        return (String)element.getProperty("modeledType");
    }

    public String getModeledBaseType(Object elementID) throws TeiidComponentException, QueryMetadataException {
        ArgCheck.isInstanceOf(FakeMetadataObject.class, (Object)elementID);
        FakeMetadataObject element = (FakeMetadataObject)elementID;
        return (String)element.getProperty("baseType");
    }

    public String getModeledPrimitiveType(Object elementID) throws TeiidComponentException, QueryMetadataException {
        ArgCheck.isInstanceOf(FakeMetadataObject.class, (Object)elementID);
        FakeMetadataObject element = (FakeMetadataObject)elementID;
        return (String)element.getProperty("primitiveType");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object addToMetadataCache(Object metadataID, String key, Object value) throws TeiidComponentException, QueryMetadataException {
        FakeMetadataObject object;
        ArgCheck.isInstanceOf(FakeMetadataObject.class, (Object)metadataID);
        FakeMetadataObject fakeMetadataObject = object = (FakeMetadataObject)metadataID;
        synchronized (fakeMetadataObject) {
            Object result = object.getProperty(key);
            object.putProperty(key, value);
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getFromMetadataCache(Object metadataID, String key) throws TeiidComponentException, QueryMetadataException {
        FakeMetadataObject object;
        ArgCheck.isInstanceOf(FakeMetadataObject.class, (Object)metadataID);
        FakeMetadataObject fakeMetadataObject = object = (FakeMetadataObject)metadataID;
        synchronized (fakeMetadataObject) {
            return object.getProperty(key);
        }
    }

    public FunctionLibrary getFunctionLibrary() {
        return this.functionLibrary;
    }

    public Object getPrimaryKey(Object metadataID) {
        Collection keys = this.getTypeOfKeysInGroup(metadataID, FakeMetadataObject.TYPE_PRIMARY_KEY);
        if (!keys.isEmpty()) {
            return keys.iterator().next();
        }
        return null;
    }
}

