/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.unittest;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.teiid.query.unittest.FakeMetadataObject;

public class FakeMetadataStore {
    private Map models = new HashMap();
    private Map groups = new HashMap();
    private Map elements = new HashMap();
    private Map keys = new HashMap();
    private Map procedures = new HashMap();
    private Map resultSets = new HashMap();

    public void addObject(FakeMetadataObject object) {
        String lookupName = object.getName().toUpperCase();
        if (object.getType().equals("Element")) {
            this.elements.put(lookupName, object);
        } else if (object.getType().equals("Group")) {
            this.groups.put(lookupName, object);
        } else if (object.getType().equals("Model")) {
            this.models.put(lookupName, object);
        } else if (object.getType().equals("Key")) {
            this.keys.put(lookupName, object);
        } else if (object.getType().equals("Procedure")) {
            this.procedures.put(lookupName, object);
        } else if (object.getType().equals("ResultSet")) {
            this.resultSets.put(lookupName, object);
        } else {
            throw new IllegalArgumentException("Bad FakeMetadataObject type: " + object.getType());
        }
    }

    public void addObjects(Collection objects) {
        Iterator iter = objects.iterator();
        while (iter.hasNext()) {
            this.addObject((FakeMetadataObject)iter.next());
        }
    }

    public FakeMetadataObject findObject(String name, String type) {
        String lookupName = name.toUpperCase();
        if (type.equals("Element")) {
            return (FakeMetadataObject)this.elements.get(lookupName);
        }
        if (type.equals("Group")) {
            return (FakeMetadataObject)this.groups.get(lookupName);
        }
        if (type.equals("Model")) {
            return (FakeMetadataObject)this.models.get(lookupName);
        }
        if (type.equals("Key")) {
            return (FakeMetadataObject)this.keys.get(lookupName);
        }
        if (type.equals("Procedure")) {
            return (FakeMetadataObject)this.procedures.get(lookupName);
        }
        if (type.equals("ResultSet")) {
            return (FakeMetadataObject)this.resultSets.get(lookupName);
        }
        throw new IllegalArgumentException("Bad FakeMetadataObject type: " + type);
    }

    public List findObjects(String type, String propertyName, Object matchValue) {
        Map domain = null;
        if (type.equals("Element")) {
            domain = this.elements;
        } else if (type.equals("Group")) {
            domain = this.groups;
        } else if (type.equals("Model")) {
            domain = this.models;
        } else if (type.equals("Key")) {
            domain = this.keys;
        } else if (type.equals("Procedure")) {
            domain = this.procedures;
        } else if (type.equals("ResultSet")) {
            domain = this.resultSets;
        } else {
            throw new IllegalArgumentException("Bad FakeMetadataObject type: " + type);
        }
        ArrayList<FakeMetadataObject> found = new ArrayList<FakeMetadataObject>();
        for (FakeMetadataObject mdobj : domain.values()) {
            if (!this.compareWithNull(mdobj.getProperty(propertyName), matchValue)) continue;
            found.add(mdobj);
        }
        return found;
    }

    public boolean compareWithNull(Object obj1, Object obj2) {
        if (obj1 == null) {
            return obj2 == null;
        }
        if (obj2 == null) {
            return false;
        }
        return obj1.equals(obj2);
    }
}

