/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.jdbc;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class JDBCURL {
    private static final String UTF_8 = "UTF-8";
    public static final String JDBC_PROTOCOL = "jdbc:teiid:";
    private static final String OLD_JDBC_PROTOCOL = "jdbc:metamatrix:";
    public static final Set<String> EXECUTION_PROPERTIES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("autoCommitTxn", "partialResultsMode", "resultSetCacheMode", "ansiQuotedIdentifiers", "SHOWPLAN", "NOEXEC", "fetchSize", "XMLFormat", "XMLValidation", "disableLocalTxn")));
    public static final Set<String> KNOWN_PROPERTIES = JDBCURL.getKnownProperties();
    private String vdbName;
    private String connectionURL;
    private Properties properties = new Properties();
    private String urlString;

    private static Set<String> getKnownProperties() {
        HashSet<String> props = new HashSet<String>(Arrays.asList("ApplicationName", "VirtualDatabaseName", "version", "VirtualDatabaseVersion", "user", "password", "autoFailover", "discoveryStategy", "PassthroughAuthentication"));
        props.addAll(EXECUTION_PROPERTIES);
        return Collections.unmodifiableSet(props);
    }

    public JDBCURL(String jdbcURL) {
        this.parseURL(jdbcURL);
    }

    public JDBCURL(String vdbName, String connectionURL, Properties props) {
        if (vdbName == null || vdbName.trim().length() == 0) {
            throw new IllegalArgumentException();
        }
        this.vdbName = vdbName;
        this.connectionURL = connectionURL;
        if (props != null) {
            JDBCURL.normalizeProperties(props, this.properties);
        }
    }

    public String getVDBName() {
        return this.vdbName;
    }

    public String getConnectionURL() {
        return this.connectionURL;
    }

    public Properties getProperties() {
        Properties newProps = new Properties();
        newProps.putAll((Map<?, ?>)this.properties);
        return newProps;
    }

    private void parseURL(String jdbcURL) {
        if (jdbcURL == null) {
            throw new IllegalArgumentException();
        }
        if ((jdbcURL = jdbcURL.trim()).length() == 0) {
            throw new IllegalArgumentException();
        }
        int delimiter = jdbcURL.indexOf(64);
        if (delimiter == -1) {
            int fsc = jdbcURL.indexOf(59);
            if (fsc == -1) {
                this.parseJDBCProtocol(jdbcURL);
            } else {
                this.parseJDBCProtocol(jdbcURL.substring(0, fsc));
                JDBCURL.parseConnectionProperties(jdbcURL.substring(fsc + 1), this.properties);
            }
        } else {
            String[] urlParts = jdbcURL.split("@", 2);
            if (urlParts.length != 2) {
                throw new IllegalArgumentException();
            }
            this.parseJDBCProtocol(urlParts[0]);
            this.parseConnectionPart(urlParts[1]);
        }
    }

    private void parseJDBCProtocol(String protocol) {
        if (protocol.startsWith(JDBC_PROTOCOL)) {
            if (protocol.length() == JDBC_PROTOCOL.length()) {
                throw new IllegalArgumentException();
            }
            this.vdbName = protocol.substring(JDBC_PROTOCOL.length());
        } else if (protocol.startsWith(OLD_JDBC_PROTOCOL)) {
            if (protocol.length() == OLD_JDBC_PROTOCOL.length()) {
                throw new IllegalArgumentException();
            }
            this.vdbName = protocol.substring(OLD_JDBC_PROTOCOL.length());
        } else {
            throw new IllegalArgumentException();
        }
    }

    private void parseConnectionPart(String connectionInfo) {
        String[] connectionParts = connectionInfo.split(";");
        if (connectionParts.length == 0 || connectionParts[0].trim().length() == 0) {
            throw new IllegalArgumentException();
        }
        this.connectionURL = connectionParts[0].trim();
        if (connectionParts.length > 1) {
            for (int i = 1; i < connectionParts.length; ++i) {
                JDBCURL.parseConnectionProperty(connectionParts[i], this.properties);
            }
        }
    }

    public static void parseConnectionProperties(String connectionInfo, Properties p) {
        String[] connectionParts = connectionInfo.split(";");
        if (connectionParts.length != 0) {
            for (int i = 0; i < connectionParts.length; ++i) {
                JDBCURL.parseConnectionProperty(connectionParts[i], p);
            }
        }
    }

    static void parseConnectionProperty(String connectionProperty, Properties p) {
        if (connectionProperty.length() == 0) {
            return;
        }
        if (connectionProperty.length() < 3) {
            throw new IllegalArgumentException();
        }
        int firstEquals = connectionProperty.indexOf(61);
        if (firstEquals < 1) {
            throw new IllegalArgumentException();
        }
        String key = connectionProperty.substring(0, firstEquals).trim();
        String value = connectionProperty.substring(firstEquals + 1).trim();
        if (value.indexOf(61) >= 0) {
            throw new IllegalArgumentException();
        }
        JDBCURL.addNormalizedProperty(key, JDBCURL.getValidValue(value), p);
    }

    public String getJDBCURL() {
        if (this.urlString == null) {
            StringBuffer buf = new StringBuffer(JDBC_PROTOCOL).append(this.vdbName);
            if (this.connectionURL != null) {
                buf.append('@').append(this.connectionURL);
            }
            for (Map.Entry<Object, Object> entry : this.properties.entrySet()) {
                if (!(entry.getValue() instanceof String)) continue;
                buf.append(';').append(entry.getKey()).append('=').append(entry.getValue());
            }
            this.urlString = buf.toString();
        }
        return this.urlString;
    }

    public String getProperty(String key) {
        return this.properties.getProperty(key);
    }

    public String getUserName() {
        return this.properties.getProperty("user");
    }

    public String getPassword() {
        return this.properties.getProperty("password");
    }

    public String getVDBVersion() {
        if (this.properties.contains("VirtualDatabaseVersion")) {
            return this.properties.getProperty("VirtualDatabaseVersion");
        }
        return this.properties.getProperty("version");
    }

    public String getTransactionAutowrapMode() {
        return this.properties.getProperty("autoCommitTxn");
    }

    public String getPartialResultsMode() {
        return this.properties.getProperty("partialResultsMode");
    }

    public String getResultSetCacheMode() {
        return this.properties.getProperty("resultSetCacheMode");
    }

    public String getAnsiQuotedIdentifiers() {
        return this.properties.getProperty("ansiQuotedIdentifiers");
    }

    public String getFetchSize() {
        return this.properties.getProperty("fetchSize");
    }

    public String getXMLFormat() {
        return this.properties.getProperty("XMLFormat");
    }

    public String getXMLValidation() {
        return this.properties.getProperty("XMLValidation");
    }

    public String getTransparentFailover() {
        return this.properties.getProperty("autoFailover");
    }

    public String getDisableLocalTransactions() {
        return this.properties.getProperty("disableLocalTxn");
    }

    public String toString() {
        return this.getJDBCURL();
    }

    private static void normalizeProperties(Properties source, Properties target) {
        Enumeration<?> e = source.propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            JDBCURL.addNormalizedProperty(key, source.get(key), target);
        }
    }

    public static void addNormalizedProperty(String key, Object value, Properties target) {
        String validKey = JDBCURL.getValidKey(key);
        target.put(validKey, value);
    }

    public static String getValidKey(String key) {
        for (String prop : KNOWN_PROPERTIES) {
            if (!prop.equalsIgnoreCase(key)) continue;
            return prop;
        }
        return key;
    }

    private static Object getValidValue(Object value) {
        if (value instanceof String) {
            try {
                return URLDecoder.decode((String)value, UTF_8);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return value;
    }

    public static Properties normalizeProperties(Properties props) {
        JDBCURL.normalizeProperties(props, props);
        return props;
    }
}

