/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.jdbc;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.teiid.core.TeiidException;
import org.teiid.core.util.PropertiesUtils;
import org.teiid.jdbc.ConnectionImpl;
import org.teiid.jdbc.JDBCPlugin;
import org.teiid.jdbc.JDBCURL;
import org.teiid.jdbc.TeiidSQLException;
import org.teiid.net.CommunicationException;
import org.teiid.net.ConnectionException;
import org.teiid.net.socket.SocketServerConnection;
import org.teiid.net.socket.SocketServerConnectionFactory;

final class SocketProfile {
    private static Logger logger = Logger.getLogger("org.teiid.jdbc");
    static final String HOST_PORT_PATTERN = "\\[?[\\p{Alnum}\\.\\-\\_:]+\\]?:\\d+";
    static final String URL_PATTERN = "jdbc:teiid:([\\w-\\.]+)@mm[s]?://\\[?[\\p{Alnum}\\.\\-\\_:]+\\]?:\\d+(,\\[?[\\p{Alnum}\\.\\-\\_:]+\\]?:\\d+)*(;.*)?";
    static Pattern urlPattern = Pattern.compile("jdbc:teiid:([\\w-\\.]+)@mm[s]?://\\[?[\\p{Alnum}\\.\\-\\_:]+\\]?:\\d+(,\\[?[\\p{Alnum}\\.\\-\\_:]+\\]?:\\d+)*(;.*)?");

    SocketProfile() {
    }

    public static Connection connect(String url, Properties info) throws SQLException {
        ConnectionImpl myConnection = null;
        info = info == null ? new Properties() : PropertiesUtils.clone((Properties)info);
        try {
            SocketProfile.parseURL(url, info);
            myConnection = SocketProfile.createConnection(url, info);
        }
        catch (TeiidException e) {
            logger.log(Level.SEVERE, "Could not create connection", e);
            throw TeiidSQLException.create(e, e.getMessage());
        }
        String logMsg = JDBCPlugin.Util.getString("JDBCDriver.Connection_sucess");
        logger.fine(logMsg);
        return myConnection;
    }

    static ConnectionImpl createConnection(String url, Properties info) throws ConnectionException, CommunicationException {
        SocketServerConnection serverConn = SocketServerConnectionFactory.getInstance().getConnection(info);
        ConnectionImpl connection = new ConnectionImpl(serverConn, info, url);
        return connection;
    }

    protected static void parseURL(String url, Properties info) throws SQLException {
        if (url == null) {
            String msg = JDBCPlugin.Util.getString("MMDriver.urlFormat");
            throw new TeiidSQLException(msg);
        }
        try {
            JDBCURL jdbcURL = new JDBCURL(url);
            info.setProperty("VirtualDatabaseName", jdbcURL.getVDBName());
            info.setProperty("serverURL", jdbcURL.getConnectionURL());
            Properties optionalParams = jdbcURL.getProperties();
            JDBCURL.normalizeProperties(info);
            Enumeration<Object> keys = optionalParams.keys();
            while (keys.hasMoreElements()) {
                String propName = (String)keys.nextElement();
                if (info.containsKey(propName)) continue;
                info.setProperty(propName, optionalParams.getProperty(propName));
            }
            if (!info.containsKey("VirtualDatabaseVersion") && jdbcURL.getVDBVersion() != null) {
                info.setProperty("VirtualDatabaseVersion", jdbcURL.getVDBVersion());
            }
            if (!info.containsKey("ApplicationName")) {
                info.setProperty("ApplicationName", "JDBC");
            }
        }
        catch (IllegalArgumentException iae) {
            throw new TeiidSQLException(JDBCPlugin.Util.getString("MMDriver.urlFormat"));
        }
    }

    public static boolean acceptsURL(String url) {
        Matcher m = urlPattern.matcher(url);
        return m.matches();
    }
}

