/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.common.buffer;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import org.teiid.common.buffer.AbstractTupleSource;
import org.teiid.common.buffer.BatchManager;
import org.teiid.common.buffer.BlockedException;
import org.teiid.common.buffer.FileStore;
import org.teiid.common.buffer.IndexedTupleSource;
import org.teiid.common.buffer.LobManager;
import org.teiid.common.buffer.TupleBatch;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.types.DataTypeManager;
import org.teiid.core.types.Streamable;
import org.teiid.core.util.Assertion;
import org.teiid.logging.LogManager;
import org.teiid.query.QueryPlugin;
import org.teiid.query.sql.symbol.Expression;

public class TupleBuffer {
    private BatchManager manager;
    private String tupleSourceID;
    private List<?> schema;
    private String[] types;
    private int batchSize;
    private int rowCount;
    private boolean isFinal;
    private TreeMap<Integer, BatchManager.ManagedBatch> batches = new TreeMap();
    private ArrayList<List<?>> batchBuffer;
    private boolean removed;
    private boolean forwardOnly;
    private boolean prefersMemory;
    private LobManager lobManager;
    private int[] lobIndexes;
    private String uuid;
    private FileStore lobStore;

    public static String[] getTypeNames(List expressions) {
        if (expressions == null) {
            return null;
        }
        String[] types = new String[expressions.size()];
        ListIterator i = expressions.listIterator();
        while (i.hasNext()) {
            Expression expr = (Expression)i.next();
            types[i.previousIndex()] = DataTypeManager.getDataTypeName((Class)expr.getType());
        }
        return types;
    }

    public TupleBuffer(BatchManager manager, String id, List<?> schema, int[] lobIndexes, int batchSize) {
        this.manager = manager;
        this.tupleSourceID = id;
        this.schema = schema;
        this.types = TupleBuffer.getTypeNames(schema);
        this.lobIndexes = lobIndexes;
        if (this.lobIndexes != null) {
            this.lobManager = new LobManager();
            this.lobStore = this.manager.createStorage("_lobs");
            this.lobStore.setCleanupReference(this);
        }
        this.batchSize = batchSize;
    }

    public String getId() {
        if (this.uuid == null) {
            this.uuid = UUID.randomUUID().toString();
        }
        return this.uuid;
    }

    public boolean isLobs() {
        return this.lobIndexes != null;
    }

    public void addTuple(List<?> tuple) throws TeiidComponentException {
        if (this.isLobs()) {
            this.lobManager.updateReferences(this.lobIndexes, tuple);
        }
        ++this.rowCount;
        if (this.batchBuffer == null) {
            this.batchBuffer = new ArrayList(this.batchSize / 4);
        }
        this.batchBuffer.add(tuple);
        if (this.batchBuffer.size() == this.batchSize) {
            this.saveBatch(false, false);
        }
    }

    public void addTupleBatch(TupleBatch batch, boolean save) throws TeiidComponentException {
        block3: {
            block2: {
                this.setRowCount(batch.getBeginRow() - 1);
                if (!save) break block2;
                for (List<?> tuple : batch.getTuples()) {
                    this.addTuple(tuple);
                }
                break block3;
            }
            if (!this.isLobs()) break block3;
            for (List<?> tuple : batch.getTuples()) {
                this.lobManager.updateReferences(this.lobIndexes, tuple);
            }
        }
    }

    public void setRowCount(int rowCount) throws TeiidComponentException {
        assert (this.rowCount <= rowCount);
        if (this.rowCount != rowCount) {
            this.saveBatch(false, true);
            this.rowCount = rowCount;
        }
    }

    public void purge() {
        if (this.batchBuffer != null) {
            this.batchBuffer.clear();
        }
        for (BatchManager.ManagedBatch batch : this.batches.values()) {
            batch.remove();
        }
        this.batches.clear();
    }

    public void persistLobs() throws TeiidComponentException {
        if (this.lobManager != null) {
            this.lobManager.persist(this.lobStore);
        }
    }

    public void saveBatch() throws TeiidComponentException {
        this.saveBatch(false, false);
    }

    void saveBatch(boolean finalBatch, boolean force) throws TeiidComponentException {
        Assertion.assertTrue((!this.isRemoved() ? 1 : 0) != 0);
        if (this.batchBuffer == null || this.batchBuffer.isEmpty() || !force && this.batchBuffer.size() < Math.max(1, this.batchSize / 32)) {
            return;
        }
        TupleBatch writeBatch = new TupleBatch(this.rowCount - this.batchBuffer.size() + 1, this.batchBuffer);
        if (finalBatch) {
            writeBatch.setTerminationFlag(true);
        }
        writeBatch.setDataTypes(this.types);
        BatchManager.ManagedBatch mbatch = this.manager.createManagedBatch(writeBatch, this.prefersMemory);
        this.batches.put(writeBatch.getBeginRow(), mbatch);
        this.batchBuffer = null;
    }

    public void close() throws TeiidComponentException {
        this.saveBatch(true, false);
        this.isFinal = true;
    }

    public TupleBatch getBatch(int row) throws TeiidComponentException {
        TupleBatch result = null;
        if (row > this.rowCount) {
            result = new TupleBatch(this.rowCount + 1, new List[0]);
        } else if (this.batchBuffer != null && row > this.rowCount - this.batchBuffer.size()) {
            result = new TupleBatch(this.rowCount - this.batchBuffer.size() + 1, this.batchBuffer);
            if (this.forwardOnly) {
                this.batchBuffer = null;
            }
        } else {
            if (this.batchBuffer != null && !this.batchBuffer.isEmpty()) {
                this.saveBatch(this.isFinal, false);
            }
            Map.Entry<Integer, BatchManager.ManagedBatch> entry = this.batches.floorEntry(row);
            Assertion.isNotNull(entry);
            BatchManager.ManagedBatch batch = entry.getValue();
            result = batch.getBatch(!this.forwardOnly, this.types);
            if (this.forwardOnly) {
                this.batches.remove(entry.getKey());
            }
        }
        result.setDataTypes(this.types);
        if (this.isFinal && result.getEndRow() == this.rowCount) {
            result.setTerminationFlag(true);
        }
        return result;
    }

    public void remove() {
        if (!this.removed) {
            if (LogManager.isMessageToBeRecorded((String)"org.teiid.BUFFER_MGR", (int)5)) {
                LogManager.logDetail((String)"org.teiid.BUFFER_MGR", (Object[])new Object[]{"Removing TupleBuffer:", this.tupleSourceID});
            }
            if (this.lobStore != null) {
                this.lobStore.remove();
            }
            this.batchBuffer = null;
            this.purge();
            this.manager.remove();
            this.removed = true;
        }
    }

    public int getRowCount() {
        return this.rowCount;
    }

    public boolean isFinal() {
        return this.isFinal;
    }

    public void setFinal(boolean isFinal) {
        this.isFinal = isFinal;
    }

    public List<?> getSchema() {
        return this.schema;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public Streamable<?> getLobReference(String id) throws TeiidComponentException {
        if (this.lobManager == null) {
            throw new TeiidComponentException(QueryPlugin.Util.getString("ProcessWorker.wrongdata"));
        }
        return this.lobManager.getLobReference(id);
    }

    public void setForwardOnly(boolean forwardOnly) {
        this.forwardOnly = forwardOnly;
    }

    public IndexedTupleSource createIndexedTupleSource() {
        return this.createIndexedTupleSource(false);
    }

    public IndexedTupleSource createIndexedTupleSource(final boolean singleUse) {
        if (singleUse) {
            this.setForwardOnly(true);
        }
        return new AbstractTupleSource(){

            @Override
            protected List<?> finalRow() throws BlockedException {
                if (TupleBuffer.this.isFinal) {
                    return null;
                }
                throw BlockedException.INSTANCE;
            }

            @Override
            public int available() {
                return TupleBuffer.this.rowCount - this.getCurrentIndex() + 1;
            }

            @Override
            protected TupleBatch getBatch(int row) throws TeiidComponentException {
                return TupleBuffer.this.getBatch(row);
            }

            @Override
            public void closeSource() {
                super.closeSource();
                if (singleUse) {
                    TupleBuffer.this.remove();
                }
            }
        };
    }

    public String toString() {
        return this.tupleSourceID;
    }

    public boolean isRemoved() {
        return this.removed;
    }

    public boolean isForwardOnly() {
        return this.forwardOnly;
    }

    public void setPrefersMemory(boolean prefersMemory) {
        this.prefersMemory = prefersMemory;
    }

    public boolean isPrefersMemory() {
        return this.prefersMemory;
    }
}

