/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.common.buffer.impl;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicLong;
import org.teiid.common.buffer.FileStore;
import org.teiid.common.buffer.StorageManager;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.util.Assertion;
import org.teiid.logging.LogManager;
import org.teiid.query.QueryPlugin;

public class FileStorageManager
implements StorageManager {
    public static final int DEFAULT_MAX_OPEN_FILES = 64;
    public static final long DEFAULT_MAX_FILESIZE = 2048L;
    public static final long DEFAULT_MAX_BUFFERSPACE = 0xC80000000L;
    private static final String FILE_PREFIX = "b_";
    private long maxBufferSpace = 0xC80000000L;
    private AtomicLong usedBufferSpace = new AtomicLong();
    private int maxOpenFiles = 64;
    private long maxFileSize = 0x80000000L;
    private String directory;
    private File dirFile;
    private Map<File, RandomAccessFile> fileCache = Collections.synchronizedMap(new LinkedHashMap<File, RandomAccessFile>(){

        @Override
        protected boolean removeEldestEntry(Map.Entry<File, RandomAccessFile> eldest) {
            if (this.size() > FileStorageManager.this.maxOpenFiles) {
                try {
                    eldest.getValue().close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return true;
            }
            return false;
        }
    });

    @Override
    public void initialize() throws TeiidComponentException {
        if (this.directory == null) {
            throw new TeiidComponentException(QueryPlugin.Util.getString("FileStoreageManager.no_directory"));
        }
        this.dirFile = new File(this.directory);
        if (this.dirFile.exists()) {
            if (!this.dirFile.isDirectory()) {
                throw new TeiidComponentException(QueryPlugin.Util.getString("FileStoreageManager.not_a_directory", new Object[]{this.dirFile.getAbsoluteFile()}));
            }
        } else if (!this.dirFile.mkdirs()) {
            throw new TeiidComponentException(QueryPlugin.Util.getString("FileStoreageManager.error_creating", new Object[]{this.dirFile.getAbsoluteFile()}));
        }
    }

    public void setMaxFileSize(long maxFileSize) {
        this.maxFileSize = maxFileSize * 1024L * 1024L;
    }

    void setMaxFileSizeDirect(long maxFileSize) {
        this.maxFileSize = maxFileSize;
    }

    public void setMaxOpenFiles(int maxOpenFiles) {
        this.maxOpenFiles = maxOpenFiles;
    }

    public void setStorageDirectory(String directory) {
        this.directory = directory;
    }

    File createFile(String name, int fileNumber) throws TeiidComponentException {
        try {
            File storageFile = File.createTempFile(FILE_PREFIX + name + "_" + String.valueOf(fileNumber) + "_", null, this.dirFile);
            if (LogManager.isMessageToBeRecorded((String)"org.teiid.BUFFER_MGR", (int)5)) {
                LogManager.logDetail((String)"org.teiid.BUFFER_MGR", (Object[])new Object[]{"Created temporary storage area file " + storageFile.getAbsoluteFile()});
            }
            return storageFile;
        }
        catch (IOException e) {
            throw new TeiidComponentException((Throwable)e, QueryPlugin.Util.getString("FileStoreageManager.error_creating", new Object[]{name + "_" + fileNumber}));
        }
    }

    @Override
    public FileStore createFileStore(String name) {
        return new DiskStore(name);
    }

    public long getMaxFileSize() {
        return this.maxFileSize;
    }

    public String getDirectory() {
        return this.directory;
    }

    Map<File, RandomAccessFile> getFileCache() {
        return this.fileCache;
    }

    public int getOpenFiles() {
        return this.fileCache.size();
    }

    public long getUsedBufferSpace() {
        return this.usedBufferSpace.get();
    }

    public void setMaxBufferSpace(long maxBufferSpace) {
        this.maxBufferSpace = maxBufferSpace;
    }

    public class DiskStore
    extends FileStore {
        private String name;
        private TreeMap<Long, FileInfo> storageFiles = new TreeMap();

        public DiskStore(String name) {
            this.name = name;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public int readDirect(long fileOffset, byte[] b, int offSet, int length) throws TeiidComponentException {
            FileInfo fileInfo;
            Map.Entry<Long, FileInfo> entry = this.storageFiles.floorEntry(fileOffset);
            Assertion.isNotNull(entry);
            FileInfo fileInfo2 = fileInfo = entry.getValue();
            synchronized (fileInfo2) {
                try {
                    RandomAccessFile fileAccess = fileInfo.open();
                    fileAccess.seek(fileOffset - entry.getKey());
                    int n = fileAccess.read(b, offSet, length);
                    return n;
                }
                catch (IOException e) {
                    throw new TeiidComponentException((Throwable)e, QueryPlugin.Util.getString("FileStoreageManager.error_reading", new Object[]{fileInfo.file.getAbsoluteFile()}));
                }
                finally {
                    fileInfo.close();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void writeDirect(byte[] bytes, int offset, int length) throws TeiidComponentException {
            long used = FileStorageManager.this.usedBufferSpace.addAndGet(length);
            if (used > FileStorageManager.this.maxBufferSpace) {
                FileStorageManager.this.usedBufferSpace.addAndGet(-length);
                throw new TeiidComponentException(QueryPlugin.Util.getString("FileStoreageManager.space_exhausted", new Object[]{FileStorageManager.this.maxBufferSpace}));
            }
            Map.Entry<Long, FileInfo> entry = this.storageFiles.lastEntry();
            boolean createNew = false;
            FileInfo fileInfo = null;
            long fileOffset = 0L;
            if (entry == null) {
                createNew = true;
            } else {
                fileInfo = entry.getValue();
                fileOffset = entry.getKey();
                boolean bl = createNew = entry.getValue().file.length() + (long)length > FileStorageManager.this.getMaxFileSize();
            }
            if (createNew) {
                FileInfo newFileInfo = new FileInfo(FileStorageManager.this.createFile(this.name, this.storageFiles.size()));
                if (fileInfo != null) {
                    fileOffset += fileInfo.file.length();
                }
                this.storageFiles.put(fileOffset, newFileInfo);
                fileInfo = newFileInfo;
            }
            FileInfo fileInfo2 = fileInfo;
            synchronized (fileInfo2) {
                try {
                    RandomAccessFile fileAccess = fileInfo.open();
                    long pointer = fileAccess.length();
                    fileAccess.setLength(pointer + (long)length);
                    fileAccess.seek(pointer);
                    fileAccess.write(bytes, offset, length);
                }
                catch (IOException e) {
                    throw new TeiidComponentException((Throwable)e, QueryPlugin.Util.getString("FileStoreageManager.error_reading", new Object[]{fileInfo.file.getAbsoluteFile()}));
                }
                finally {
                    fileInfo.close();
                }
            }
        }

        @Override
        public synchronized void removeDirect() {
            FileStorageManager.this.usedBufferSpace.addAndGet(-this.len);
            for (FileInfo info : this.storageFiles.values()) {
                info.delete();
            }
        }
    }

    private class FileInfo {
        private File file;
        private RandomAccessFile fileData;

        public FileInfo(File file) {
            this.file = file;
        }

        public RandomAccessFile open() throws FileNotFoundException {
            if (this.fileData == null) {
                this.fileData = (RandomAccessFile)FileStorageManager.this.fileCache.remove(this.file);
                if (this.fileData == null) {
                    this.fileData = new RandomAccessFile(this.file, "rw");
                }
            }
            return this.fileData;
        }

        public void close() {
            FileStorageManager.this.fileCache.put(this.file, this.fileData);
            this.fileData = null;
        }

        public void delete() {
            if (this.fileData == null) {
                this.fileData = (RandomAccessFile)FileStorageManager.this.fileCache.remove(this.file);
            }
            if (this.fileData != null) {
                try {
                    this.fileData.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            this.file.delete();
        }

        public String toString() {
            return "FileInfo<" + this.file.getName() + ", has fileData = " + (this.fileData != null) + ">";
        }
    }
}

