/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.core.id;

import java.util.Set;
import org.teiid.core.CorePlugin;
import org.teiid.core.id.InvalidIDException;

public class ParsedObjectID {
    private static final int DELIMITER_LENGTH = 1;
    private final String protocol;
    private final String remainder;

    protected ParsedObjectID(String protocol, String remainder) {
        this.protocol = protocol;
        this.remainder = remainder;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getRemainder() {
        return this.remainder;
    }

    public static ParsedObjectID parsedStringifiedObjectID(String id, Set protocols) throws InvalidIDException {
        for (String protocol : protocols) {
            if (!id.startsWith(protocol)) continue;
            return new ParsedObjectID(protocol, id.substring(protocol.length() + 1));
        }
        throw new InvalidIDException(CorePlugin.Util.getString("ParsedObjectID.The_stringified_ObjectID_does_not_have_a_protocol"));
    }

    public static ParsedObjectID parsedStringifiedObjectID(String id) throws InvalidIDException {
        return ParsedObjectID.parsedStringifiedObjectID(id, ':');
    }

    public static ParsedObjectID parsedStringifiedObjectID(String id, char delim) throws InvalidIDException {
        int index = -1;
        if (id != null) {
            index = id.indexOf(delim);
        }
        if (index == -1) {
            throw new InvalidIDException(CorePlugin.Util.getString("ParsedObjectID.The_stringified_ObjectID_does_not_have_a_protocol"));
        }
        return new ParsedObjectID(id.substring(0, index), id.substring(index + 1));
    }

    public static ParsedObjectID parsedStringifiedObjectID(String id, String expectedProtocol) throws InvalidIDException {
        if (expectedProtocol == null) {
            return new ParsedObjectID("", id);
        }
        if (id.startsWith(expectedProtocol)) {
            return new ParsedObjectID(expectedProtocol, id.substring(expectedProtocol.length() + 1));
        }
        throw new InvalidIDException(CorePlugin.Util.getString("ParsedObjectID.The_stringified_ObjectID_does_not_have_the_required_protocol_{0}", new Object[]{expectedProtocol}));
    }
}

