/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.dqp.internal.process;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import javax.resource.spi.work.Work;
import javax.resource.spi.work.WorkEvent;
import javax.resource.spi.work.WorkListener;
import javax.transaction.xa.Xid;
import org.teiid.adminapi.Admin;
import org.teiid.adminapi.AdminException;
import org.teiid.adminapi.Request;
import org.teiid.adminapi.Transaction;
import org.teiid.adminapi.impl.CacheStatisticsMetadata;
import org.teiid.adminapi.impl.RequestMetadata;
import org.teiid.adminapi.impl.WorkerPoolStatisticsMetadata;
import org.teiid.cache.CacheConfiguration;
import org.teiid.cache.CacheFactory;
import org.teiid.client.DQP;
import org.teiid.client.RequestMessage;
import org.teiid.client.ResultsMessage;
import org.teiid.client.lob.LobChunk;
import org.teiid.client.metadata.MetadataResult;
import org.teiid.client.util.ResultsFuture;
import org.teiid.client.util.ResultsReceiver;
import org.teiid.client.xa.XATransactionException;
import org.teiid.client.xa.XidImpl;
import org.teiid.common.buffer.BufferManager;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.dqp.internal.process.CachedResults;
import org.teiid.dqp.internal.process.DQPConfiguration;
import org.teiid.dqp.internal.process.DQPWorkContext;
import org.teiid.dqp.internal.process.DataTierManagerImpl;
import org.teiid.dqp.internal.process.DataTierTupleSource;
import org.teiid.dqp.internal.process.MetaDataProcessor;
import org.teiid.dqp.internal.process.PreparedPlan;
import org.teiid.dqp.internal.process.PreparedStatementRequest;
import org.teiid.dqp.internal.process.Request;
import org.teiid.dqp.internal.process.RequestWorkItem;
import org.teiid.dqp.internal.process.SessionAwareCache;
import org.teiid.dqp.internal.process.ThreadReuseExecutor;
import org.teiid.dqp.message.AtomicRequestMessage;
import org.teiid.dqp.message.RequestID;
import org.teiid.dqp.service.BufferService;
import org.teiid.dqp.service.TransactionContext;
import org.teiid.dqp.service.TransactionService;
import org.teiid.logging.CommandLogMessage;
import org.teiid.logging.LogManager;
import org.teiid.query.QueryPlugin;
import org.teiid.query.processor.ProcessorDataManager;
import org.teiid.query.tempdata.TempTableDataManager;
import org.teiid.query.tempdata.TempTableStore;

public class DQPCore
implements DQP {
    private ThreadReuseExecutor processWorkerPool;
    private BufferManager bufferManager;
    private ProcessorDataManager dataTierMgr;
    private SessionAwareCache<PreparedPlan> prepPlanCache;
    private SessionAwareCache<CachedResults> rsCache;
    private TransactionService transactionService;
    private BufferService bufferService;
    private DQPConfiguration config = new DQPConfiguration();
    private int chunkSize = 102400;
    private Map<RequestID, RequestWorkItem> requests = new ConcurrentHashMap<RequestID, RequestWorkItem>();
    private Map<String, ClientState> clientState = new ConcurrentHashMap<String, ClientState>();
    private int maxActivePlans = 20;
    private int currentlyActivePlans;
    private LinkedList<RequestWorkItem> waitingPlans = new LinkedList();
    private CacheFactory cacheFactory;
    private SessionAwareCache<CachedResults> matTables;

    public void stop() {
        this.processWorkerPool.shutdownNow();
        try {
            this.processWorkerPool.awaitTermination(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        LogManager.logDetail((String)"org.teiid.PROCESSOR", (Object[])new Object[]{"Stopping the DQP"});
    }

    public List<RequestMetadata> getRequestsForSession(String sessionId) {
        ClientState state = this.getClientState(sessionId, false);
        if (state == null) {
            return Collections.emptyList();
        }
        return this.buildRequestInfos(state.getRequests(), -1);
    }

    public ClientState getClientState(String key, boolean create) {
        if (key == null) {
            return null;
        }
        ClientState state = this.clientState.get(key);
        if (state == null && create) {
            state = new ClientState(new TempTableStore(key));
            this.clientState.put(key, state);
        }
        return state;
    }

    public List<RequestMetadata> getRequests() {
        return this.buildRequestInfos(this.requests.keySet(), -1);
    }

    public List<RequestMetadata> getLongRunningRequests() {
        return this.buildRequestInfos(this.requests.keySet(), this.config.getQueryThresholdInSecs());
    }

    private List<RequestMetadata> buildRequestInfos(Collection<RequestID> ids, int longRunningQueryThreshold) {
        ArrayList<RequestMetadata> results = new ArrayList<RequestMetadata>();
        for (RequestID requestID : ids) {
            RequestWorkItem holder = this.requests.get(requestID);
            if (holder == null || holder.isCanceled()) continue;
            RequestMetadata req = new RequestMetadata();
            req.setExecutionId(holder.requestID.getExecutionID());
            req.setSessionId(holder.requestID.getConnectionID());
            req.setCommand(holder.requestMsg.getCommandString());
            req.setStartTime(holder.getProcessingTimestamp());
            req.setState(holder.isCanceled() ? Request.ProcessingState.CANCELED : (holder.isDoneProcessing() ? Request.ProcessingState.DONE : Request.ProcessingState.PROCESSING));
            switch (holder.getThreadState()) {
                case DONE: 
                case IDLE: {
                    req.setThreadState(Request.ThreadState.IDLE);
                    break;
                }
                default: {
                    if (holder.isProcessing()) {
                        req.setThreadState(Request.ThreadState.RUNNING);
                        break;
                    }
                    req.setThreadState(Request.ThreadState.QUEUED);
                }
            }
            if (holder.getTransactionContext() != null && holder.getTransactionContext().getTransactionType() != TransactionContext.Scope.NONE) {
                req.setTransactionId(holder.getTransactionContext().getTransactionId());
            }
            for (DataTierTupleSource conInfo : holder.getConnectorRequests()) {
                String connectorName = conInfo.getConnectorName();
                if (connectorName == null) continue;
                AtomicRequestMessage arm = conInfo.getAtomicRequestMessage();
                RequestMetadata info = new RequestMetadata();
                if (conInfo.isQueued()) {
                    info.setThreadState(Request.ThreadState.QUEUED);
                } else if (conInfo.isRunning()) {
                    info.setThreadState(Request.ThreadState.RUNNING);
                } else {
                    info.setThreadState(Request.ThreadState.IDLE);
                }
                info.setExecutionId(arm.getRequestID().getExecutionID());
                info.setSessionId(holder.requestID.getConnectionID());
                info.setCommand(arm.getCommand().toString());
                info.setStartTime(arm.getProcessingTimestamp());
                info.setSourceRequest(true);
                info.setNodeId(Integer.valueOf(arm.getAtomicRequestID().getNodeID()));
                info.setState(conInfo.isCanceled() ? Request.ProcessingState.CANCELED : (conInfo.isDone() ? Request.ProcessingState.DONE : Request.ProcessingState.PROCESSING));
                results.add(info);
            }
            long elapsedTime = System.currentTimeMillis() - req.getStartTime();
            if (longRunningQueryThreshold != -1 && elapsedTime <= (long)longRunningQueryThreshold) continue;
            results.add(req);
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultsFuture<ResultsMessage> executeRequest(long reqID, RequestMessage requestMsg) {
        DQPWorkContext workContext = DQPWorkContext.getWorkContext();
        RequestID requestID = workContext.getRequestID(reqID);
        requestMsg.setFetchSize(Math.min(requestMsg.getFetchSize(), this.config.getMaxRowsFetchSize()));
        Request request = null;
        request = requestMsg.isPreparedStatement() || requestMsg.isCallableStatement() ? new PreparedStatementRequest(this.prepPlanCache) : new Request();
        ClientState state = this.getClientState(workContext.getSessionId(), true);
        request.initialize(requestMsg, this.bufferManager, this.dataTierMgr, this.transactionService, state.sessionTables, workContext, this.config.getUseDataRoles(), this.prepPlanCache);
        request.setResultSetCacheEnabled(this.rsCache != null);
        request.setAllowCreateTemporaryTablesByDefault(this.config.isAllowCreateTemporaryTablesByDefault());
        ResultsFuture resultsFuture = new ResultsFuture();
        RequestWorkItem workItem = new RequestWorkItem(this, requestMsg, request, (ResultsReceiver<ResultsMessage>)resultsFuture.getResultsReceiver(), requestID, workContext);
        this.logMMCommand(workItem, CommandLogMessage.Event.NEW, null);
        this.addRequest(requestID, workItem, state);
        LinkedList<RequestWorkItem> linkedList = this.waitingPlans;
        synchronized (linkedList) {
            if (this.currentlyActivePlans < this.maxActivePlans) {
                this.startActivePlan(workItem);
            } else {
                if (LogManager.isMessageToBeRecorded((String)"org.teiid.PROCESSOR", (int)5)) {
                    LogManager.logDetail((String)"org.teiid.PROCESSOR", (Object[])new Object[]{"Queuing plan, since max plans has been reached."});
                }
                this.waitingPlans.add(workItem);
            }
        }
        return resultsFuture;
    }

    public ResultsFuture<ResultsMessage> processCursorRequest(long reqID, int batchFirst, int fetchSize) throws TeiidProcessingException {
        if (LogManager.isMessageToBeRecorded((String)"org.teiid.PROCESSOR", (int)5)) {
            LogManager.logDetail((String)"org.teiid.PROCESSOR", (Object[])new Object[]{"DQP process cursor request from " + batchFirst});
        }
        DQPWorkContext workContext = DQPWorkContext.getWorkContext();
        ResultsFuture resultsFuture = new ResultsFuture();
        RequestWorkItem workItem = this.getRequestWorkItem(workContext.getRequestID(reqID));
        workItem.requestMore(batchFirst, batchFirst + Math.min(fetchSize, this.config.getMaxRowsFetchSize()) - 1, (ResultsReceiver<ResultsMessage>)resultsFuture.getResultsReceiver());
        return resultsFuture;
    }

    void addRequest(RequestID requestID, RequestWorkItem workItem, ClientState state) {
        this.requests.put(requestID, workItem);
        state.addRequest(requestID);
    }

    private void startActivePlan(RequestWorkItem workItem) {
        workItem.active = true;
        this.addWork(workItem);
        ++this.currentlyActivePlans;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void finishProcessing(RequestWorkItem workItem) {
        LinkedList<RequestWorkItem> linkedList = this.waitingPlans;
        synchronized (linkedList) {
            if (!workItem.active) {
                return;
            }
            workItem.active = false;
            --this.currentlyActivePlans;
            if (!this.waitingPlans.isEmpty()) {
                this.startActivePlan(this.waitingPlans.remove());
            }
        }
    }

    void removeRequest(RequestWorkItem workItem) {
        this.finishProcessing(workItem);
        this.requests.remove(workItem.requestID);
        ClientState state = this.getClientState(workItem.getDqpWorkContext().getSessionId(), false);
        if (state != null) {
            state.removeRequest(workItem.requestID);
        }
    }

    void addWork(Runnable work) {
        this.processWorkerPool.execute(work);
    }

    void scheduleWork(final Runnable r, int priority, long delay) {
        this.processWorkerPool.schedule(new FutureWork<Void>(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                r.run();
                return null;
            }
        }, priority), delay, TimeUnit.MILLISECONDS);
    }

    public ResultsFuture<?> closeLobChunkStream(int lobRequestId, long requestId, String streamId) throws TeiidProcessingException {
        DQPWorkContext workContext;
        RequestWorkItem workItem;
        if (LogManager.isMessageToBeRecorded((String)"org.teiid.PROCESSOR", (int)5)) {
            LogManager.logDetail((String)"org.teiid.PROCESSOR", (Object[])new Object[]{"Request to close the Lob stream with Stream id=" + streamId + " instance id=" + lobRequestId});
        }
        if ((workItem = this.safeGetWorkItem((workContext = DQPWorkContext.getWorkContext()).getRequestID(requestId))) != null) {
            workItem.removeLobStream(lobRequestId);
        }
        return ResultsFuture.NULL_FUTURE;
    }

    public ResultsFuture<LobChunk> requestNextLobChunk(int lobRequestId, long requestId, String streamId) throws TeiidProcessingException {
        if (LogManager.isMessageToBeRecorded((String)"org.teiid.PROCESSOR", (int)5)) {
            LogManager.logDetail((String)"org.teiid.PROCESSOR", (Object[])new Object[]{"Request for next Lob chunk with Stream id=" + streamId + " instance id=" + lobRequestId});
        }
        RequestWorkItem workItem = this.getRequestWorkItem(DQPWorkContext.getWorkContext().getRequestID(requestId));
        ResultsFuture resultsFuture = new ResultsFuture();
        workItem.processLobChunkRequest(streamId, lobRequestId, (ResultsReceiver<LobChunk>)resultsFuture.getResultsReceiver());
        return resultsFuture;
    }

    RequestWorkItem getRequestWorkItem(RequestID reqID) throws TeiidProcessingException {
        RequestWorkItem result = this.requests.get(reqID);
        if (result == null) {
            throw new TeiidProcessingException(QueryPlugin.Util.getString("DQPCore.The_request_has_been_closed.", new Object[]{reqID}));
        }
        return result;
    }

    RequestWorkItem safeGetWorkItem(Object processorID) {
        return this.requests.get(processorID);
    }

    public WorkerPoolStatisticsMetadata getWorkerPoolStatistics() {
        return this.processWorkerPool.getStats();
    }

    public void terminateSession(String sessionId) {
        ClientState state = this.clientState.remove(sessionId);
        if (state != null) {
            for (RequestID reqId : state.getRequests()) {
                try {
                    this.cancelRequest(reqId);
                }
                catch (TeiidComponentException err) {
                    LogManager.logWarning((String)"org.teiid.PROCESSOR", (Throwable)err, (String)("Failed to cancel " + reqId));
                }
            }
        }
        try {
            this.transactionService.cancelTransactions(sessionId, false);
        }
        catch (XATransactionException err) {
            LogManager.logWarning((String)"org.teiid.PROCESSOR", (String)("rollback failed for requestID=" + sessionId));
        }
    }

    public boolean cancelRequest(String sessionId, long executionId) throws TeiidComponentException {
        RequestID requestID = new RequestID(sessionId, executionId);
        return this.cancelRequest(requestID);
    }

    private boolean cancelRequest(RequestID requestID) throws TeiidComponentException {
        if (LogManager.isMessageToBeRecorded((String)"org.teiid.PROCESSOR", (int)5)) {
            LogManager.logDetail((String)"org.teiid.PROCESSOR", (Object[])new Object[]{"cancelQuery for requestID=" + requestID});
        }
        boolean markCancelled = false;
        RequestWorkItem workItem = this.safeGetWorkItem(requestID);
        if (workItem != null) {
            markCancelled = workItem.requestCancel();
        }
        if (markCancelled) {
            this.logMMCommand(workItem, CommandLogMessage.Event.CANCEL, null);
        } else {
            LogManager.logDetail((String)"org.teiid.PROCESSOR", (Object[])new Object[]{QueryPlugin.Util.getString("DQPCore.failed_to_cancel")});
        }
        return markCancelled;
    }

    public ResultsFuture<?> closeRequest(long requestId) throws TeiidProcessingException, TeiidComponentException {
        DQPWorkContext workContext = DQPWorkContext.getWorkContext();
        this.closeRequest(workContext.getRequestID(requestId));
        return ResultsFuture.NULL_FUTURE;
    }

    void closeRequest(RequestID requestID) throws TeiidComponentException {
        RequestWorkItem workItem;
        if (LogManager.isMessageToBeRecorded((String)"org.teiid.PROCESSOR", (int)5)) {
            LogManager.logDetail((String)"org.teiid.PROCESSOR", (Object[])new Object[]{"closeQuery for requestID=" + requestID});
        }
        if ((workItem = this.safeGetWorkItem(requestID)) != null) {
            workItem.requestClose();
        } else {
            LogManager.logDetail((String)"org.teiid.PROCESSOR", (Object[])new Object[]{requestID + " close call ignored as the request has already been removed."});
        }
    }

    private void clearPlanCache() {
        LogManager.logInfo((String)"org.teiid.PROCESSOR", (String)QueryPlugin.Util.getString("DQPCore.Clearing_prepared_plan_cache"));
        this.prepPlanCache.clearAll();
    }

    private void clearResultSetCache() {
        if (this.rsCache != null) {
            this.rsCache.clearAll();
        }
    }

    private void clearPlanCache(String vdbName, int version) {
        LogManager.logInfo((String)"org.teiid.PROCESSOR", (String)QueryPlugin.Util.getString("DQPCore.Clearing_prepared_plan_cache"));
        this.prepPlanCache.clearForVDB(vdbName, version);
    }

    private void clearResultSetCache(String vdbName, int version) {
        if (this.rsCache != null) {
            LogManager.logInfo((String)"org.teiid.PROCESSOR", (String)QueryPlugin.Util.getString("DQPCore.clearing_resultset_cache", new Object[]{vdbName, version}));
            this.rsCache.clearForVDB(vdbName, version);
        }
    }

    public CacheStatisticsMetadata getCacheStatistics(String cacheType) {
        if (cacheType.equalsIgnoreCase(Admin.Cache.PREPARED_PLAN_CACHE.toString())) {
            return this.buildCacheStats(Admin.Cache.PREPARED_PLAN_CACHE.toString(), this.prepPlanCache);
        }
        if (cacheType.equalsIgnoreCase(Admin.Cache.QUERY_SERVICE_RESULT_SET_CACHE.toString())) {
            return this.buildCacheStats(Admin.Cache.QUERY_SERVICE_RESULT_SET_CACHE.toString(), this.rsCache);
        }
        return null;
    }

    private CacheStatisticsMetadata buildCacheStats(String name, SessionAwareCache cache) {
        CacheStatisticsMetadata stats = new CacheStatisticsMetadata();
        stats.setName(name);
        stats.setHitRatio(cache.getRequestCount() == 0 ? 0.0 : (double)cache.getCacheHitCount() / (double)cache.getRequestCount() * 100.0);
        stats.setTotalEntries(cache.getTotalCacheEntries());
        stats.setRequestCount(cache.getRequestCount());
        return stats;
    }

    public Collection<String> getCacheTypes() {
        ArrayList<String> caches = new ArrayList<String>();
        caches.add(Admin.Cache.PREPARED_PLAN_CACHE.toString());
        caches.add(Admin.Cache.QUERY_SERVICE_RESULT_SET_CACHE.toString());
        return caches;
    }

    public void clearCache(String cacheType) {
        Admin.Cache cache = Admin.Cache.valueOf((String)cacheType);
        switch (cache) {
            case PREPARED_PLAN_CACHE: {
                this.clearPlanCache();
                break;
            }
            case QUERY_SERVICE_RESULT_SET_CACHE: {
                this.clearResultSetCache();
            }
        }
    }

    public void clearCache(String cacheType, String vdbName, int version) {
        Admin.Cache cache = Admin.Cache.valueOf((String)cacheType);
        switch (cache) {
            case PREPARED_PLAN_CACHE: {
                this.clearPlanCache(vdbName, version);
                break;
            }
            case QUERY_SERVICE_RESULT_SET_CACHE: {
                this.clearResultSetCache(vdbName, version);
            }
        }
        if (this.matTables != null) {
            this.matTables.clearForVDB(vdbName, version);
        }
    }

    public Collection<Transaction> getTransactions() {
        return this.transactionService.getTransactions();
    }

    public void terminateTransaction(String xid) throws AdminException {
        this.transactionService.terminateTransaction(xid);
    }

    void logMMCommand(RequestWorkItem workItem, CommandLogMessage.Event status, Integer rowCount) {
        if (!LogManager.isMessageToBeRecorded((String)"org.teiid.COMMAND_LOG", (int)5)) {
            return;
        }
        RequestMessage msg = workItem.requestMsg;
        DQPWorkContext workContext = DQPWorkContext.getWorkContext();
        RequestID rID = new RequestID(workContext.getSessionId(), msg.getExecutionId());
        String txnID = null;
        TransactionContext tc = workItem.getTransactionContext();
        if (tc != null && tc.getTransactionType() != TransactionContext.Scope.NONE) {
            txnID = tc.getTransactionId();
        }
        String appName = workContext.getAppName();
        CommandLogMessage message = null;
        message = status == CommandLogMessage.Event.NEW ? new CommandLogMessage(System.currentTimeMillis(), rID.toString(), txnID, workContext.getSessionId(), appName, workContext.getUserName(), workContext.getVdbName(), workContext.getVdbVersion(), msg.getCommandString()) : new CommandLogMessage(System.currentTimeMillis(), rID.toString(), txnID, workContext.getSessionId(), workContext.getUserName(), workContext.getVdbName(), workContext.getVdbVersion(), rowCount, status);
        LogManager.log((int)5, (String)"org.teiid.COMMAND_LOG", (Object)message);
    }

    ProcessorDataManager getDataTierManager() {
        return this.dataTierMgr;
    }

    public BufferManager getBufferManager() {
        return this.bufferManager;
    }

    public TransactionService getTransactionService() {
        return this.transactionService;
    }

    SessionAwareCache<CachedResults> getRsCache() {
        return this.rsCache;
    }

    int getProcessorTimeSlice() {
        return this.config.getTimeSliceInMilli();
    }

    int getChunkSize() {
        return this.chunkSize;
    }

    public void start(DQPConfiguration config) {
        this.config = config;
        this.chunkSize = config.getLobChunkSizeInKB() * 1024;
        this.bufferManager = this.bufferService.getBufferManager();
        CacheConfiguration rsCacheConfig = config.getResultsetCacheConfig();
        if (rsCacheConfig != null && rsCacheConfig.isEnabled()) {
            this.rsCache = new SessionAwareCache(this.cacheFactory, SessionAwareCache.Type.RESULTSET, rsCacheConfig);
            this.rsCache.setBufferManager(this.bufferManager);
        }
        this.prepPlanCache = new SessionAwareCache(this.cacheFactory, SessionAwareCache.Type.PREPAREDPLAN, new CacheConfiguration(CacheConfiguration.Policy.LRU, 28800, config.getPreparedPlanCacheMaxCount(), "PreparedCache"));
        this.prepPlanCache.setBufferManager(this.bufferManager);
        this.processWorkerPool = new ThreadReuseExecutor("QueryProcessorQueue", config.getMaxThreads());
        if (this.cacheFactory.isReplicated()) {
            this.matTables = new SessionAwareCache(this.cacheFactory, SessionAwareCache.Type.RESULTSET, new CacheConfiguration(CacheConfiguration.Policy.LRU, -1, -1, "MaterilizationTables"));
            this.matTables.setBufferManager(this.bufferManager);
        }
        this.dataTierMgr = new TempTableDataManager(new DataTierManagerImpl(this, this.bufferService), this.bufferManager, this.processWorkerPool, this.rsCache, this.matTables, this.cacheFactory);
    }

    public void setBufferService(BufferService service) {
        this.bufferService = service;
    }

    public void setTransactionService(TransactionService service) {
        this.transactionService = service;
    }

    public boolean cancelRequest(long requestID) throws TeiidProcessingException, TeiidComponentException {
        DQPWorkContext workContext = DQPWorkContext.getWorkContext();
        return this.cancelRequest(workContext.getRequestID(requestID));
    }

    public ResultsFuture<?> begin() throws XATransactionException {
        String threadId = DQPWorkContext.getWorkContext().getSessionId();
        this.getTransactionService().begin(threadId);
        return ResultsFuture.NULL_FUTURE;
    }

    public ResultsFuture<?> commit() throws XATransactionException {
        final String threadId = DQPWorkContext.getWorkContext().getSessionId();
        Callable<Void> processor = new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                DQPCore.this.getTransactionService().commit(threadId);
                return null;
            }
        };
        return this.addWork(processor, 0);
    }

    public ResultsFuture<?> rollback() throws XATransactionException {
        final String threadId = DQPWorkContext.getWorkContext().getSessionId();
        Callable<Void> processor = new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                DQPCore.this.getTransactionService().rollback(threadId);
                return null;
            }
        };
        return this.addWork(processor, 0);
    }

    public ResultsFuture<?> commit(final XidImpl xid, final boolean onePhase) throws XATransactionException {
        Callable<Void> processor = new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                DQPWorkContext workContext = DQPWorkContext.getWorkContext();
                DQPCore.this.getTransactionService().commit(workContext.getSessionId(), xid, onePhase, workContext.getSession().isEmbedded());
                return null;
            }
        };
        return this.addWork(processor, 0);
    }

    public ResultsFuture<?> end(XidImpl xid, int flags) throws XATransactionException {
        DQPWorkContext workContext = DQPWorkContext.getWorkContext();
        this.getTransactionService().end(workContext.getSessionId(), xid, flags, workContext.getSession().isEmbedded());
        return ResultsFuture.NULL_FUTURE;
    }

    public ResultsFuture<?> forget(XidImpl xid) throws XATransactionException {
        DQPWorkContext workContext = DQPWorkContext.getWorkContext();
        this.getTransactionService().forget(workContext.getSessionId(), xid, workContext.getSession().isEmbedded());
        return ResultsFuture.NULL_FUTURE;
    }

    public ResultsFuture<Integer> prepare(final XidImpl xid) throws XATransactionException {
        Callable<Integer> processor = new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                DQPWorkContext workContext = DQPWorkContext.getWorkContext();
                return DQPCore.this.getTransactionService().prepare(workContext.getSessionId(), xid, workContext.getSession().isEmbedded());
            }
        };
        return this.addWork(processor, 10);
    }

    <T> ResultsFuture<T> addWork(Callable<T> processor, int priority) {
        FutureWork<T> work = new FutureWork<T>(processor, priority);
        this.addWork(work);
        return work.getResult();
    }

    public ResultsFuture<Xid[]> recover(int flag) throws XATransactionException {
        ResultsFuture result = new ResultsFuture();
        DQPWorkContext workContext = DQPWorkContext.getWorkContext();
        result.getResultsReceiver().receiveResults((Object)this.getTransactionService().recover(flag, workContext.getSession().isEmbedded()));
        return result;
    }

    public ResultsFuture<?> rollback(final XidImpl xid) throws XATransactionException {
        Callable<Void> processor = new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                DQPWorkContext workContext = DQPWorkContext.getWorkContext();
                DQPCore.this.getTransactionService().rollback(workContext.getSessionId(), xid, workContext.getSession().isEmbedded());
                return null;
            }
        };
        return this.addWork(processor, 0);
    }

    public ResultsFuture<?> start(final XidImpl xid, final int flags, final int timeout) throws XATransactionException {
        Callable<Void> processor = new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                DQPWorkContext workContext = DQPWorkContext.getWorkContext();
                DQPCore.this.getTransactionService().start(workContext.getSessionId(), xid, flags, timeout, workContext.getSession().isEmbedded());
                return null;
            }
        };
        return this.addWork(processor, 100);
    }

    public MetadataResult getMetadata(long requestID) throws TeiidComponentException, TeiidProcessingException {
        DQPWorkContext workContext = DQPWorkContext.getWorkContext();
        MetaDataProcessor processor = new MetaDataProcessor(this, this.prepPlanCache, workContext.getVdbName(), workContext.getVdbVersion());
        return processor.processMessage(workContext.getRequestID(requestID), workContext, null, true);
    }

    public MetadataResult getMetadata(long requestID, String preparedSql, boolean allowDoubleQuotedVariable) throws TeiidComponentException, TeiidProcessingException {
        DQPWorkContext workContext = DQPWorkContext.getWorkContext();
        MetaDataProcessor processor = new MetaDataProcessor(this, this.prepPlanCache, workContext.getVdbName(), workContext.getVdbVersion());
        return processor.processMessage(workContext.getRequestID(requestID), workContext, preparedSql, allowDoubleQuotedVariable);
    }

    public boolean isExceptionOnMaxSourceRows() {
        return this.config.isExceptionOnMaxSourceRows();
    }

    public int getMaxSourceRows() {
        return this.config.getMaxSourceRows();
    }

    public void setCacheFactory(CacheFactory factory) {
        this.cacheFactory = factory;
    }

    static class ClientState {
        List<RequestID> requests;
        TempTableStore sessionTables;

        public ClientState(TempTableStore tableStoreImpl) {
            this.sessionTables = tableStoreImpl;
        }

        public synchronized void addRequest(RequestID requestID) {
            if (this.requests == null) {
                this.requests = new LinkedList<RequestID>();
            }
            this.requests.add(requestID);
        }

        public synchronized List<RequestID> getRequests() {
            if (this.requests == null) {
                return Collections.emptyList();
            }
            return new ArrayList<RequestID>(this.requests);
        }

        public synchronized void removeRequest(RequestID requestID) {
            if (this.requests != null) {
                this.requests.remove(requestID);
            }
        }
    }

    public static final class FutureWork<T>
    implements Work,
    WorkListener,
    ThreadReuseExecutor.PrioritizedRunnable {
        private final Callable<T> toCall;
        private ResultsFuture<T> result = new ResultsFuture();
        private ResultsReceiver<T> receiver = this.result.getResultsReceiver();
        private int priority;
        private long creationTime = System.currentTimeMillis();
        private DQPWorkContext workContext = DQPWorkContext.getWorkContext();

        public FutureWork(Callable<T> processor, int priority) {
            this.toCall = processor;
            this.priority = priority;
        }

        public ResultsFuture<T> getResult() {
            return this.result;
        }

        @Override
        public void run() {
            try {
                this.receiver.receiveResults(this.toCall.call());
            }
            catch (Throwable t) {
                this.receiver.exceptionOccurred(t);
            }
        }

        public void release() {
        }

        public void workAccepted(WorkEvent arg0) {
        }

        public void workCompleted(WorkEvent arg0) {
        }

        public void workRejected(WorkEvent arg0) {
            this.receiver.exceptionOccurred((Throwable)arg0.getException());
        }

        public void workStarted(WorkEvent arg0) {
        }

        @Override
        public int getPriority() {
            return this.priority;
        }

        @Override
        public long getCreationTime() {
            return this.creationTime;
        }

        @Override
        public DQPWorkContext getDqpWorkContext() {
            return this.workContext;
        }
    }
}

