/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.dqp.internal.process;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.SQLXML;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import javax.activation.DataSource;
import javax.xml.transform.Source;
import org.teiid.client.SourceWarning;
import org.teiid.client.util.ResultsFuture;
import org.teiid.common.buffer.BlockedException;
import org.teiid.common.buffer.FileStore;
import org.teiid.common.buffer.TupleSource;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.core.TeiidRuntimeException;
import org.teiid.core.types.BlobImpl;
import org.teiid.core.types.BlobType;
import org.teiid.core.types.DataTypeManager;
import org.teiid.core.types.InputStreamFactory;
import org.teiid.core.types.SQLXMLImpl;
import org.teiid.core.types.StandardXMLTranslator;
import org.teiid.core.types.TransformationException;
import org.teiid.core.types.XMLTranslator;
import org.teiid.core.types.XMLType;
import org.teiid.core.util.Assertion;
import org.teiid.core.util.ObjectConverterUtil;
import org.teiid.dqp.internal.datamgr.ConnectorWork;
import org.teiid.dqp.internal.process.DataTierManagerImpl;
import org.teiid.dqp.internal.process.RequestWorkItem;
import org.teiid.dqp.message.AtomicRequestMessage;
import org.teiid.dqp.message.AtomicResultsMessage;
import org.teiid.query.processor.xml.XMLUtil;
import org.teiid.query.sql.symbol.SingleElementSymbol;
import org.teiid.translator.DataNotAvailableException;
import org.teiid.translator.TranslatorException;

public class DataTierTupleSource
implements TupleSource {
    private final AtomicRequestMessage aqr;
    private final RequestWorkItem workItem;
    private final ConnectorWork cwi;
    private final DataTierManagerImpl dtm;
    private boolean[] convertToRuntimeType;
    private boolean[] convertToDesiredRuntimeType;
    private Class<?>[] schema;
    private int index;
    private int rowsProcessed;
    private AtomicResultsMessage arm;
    private boolean closed;
    private volatile boolean canceled;
    private boolean executed;
    private volatile boolean done;
    private boolean explicitClose;
    private volatile ResultsFuture<AtomicResultsMessage> futureResult;
    private volatile boolean running;

    public DataTierTupleSource(AtomicRequestMessage aqr, RequestWorkItem workItem, ConnectorWork cwi, DataTierManagerImpl dtm) {
        this.aqr = aqr;
        this.workItem = workItem;
        this.cwi = cwi;
        this.dtm = dtm;
        List<SingleElementSymbol> symbols = this.aqr.getCommand().getProjectedSymbols();
        this.schema = new Class[symbols.size()];
        this.convertToDesiredRuntimeType = new boolean[symbols.size()];
        this.convertToRuntimeType = new boolean[symbols.size()];
        for (int i = 0; i < symbols.size(); ++i) {
            SingleElementSymbol symbol = symbols.get(i);
            this.schema[i] = symbol.getType();
            this.convertToDesiredRuntimeType[i] = true;
            this.convertToRuntimeType[i] = true;
        }
        Assertion.isNull((Object)workItem.getConnectorRequest(aqr.getAtomicRequestID()));
        workItem.addConnectorRequest(aqr.getAtomicRequestID(), this);
        if (!aqr.isTransactional()) {
            this.addWork();
        }
    }

    private void addWork() {
        this.futureResult = this.dtm.addWork(new Callable<AtomicResultsMessage>(){

            @Override
            public AtomicResultsMessage call() throws Exception {
                return DataTierTupleSource.this.getResults();
            }
        }, 100);
        this.futureResult.addCompletionListener((ResultsFuture.CompletionListener)new ResultsFuture.CompletionListener<AtomicResultsMessage>(){

            public void onCompletion(ResultsFuture<AtomicResultsMessage> future) {
                DataTierTupleSource.this.workItem.moreWork();
            }
        });
    }

    private List correctTypes(List row) throws TransformationException {
        for (int i = 0; i < row.size(); ++i) {
            Object value = row.get(i);
            if (value == null) continue;
            if (this.convertToRuntimeType[i]) {
                boolean lob = !this.arm.supportsCloseWithLobs() && DataTypeManager.isLOB(value.getClass());
                Object result = this.convertToRuntimeType(value, this.schema[i]);
                if (value == result && !DataTypeManager.DefaultDataClasses.OBJECT.equals(this.schema[i])) {
                    this.convertToRuntimeType[i] = false;
                } else {
                    if (lob && DataTypeManager.isLOB(result.getClass()) && DataTypeManager.isLOB(this.schema[i])) {
                        this.explicitClose = true;
                    }
                    row.set(i, result);
                    value = result;
                }
            }
            if (this.convertToDesiredRuntimeType[i]) {
                if (value == null) continue;
                Object result = DataTypeManager.transformValue(value, value.getClass(), this.schema[i]);
                if (value == result) {
                    this.convertToDesiredRuntimeType[i] = false;
                    continue;
                }
                row.set(i, result);
                continue;
            }
            row.set(i, DataTypeManager.getCanonicalValue(value));
        }
        return row;
    }

    private Object convertToRuntimeType(Object value, Class<?> desiredType) throws TransformationException {
        if (value instanceof DataSource && (!(value instanceof Source) || desiredType != DataTypeManager.DefaultDataClasses.XML)) {
            if (value instanceof InputStreamFactory) {
                return new BlobType((Blob)new BlobImpl((InputStreamFactory)value));
            }
            FileStore fs = this.dtm.getBufferManager().createFileStore("bytes");
            XMLUtil.FileStoreInputStreamFactory fsisf = new XMLUtil.FileStoreInputStreamFactory(fs, "UTF-8");
            try {
                ObjectConverterUtil.write((OutputStream)fsisf.getOuputStream(), (InputStream)((DataSource)value).getInputStream(), (int)-1);
            }
            catch (IOException e) {
                throw new TransformationException((Exception)e, e.getMessage());
            }
            return new BlobType((Blob)new BlobImpl((InputStreamFactory)fsisf));
        }
        if (value instanceof Source) {
            SQLXMLImpl sqlxml;
            if (value instanceof InputStreamFactory) {
                return new XMLType((SQLXML)new SQLXMLImpl((InputStreamFactory)value));
            }
            StandardXMLTranslator sxt = new StandardXMLTranslator((Source)value);
            try {
                sqlxml = XMLUtil.saveToBufferManager(this.dtm.getBufferManager(), (XMLTranslator)sxt);
            }
            catch (TeiidComponentException e) {
                throw new TeiidRuntimeException((Throwable)e);
            }
            catch (TeiidProcessingException e) {
                throw new TeiidRuntimeException((Throwable)e);
            }
            return new XMLType((SQLXML)sqlxml);
        }
        return DataTypeManager.convertToRuntimeType((Object)value);
    }

    @Override
    public List<?> nextTuple() throws TeiidComponentException, TeiidProcessingException {
        do {
            if (this.arm == null) {
                AtomicResultsMessage results = null;
                try {
                    results = this.futureResult != null || !this.aqr.isTransactional() ? this.asynchGet() : this.getResults();
                }
                catch (TranslatorException e) {
                    results = this.exceptionOccurred(e, true);
                }
                catch (DataNotAvailableException e) {
                    this.dtm.scheduleWork(new Runnable(){

                        @Override
                        public void run() {
                            DataTierTupleSource.this.workItem.moreWork();
                        }
                    }, 10, e.getRetryDelay());
                    throw BlockedException.INSTANCE;
                }
                this.receiveResults(results);
            }
            if (this.index < this.arm.getResults().length) {
                return this.correctTypes(this.arm.getResults()[this.index++]);
            }
            this.arm = null;
        } while (!this.isDone());
        return null;
    }

    private AtomicResultsMessage asynchGet() throws BlockedException, TeiidProcessingException, TeiidComponentException, TranslatorException {
        if (this.futureResult == null) {
            this.addWork();
        }
        if (!this.futureResult.isDone()) {
            throw BlockedException.INSTANCE;
        }
        ResultsFuture<AtomicResultsMessage> currentResults = this.futureResult;
        this.futureResult = null;
        AtomicResultsMessage results = null;
        try {
            results = (AtomicResultsMessage)currentResults.get();
            if (results.getFinalRow() < 0) {
                this.addWork();
            }
        }
        catch (InterruptedException e) {
            throw new TeiidRuntimeException((Throwable)e);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof TeiidProcessingException) {
                throw (TeiidProcessingException)e.getCause();
            }
            if (e.getCause() instanceof TeiidComponentException) {
                throw (TeiidComponentException)e.getCause();
            }
            if (e.getCause() instanceof TranslatorException) {
                throw (TranslatorException)e.getCause();
            }
            if (e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            throw new RuntimeException(e);
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AtomicResultsMessage getResults() throws BlockedException, TeiidComponentException, TranslatorException {
        AtomicResultsMessage results = null;
        try {
            this.running = true;
            if (!this.executed) {
                results = this.cwi.execute();
                this.executed = true;
            } else {
                results = this.cwi.more();
            }
        }
        finally {
            this.running = false;
        }
        return results;
    }

    public boolean isQueued() {
        ResultsFuture<AtomicResultsMessage> future = this.futureResult;
        return !this.running && future != null && !future.isDone();
    }

    public boolean isDone() {
        return this.done;
    }

    public boolean isRunning() {
        return this.running;
    }

    public void fullyCloseSource() {
        if (!this.closed) {
            if (this.cwi != null) {
                this.workItem.closeAtomicRequest(this.aqr.getAtomicRequestID());
                if (!this.aqr.isTransactional()) {
                    if (this.futureResult != null && !this.futureResult.isDone()) {
                        this.futureResult.addCompletionListener((ResultsFuture.CompletionListener)new ResultsFuture.CompletionListener<AtomicResultsMessage>(){

                            public void onCompletion(ResultsFuture<AtomicResultsMessage> future) {
                                DataTierTupleSource.this.cwi.close();
                            }
                        });
                    } else {
                        this.dtm.addWork(new Callable<Void>(){

                            @Override
                            public Void call() throws Exception {
                                DataTierTupleSource.this.cwi.close();
                                return null;
                            }
                        }, 0);
                    }
                } else {
                    this.cwi.close();
                }
            }
            this.closed = true;
        }
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public void cancelRequest() {
        this.canceled = true;
        if (this.cwi != null) {
            this.cwi.cancel();
        }
    }

    @Override
    public void closeSource() {
        if (!this.explicitClose) {
            this.fullyCloseSource();
        }
    }

    AtomicResultsMessage exceptionOccurred(TranslatorException exception, boolean removeState) throws TeiidComponentException, TeiidProcessingException {
        if (removeState) {
            this.fullyCloseSource();
        }
        if (this.workItem.requestMsg.supportsPartialResults()) {
            AtomicResultsMessage emptyResults = new AtomicResultsMessage(new List[0], null);
            emptyResults.setWarnings(Arrays.asList(new Exception[]{exception}));
            emptyResults.setFinalRow(this.rowsProcessed);
            return emptyResults;
        }
        if (exception.getCause() instanceof TeiidComponentException) {
            throw (TeiidComponentException)exception.getCause();
        }
        if (exception.getCause() instanceof TeiidProcessingException) {
            throw (TeiidProcessingException)exception.getCause();
        }
        throw new TeiidProcessingException((Throwable)exception);
    }

    void receiveResults(AtomicResultsMessage response) {
        this.arm = response;
        this.explicitClose |= !this.arm.supportsImplicitClose();
        this.rowsProcessed += response.getResults().length;
        this.index = 0;
        if (response.getWarnings() != null) {
            for (Exception warning : response.getWarnings()) {
                SourceWarning sourceFailure = new SourceWarning(this.aqr.getModelName(), this.aqr.getConnectorName(), (Throwable)warning, true);
                this.workItem.addSourceFailureDetails(sourceFailure);
            }
        }
        if (response.getFinalRow() >= 0) {
            this.done = true;
        }
    }

    public AtomicRequestMessage getAtomicRequestMessage() {
        return this.aqr;
    }

    public String getConnectorName() {
        return this.aqr.getConnectorName();
    }

    public boolean isTransactional() {
        return this.aqr.isTransactional();
    }
}

