/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.dqp.message;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class RequestID
implements Externalizable {
    static final long serialVersionUID = -2888539138291776071L;
    public static final String NO_CONNECTION_STR = "C";
    private static final String SEPARATOR = ".";
    private String connectionID;
    private long executionID;
    private String combinedID;
    private int hash;

    public RequestID() {
    }

    public RequestID(String connectionID, long executionID) {
        this.connectionID = connectionID;
        this.executionID = executionID;
        this.createCombinedID();
        this.computeHashCode();
    }

    public RequestID(long connectionID, long executionID) {
        this.connectionID = String.valueOf(connectionID);
        this.executionID = executionID;
        this.createCombinedID();
        this.computeHashCode();
    }

    public RequestID(long executionID) {
        this(null, executionID);
    }

    public String getConnectionID() {
        return this.connectionID;
    }

    public long getExecutionID() {
        return this.executionID;
    }

    private void createCombinedID() {
        StringBuffer combinedStr = new StringBuffer();
        if (this.connectionID != null) {
            combinedStr.append(this.connectionID);
        } else {
            combinedStr.append(NO_CONNECTION_STR);
        }
        combinedStr.append(SEPARATOR);
        combinedStr.append(this.executionID);
        this.combinedID = combinedStr.toString();
    }

    private void computeHashCode() {
        this.hash = this.combinedID.hashCode();
    }

    public int hashCode() {
        return this.hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof RequestID) || obj.hashCode() != this.hashCode()) {
            return false;
        }
        return this.toString().equals(obj.toString());
    }

    public String toString() {
        return this.combinedID;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.connectionID = (String)in.readObject();
        this.executionID = in.readLong();
        this.createCombinedID();
        this.computeHashCode();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.connectionID);
        out.writeLong(this.executionID);
    }
}

