/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.mapping.xml;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.teiid.query.processor.ProcessorPlan;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.lang.Criteria;
import org.teiid.query.sql.lang.OrderBy;
import org.teiid.query.sql.symbol.ElementSymbol;

public class ResultSetInfo {
    private String resultSetName;
    private Command rsCommand;
    private List boundReferences;
    private ProcessorPlan rsPlan;
    private int userRowLimit = -1;
    private boolean exceptionOnRowLimit = false;
    private OrderBy orderBy;
    private Criteria criteria;
    private Set criteriaResultSets = new HashSet();
    private boolean criteriaRaised = false;
    private boolean stagedResult = false;
    private boolean joinedWithParent = false;
    private boolean joinRoot = false;
    private int mappingClassNumber = 0;
    private ElementSymbol mappingClassSymbol;

    public ResultSetInfo(String resultName) {
        this(resultName, false);
    }

    public ResultSetInfo(String resultName, boolean staged) {
        this.resultSetName = resultName;
        this.stagedResult = staged;
    }

    public String getResultSetName() {
        return this.resultSetName;
    }

    public Command getCommand() {
        return this.rsCommand;
    }

    public void setCommand(Command cmd) {
        this.rsCommand = cmd;
    }

    public ProcessorPlan getPlan() {
        return this.rsPlan;
    }

    public void setPlan(ProcessorPlan plan) {
        this.rsPlan = plan;
    }

    public int getUserRowLimit() {
        return this.userRowLimit;
    }

    public void setUserRowLimit(int limit, boolean throwException) {
        this.userRowLimit = limit;
        this.exceptionOnRowLimit = throwException;
    }

    public boolean exceptionOnRowlimit() {
        return this.exceptionOnRowLimit;
    }

    public Criteria getCriteria() {
        return this.criteria;
    }

    public void setCriteria(Criteria criteria) {
        this.criteria = criteria;
    }

    public OrderBy getOrderBy() {
        return this.orderBy;
    }

    public void setOrderBy(OrderBy orderBy) {
        this.orderBy = orderBy;
    }

    public Set getCriteriaResultSets() {
        return this.criteriaResultSets;
    }

    public void addToCriteriaResultSets(Set criteriaResultSets) {
        this.criteriaResultSets.addAll(criteriaResultSets);
    }

    public boolean isCriteriaRaised() {
        return this.criteriaRaised;
    }

    public void setCriteriaRaised(boolean criteriaRaised) {
        this.criteriaRaised = criteriaRaised;
    }

    public Object clone() {
        ResultSetInfo clone = new ResultSetInfo(this.resultSetName, this.stagedResult);
        clone.rsPlan = this.rsPlan;
        clone.boundReferences = this.boundReferences;
        clone.userRowLimit = this.userRowLimit;
        clone.exceptionOnRowLimit = this.exceptionOnRowLimit;
        clone.rsCommand = (Command)this.rsCommand.clone();
        clone.criteriaRaised = this.criteriaRaised;
        clone.joinedWithParent = this.joinedWithParent;
        clone.joinRoot = this.joinRoot;
        clone.mappingClassNumber = this.mappingClassNumber;
        clone.mappingClassSymbol = this.mappingClassSymbol;
        return clone;
    }

    public String toString() {
        return this.resultSetName + ", resultSetObject " + this.rsCommand;
    }

    public boolean isJoinedWithParent() {
        return this.joinedWithParent;
    }

    public void setJoinedWithParent(boolean joinedWithParent) {
        this.joinedWithParent = joinedWithParent;
    }

    public boolean isJoinRoot() {
        return this.joinRoot;
    }

    public void setJoinRoot(boolean joinRoot) {
        this.joinRoot = joinRoot;
    }

    public int getMappingClassNumber() {
        return this.mappingClassNumber;
    }

    public void setMappingClassNumber(int mappingClassNumber) {
        this.mappingClassNumber = mappingClassNumber;
    }

    public ElementSymbol getMappingClassSymbol() {
        return this.mappingClassSymbol;
    }

    public void setMappingClassSymbol(ElementSymbol mappingClassSymbol) {
        this.mappingClassSymbol = mappingClassSymbol;
    }

    public boolean isStagedResult() {
        return this.stagedResult;
    }
}

