/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.optimizer;

import java.util.LinkedHashMap;
import java.util.Map;
import org.teiid.api.exception.query.QueryMetadataException;
import org.teiid.api.exception.query.QueryPlannerException;
import org.teiid.api.exception.query.QueryResolverException;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.core.TeiidRuntimeException;
import org.teiid.core.id.IDGenerator;
import org.teiid.core.id.IntegerIDFactory;
import org.teiid.dqp.internal.process.PreparedPlan;
import org.teiid.metadata.FunctionMethod;
import org.teiid.query.analysis.AnalysisRecord;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.metadata.TempCapabilitiesFinder;
import org.teiid.query.metadata.TempMetadataAdapter;
import org.teiid.query.metadata.TempMetadataStore;
import org.teiid.query.optimizer.BatchedUpdatePlanner;
import org.teiid.query.optimizer.CommandPlanner;
import org.teiid.query.optimizer.ProcedurePlanner;
import org.teiid.query.optimizer.capabilities.CapabilitiesFinder;
import org.teiid.query.optimizer.relational.RelationalPlanner;
import org.teiid.query.optimizer.xml.XMLPlanner;
import org.teiid.query.processor.ProcessorPlan;
import org.teiid.query.processor.proc.ProcedurePlan;
import org.teiid.query.resolver.QueryResolver;
import org.teiid.query.rewriter.QueryRewriter;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.lang.ProcedureContainer;
import org.teiid.query.sql.lang.Query;
import org.teiid.query.sql.lang.StoredProcedure;
import org.teiid.query.sql.lang.TranslatableProcedureContainer;
import org.teiid.query.sql.proc.CreateUpdateProcedureCommand;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.util.CommandContext;

public class QueryOptimizer {
    private static final CommandPlanner XML_PLANNER = new XMLPlanner();
    private static final CommandPlanner PROCEDURE_PLANNER = new ProcedurePlanner();
    private static final CommandPlanner BATCHED_UPDATE_PLANNER = new BatchedUpdatePlanner();

    private QueryOptimizer() {
    }

    public static ProcessorPlan optimizePlan(Command command, QueryMetadataInterface metadata, IDGenerator idGenerator, CapabilitiesFinder capFinder, AnalysisRecord analysisRecord, CommandContext context) throws QueryMetadataException, TeiidComponentException, QueryPlannerException {
        if (analysisRecord == null) {
            analysisRecord = new AnalysisRecord(false, false);
        }
        if (context == null) {
            context = new CommandContext();
        }
        if (!(capFinder instanceof TempCapabilitiesFinder)) {
            capFinder = new TempCapabilitiesFinder(capFinder);
        }
        boolean debug = analysisRecord.recordDebug();
        Map tempMetadata = command.getTemporaryMetadata();
        metadata = new TempMetadataAdapter(metadata, new TempMetadataStore(tempMetadata));
        if (idGenerator == null) {
            idGenerator = new IDGenerator();
            idGenerator.setDefaultFactory(new IntegerIDFactory());
        }
        if (debug) {
            analysisRecord.println("\n----------------------------------------------------------------------------");
            analysisRecord.println("OPTIMIZE: \n" + command);
        }
        ProcessorPlan result = null;
        if (command.getType() == 7) {
            CreateUpdateProcedureCommand cupc = (CreateUpdateProcedureCommand)command;
            if (cupc.isUpdateProcedure()) {
                result = QueryOptimizer.planProcedure(command, metadata, idGenerator, capFinder, analysisRecord, context);
            } else {
                String fullName = metadata.getFullName(cupc.getVirtualGroup().getMetadataID());
                PreparedPlan pp = context.getPlan(fullName);
                if (pp == null) {
                    FunctionMethod.Determinism determinismLevel = context.resetDeterminismLevel();
                    ProcessorPlan plan = QueryOptimizer.planProcedure(command, metadata, idGenerator, capFinder, analysisRecord, context);
                    pp = new PreparedPlan();
                    pp.setPlan(plan);
                    context.putPlan(fullName, pp, context.getDeterminismLevel());
                    context.setDeterminismLevel(determinismLevel);
                }
                result = pp.getPlan().clone();
            }
            ProcedureContainer container = (ProcedureContainer)cupc.getUserCommand();
            ProcedurePlan plan = (ProcedurePlan)result;
            if (container != null) {
                LinkedHashMap<ElementSymbol, Expression> params = container.getProcedureParameters();
                if (container instanceof StoredProcedure) {
                    plan.setRequiresTransaction(container.getUpdateCount() > 0);
                }
                plan.setParams(params);
                plan.setMetadata(metadata);
                if (container instanceof TranslatableProcedureContainer) {
                    plan.setImplicitParams(((TranslatableProcedureContainer)container).getImplicitParams());
                }
            }
        } else if (command.getType() == 9) {
            result = BATCHED_UPDATE_PLANNER.optimize(command, idGenerator, metadata, capFinder, analysisRecord, context);
        } else {
            try {
                if (command.getType() == 1 && command instanceof Query && QueryResolver.isXMLQuery((Query)command, metadata)) {
                    result = XML_PLANNER.optimize(command, idGenerator, metadata, capFinder, analysisRecord, context);
                } else {
                    RelationalPlanner planner = new RelationalPlanner();
                    planner.initialize(command, idGenerator, metadata, capFinder, analysisRecord, context);
                    result = planner.optimize(command);
                }
            }
            catch (QueryResolverException e) {
                throw new TeiidRuntimeException((Throwable)((Object)e));
            }
        }
        if (debug) {
            analysisRecord.println("\n----------------------------------------------------------------------------");
            analysisRecord.println("OPTIMIZATION COMPLETE:");
            analysisRecord.println("PROCESSOR PLAN:\n" + result);
            analysisRecord.println("============================================================================");
        }
        return result;
    }

    private static ProcessorPlan planProcedure(Command command, QueryMetadataInterface metadata, IDGenerator idGenerator, CapabilitiesFinder capFinder, AnalysisRecord analysisRecord, CommandContext context) throws TeiidComponentException, QueryPlannerException, QueryMetadataException {
        try {
            command = QueryRewriter.rewrite(command, metadata, context);
        }
        catch (TeiidProcessingException e) {
            throw new QueryPlannerException(e, e.getMessage());
        }
        ProcessorPlan result = PROCEDURE_PLANNER.optimize(command, idGenerator, metadata, capFinder, analysisRecord, context);
        return result;
    }
}

