/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.optimizer.relational.plantree;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.teiid.query.optimizer.relational.plantree.NodeConstants;
import org.teiid.query.optimizer.relational.plantree.NodeEditor;
import org.teiid.query.sql.LanguageObject;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.lang.Criteria;
import org.teiid.query.sql.lang.SubqueryContainer;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.query.sql.util.SymbolMap;
import org.teiid.query.sql.visitor.ElementCollectorVisitor;
import org.teiid.query.sql.visitor.GroupsUsedByElementsVisitor;
import org.teiid.query.sql.visitor.ValueIteratorProviderCollectorVisitor;

public class PlanNode {
    private int type;
    private PlanNode parent;
    private LinkedList<PlanNode> children = new LinkedList();
    private List<PlanNode> childrenView = Collections.unmodifiableList(this.children);
    private Map<NodeConstants.Info, Object> nodeProperties;
    private Set<GroupSymbol> groups = new HashSet<GroupSymbol>();
    private static final String TAB = "  ";

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public PlanNode getParent() {
        return this.parent;
    }

    private void setParent(PlanNode parent) {
        if (this.parent != null) {
            this.parent.children.remove(this);
        }
        this.parent = parent;
    }

    public List<PlanNode> getChildren() {
        return this.childrenView;
    }

    public List<PlanNode> removeAllChildren() {
        ArrayList<PlanNode> childrenCopy = new ArrayList<PlanNode>(this.children);
        Iterator childIter = this.children.iterator();
        while (childIter.hasNext()) {
            PlanNode child = (PlanNode)childIter.next();
            childIter.remove();
            child.parent = null;
        }
        return childrenCopy;
    }

    public int getChildCount() {
        return this.children.size();
    }

    public PlanNode getFirstChild() {
        if (this.getChildCount() > 0) {
            return this.children.getFirst();
        }
        return null;
    }

    public PlanNode getLastChild() {
        if (this.getChildCount() > 0) {
            return this.children.getLast();
        }
        return null;
    }

    public void addFirstChild(PlanNode child) {
        this.children.addFirst(child);
        child.setParent(this);
    }

    public void addLastChild(PlanNode child) {
        this.children.addLast(child);
        child.setParent(this);
    }

    public void addChildren(Collection<PlanNode> otherChildren) {
        for (PlanNode planNode : otherChildren) {
            this.addLastChild(planNode);
        }
    }

    public PlanNode removeFromParent() {
        PlanNode result = this.parent;
        if (result != null) {
            result.removeChild(this);
        }
        return result;
    }

    public boolean removeChild(PlanNode child) {
        boolean result = this.children.remove(child);
        if (result) {
            child.parent = null;
        }
        return result;
    }

    public Object getProperty(NodeConstants.Info propertyID) {
        if (this.nodeProperties == null) {
            return null;
        }
        return this.nodeProperties.get((Object)propertyID);
    }

    public void setProperty(NodeConstants.Info propertyID, Object value) {
        if (this.nodeProperties == null) {
            this.nodeProperties = new HashMap<NodeConstants.Info, Object>();
        }
        this.nodeProperties.put(propertyID, value);
    }

    public Object removeProperty(Object propertyID) {
        if (this.nodeProperties == null) {
            return null;
        }
        return this.nodeProperties.remove(propertyID);
    }

    public boolean hasProperty(NodeConstants.Info propertyID) {
        return this.getProperty(propertyID) != null;
    }

    public boolean hasCollectionProperty(NodeConstants.Info propertyID) {
        Collection value = (Collection)this.getProperty(propertyID);
        return value != null && !value.isEmpty();
    }

    public void addGroup(GroupSymbol groupID) {
        this.groups.add(groupID);
    }

    public void addGroups(Collection<GroupSymbol> newGroups) {
        this.groups.addAll(newGroups);
    }

    public Set<GroupSymbol> getGroups() {
        return this.groups;
    }

    public String toString() {
        StringBuffer str = new StringBuffer();
        this.getRecursiveString(str, 0);
        return str.toString();
    }

    public String nodeToString() {
        StringBuffer str = new StringBuffer();
        this.getNodeString(str);
        return str.toString();
    }

    private void setTab(StringBuffer str, int tabStop) {
        for (int i = 0; i < tabStop; ++i) {
            str.append(TAB);
        }
    }

    void getRecursiveString(StringBuffer str, int tabLevel) {
        this.setTab(str, tabLevel);
        this.getNodeString(str);
        str.append(")\n");
        for (PlanNode child : this.children) {
            child.getRecursiveString(str, tabLevel + 1);
        }
    }

    void getNodeString(StringBuffer str) {
        str.append(NodeConstants.getNodeTypeString(this.type));
        str.append("(groups=");
        str.append(this.groups);
        if (this.nodeProperties != null) {
            str.append(", props=");
            str.append(this.nodeProperties);
        }
    }

    public boolean hasBooleanProperty(NodeConstants.Info propertyKey) {
        return Boolean.TRUE.equals(this.getProperty(propertyKey));
    }

    public void replaceChild(PlanNode child, PlanNode replacement) {
        int i = this.children.indexOf(child);
        this.children.set(i, replacement);
        child.setParent(null);
        replacement.setParent(this);
    }

    public void addAsParent(PlanNode node) {
        if (this.parent != null) {
            this.parent.replaceChild(this, node);
        }
        assert (node.getChildCount() == 0);
        node.addLastChild(this);
    }

    public List<SymbolMap> getCorrelatedReferences() {
        List<SubqueryContainer> containers = this.getSubqueryContainers();
        if (containers.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<SymbolMap> result = new ArrayList<SymbolMap>(containers.size());
        for (SubqueryContainer container : containers) {
            SymbolMap map = ((Command)container.getCommand()).getCorrelatedReferences();
            if (map == null) continue;
            result.add(map);
        }
        return result;
    }

    public List<SymbolMap> getAllReferences() {
        ArrayList<SymbolMap> refMaps = new ArrayList<SymbolMap>(this.getCorrelatedReferences());
        refMaps.addAll(this.getExportedCorrelatedReferences());
        return refMaps;
    }

    public List<SymbolMap> getExportedCorrelatedReferences() {
        if (this.type != 4) {
            return Collections.emptyList();
        }
        LinkedList<SymbolMap> result = new LinkedList<SymbolMap>();
        block0: for (PlanNode child : NodeEditor.findAllNodes(this, 64, 1)) {
            SymbolMap references = (SymbolMap)child.getProperty(NodeConstants.Info.CORRELATED_REFERENCES);
            if (references == null) continue;
            Set<GroupSymbol> correlationGroups = GroupsUsedByElementsVisitor.getGroups(references.getValues());
            PlanNode joinNode = NodeEditor.findParent(child, 4, 64);
            while (joinNode != null) {
                if (joinNode.getGroups().containsAll(correlationGroups)) {
                    if (joinNode != this) continue block0;
                    result.add(references);
                    continue block0;
                }
                joinNode = NodeEditor.findParent(joinNode, 4, 64);
            }
        }
        return result;
    }

    public Set<ElementSymbol> getCorrelatedReferenceElements() {
        List<SymbolMap> maps = this.getCorrelatedReferences();
        if (maps.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<ElementSymbol> result = new HashSet<ElementSymbol>();
        for (SymbolMap symbolMap : maps) {
            List<Expression> values = symbolMap.getValues();
            for (Expression expr : values) {
                ElementCollectorVisitor.getElements((LanguageObject)expr, result);
            }
        }
        return result;
    }

    public List<SubqueryContainer> getSubqueryContainers() {
        List<Criteria> toSearch = Collections.emptyList();
        switch (this.getType()) {
            case 16: {
                Criteria criteria = (Criteria)this.getProperty(NodeConstants.Info.SELECT_CRITERIA);
                toSearch = Arrays.asList(criteria);
                break;
            }
            case 8: {
                toSearch = (Collection)this.getProperty(NodeConstants.Info.PROJECT_COLS);
                break;
            }
            case 4: {
                toSearch = (List<Criteria>)this.getProperty(NodeConstants.Info.JOIN_CRITERIA);
            }
        }
        return ValueIteratorProviderCollectorVisitor.getValueIteratorProviders(toSearch);
    }

    public float getCardinality() {
        Float cardinality = (Float)this.getProperty(NodeConstants.Info.EST_CARDINALITY);
        if (cardinality == null) {
            return -1.0f;
        }
        return cardinality.floatValue();
    }
}

