/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.optimizer.relational.rules;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.teiid.api.exception.query.QueryMetadataException;
import org.teiid.api.exception.query.QueryPlannerException;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.id.IDGenerator;
import org.teiid.query.analysis.AnalysisRecord;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.optimizer.QueryOptimizer;
import org.teiid.query.optimizer.capabilities.CapabilitiesFinder;
import org.teiid.query.optimizer.relational.OptimizerRule;
import org.teiid.query.optimizer.relational.RuleStack;
import org.teiid.query.optimizer.relational.plantree.NodeConstants;
import org.teiid.query.optimizer.relational.plantree.NodeEditor;
import org.teiid.query.optimizer.relational.plantree.NodeFactory;
import org.teiid.query.optimizer.relational.plantree.PlanNode;
import org.teiid.query.optimizer.relational.rules.FrameUtil;
import org.teiid.query.optimizer.relational.rules.NewCalculateCostUtil;
import org.teiid.query.optimizer.relational.rules.RuleChooseJoinStrategy;
import org.teiid.query.optimizer.relational.rules.RuleCollapseSource;
import org.teiid.query.optimizer.relational.rules.RuleImplementJoinStrategy;
import org.teiid.query.processor.relational.JoinNode;
import org.teiid.query.processor.relational.MergeJoinStrategy;
import org.teiid.query.processor.relational.RelationalPlan;
import org.teiid.query.resolver.util.ResolverUtil;
import org.teiid.query.rewriter.QueryRewriter;
import org.teiid.query.sql.LanguageObject;
import org.teiid.query.sql.lang.CompareCriteria;
import org.teiid.query.sql.lang.CompoundCriteria;
import org.teiid.query.sql.lang.Criteria;
import org.teiid.query.sql.lang.ExistsCriteria;
import org.teiid.query.sql.lang.FromClause;
import org.teiid.query.sql.lang.GroupBy;
import org.teiid.query.sql.lang.JoinType;
import org.teiid.query.sql.lang.NotCriteria;
import org.teiid.query.sql.lang.OrderBy;
import org.teiid.query.sql.lang.OrderByItem;
import org.teiid.query.sql.lang.Query;
import org.teiid.query.sql.lang.SubqueryCompareCriteria;
import org.teiid.query.sql.lang.SubquerySetCriteria;
import org.teiid.query.sql.navigator.DeepPostOrderNavigator;
import org.teiid.query.sql.symbol.AggregateSymbol;
import org.teiid.query.sql.symbol.AliasSymbol;
import org.teiid.query.sql.symbol.Constant;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.query.sql.symbol.Reference;
import org.teiid.query.sql.symbol.ScalarSubquery;
import org.teiid.query.sql.symbol.SingleElementSymbol;
import org.teiid.query.sql.util.SymbolMap;
import org.teiid.query.sql.visitor.AggregateSymbolCollectorVisitor;
import org.teiid.query.sql.visitor.ExpressionMappingVisitor;
import org.teiid.query.sql.visitor.GroupsUsedByElementsVisitor;
import org.teiid.query.sql.visitor.ReferenceCollectorVisitor;
import org.teiid.query.util.CommandContext;

public final class RuleMergeCriteria
implements OptimizerRule {
    private IDGenerator idGenerator;
    private CapabilitiesFinder capFinder;
    private AnalysisRecord analysisRecord;
    private CommandContext context;
    private QueryMetadataInterface metadata;

    public RuleMergeCriteria(IDGenerator idGenerator, CapabilitiesFinder capFinder, AnalysisRecord analysisRecord, CommandContext context, QueryMetadataInterface metadata) {
        this.idGenerator = idGenerator;
        this.capFinder = capFinder;
        this.analysisRecord = analysisRecord;
        this.context = context;
        this.metadata = metadata;
    }

    @Override
    public PlanNode execute(PlanNode plan, QueryMetadataInterface metadata, CapabilitiesFinder capFinder, RuleStack rules, AnalysisRecord analysisRecord, CommandContext context) throws QueryPlannerException, TeiidComponentException {
        ArrayList<PlanNode> criteriaChains = new ArrayList<PlanNode>();
        this.findCriteriaChains(plan, criteriaChains);
        for (PlanNode critNode : criteriaChains) {
            RuleMergeCriteria.mergeChain(critNode, metadata);
        }
        return plan;
    }

    void findCriteriaChains(PlanNode root, List<PlanNode> foundNodes) throws QueryPlannerException, TeiidComponentException {
        PlanNode recurseRoot = root;
        if (root.getType() == 16) {
            while (recurseRoot.getType() == 16) {
                recurseRoot = this.planSemiJoin(recurseRoot, root);
                if (root.getChildCount() == 0 && (root = recurseRoot.getFirstChild()).getType() != 16) {
                    root = root.getParent();
                }
                recurseRoot = recurseRoot.getFirstChild();
            }
            if (recurseRoot.getParent() != root) {
                foundNodes.add(root);
            }
        }
        if (recurseRoot.getType() != 1) {
            for (PlanNode child : recurseRoot.getChildren()) {
                this.findCriteriaChains(child, foundNodes);
            }
        }
    }

    static void mergeChain(PlanNode chainRoot, QueryMetadataInterface metadata) {
        CompoundCriteria critParts = new CompoundCriteria();
        LinkedList<Criteria> subqueryCriteria = new LinkedList<Criteria>();
        PlanNode current = chainRoot;
        boolean isDependentSet = false;
        while (current.getType() == 16) {
            if (!current.getCorrelatedReferenceElements().isEmpty()) {
                subqueryCriteria.add(0, (Criteria)current.getProperty(NodeConstants.Info.SELECT_CRITERIA));
            } else {
                critParts.getCriteria().add(0, (Criteria)current.getProperty(NodeConstants.Info.SELECT_CRITERIA));
            }
            isDependentSet |= current.hasBooleanProperty(NodeConstants.Info.IS_DEPENDENT_SET);
            PlanNode last = current;
            current = current.getLastChild();
            if (last == chainRoot) continue;
            NodeEditor.removeChildNode(last.getParent(), last);
        }
        critParts.getCriteria().addAll(subqueryCriteria);
        Criteria combinedCrit = QueryRewriter.optimizeCriteria(critParts, metadata);
        if (isDependentSet) {
            chainRoot.setProperty(NodeConstants.Info.IS_DEPENDENT_SET, Boolean.TRUE);
        }
        chainRoot.setProperty(NodeConstants.Info.SELECT_CRITERIA, combinedCrit);
        chainRoot.getGroups().clear();
        chainRoot.addGroups(GroupsUsedByElementsVisitor.getGroups(combinedCrit));
        chainRoot.addGroups(GroupsUsedByElementsVisitor.getGroups(chainRoot.getCorrelatedReferenceElements()));
    }

    private PlanNode planSemiJoin(PlanNode current, PlanNode root) throws QueryMetadataException, TeiidComponentException {
        float sourceCost = NewCalculateCostUtil.computeCostForTree(current, this.metadata);
        if (sourceCost != -1.0f && sourceCost < 10.0f) {
            return current;
        }
        Criteria crit = (Criteria)current.getProperty(NodeConstants.Info.SELECT_CRITERIA);
        PlannedResult plannedResult = this.findSubquery(crit);
        if (plannedResult.query == null) {
            return current;
        }
        RelationalPlan originalPlan = (RelationalPlan)plannedResult.query.getProcessorPlan();
        Number originalCardinality = originalPlan.getRootNode().getEstimateNodeCardinality();
        if (originalCardinality.floatValue() == -1.0f) {
            return current;
        }
        Set<GroupSymbol> leftGroups = FrameUtil.findJoinSourceNode(current).getGroups();
        if (!this.planQuery(leftGroups, false, plannedResult)) {
            return current;
        }
        plannedResult.query.setOrderBy(new OrderBy(plannedResult.rightExpressions));
        for (OrderByItem item : plannedResult.query.getOrderBy().getOrderByItems()) {
            int index = plannedResult.query.getProjectedSymbols().indexOf(item.getSymbol());
            item.setExpressionPosition(index);
        }
        try {
            RelationalPlan subPlan = (RelationalPlan)QueryOptimizer.optimizePlan(plannedResult.query, this.metadata, this.idGenerator, this.capFinder, this.analysisRecord, this.context);
            Number planCardinality = subPlan.getRootNode().getEstimateNodeCardinality();
            if (planCardinality.floatValue() == -1.0f || planCardinality.floatValue() > 1.0E7f || sourceCost != -1.0f && (double)(sourceCost * originalCardinality.floatValue()) < (double)planCardinality.floatValue() / (100.0 * Math.log(Math.max(4.0f, sourceCost)))) {
                return current;
            }
            PlanNode semiJoin = NodeFactory.getNewNode(4);
            semiJoin.addGroups(current.getGroups());
            semiJoin.setProperty(NodeConstants.Info.JOIN_STRATEGY, (Object)JoinNode.JoinStrategyType.MERGE);
            semiJoin.setProperty(NodeConstants.Info.JOIN_TYPE, plannedResult.not ? JoinType.JOIN_ANTI_SEMI : JoinType.JOIN_SEMI);
            semiJoin.setProperty(NodeConstants.Info.NON_EQUI_JOIN_CRITERIA, plannedResult.nonEquiJoinCriteria);
            semiJoin.setProperty(NodeConstants.Info.LEFT_EXPRESSIONS, plannedResult.leftExpressions);
            semiJoin.setProperty(NodeConstants.Info.RIGHT_EXPRESSIONS, plannedResult.rightExpressions);
            semiJoin.setProperty(NodeConstants.Info.SORT_RIGHT, (Object)MergeJoinStrategy.SortOption.ALREADY_SORTED);
            semiJoin.setProperty(NodeConstants.Info.OUTPUT_COLS, root.getProperty(NodeConstants.Info.OUTPUT_COLS));
            List childOutput = (List)current.getFirstChild().getProperty(NodeConstants.Info.OUTPUT_COLS);
            for (PlanNode toCorrect = root; toCorrect != current; toCorrect = toCorrect.getFirstChild()) {
                toCorrect.setProperty(NodeConstants.Info.OUTPUT_COLS, childOutput);
            }
            PlanNode node = NodeFactory.getNewNode(1);
            node.setProperty(NodeConstants.Info.PROCESSOR_PLAN, subPlan);
            node.setProperty(NodeConstants.Info.OUTPUT_COLS, plannedResult.query.getProjectedSymbols());
            node.setProperty(NodeConstants.Info.EST_CARDINALITY, planCardinality);
            root.addAsParent(semiJoin);
            semiJoin.addLastChild(node);
            PlanNode result = current.getParent();
            NodeEditor.removeChildNode(result, current);
            RuleImplementJoinStrategy.insertSort(semiJoin.getFirstChild(), plannedResult.leftExpressions, semiJoin, this.metadata, this.capFinder, true);
            return result;
        }
        catch (QueryPlannerException e) {
            return current;
        }
    }

    public PlannedResult findSubquery(Criteria crit) throws TeiidComponentException, QueryMetadataException {
        Query query;
        ScalarSubquery ss;
        CompareCriteria cc;
        PlannedResult result = new PlannedResult();
        if (crit instanceof NotCriteria) {
            result.not = true;
            crit = ((NotCriteria)crit).getCriteria();
        }
        if (crit instanceof SubquerySetCriteria) {
            SubquerySetCriteria ssc = (SubquerySetCriteria)crit;
            result.not ^= ssc.isNegated();
            crit = new SubqueryCompareCriteria(ssc.getExpression(), ssc.getCommand(), 1, 2);
        } else if (crit instanceof CompareCriteria && (cc = (CompareCriteria)crit).getRightExpression() instanceof ScalarSubquery && (ss = (ScalarSubquery)cc.getRightExpression()).getCommand() instanceof Query && (query = (Query)ss.getCommand()).getGroupBy() == null && query.hasAggregates()) {
            crit = new SubqueryCompareCriteria(cc.getLeftExpression(), ss.getCommand(), cc.getOperator(), 2);
        }
        if (crit instanceof SubqueryCompareCriteria) {
            SubqueryCompareCriteria scc = (SubqueryCompareCriteria)crit;
            if (scc.getPredicateQuantifier() != 2 || !(scc.getCommand() instanceof Query)) {
                return result;
            }
            Query query2 = (Query)scc.getCommand();
            Expression rightExpr = SymbolMap.getExpression(query2.getProjectedSymbols().get(0));
            if (result.not && !this.isNonNull(query2, rightExpr)) {
                return result;
            }
            result.query = query2;
            result.additionalCritieria = (Criteria)new CompareCriteria(scc.getLeftExpression(), scc.getOperator(), rightExpr).clone();
        }
        if (crit instanceof ExistsCriteria) {
            ExistsCriteria exists = (ExistsCriteria)crit;
            if (!(exists.getCommand() instanceof Query)) {
                return result;
            }
            result.query = (Query)exists.getCommand();
        }
        return result;
    }

    private boolean isNonNull(Query query, Expression rightExpr) throws TeiidComponentException, QueryMetadataException {
        if (rightExpr instanceof ElementSymbol) {
            ElementSymbol es = (ElementSymbol)rightExpr;
            if (this.metadata.elementSupports(es.getMetadataID(), 4)) {
                return false;
            }
            if (!this.isSimpleJoin(query)) {
                return false;
            }
        } else if (rightExpr instanceof Constant) {
            if (((Constant)rightExpr).isNull()) {
                return false;
            }
        } else if (rightExpr instanceof AggregateSymbol) {
            AggregateSymbol as = (AggregateSymbol)rightExpr;
            if (as.getAggregateFunction() != AggregateSymbol.Type.COUNT) {
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    private boolean isSimpleJoin(Query query) {
        if (query.getFrom() != null) {
            for (FromClause clause : query.getFrom().getClauses()) {
                if (!RuleCollapseSource.hasOuterJoins(clause)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean planQuery(Collection<GroupSymbol> leftGroups, boolean requireDistinct, PlannedResult plannedResult) throws QueryMetadataException, TeiidComponentException {
        if (plannedResult.query.getLimit() != null || plannedResult.query.getFrom() == null) {
            return false;
        }
        plannedResult.query = (Query)plannedResult.query.clone();
        List<GroupSymbol> rightGroups = plannedResult.query.getFrom().getGroups();
        LinkedHashSet<SingleElementSymbol> requiredExpressions = new LinkedHashSet<SingleElementSymbol>();
        SymbolMap refs = plannedResult.query.getCorrelatedReferences();
        boolean addGroupBy = false;
        if (refs != null) {
            boolean hasAggregates = plannedResult.query.hasAggregates();
            Criteria where = plannedResult.query.getCriteria();
            if (plannedResult.query.getGroupBy() == null) {
                plannedResult.query.setCriteria(null);
            }
            Criteria having = plannedResult.query.getHaving();
            plannedResult.query.setHaving(null);
            if (this.hasCorrelatedReferences(plannedResult.query, refs)) {
                return false;
            }
            if (plannedResult.query.getGroupBy() == null) {
                this.processCriteria(leftGroups, plannedResult, rightGroups, requiredExpressions, refs, where, true);
                if (hasAggregates) {
                    if (!plannedResult.nonEquiJoinCriteria.isEmpty()) {
                        return false;
                    }
                    addGroupBy = true;
                }
            }
            this.processCriteria(leftGroups, plannedResult, rightGroups, requiredExpressions, refs, having, false);
        }
        if (plannedResult.additionalCritieria != null) {
            RuleChooseJoinStrategy.separateCriteria(leftGroups, rightGroups, plannedResult.leftExpressions, plannedResult.rightExpressions, Criteria.separateCriteriaByAnd(plannedResult.additionalCritieria), plannedResult.nonEquiJoinCriteria);
        }
        if (plannedResult.leftExpressions.isEmpty()) {
            return false;
        }
        plannedResult.leftExpressions = RuleChooseJoinStrategy.createExpressionSymbols(plannedResult.leftExpressions);
        plannedResult.rightExpressions = RuleChooseJoinStrategy.createExpressionSymbols(plannedResult.rightExpressions);
        if (requireDistinct && !addGroupBy && !RuleMergeCriteria.isDistinct(plannedResult.query, plannedResult.rightExpressions, this.metadata)) {
            if (!requiredExpressions.isEmpty()) {
                return false;
            }
            plannedResult.query.getSelect().setDistinct(true);
        }
        if (addGroupBy) {
            plannedResult.query.setGroupBy(new GroupBy(plannedResult.rightExpressions));
        }
        HashSet<SingleElementSymbol> projectedSymbols = new HashSet<SingleElementSymbol>();
        for (SingleElementSymbol ses : plannedResult.query.getProjectedSymbols()) {
            if (ses instanceof AliasSymbol) {
                ses = ((AliasSymbol)ses).getSymbol();
            }
            projectedSymbols.add(ses);
        }
        for (SingleElementSymbol ses : requiredExpressions) {
            if (!projectedSymbols.add(ses)) continue;
            plannedResult.query.getSelect().addSymbol(ses);
        }
        for (SingleElementSymbol ses : plannedResult.rightExpressions) {
            if (!projectedSymbols.add(ses)) continue;
            plannedResult.query.getSelect().addSymbol(ses);
        }
        return true;
    }

    private void processCriteria(Collection<GroupSymbol> leftGroups, PlannedResult plannedResult, List<GroupSymbol> rightGroups, Set<SingleElementSymbol> requiredExpressions, SymbolMap refs, Criteria joinCriteria, boolean where) {
        if (joinCriteria == null) {
            return;
        }
        List<Criteria> crits = Criteria.separateCriteriaByAnd((Criteria)joinCriteria.clone());
        Iterator<Criteria> critIter = crits.iterator();
        while (critIter.hasNext()) {
            Criteria conjunct = critIter.next();
            LinkedList<SingleElementSymbol> aggregates = new LinkedList<SingleElementSymbol>();
            LinkedList<SingleElementSymbol> elements = new LinkedList<SingleElementSymbol>();
            AggregateSymbolCollectorVisitor.getAggregates(conjunct, aggregates, elements);
            ReferenceReplacementVisitor emv = new ReferenceReplacementVisitor(refs);
            DeepPostOrderNavigator.doVisit(conjunct, emv);
            if (!emv.replacedAny) {
                critIter.remove();
                if (where) {
                    plannedResult.query.setCriteria(Criteria.combineCriteria(plannedResult.query.getCriteria(), conjunct));
                    continue;
                }
                plannedResult.query.setHaving(Criteria.combineCriteria(plannedResult.query.getHaving(), conjunct));
                continue;
            }
            requiredExpressions.addAll(aggregates);
            requiredExpressions.addAll(elements);
        }
        RuleChooseJoinStrategy.separateCriteria(leftGroups, rightGroups, plannedResult.leftExpressions, plannedResult.rightExpressions, crits, plannedResult.nonEquiJoinCriteria);
    }

    public static boolean isDistinct(Query query, List<SingleElementSymbol> expressions, QueryMetadataInterface metadata) throws QueryMetadataException, TeiidComponentException {
        boolean distinct = false;
        if (query.getGroupBy() != null) {
            distinct = true;
            for (SingleElementSymbol groupByExpr : query.getGroupBy().getSymbols()) {
                if (expressions.contains(groupByExpr)) continue;
                distinct = false;
                break;
            }
        }
        if (distinct) {
            return true;
        }
        HashSet<GroupSymbol> keyPreservingGroups = new HashSet<GroupSymbol>();
        ResolverUtil.findKeyPreserved(query, keyPreservingGroups, metadata);
        return NewCalculateCostUtil.usesKey(expressions, keyPreservingGroups, metadata);
    }

    private boolean hasCorrelatedReferences(LanguageObject object, SymbolMap correlatedReferences) {
        List<Reference> references = ReferenceCollectorVisitor.getReferences(object);
        for (Reference reference : references) {
            if (!correlatedReferences.asMap().containsKey(reference.getExpression())) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return "MergeCriteria";
    }

    public static class PlannedResult {
        public List leftExpressions = new LinkedList();
        public List rightExpressions = new LinkedList();
        public Query query;
        public boolean not;
        public List<Criteria> nonEquiJoinCriteria = new LinkedList<Criteria>();
        public Criteria additionalCritieria;
    }

    protected static final class ReferenceReplacementVisitor
    extends ExpressionMappingVisitor {
        private final SymbolMap refs;
        private boolean replacedAny;

        ReferenceReplacementVisitor(SymbolMap refs) {
            super(null);
            this.refs = refs;
        }

        @Override
        public Expression replaceExpression(Expression element) {
            Reference r;
            Expression ex;
            if (element instanceof Reference && (ex = this.refs.getMappedExpression((r = (Reference)element).getExpression())) != null) {
                this.replacedAny = true;
                return ex;
            }
            return element;
        }
    }
}

