/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.optimizer.relational.rules;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.teiid.api.exception.query.QueryMetadataException;
import org.teiid.api.exception.query.QueryPlannerException;
import org.teiid.api.exception.query.QueryResolverException;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.types.DataTypeManager;
import org.teiid.query.analysis.AnalysisRecord;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.metadata.TempMetadataAdapter;
import org.teiid.query.metadata.TempMetadataStore;
import org.teiid.query.optimizer.capabilities.CapabilitiesFinder;
import org.teiid.query.optimizer.capabilities.SourceCapabilities;
import org.teiid.query.optimizer.relational.OptimizerRule;
import org.teiid.query.optimizer.relational.RuleStack;
import org.teiid.query.optimizer.relational.plantree.NodeConstants;
import org.teiid.query.optimizer.relational.plantree.NodeEditor;
import org.teiid.query.optimizer.relational.plantree.NodeFactory;
import org.teiid.query.optimizer.relational.plantree.PlanNode;
import org.teiid.query.optimizer.relational.rules.CapabilitiesUtil;
import org.teiid.query.optimizer.relational.rules.FrameUtil;
import org.teiid.query.optimizer.relational.rules.NewCalculateCostUtil;
import org.teiid.query.optimizer.relational.rules.RuleDecomposeJoin;
import org.teiid.query.optimizer.relational.rules.RuleRaiseAccess;
import org.teiid.query.optimizer.relational.rules.RuleRemoveOptionalJoins;
import org.teiid.query.resolver.util.ResolverUtil;
import org.teiid.query.resolver.util.ResolverVisitor;
import org.teiid.query.rewriter.QueryRewriter;
import org.teiid.query.sql.LanguageObject;
import org.teiid.query.sql.lang.CompareCriteria;
import org.teiid.query.sql.lang.Criteria;
import org.teiid.query.sql.lang.IsNullCriteria;
import org.teiid.query.sql.lang.JoinType;
import org.teiid.query.sql.lang.OrderBy;
import org.teiid.query.sql.lang.Select;
import org.teiid.query.sql.lang.SetQuery;
import org.teiid.query.sql.symbol.AggregateSymbol;
import org.teiid.query.sql.symbol.AliasSymbol;
import org.teiid.query.sql.symbol.Constant;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.ExpressionSymbol;
import org.teiid.query.sql.symbol.Function;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.query.sql.symbol.SearchedCaseExpression;
import org.teiid.query.sql.symbol.SingleElementSymbol;
import org.teiid.query.sql.util.SymbolMap;
import org.teiid.query.sql.visitor.AggregateSymbolCollectorVisitor;
import org.teiid.query.sql.visitor.ElementCollectorVisitor;
import org.teiid.query.sql.visitor.ExpressionMappingVisitor;
import org.teiid.query.sql.visitor.GroupsUsedByElementsVisitor;
import org.teiid.query.util.CommandContext;

public class RulePushAggregates
implements OptimizerRule {
    @Override
    public PlanNode execute(PlanNode plan, QueryMetadataInterface metadata, CapabilitiesFinder capFinder, RuleStack rules, AnalysisRecord analysisRecord, CommandContext context) throws QueryPlannerException, QueryMetadataException, TeiidComponentException {
        for (PlanNode groupNode : NodeEditor.findAllNodes(plan, 128, 1)) {
            PlanNode child = groupNode.getFirstChild();
            List groupingExpressions = (List)groupNode.getProperty(NodeConstants.Info.GROUP_COLS);
            if (child.getType() == 64) {
                PlanNode setOp = child.getFirstChild();
                try {
                    this.pushGroupNodeOverUnion(plan, metadata, capFinder, groupNode, child, groupingExpressions, setOp, context);
                    continue;
                }
                catch (QueryResolverException e) {
                    throw new TeiidComponentException((Throwable)((Object)e));
                }
            }
            if (child.getType() != 4) continue;
            LinkedHashSet<AggregateSymbol> aggregates = RulePushAggregates.collectAggregates(groupNode);
            this.pushGroupNode(groupNode, groupingExpressions, aggregates, metadata, capFinder);
        }
        return plan;
    }

    private void pushGroupNodeOverUnion(PlanNode plan, QueryMetadataInterface metadata, CapabilitiesFinder capFinder, PlanNode groupNode, PlanNode child, List<SingleElementSymbol> groupingExpressions, PlanNode setOp, CommandContext context) throws TeiidComponentException, QueryMetadataException, QueryPlannerException, QueryResolverException {
        if (setOp == null || setOp.getType() != 256 || setOp.getProperty(NodeConstants.Info.SET_OPERATION) != SetQuery.Operation.UNION) {
            return;
        }
        LinkedHashSet<AggregateSymbol> aggregates = RulePushAggregates.collectAggregates(groupNode);
        Map partitionInfo = (Map)child.getProperty(NodeConstants.Info.PARTITION_INFO);
        boolean cardinalityDependent = RuleRemoveOptionalJoins.areAggregatesCardinalityDependent(aggregates);
        LinkedList<PlanNode> unionChildren = new LinkedList<PlanNode>();
        RulePushAggregates.findUnionChildren(unionChildren, cardinalityDependent, setOp);
        SymbolMap parentMap = (SymbolMap)child.getProperty(NodeConstants.Info.SYMBOL_MAP);
        if (partitionInfo != null && !Collections.disjoint(partitionInfo.keySet(), groupingExpressions)) {
            this.decomposeGroupBy(groupNode, child, groupingExpressions, aggregates, unionChildren, parentMap, context, metadata, capFinder);
            return;
        }
        if (aggregates.isEmpty()) {
            if (groupingExpressions != null && !groupingExpressions.isEmpty()) {
                setOp.setProperty(NodeConstants.Info.USE_ALL, Boolean.FALSE);
            }
            return;
        }
        if (unionChildren.size() < 2) {
            return;
        }
        List<ElementSymbol> virtualElements = parentMap.getKeys();
        ArrayList<AggregateSymbol> copy = new ArrayList<AggregateSymbol>(aggregates);
        aggregates.clear();
        Map<AggregateSymbol, Expression> aggMap = RulePushAggregates.buildAggregateMap(copy, metadata, aggregates);
        boolean shouldPushdown = false;
        ArrayList<Boolean> pushdownList = new ArrayList<Boolean>(unionChildren.size());
        for (PlanNode planNode : unionChildren) {
            boolean pushdown = this.canPushGroupByToUnionChild(metadata, capFinder, groupingExpressions, aggregates, planNode);
            pushdownList.add(pushdown);
            shouldPushdown |= pushdown;
        }
        if (!shouldPushdown) {
            return;
        }
        Iterator pushdownIterator = pushdownList.iterator();
        for (PlanNode planNode : unionChildren) {
            this.addView(plan, planNode, (Boolean)pushdownIterator.next(), groupingExpressions, aggregates, virtualElements, metadata, capFinder);
        }
        List projectedViewSymbols = (List)NodeEditor.findNodePreOrder(child, 8).getProperty(NodeConstants.Info.PROJECT_COLS);
        ArrayList<ElementSymbol> updatedVirturalElement = new ArrayList<ElementSymbol>(virtualElements);
        GroupSymbol virtualGroup = child.getGroups().iterator().next();
        for (int i = updatedVirturalElement.size(); i < projectedViewSymbols.size(); ++i) {
            SingleElementSymbol symbol = (SingleElementSymbol)projectedViewSymbols.get(i);
            String name = symbol.getShortName();
            String virtualElementName = virtualGroup.getCanonicalName() + "." + name;
            ElementSymbol virtualElement = new ElementSymbol(virtualElementName);
            virtualElement.setGroupSymbol(virtualGroup);
            virtualElement.setType(symbol.getType());
            updatedVirturalElement.add(virtualElement);
        }
        SymbolMap newParentMap = SymbolMap.createSymbolMap(updatedVirturalElement, projectedViewSymbols);
        child.setProperty(NodeConstants.Info.SYMBOL_MAP, newParentMap);
        HashMap projectedMap = new HashMap();
        Iterator aggIter = aggregates.iterator();
        for (ElementSymbol projectedViewSymbol : newParentMap.getKeys().subList(projectedViewSymbols.size() - aggregates.size(), projectedViewSymbols.size())) {
            projectedMap.put(aggIter.next(), projectedViewSymbol);
        }
        for (Expression expr : aggMap.values()) {
            ExpressionMappingVisitor.mapExpressions(expr, projectedMap);
        }
        RulePushAggregates.mapExpressions(groupNode.getParent(), aggMap, metadata);
    }

    private void decomposeGroupBy(PlanNode groupNode, PlanNode sourceNode, List<SingleElementSymbol> groupingExpressions, LinkedHashSet<AggregateSymbol> aggregates, LinkedList<PlanNode> unionChildren, SymbolMap parentMap, CommandContext context, QueryMetadataInterface metadata, CapabilitiesFinder capFinder) throws QueryPlannerException, QueryMetadataException, TeiidComponentException {
        groupNode.getParent().replaceChild(groupNode, groupNode.getFirstChild());
        GroupSymbol group = sourceNode.getGroups().iterator().next().clone();
        boolean first = true;
        List symbols = null;
        for (PlanNode planNode : unionChildren) {
            PlanNode groupClone = NodeFactory.getNewNode(128);
            groupClone.setProperty(NodeConstants.Info.GROUP_COLS, LanguageObject.Util.deepClone(groupingExpressions, SingleElementSymbol.class));
            groupClone.addGroups(groupNode.getGroups());
            PlanNode view = RuleDecomposeJoin.createSource(group, planNode, parentMap);
            view.addAsParent(groupClone);
            PlanNode projectPlanNode = NodeFactory.getNewNode(8);
            Select allSymbols = new Select(groupingExpressions);
            allSymbols.addSymbols(aggregates);
            if (first) {
                first = false;
                QueryRewriter.makeSelectUnique(allSymbols, false);
                symbols = allSymbols.getSymbols();
            }
            projectPlanNode.setProperty(NodeConstants.Info.PROJECT_COLS, allSymbols.getSymbols());
            projectPlanNode.addGroups(view.getGroups());
            groupClone.addAsParent(projectPlanNode);
            if (planNode.getType() != 1) continue;
            while (RuleRaiseAccess.raiseAccessNode(planNode, planNode, metadata, capFinder, true, null) != null) {
            }
        }
        GroupSymbol modifiedGroup = group.clone();
        SymbolMap symbolMap = RulePushAggregates.createSymbolMap(modifiedGroup, symbols, sourceNode, metadata);
        sourceNode.setProperty(NodeConstants.Info.SYMBOL_MAP, symbolMap);
        FrameUtil.convertFrame(sourceNode, group, Collections.singleton(modifiedGroup), symbolMap.inserseMapping(), metadata);
    }

    private boolean canPushGroupByToUnionChild(QueryMetadataInterface metadata, CapabilitiesFinder capFinder, List<SingleElementSymbol> groupingExpressions, LinkedHashSet<AggregateSymbol> aggregates, PlanNode planNode) throws QueryMetadataException, TeiidComponentException {
        if (planNode.getType() != 1) {
            return false;
        }
        Object modelId = RuleRaiseAccess.getModelIDFromAccess(planNode, metadata);
        if (!CapabilitiesUtil.supports(SourceCapabilities.Capability.QUERY_FROM_INLINE_VIEWS, modelId, metadata, capFinder) || !CapabilitiesUtil.supports(SourceCapabilities.Capability.QUERY_GROUP_BY, modelId, metadata, capFinder)) {
            return false;
        }
        for (AggregateSymbol aggregate : aggregates) {
            if (CapabilitiesUtil.supportsAggregateFunction(modelId, aggregate, metadata, capFinder)) continue;
            return false;
        }
        return groupingExpressions != null && !groupingExpressions.isEmpty() || CapabilitiesUtil.supports(SourceCapabilities.Capability.QUERY_AGGREGATES_COUNT_STAR, modelId, metadata, capFinder);
    }

    static PlanNode findUnionChildren(List<PlanNode> unionChildren, boolean carinalityDependent, PlanNode setOp) {
        if (setOp.getType() != 256 || setOp.getProperty(NodeConstants.Info.SET_OPERATION) != SetQuery.Operation.UNION) {
            return setOp;
        }
        if (!setOp.hasBooleanProperty(NodeConstants.Info.USE_ALL)) {
            if (carinalityDependent) {
                return setOp;
            }
            setOp.setProperty(NodeConstants.Info.USE_ALL, Boolean.TRUE);
        }
        for (PlanNode planNode : setOp.getChildren()) {
            PlanNode child = RulePushAggregates.findUnionChildren(unionChildren, carinalityDependent, planNode);
            if (child == null) continue;
            unionChildren.add(child);
        }
        return null;
    }

    public void addView(PlanNode root, PlanNode unionSource, boolean pushdown, List<SingleElementSymbol> groupingExpressions, Set<AggregateSymbol> aggregates, List<ElementSymbol> virtualElements, QueryMetadataInterface metadata, CapabilitiesFinder capFinder) throws TeiidComponentException, QueryPlannerException, QueryResolverException {
        PlanNode originalNode = unionSource;
        PlanNode sortNode = NodeEditor.findNodePreOrder(unionSource, 32, 64);
        List<SingleElementSymbol> sortOrder = null;
        OrderBy orderBy = null;
        if (sortNode != null) {
            orderBy = (OrderBy)sortNode.getProperty(NodeConstants.Info.SORT_ORDER);
            sortOrder = orderBy.getSortKeys();
        }
        List<SingleElementSymbol> projectCols = FrameUtil.findTopCols(unionSource);
        for (int i = 0; i < virtualElements.size(); ++i) {
            int sortIndex;
            ElementSymbol virtualElem = virtualElements.get(i);
            SingleElementSymbol projectedSymbol = projectCols.get(i);
            if (projectedSymbol.getShortCanonicalName().equals(virtualElem.getShortCanonicalName())) continue;
            if (sortOrder != null && (sortIndex = sortOrder.indexOf(projectedSymbol)) > -1) {
                this.updateSymbolName(sortOrder, sortIndex, virtualElem, sortOrder.get(sortIndex));
                orderBy.getOrderByItems().get(sortIndex).setSymbol(sortOrder.get(sortIndex));
            }
            this.updateSymbolName(projectCols, i, virtualElem, projectedSymbol);
        }
        GroupSymbol group = new GroupSymbol("X");
        PlanNode intermediateView = RulePushAggregates.createView(group, virtualElements, unionSource, metadata);
        SymbolMap symbolMap = (SymbolMap)intermediateView.getProperty(NodeConstants.Info.SYMBOL_MAP);
        unionSource = intermediateView;
        Set<SingleElementSymbol> newGroupingExpressions = Collections.emptySet();
        if (groupingExpressions != null) {
            newGroupingExpressions = new HashSet();
            for (SingleElementSymbol singleElementSymbol : groupingExpressions) {
                newGroupingExpressions.add((SingleElementSymbol)symbolMap.getKeys().get(virtualElements.indexOf(singleElementSymbol)).clone());
            }
        }
        List<SingleElementSymbol> projectedViewSymbols = LanguageObject.Util.deepClone(symbolMap.getKeys(), SingleElementSymbol.class);
        SymbolMap viewMapping = SymbolMap.createSymbolMap(NodeEditor.findParent(unionSource, 64).getGroups().iterator().next(), projectedViewSymbols, metadata);
        for (AggregateSymbol agg : aggregates) {
            agg = (AggregateSymbol)agg.clone();
            ExpressionMappingVisitor.mapExpressions(agg, viewMapping.asMap());
            if (pushdown) {
                projectedViewSymbols.add(agg);
                continue;
            }
            if (agg.getAggregateFunction() == AggregateSymbol.Type.COUNT) {
                if (agg.getExpression() == null) {
                    projectedViewSymbols.add(new ExpressionSymbol("stagedAgg", new Constant(1)));
                    continue;
                }
                SearchedCaseExpression count = new SearchedCaseExpression(Arrays.asList(new IsNullCriteria(agg.getExpression())), Arrays.asList(new Constant(0)));
                count.setElseExpression(new Constant(1));
                count.setType(DataTypeManager.DefaultDataClasses.INTEGER);
                projectedViewSymbols.add(new ExpressionSymbol("stagedAgg", count));
                continue;
            }
            Expression ex = agg.getExpression();
            ex = ResolverUtil.convertExpression(ex, DataTypeManager.getDataTypeName(agg.getType()), metadata);
            projectedViewSymbols.add(new ExpressionSymbol("stagedAgg", ex));
        }
        if (pushdown) {
            unionSource = this.addGroupBy(unionSource, newGroupingExpressions, new LinkedList<AggregateSymbol>());
        }
        PlanNode projectPlanNode = NodeFactory.getNewNode(8);
        unionSource.addAsParent(projectPlanNode);
        unionSource = projectPlanNode;
        Select select = new Select(projectedViewSymbols);
        QueryRewriter.makeSelectUnique(select, false);
        projectedViewSymbols = select.getProjectedSymbols();
        projectPlanNode.setProperty(NodeConstants.Info.PROJECT_COLS, projectedViewSymbols);
        projectPlanNode.addGroup(group);
        if (pushdown) {
            while (RuleRaiseAccess.raiseAccessNode(root, originalNode, metadata, capFinder, true, null) != null) {
            }
        }
    }

    static PlanNode createView(GroupSymbol group, List<? extends SingleElementSymbol> virtualElements, PlanNode child, QueryMetadataInterface metadata) throws TeiidComponentException {
        PlanNode intermediateView = NodeFactory.getNewNode(64);
        SymbolMap symbolMap = RulePushAggregates.createSymbolMap(group, virtualElements, child, metadata);
        intermediateView.setProperty(NodeConstants.Info.SYMBOL_MAP, symbolMap);
        child.addAsParent(intermediateView);
        intermediateView.addGroup(group);
        return intermediateView;
    }

    private static SymbolMap createSymbolMap(GroupSymbol group, List<? extends SingleElementSymbol> virtualElements, PlanNode child, QueryMetadataInterface metadata) throws TeiidComponentException, QueryMetadataException {
        TempMetadataStore store = new TempMetadataStore();
        TempMetadataAdapter tma = new TempMetadataAdapter(metadata, store);
        try {
            group.setMetadataID(ResolverUtil.addTempGroup(tma, group, virtualElements, false));
        }
        catch (QueryResolverException e) {
            throw new TeiidComponentException((Throwable)((Object)e));
        }
        List<ElementSymbol> projectedSymbols = ResolverUtil.resolveElementsInGroup(group, metadata);
        SymbolMap symbolMap = SymbolMap.createSymbolMap(projectedSymbols, (List)NodeEditor.findNodePreOrder(child, 8).getProperty(NodeConstants.Info.PROJECT_COLS));
        return symbolMap;
    }

    private void updateSymbolName(List<SingleElementSymbol> projectCols, int i, ElementSymbol virtualElem, SingleElementSymbol projectedSymbol) {
        if (projectedSymbol instanceof AliasSymbol) {
            ((AliasSymbol)projectedSymbol).setName(virtualElem.getShortCanonicalName());
        } else {
            projectCols.set(i, new AliasSymbol(virtualElem.getShortCanonicalName(), projectedSymbol));
        }
    }

    static LinkedHashSet<AggregateSymbol> collectAggregates(PlanNode groupNode) {
        LinkedHashSet<AggregateSymbol> aggregates = new LinkedHashSet<AggregateSymbol>();
        for (PlanNode currentNode = groupNode.getParent(); currentNode != null; currentNode = currentNode.getParent()) {
            if (currentNode.getType() == 8) {
                List projectedSymbols = (List)currentNode.getProperty(NodeConstants.Info.PROJECT_COLS);
                for (SingleElementSymbol symbol : projectedSymbols) {
                    aggregates.addAll(AggregateSymbolCollectorVisitor.getAggregates(symbol, true));
                }
                break;
            }
            if (currentNode.getType() != 16) continue;
            Criteria crit = (Criteria)currentNode.getProperty(NodeConstants.Info.SELECT_CRITERIA);
            aggregates.addAll(AggregateSymbolCollectorVisitor.getAggregates(crit, true));
        }
        return aggregates;
    }

    private void pushGroupNode(PlanNode groupNode, List<SingleElementSymbol> groupingExpressions, Set<AggregateSymbol> allAggregates, QueryMetadataInterface metadata, CapabilitiesFinder capFinder) throws TeiidComponentException, QueryMetadataException, QueryPlannerException {
        Map<PlanNode, List<AggregateSymbol>> aggregateMap = this.createNodeMapping(groupNode, allAggregates);
        Map<PlanNode, List<SingleElementSymbol>> groupingMap = this.createNodeMapping(groupNode, groupingExpressions);
        HashSet<PlanNode> possibleTargetNodes = new HashSet<PlanNode>(aggregateMap.keySet());
        possibleTargetNodes.addAll(groupingMap.keySet());
        for (PlanNode planNode : possibleTargetNodes) {
            PlanNode stageGroup;
            LinkedHashSet<SingleElementSymbol> stagedGroupingSymbols = new LinkedHashSet<SingleElementSymbol>();
            List<AggregateSymbol> aggregates = aggregateMap.get(planNode);
            List<SingleElementSymbol> groupBy = groupingMap.get(planNode);
            if (!this.canPush(groupNode, stagedGroupingSymbols, planNode)) continue;
            if (groupBy != null) {
                stagedGroupingSymbols.addAll(groupBy);
            }
            this.collectSymbolsFromOtherAggregates(allAggregates, aggregates, planNode, stagedGroupingSymbols);
            if (NewCalculateCostUtil.usesKey(planNode, stagedGroupingSymbols, metadata)) continue;
            if (aggregates != null) {
                RulePushAggregates.stageAggregates(groupNode, metadata, stagedGroupingSymbols, aggregates);
            } else {
                aggregates = new ArrayList<AggregateSymbol>(1);
            }
            if (aggregates.isEmpty() && stagedGroupingSymbols.isEmpty() || (stageGroup = this.addGroupBy(planNode, stagedGroupingSymbols, aggregates)).getFirstChild().getType() != 1 || !RuleRaiseAccess.canRaiseOverGroupBy(stageGroup, stageGroup.getFirstChild(), aggregates, metadata, capFinder, null)) continue;
            RuleRaiseAccess.performRaise(null, stageGroup.getFirstChild(), stageGroup);
            if (!stagedGroupingSymbols.isEmpty()) continue;
            RuleRaiseAccess.performRaise(null, stageGroup.getParent(), stageGroup.getParent().getParent());
        }
    }

    private PlanNode addGroupBy(PlanNode planNode, Collection<SingleElementSymbol> stagedGroupingSymbols, Collection<AggregateSymbol> aggregates) {
        PlanNode stageGroup = NodeFactory.getNewNode(128);
        planNode.addAsParent(stageGroup);
        if (!stagedGroupingSymbols.isEmpty()) {
            stageGroup.setProperty(NodeConstants.Info.GROUP_COLS, new ArrayList<SingleElementSymbol>(stagedGroupingSymbols));
            stageGroup.addGroups(GroupsUsedByElementsVisitor.getGroups(stagedGroupingSymbols));
        } else {
            PlanNode selectNode = NodeFactory.getNewNode(16);
            AggregateSymbol count = new AggregateSymbol("stagedAgg", "COUNT", false, null);
            aggregates.add(count);
            selectNode.setProperty(NodeConstants.Info.SELECT_CRITERIA, new CompareCriteria(count, 4, new Constant(new Integer(0))));
            selectNode.setProperty(NodeConstants.Info.IS_HAVING, Boolean.TRUE);
            stageGroup.addAsParent(selectNode);
        }
        return stageGroup;
    }

    static void stageAggregates(PlanNode groupNode, QueryMetadataInterface metadata, Collection<SingleElementSymbol> stagedGroupingSymbols, Collection<AggregateSymbol> aggregates) throws TeiidComponentException, QueryPlannerException {
        HashSet<Expression> expressions = new HashSet<Expression>();
        for (SingleElementSymbol expression : stagedGroupingSymbols) {
            expressions.add(SymbolMap.getExpression(expression));
        }
        Iterator<AggregateSymbol> iterator = aggregates.iterator();
        while (iterator.hasNext()) {
            AggregateSymbol symbol = iterator.next();
            Expression expr = symbol.getExpression();
            if (expr == null || !expressions.contains(expr)) continue;
            iterator.remove();
        }
        if (!aggregates.isEmpty()) {
            try {
                HashSet<AggregateSymbol> newAggs = new HashSet<AggregateSymbol>();
                Map<AggregateSymbol, Expression> aggMap = RulePushAggregates.buildAggregateMap(aggregates, metadata, newAggs);
                RulePushAggregates.mapExpressions(groupNode.getParent(), aggMap, metadata);
                aggregates.clear();
                aggregates.addAll(newAggs);
            }
            catch (QueryResolverException err) {
                throw new TeiidComponentException((Throwable)((Object)err));
            }
        }
    }

    private void collectSymbolsFromOtherAggregates(Collection<AggregateSymbol> allAggregates, Collection<AggregateSymbol> aggregates, PlanNode current, Set<SingleElementSymbol> stagedGroupingSymbols) {
        HashSet<AggregateSymbol> otherAggs = new HashSet<AggregateSymbol>(allAggregates);
        if (aggregates != null) {
            otherAggs.removeAll(aggregates);
        }
        PlanNode source = FrameUtil.findJoinSourceNode(current);
        for (AggregateSymbol aggregateSymbol : otherAggs) {
            for (ElementSymbol symbol : ElementCollectorVisitor.getElements((LanguageObject)aggregateSymbol, true)) {
                if (!source.getGroups().contains(symbol.getGroupSymbol())) continue;
                stagedGroupingSymbols.add(symbol);
            }
        }
    }

    private boolean canPush(PlanNode groupNode, Set<SingleElementSymbol> stagedGroupingSymbols, PlanNode planNode) {
        Set<GroupSymbol> groups = FrameUtil.findJoinSourceNode(planNode).getGroups();
        for (PlanNode parentJoin = planNode.getParent(); parentJoin != groupNode; parentJoin = parentJoin.getParent()) {
            if (parentJoin.getType() != 4 || parentJoin.hasCollectionProperty(NodeConstants.Info.NON_EQUI_JOIN_CRITERIA) || ((JoinType)parentJoin.getProperty(NodeConstants.Info.JOIN_TYPE)).isOuter()) {
                return false;
            }
            if (planNode == parentJoin.getFirstChild() ? parentJoin.hasCollectionProperty(NodeConstants.Info.LEFT_EXPRESSIONS) && !this.filterJoinColumns(stagedGroupingSymbols, groups, (List)parentJoin.getProperty(NodeConstants.Info.LEFT_EXPRESSIONS)) : parentJoin.hasCollectionProperty(NodeConstants.Info.RIGHT_EXPRESSIONS) && !this.filterJoinColumns(stagedGroupingSymbols, groups, (List)parentJoin.getProperty(NodeConstants.Info.RIGHT_EXPRESSIONS))) {
                return false;
            }
            planNode = parentJoin;
        }
        return true;
    }

    private boolean filterJoinColumns(Set<SingleElementSymbol> stagedGroupingSymbols, Set<GroupSymbol> groups, List<SingleElementSymbol> symbols) {
        for (SingleElementSymbol singleElementSymbol : symbols) {
            if (!(singleElementSymbol instanceof ElementSymbol)) {
                return false;
            }
            if (!groups.contains(((ElementSymbol)singleElementSymbol).getGroupSymbol())) continue;
            stagedGroupingSymbols.add(singleElementSymbol);
        }
        return true;
    }

    private <T extends SingleElementSymbol> Map<PlanNode, List<T>> createNodeMapping(PlanNode groupNode, Collection<T> expressions) {
        HashMap<PlanNode, List<T>> result = new HashMap<PlanNode, List<T>>();
        if (expressions == null) {
            return result;
        }
        for (SingleElementSymbol aggregateSymbol : expressions) {
            PlanNode originatingNode;
            Set<GroupSymbol> groups;
            AggregateSymbol partitionAgg;
            if (aggregateSymbol instanceof AggregateSymbol && (partitionAgg = (AggregateSymbol)aggregateSymbol).isDistinct() || (groups = GroupsUsedByElementsVisitor.getGroups(aggregateSymbol)).isEmpty() || (originatingNode = FrameUtil.findOriginatingNode(groupNode, groups)) == null) continue;
            PlanNode parentAccess = NodeEditor.findParent(originatingNode, 1, 128);
            if (parentAccess != null) {
                while (parentAccess.getType() == 16) {
                    parentAccess = parentAccess.getParent();
                }
                originatingNode = parentAccess;
            }
            if (originatingNode.getParent() == groupNode) continue;
            LinkedList<SingleElementSymbol> symbols = (LinkedList<SingleElementSymbol>)result.get(originatingNode);
            if (symbols == null) {
                symbols = new LinkedList<SingleElementSymbol>();
                result.put(originatingNode, symbols);
            }
            symbols.add(aggregateSymbol);
        }
        return result;
    }

    private static Map<AggregateSymbol, Expression> buildAggregateMap(Collection<? extends SingleElementSymbol> aggregateExpressions, QueryMetadataInterface metadata, Set<AggregateSymbol> nestedAggregates) throws QueryResolverException, TeiidComponentException {
        HashMap<AggregateSymbol, Expression> aggMap = new HashMap<AggregateSymbol, Expression>();
        for (SingleElementSymbol singleElementSymbol : aggregateExpressions) {
            AggregateSymbol sumAgg;
            AggregateSymbol countAgg;
            AggregateSymbol partitionAgg = (AggregateSymbol)singleElementSymbol;
            Expression newExpression = null;
            AggregateSymbol.Type aggFunction = partitionAgg.getAggregateFunction();
            if (aggFunction == AggregateSymbol.Type.COUNT) {
                AggregateSymbol newAgg = new AggregateSymbol("stagedAgg", "SUM", false, partitionAgg);
                Function convertFunc = new Function("convert", new Expression[]{newAgg, new Constant(DataTypeManager.getDataTypeName(partitionAgg.getType()))});
                ResolverVisitor.resolveLanguageObject(convertFunc, metadata);
                newExpression = convertFunc;
                nestedAggregates.add(partitionAgg);
            } else if (aggFunction == AggregateSymbol.Type.AVG) {
                countAgg = new AggregateSymbol("stagedAgg", "COUNT", false, partitionAgg.getExpression());
                sumAgg = new AggregateSymbol("stagedAgg", "SUM", false, partitionAgg.getExpression());
                AggregateSymbol sumSumAgg = new AggregateSymbol("stagedAgg", "SUM", false, sumAgg);
                AggregateSymbol sumCountAgg = new AggregateSymbol("stagedAgg", "SUM", false, countAgg);
                Function convertedSum = new Function("convert", new Expression[]{sumSumAgg, new Constant(DataTypeManager.getDataTypeName(partitionAgg.getType()))});
                Function convertCount = new Function("convert", new Expression[]{sumCountAgg, new Constant(DataTypeManager.getDataTypeName(partitionAgg.getType()))});
                Function divideFunc = new Function("/", new Expression[]{convertedSum, convertCount});
                ResolverVisitor.resolveLanguageObject(divideFunc, metadata);
                newExpression = divideFunc;
                nestedAggregates.add(countAgg);
                nestedAggregates.add(sumAgg);
            } else if (partitionAgg.isEnhancedNumeric()) {
                countAgg = new AggregateSymbol("stagedAgg", "COUNT", false, partitionAgg.getExpression());
                sumAgg = new AggregateSymbol("stagedAgg", "SUM", false, partitionAgg.getExpression());
                AggregateSymbol sumSqAgg = new AggregateSymbol("stagedAgg", "SUM", false, new Function("power", new Expression[]{partitionAgg.getExpression(), new Constant(2)}));
                AggregateSymbol sumSumAgg = new AggregateSymbol("stagedAgg", "SUM", false, sumAgg);
                AggregateSymbol sumCountAgg = new AggregateSymbol("stagedAgg", "SUM", false, countAgg);
                AggregateSymbol sumSumSqAgg = new AggregateSymbol("stagedAgg", "SUM", false, sumSqAgg);
                Function convertedSum = new Function("convert", new Expression[]{sumSumAgg, new Constant("double")});
                Function divideFunc = new Function("/", new Expression[]{new Function("power", new Expression[]{convertedSum, new Constant(2)}), sumCountAgg});
                Function minusFunc = new Function("-", new Expression[]{sumSumSqAgg, divideFunc});
                Expression divisor = null;
                divisor = aggFunction == AggregateSymbol.Type.STDDEV_SAMP || aggFunction == AggregateSymbol.Type.VAR_SAMP ? new Function("-", new Expression[]{sumCountAgg, new Constant(1)}) : sumCountAgg;
                Expression result = new Function("/", new Expression[]{minusFunc, divisor});
                result = aggFunction == AggregateSymbol.Type.STDDEV_POP || aggFunction == AggregateSymbol.Type.STDDEV_SAMP ? new Function("sqrt", new Expression[]{result}) : new Function("convert", new Expression[]{result, new Constant("double")});
                Constant n = new Constant(0);
                if (aggFunction == AggregateSymbol.Type.STDDEV_SAMP || aggFunction == AggregateSymbol.Type.VAR_SAMP) {
                    n = new Constant(1);
                }
                result = new SearchedCaseExpression(Arrays.asList(new CompareCriteria(sumCountAgg, 4, n)), Arrays.asList(result));
                ResolverVisitor.resolveLanguageObject(result, metadata);
                newExpression = result;
                nestedAggregates.add(countAgg);
                nestedAggregates.add(sumAgg);
                nestedAggregates.add(sumSqAgg);
            } else {
                if (aggFunction == AggregateSymbol.Type.TEXTAGG) continue;
                newExpression = new AggregateSymbol("stagedAgg", aggFunction.name(), false, partitionAgg);
                nestedAggregates.add(partitionAgg);
            }
            aggMap.put(partitionAgg, newExpression);
        }
        return aggMap;
    }

    static void mapExpressions(PlanNode node, Map<? extends Expression, ? extends Expression> exprMap, QueryMetadataInterface metadata) throws QueryPlannerException {
        while (node != null) {
            FrameUtil.convertNode(node, null, null, exprMap, metadata, true);
            switch (node.getType()) {
                case 64: 
                case 128: {
                    return;
                }
            }
            node = node.getParent();
        }
    }

    public String toString() {
        return "PushAggregates";
    }
}

