/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.processor.proc;

import java.util.ArrayList;
import java.util.List;
import org.teiid.client.plan.PlanNode;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.query.processor.ProcessorPlan;
import org.teiid.query.processor.proc.CreateCursorResultSetInstruction;
import org.teiid.query.processor.proc.ProcedurePlan;
import org.teiid.query.processor.proc.Program;
import org.teiid.query.processor.proc.RepeatedInstruction;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.SingleElementSymbol;
import org.teiid.query.sql.util.VariableContext;

public class LoopInstruction
extends CreateCursorResultSetInstruction
implements RepeatedInstruction {
    private Program loopProgram;
    private List elements;

    public LoopInstruction(Program loopProgram, String rsName, ProcessorPlan plan) {
        super(rsName, plan, false);
        this.loopProgram = loopProgram;
    }

    @Override
    public void process(ProcedurePlan procEnv) throws TeiidComponentException {
        List currentRow = procEnv.getCurrentRow(this.rsName);
        VariableContext varContext = procEnv.getCurrentVariableContext();
        if (this.elements == null) {
            List schema = procEnv.getSchema(this.rsName);
            this.elements = new ArrayList(schema.size());
            for (int i = 0; i < schema.size(); ++i) {
                SingleElementSymbol element = (SingleElementSymbol)schema.get(i);
                this.elements.add(new ElementSymbol(this.rsName + "." + element.getShortName()));
            }
        }
        for (int i = 0; i < this.elements.size(); ++i) {
            varContext.setValue((ElementSymbol)this.elements.get(i), currentRow.get(i));
        }
    }

    @Override
    public LoopInstruction clone() {
        ProcessorPlan clonedPlan = this.plan.clone();
        return new LoopInstruction((Program)this.loopProgram.clone(), this.rsName, clonedPlan);
    }

    @Override
    public String toString() {
        return "LOOP INSTRUCTION: " + this.rsName;
    }

    @Override
    public PlanNode getDescriptionProperties() {
        PlanNode props = new PlanNode("LOOP");
        props.addProperty("Query", this.plan.getDescriptionProperties());
        props.addProperty("Result Set", this.rsName);
        props.addProperty("Program", this.loopProgram.getDescriptionProperties());
        return props;
    }

    @Override
    public boolean testCondition(ProcedurePlan procEnv) throws TeiidComponentException, TeiidProcessingException {
        if (!procEnv.resultSetExists(this.rsName)) {
            procEnv.executePlan(this.plan, this.rsName, null, false);
        }
        return procEnv.iterateCursor(this.rsName);
    }

    @Override
    public Program getNestedProgram() {
        return this.loopProgram;
    }

    @Override
    public void postInstruction(ProcedurePlan procEnv) throws TeiidComponentException {
        procEnv.removeResults(this.rsName);
    }
}

