/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.processor.proc;

import java.util.ArrayList;
import java.util.List;
import org.teiid.client.plan.PlanNode;
import org.teiid.query.processor.proc.ProgramInstruction;

public class Program
implements Cloneable {
    private List<ProgramInstruction> programInstructions;
    private int counter = 0;

    public ProgramInstruction getCurrentInstruction() {
        return this.getInstructionAtIndex(this.counter);
    }

    public void incrementProgramCounter() {
        ++this.counter;
    }

    public void decrementProgramCounter() {
        --this.counter;
    }

    public void resetProgramCounter() {
        this.counter = 0;
    }

    int getProgramCounter() {
        return this.counter;
    }

    public ProgramInstruction getInstructionAt(int instructionIndex) {
        return this.getInstructionAtIndex(instructionIndex);
    }

    public void addInstruction(ProgramInstruction instruction) {
        if (instruction != null) {
            this.getProcessorInstructions().add(instruction);
        }
    }

    public void addInstructions(Program instructions) {
        if (instructions != null) {
            this.getProcessorInstructions().addAll(instructions.getProcessorInstructions());
        }
    }

    public Object clone() {
        Program program = new Program();
        program.counter = this.counter;
        if (this.programInstructions != null) {
            ArrayList<ProgramInstruction> clonedInstructions = new ArrayList<ProgramInstruction>(this.programInstructions.size());
            for (ProgramInstruction pi : this.programInstructions) {
                clonedInstructions.add(pi.clone());
            }
            program.programInstructions = clonedInstructions;
        }
        return program;
    }

    public PlanNode getDescriptionProperties() {
        PlanNode props = new PlanNode("Program");
        if (this.programInstructions != null) {
            for (int i = 0; i < this.programInstructions.size(); ++i) {
                ProgramInstruction inst = this.programInstructions.get(i);
                PlanNode childProps = inst.getDescriptionProperties();
                props.addProperty("Instruction " + i, childProps);
            }
        }
        return props;
    }

    private ProgramInstruction getInstructionAtIndex(int instructionIndex) {
        if (this.programInstructions != null && instructionIndex < this.getProcessorInstructions().size()) {
            return this.getProcessorInstructions().get(instructionIndex);
        }
        return null;
    }

    public List<ProgramInstruction> getProcessorInstructions() {
        if (this.programInstructions == null) {
            this.programInstructions = new ArrayList<ProgramInstruction>();
        }
        return this.programInstructions;
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        this.programToString(str);
        return "PROGRAM counter " + this.counter + "\n" + str.toString();
    }

    private final void programToString(StringBuilder str) {
        int instructionIndex = 0;
        ProgramInstruction inst = this.getInstructionAt(instructionIndex);
        while (inst != null) {
            Program.printLine(instructionIndex++, inst.toString(), str);
            if (instructionIndex > 1000) {
                Program.printLine(instructionIndex, "[OUTPUT TRUNCATED...]", str);
                break;
            }
            inst = this.getInstructionAt(instructionIndex);
        }
    }

    private static final void printLine(int counter, String line, StringBuilder buffer) {
        String counterStr = "" + counter + ": ";
        if (counter < 10) {
            counterStr = counterStr + " ";
        }
        if (counterStr.length() == 1) {
            counterStr = counterStr + "  ";
        } else if (counterStr.length() == 2) {
            counterStr = counterStr + " ";
        }
        buffer.append(counterStr + line + "\n");
    }
}

