/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.processor.relational;

import java.util.List;
import org.teiid.api.exception.query.ExpressionEvaluationException;
import org.teiid.common.buffer.BlockedException;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.core.util.Assertion;
import org.teiid.query.processor.relational.DependentCriteriaProcessor;
import org.teiid.query.processor.relational.RelationalNode;
import org.teiid.query.rewriter.QueryRewriter;
import org.teiid.query.sql.lang.CompareCriteria;
import org.teiid.query.sql.lang.Criteria;
import org.teiid.query.sql.lang.IsNullCriteria;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.Reference;
import org.teiid.query.sql.util.VariableContext;

public class DependentProcedureCriteriaProcessor
extends DependentCriteriaProcessor {
    private List inputReferences;
    private List inputDefaults;
    private Criteria critInProgress;

    public DependentProcedureCriteriaProcessor(RelationalNode dependentNode, Criteria dependentCriteria, List references, List defaults) throws ExpressionEvaluationException, TeiidComponentException {
        super(1, dependentNode, dependentCriteria);
        this.inputDefaults = defaults;
        this.inputReferences = references;
    }

    protected boolean prepareNextCommand(VariableContext context) throws BlockedException, TeiidComponentException, TeiidProcessingException {
        if (this.critInProgress == null) {
            this.critInProgress = this.prepareCriteria();
        }
        for (int j = 0; j < this.inputReferences.size(); ++j) {
            Reference ref = (Reference)this.inputReferences.get(j);
            context.remove(ref.getExpression());
        }
        if (this.critInProgress == QueryRewriter.FALSE_CRITERIA) {
            this.critInProgress = null;
            this.consumedCriteria();
            return false;
        }
        boolean validRow = true;
        for (Criteria crit : Criteria.separateCriteriaByAnd(this.critInProgress)) {
            Object value = null;
            boolean nullAllowed = false;
            Reference parameter = null;
            if (crit instanceof IsNullCriteria) {
                parameter = (Reference)((IsNullCriteria)crit).getExpression();
                nullAllowed = true;
            } else if (crit instanceof CompareCriteria) {
                CompareCriteria compare = (CompareCriteria)crit;
                value = compare.getRightExpression();
                parameter = (Reference)compare.getLeftExpression();
            } else {
                Assertion.failed((String)"Unknown predicate type");
            }
            if (value instanceof Expression) {
                value = this.eval.evaluate((Expression)value, null);
            }
            if (value == null && !nullAllowed) {
                validRow = false;
                break;
            }
            ElementSymbol parameterSymbol = parameter.getExpression();
            if (context.containsVariable(parameterSymbol)) {
                Object existingValue = context.getValue(parameterSymbol);
                if (value != null && !value.equals(existingValue) || value == null && existingValue != null) {
                    validRow = false;
                    break;
                }
            }
            context.setValue(parameterSymbol, value);
        }
        this.critInProgress = null;
        this.consumedCriteria();
        if (!validRow) {
            return false;
        }
        for (int j = 0; j < this.inputReferences.size(); ++j) {
            Object defaultValue = this.inputDefaults.get(j);
            Reference ref = (Reference)this.inputReferences.get(j);
            if (defaultValue == null || context.containsVariable(ref.getExpression())) continue;
            context.setValue(ref.getExpression(), defaultValue);
        }
        return true;
    }
}

