/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.processor.relational;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.teiid.api.exception.query.ExpressionEvaluationException;
import org.teiid.client.plan.PlanNode;
import org.teiid.common.buffer.BlockedException;
import org.teiid.common.buffer.BufferManager;
import org.teiid.common.buffer.TupleBatch;
import org.teiid.common.buffer.TupleBuffer;
import org.teiid.common.buffer.TupleSource;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.query.eval.Evaluator;
import org.teiid.query.function.aggregate.AggregateFunction;
import org.teiid.query.function.aggregate.Avg;
import org.teiid.query.function.aggregate.ConstantFunction;
import org.teiid.query.function.aggregate.Count;
import org.teiid.query.function.aggregate.Max;
import org.teiid.query.function.aggregate.Min;
import org.teiid.query.function.aggregate.StatsFunction;
import org.teiid.query.function.aggregate.Sum;
import org.teiid.query.function.aggregate.TextAgg;
import org.teiid.query.function.aggregate.XMLAgg;
import org.teiid.query.processor.BatchCollector;
import org.teiid.query.processor.ProcessorDataManager;
import org.teiid.query.processor.relational.RelationalNode;
import org.teiid.query.processor.relational.SortUtility;
import org.teiid.query.processor.relational.SortingFilter;
import org.teiid.query.sql.lang.OrderByItem;
import org.teiid.query.sql.symbol.AggregateSymbol;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.SingleElementSymbol;
import org.teiid.query.sql.symbol.TextLine;
import org.teiid.query.util.CommandContext;

public class GroupingNode
extends RelationalNode {
    private List sortElements;
    private List sortTypes;
    private boolean removeDuplicates;
    private int phase = 1;
    private Map elementMap;
    private List<Expression> collectedExpressions;
    private SortUtility sortUtility;
    private TupleBuffer sortBuffer;
    private TupleSource groupTupleSource;
    private AggregateFunction[] functions;
    private List lastRow;
    private List currentGroupTuple;
    private static final int COLLECTION = 1;
    private static final int SORT = 2;
    private static final int GROUP = 3;

    public GroupingNode(int nodeID) {
        super(nodeID);
    }

    @Override
    public void reset() {
        super.reset();
        this.phase = 1;
        this.sortUtility = null;
        this.sortBuffer = null;
        this.lastRow = null;
        this.currentGroupTuple = null;
        if (this.functions != null) {
            for (AggregateFunction function : this.functions) {
                function.reset();
            }
        }
    }

    public void setRemoveDuplicates(boolean removeDuplicates) {
        this.removeDuplicates = removeDuplicates;
    }

    public void setGroupingElements(List groupingElements) {
        this.sortElements = groupingElements;
        if (groupingElements != null) {
            this.sortTypes = Collections.nCopies(groupingElements.size(), true);
        }
    }

    @Override
    public void initialize(CommandContext context, BufferManager bufferManager, ProcessorDataManager dataMgr) {
        super.initialize(context, bufferManager, dataMgr);
        if (this.functions != null) {
            return;
        }
        List sourceElements = this.getChildren()[0].getElements();
        this.elementMap = GroupingNode.createLookupMap(sourceElements);
        if (this.sortElements != null) {
            this.collectedExpressions = new ArrayList<Expression>(this.sortElements.size() + this.getElements().size());
            this.collectedExpressions.addAll(this.sortElements);
        } else {
            this.collectedExpressions = new ArrayList<Expression>(this.getElements().size());
        }
        this.functions = new AggregateFunction[this.getElements().size()];
        for (int i = 0; i < this.getElements().size(); ++i) {
            SingleElementSymbol symbol = (SingleElementSymbol)this.getElements().get(i);
            Class outputType = symbol.getType();
            Class inputType = symbol.getType();
            if (symbol instanceof AggregateSymbol) {
                AggregateSymbol aggSymbol = (AggregateSymbol)symbol;
                if (aggSymbol.getExpression() == null) {
                    this.functions[i] = new Count();
                } else {
                    Expression ex = aggSymbol.getExpression();
                    inputType = ex.getType();
                    int index = this.collectExpression(ex);
                    AggregateSymbol.Type function = aggSymbol.getAggregateFunction();
                    switch (function) {
                        case COUNT: {
                            this.functions[i] = new Count();
                            break;
                        }
                        case SUM: {
                            this.functions[i] = new Sum();
                            break;
                        }
                        case AVG: {
                            this.functions[i] = new Avg();
                            break;
                        }
                        case MIN: {
                            this.functions[i] = new Min();
                            break;
                        }
                        case MAX: {
                            this.functions[i] = new Max();
                            break;
                        }
                        case XMLAGG: {
                            this.functions[i] = new XMLAgg(context);
                            break;
                        }
                        case TEXTAGG: {
                            this.functions[i] = new TextAgg(context, (TextLine)ex);
                            break;
                        }
                        default: {
                            this.functions[i] = new StatsFunction(function);
                        }
                    }
                    if (aggSymbol.isDistinct() && !function.equals("MIN") && !function.equals("MAX")) {
                        SortingFilter filter = new SortingFilter(this.functions[i], this.getBufferManager(), this.getConnectionID(), true);
                        ElementSymbol element = new ElementSymbol("val");
                        element.setType(inputType);
                        filter.setElements(Arrays.asList(element));
                        this.functions[i] = filter;
                    } else if (aggSymbol.getOrderBy() != null) {
                        int[] orderIndecies = new int[aggSymbol.getOrderBy().getOrderByItems().size()];
                        ArrayList<OrderByItem> orderByItems = new ArrayList<OrderByItem>(orderIndecies.length);
                        ArrayList<ElementSymbol> schema = new ArrayList<ElementSymbol>(orderIndecies.length + 1);
                        ElementSymbol element = new ElementSymbol("val");
                        element.setType(inputType);
                        schema.add(element);
                        ListIterator<OrderByItem> iterator = aggSymbol.getOrderBy().getOrderByItems().listIterator();
                        while (iterator.hasNext()) {
                            OrderByItem item = iterator.next();
                            orderIndecies[iterator.previousIndex()] = this.collectExpression(item.getSymbol());
                            element = new ElementSymbol(String.valueOf(iterator.previousIndex()));
                            element.setType(inputType);
                            schema.add(element);
                            OrderByItem newItem = item.clone();
                            newItem.setSymbol(element);
                            orderByItems.add(newItem);
                        }
                        SortingFilter filter = new SortingFilter(this.functions[i], this.getBufferManager(), this.getConnectionID(), false);
                        filter.setIndecies(orderIndecies);
                        filter.setElements(schema);
                        filter.setSortItems(orderByItems);
                        this.functions[i] = filter;
                    }
                    this.functions[i].setExpressionIndex(index);
                }
            } else {
                this.functions[i] = new ConstantFunction();
                this.functions[i].setExpressionIndex(this.collectedExpressions.indexOf(symbol));
            }
            this.functions[i].initialize(outputType, inputType);
        }
    }

    private int collectExpression(Expression ex) {
        int index = this.collectedExpressions.indexOf(ex);
        if (index == -1) {
            index = this.collectedExpressions.size();
            this.collectedExpressions.add(ex);
        }
        return index;
    }

    AggregateFunction[] getFunctions() {
        return this.functions;
    }

    @Override
    public TupleBatch nextBatchDirect() throws BlockedException, TeiidComponentException, TeiidProcessingException {
        if (this.phase == 1) {
            this.collectionPhase();
        }
        if (this.phase == 2) {
            this.sortPhase();
        }
        if (this.phase == 3) {
            return this.groupPhase();
        }
        this.terminateBatches();
        return this.pullBatch();
    }

    public TupleSource getCollectionTupleSource() {
        RelationalNode sourceNode = this.getChildren()[0];
        return new BatchCollector.BatchProducerTupleSource(sourceNode){
            Evaluator eval;
            {
                this.eval = new Evaluator(GroupingNode.this.elementMap, GroupingNode.this.getDataManager(), GroupingNode.this.getContext());
            }

            @Override
            protected List updateTuple(List tuple) throws ExpressionEvaluationException, BlockedException, TeiidComponentException {
                int columns = GroupingNode.this.collectedExpressions.size();
                ArrayList<Object> exprTuple = new ArrayList<Object>(columns);
                for (int col = 0; col < columns; ++col) {
                    Object value = this.eval.evaluate((Expression)GroupingNode.this.collectedExpressions.get(col), tuple);
                    exprTuple.add(value);
                }
                return exprTuple;
            }
        };
    }

    private void collectionPhase() {
        if (this.sortElements == null) {
            this.groupTupleSource = this.getCollectionTupleSource();
            this.phase = 3;
        } else {
            this.sortUtility = new SortUtility(this.getCollectionTupleSource(), this.sortElements, this.sortTypes, this.removeDuplicates ? SortUtility.Mode.DUP_REMOVE_SORT : SortUtility.Mode.SORT, this.getBufferManager(), this.getConnectionID(), this.collectedExpressions);
            this.phase = 2;
        }
    }

    private void sortPhase() throws BlockedException, TeiidComponentException, TeiidProcessingException {
        this.sortBuffer = this.sortUtility.sort();
        this.sortBuffer.setForwardOnly(true);
        this.groupTupleSource = this.sortBuffer.createIndexedTupleSource();
        this.phase = 3;
    }

    private TupleBatch groupPhase() throws BlockedException, TeiidComponentException, TeiidProcessingException {
        int i;
        ArrayList<Object> row;
        while (true) {
            if (this.currentGroupTuple == null) {
                this.currentGroupTuple = this.groupTupleSource.nextTuple();
                if (this.currentGroupTuple == null) break;
            }
            if (this.lastRow == null) {
                this.lastRow = this.currentGroupTuple;
            } else if (!this.sameGroup(this.currentGroupTuple, this.lastRow)) {
                row = new ArrayList<Object>(this.functions.length);
                for (i = 0; i < this.functions.length; ++i) {
                    row.add(this.functions[i].getResult());
                    this.functions[i].reset();
                }
                this.lastRow = this.currentGroupTuple;
                this.addBatchRow(row);
                if (this.isBatchFull()) {
                    return this.pullBatch();
                }
            }
            this.updateAggregates(this.currentGroupTuple);
            this.currentGroupTuple = null;
        }
        if (this.lastRow != null || this.sortElements == null) {
            row = new ArrayList(this.functions.length);
            for (i = 0; i < this.functions.length; ++i) {
                row.add(this.functions[i].getResult());
            }
            this.addBatchRow(row);
        }
        this.terminateBatches();
        return this.pullBatch();
    }

    private boolean sameGroup(List newTuple, List oldTuple) {
        if (this.sortElements == null) {
            return true;
        }
        for (int i = this.sortElements.size() - 1; i >= 0; --i) {
            Object oldValue = oldTuple.get(i);
            Object newValue = newTuple.get(i);
            if (oldValue == null) {
                if (newValue == null) continue;
                return false;
            }
            if (newValue == null) {
                return false;
            }
            if (oldValue.equals(newValue)) continue;
            return false;
        }
        return true;
    }

    private void updateAggregates(List tuple) throws TeiidComponentException, TeiidProcessingException {
        for (int i = 0; i < this.functions.length; ++i) {
            this.functions[i].addInput(tuple);
        }
    }

    @Override
    public void closeDirect() {
        if (this.sortBuffer != null) {
            this.sortBuffer.remove();
            this.sortBuffer = null;
        }
    }

    @Override
    protected void getNodeString(StringBuffer str) {
        super.getNodeString(str);
        str.append(this.sortElements);
    }

    @Override
    public Object clone() {
        GroupingNode clonedNode = new GroupingNode(super.getID());
        super.copy(this, clonedNode);
        clonedNode.sortElements = this.sortElements;
        clonedNode.sortTypes = this.sortTypes;
        clonedNode.removeDuplicates = this.removeDuplicates;
        return clonedNode;
    }

    @Override
    public PlanNode getDescriptionProperties() {
        PlanNode props = super.getDescriptionProperties();
        if (this.sortElements != null) {
            int elements = this.sortElements.size();
            ArrayList<String> groupCols = new ArrayList<String>(elements);
            for (int i = 0; i < elements; ++i) {
                groupCols.add(this.sortElements.get(i).toString());
            }
            props.addProperty("Grouping Columns", groupCols);
        }
        props.addProperty("Sort Mode", String.valueOf(this.removeDuplicates));
        return props;
    }
}

