/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.processor.relational;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.teiid.client.plan.PlanNode;
import org.teiid.common.buffer.BlockedException;
import org.teiid.common.buffer.BufferManager;
import org.teiid.common.buffer.TupleBatch;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.query.analysis.AnalysisRecord;
import org.teiid.query.metadata.TempMetadataAdapter;
import org.teiid.query.processor.CollectionTupleSource;
import org.teiid.query.processor.ProcessorDataManager;
import org.teiid.query.processor.ProcessorPlan;
import org.teiid.query.processor.QueryProcessor;
import org.teiid.query.processor.relational.AccessNode;
import org.teiid.query.processor.relational.DependentAccessNode;
import org.teiid.query.processor.relational.PlanExecutionNode;
import org.teiid.query.processor.relational.ProjectIntoNode;
import org.teiid.query.processor.relational.RelationalNode;
import org.teiid.query.sql.LanguageObject;
import org.teiid.query.sql.lang.Create;
import org.teiid.query.sql.lang.Insert;
import org.teiid.query.sql.lang.QueryCommand;
import org.teiid.query.sql.lang.WithQueryCommand;
import org.teiid.query.tempdata.TempTableStore;
import org.teiid.query.util.CommandContext;

public class RelationalPlan
extends ProcessorPlan {
    private RelationalNode root;
    private List outputCols;
    private List<WithQueryCommand> with;
    private List<WithQueryCommand> withToProcess;
    private QueryProcessor withProcessor;
    private TempTableStore tempTableStore;
    private boolean multisourceUpdate;

    public RelationalPlan(RelationalNode node) {
        this.root = node;
    }

    public RelationalNode getRootNode() {
        return this.root;
    }

    public void setRootNode(RelationalNode root) {
        this.root = root;
    }

    public void setWith(List<WithQueryCommand> with) {
        this.with = with;
    }

    @Override
    public void initialize(CommandContext context, ProcessorDataManager dataMgr, BufferManager bufferMgr) {
        if (this.with != null) {
            context = context.clone();
            this.tempTableStore = new TempTableStore(context.getConnectionID());
            this.tempTableStore.setParentTempTableStore(context.getTempTableStore());
            context.setTempTableStore(this.tempTableStore);
            for (WithQueryCommand withCommand : this.with) {
                withCommand.getCommand().getProcessorPlan().initialize(context, dataMgr, bufferMgr);
            }
        }
        this.setContext(context);
        this.connectExternal(this.root, context, dataMgr, bufferMgr);
    }

    private void connectExternal(RelationalNode node, CommandContext context, ProcessorDataManager dataMgr, BufferManager bufferMgr) {
        node.initialize(context, bufferMgr, dataMgr);
        RelationalNode[] children = node.getChildren();
        for (int i = 0; i < children.length && children[i] != null; ++i) {
            this.connectExternal(children[i], context, dataMgr, bufferMgr);
        }
    }

    @Override
    public List getOutputElements() {
        return this.outputCols;
    }

    @Override
    public void open() throws TeiidComponentException, TeiidProcessingException {
        if (this.with != null) {
            if (this.withToProcess == null) {
                this.withToProcess = new LinkedList<WithQueryCommand>(this.with);
            }
            while (!this.withToProcess.isEmpty()) {
                TupleBatch batch;
                WithQueryCommand withCommand = this.withToProcess.get(0);
                if (this.withProcessor == null) {
                    ProcessorPlan plan = withCommand.getCommand().getProcessorPlan();
                    this.withProcessor = new QueryProcessor(plan, this.getContext(), this.root.getBufferManager(), this.root.getDataManager());
                    Create create = new Create();
                    create.setElementSymbolsAsColumns(withCommand.getColumns());
                    create.setTable(withCommand.getGroupSymbol());
                    this.root.getDataManager().registerRequest(this.getContext(), create, TempMetadataAdapter.TEMP_MODEL.getID(), null, 0);
                }
                do {
                    batch = this.withProcessor.nextBatch();
                    Insert insert = new Insert(withCommand.getGroupSymbol(), withCommand.getColumns(), null);
                    insert.setTupleSource(new CollectionTupleSource(batch.getTuples().iterator()));
                    this.root.getDataManager().registerRequest(this.getContext(), insert, TempMetadataAdapter.TEMP_MODEL.getID(), null, 0);
                } while (!batch.getTerminationFlag());
                this.tempTableStore.setUpdatable(withCommand.getGroupSymbol().getCanonicalName(), false);
                this.withToProcess.remove(0);
                this.withProcessor = null;
            }
        }
        this.root.open();
    }

    @Override
    public TupleBatch nextBatch() throws BlockedException, TeiidComponentException, TeiidProcessingException {
        return this.root.nextBatch();
    }

    @Override
    public void close() throws TeiidComponentException {
        if (this.with != null) {
            for (WithQueryCommand withCommand : this.with) {
                withCommand.getCommand().getProcessorPlan().close();
            }
            if (this.tempTableStore != null) {
                this.tempTableStore.removeTempTables();
            }
        }
        this.root.close();
    }

    @Override
    public void reset() {
        super.reset();
        this.root.reset();
        if (this.with != null) {
            this.withToProcess = null;
            this.withProcessor = null;
            for (WithQueryCommand withCommand : this.with) {
                withCommand.getCommand().getProcessorPlan().reset();
            }
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.with != null) {
            sb.append("WITH");
            for (WithQueryCommand withCommand : this.with) {
                sb.append("\n");
                sb.append(withCommand.getCommand().getProcessorPlan());
            }
        }
        sb.append(this.root.toString());
        return sb.toString();
    }

    @Override
    public RelationalPlan clone() {
        RelationalPlan plan = new RelationalPlan((RelationalNode)this.root.clone());
        plan.setOutputElements(this.outputCols);
        if (this.with != null) {
            ArrayList<WithQueryCommand> newWith = LanguageObject.Util.deepClone(this.with, WithQueryCommand.class);
            for (WithQueryCommand withQueryCommand : newWith) {
                withQueryCommand.getCommand().setProcessorPlan(withQueryCommand.getCommand().getProcessorPlan().clone());
            }
            plan.setWith(newWith);
        }
        return plan;
    }

    @Override
    public PlanNode getDescriptionProperties() {
        PlanNode node = this.root.getDescriptionProperties();
        if (this.with != null) {
            AnalysisRecord.addLanaguageObjects(node, "With", this.with);
        }
        return node;
    }

    public void setOutputElements(List outputCols) {
        this.outputCols = outputCols;
    }

    public void setMultisourceUpdate(boolean multisourceUpdate) {
        this.multisourceUpdate = multisourceUpdate;
    }

    @Override
    public boolean requiresTransaction(boolean transactionalReads) {
        if (this.multisourceUpdate) {
            return true;
        }
        if (this.with != null) {
            if (transactionalReads) {
                return true;
            }
            for (WithQueryCommand withCommand : this.with) {
                if (!withCommand.getCommand().getProcessorPlan().requiresTransaction(transactionalReads)) continue;
                return true;
            }
        }
        return this.requiresTransaction(transactionalReads, this.root);
    }

    boolean requiresTransaction(boolean transactionalReads, RelationalNode node) {
        if (node instanceof DependentAccessNode) {
            return transactionalReads || !(((DependentAccessNode)node).getCommand() instanceof QueryCommand);
        }
        if (node instanceof ProjectIntoNode) {
            if (((ProjectIntoNode)node).getMode() == ProjectIntoNode.Mode.ITERATOR) {
                return transactionalReads;
            }
            return true;
        }
        if (node instanceof AccessNode) {
            return false;
        }
        if (transactionalReads) {
            return true;
        }
        if (node instanceof PlanExecutionNode) {
            ProcessorPlan plan = ((PlanExecutionNode)node).getProcessorPlan();
            return plan.requiresTransaction(transactionalReads);
        }
        for (RelationalNode child : node.getChildren()) {
            if (child == null || !this.requiresTransaction(transactionalReads, child)) continue;
            return true;
        }
        return false;
    }
}

