/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.processor.xml;

import java.util.List;
import java.util.Map;
import org.teiid.common.buffer.BlockedException;
import org.teiid.common.buffer.BufferManager;
import org.teiid.common.buffer.IndexedTupleSource;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.logging.LogManager;
import org.teiid.query.QueryPlugin;
import org.teiid.query.mapping.xml.ResultSetInfo;
import org.teiid.query.processor.BatchIterator;
import org.teiid.query.processor.ProcessorDataManager;
import org.teiid.query.processor.ProcessorPlan;
import org.teiid.query.processor.QueryProcessor;
import org.teiid.query.processor.xml.PlanExecutor;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.util.VariableContext;
import org.teiid.query.util.CommandContext;

class RelationalPlanExecutor
implements PlanExecutor {
    QueryProcessor internalProcessor;
    ResultSetInfo resultInfo;
    BufferManager bufferMgr;
    boolean endOfRows = false;
    IndexedTupleSource tupleSource;
    List currentRow;
    int currentRowNumber = 0;

    public RelationalPlanExecutor(ResultSetInfo resultInfo, CommandContext context, ProcessorDataManager dataMgr, BufferManager bufferMgr) throws TeiidComponentException {
        this.resultInfo = resultInfo;
        this.bufferMgr = bufferMgr;
        ProcessorPlan plan = resultInfo.getPlan();
        CommandContext subContext = context.clone();
        subContext.pushVariableContext(new VariableContext());
        this.internalProcessor = new QueryProcessor(plan, subContext, bufferMgr, dataMgr);
    }

    @Override
    public List getOutputElements() throws TeiidComponentException {
        ProcessorPlan plan = this.resultInfo.getPlan();
        return plan.getOutputElements();
    }

    @Override
    public void execute(Map referenceValues) throws TeiidComponentException, BlockedException, TeiidProcessingException {
        if (this.tupleSource == null) {
            this.setReferenceValues(referenceValues);
            this.tupleSource = new BatchIterator(this.internalProcessor);
        }
        this.tupleSource.hasNext();
    }

    void setReferenceValues(Map<ElementSymbol, Object> referencesValues) {
        if (referencesValues == null || referencesValues.isEmpty()) {
            return;
        }
        for (Map.Entry<ElementSymbol, Object> entry : referencesValues.entrySet()) {
            this.internalProcessor.getContext().getVariableContext().setValue(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public List nextRow() throws TeiidComponentException, TeiidProcessingException {
        if (!this.endOfRows) {
            this.currentRow = this.tupleSource.nextTuple();
            ++this.currentRowNumber;
            if (this.currentRow != null && this.resultInfo.getUserRowLimit() > 0 && this.currentRowNumber > this.resultInfo.getUserRowLimit()) {
                if (this.resultInfo.exceptionOnRowlimit()) {
                    throw new TeiidProcessingException(QueryPlugin.Util.getString("row_limit_passed", new Object[]{new Integer(this.resultInfo.getUserRowLimit()), this.resultInfo.getResultSetName()}));
                }
                this.currentRow = null;
            }
        }
        if (this.currentRow == null) {
            this.endOfRows = true;
        }
        return this.currentRow;
    }

    @Override
    public List currentRow() throws TeiidComponentException, TeiidProcessingException {
        if (this.currentRow == null && !this.endOfRows) {
            return this.nextRow();
        }
        return this.currentRow;
    }

    @Override
    public void close() throws TeiidComponentException {
        this.internalProcessor.closeProcessing();
        LogManager.logTrace((String)"org.teiid.PROCESSOR.XML_PLAN", (Object[])new Object[]{"closed executor", this.resultInfo.getResultSetName()});
    }
}

