/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.processor.xml;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.teiid.client.plan.PlanNode;
import org.teiid.common.buffer.BlockedException;
import org.teiid.common.buffer.BufferManager;
import org.teiid.common.buffer.TupleBatch;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.core.types.DataTypeManager;
import org.teiid.core.types.XMLType;
import org.teiid.logging.LogManager;
import org.teiid.query.QueryPlugin;
import org.teiid.query.analysis.AnalysisRecord;
import org.teiid.query.processor.ProcessorDataManager;
import org.teiid.query.processor.ProcessorPlan;
import org.teiid.query.processor.xml.DocumentInProgress;
import org.teiid.query.processor.xml.ProcessorInstruction;
import org.teiid.query.processor.xml.Program;
import org.teiid.query.processor.xml.ProgramUtil;
import org.teiid.query.processor.xml.XMLContext;
import org.teiid.query.processor.xml.XMLProcessorEnvironment;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.query.tempdata.TempTableStore;
import org.teiid.query.util.CommandContext;
import org.xml.sax.Attributes;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class XMLPlan
extends ProcessorPlan {
    private XMLProcessorEnvironment env;
    private Program originalProgram;
    XMLContext context = new XMLContext();
    private ProcessorDataManager dataMgr;
    private BufferManager bufferMgr;
    private int nextBatchCount = 1;
    private Collection<SQLXML> xmlSchemas;
    public static final String XML_TREE_FORMAT = "Tree";
    public static final String XML_COMPACT_FORMAT = "Compact";

    public XMLPlan(XMLProcessorEnvironment env) {
        this.env = env;
        this.originalProgram = this.env.getCurrentProgram();
    }

    @Override
    public void initialize(CommandContext context, ProcessorDataManager dataMgr, BufferManager bufferMgr) {
        context = context.clone();
        this.setContext(context);
        TempTableStore tempTableStore = new TempTableStore(context.getConnectionID());
        tempTableStore.setParentTempTableStore(context.getTempTableStore());
        context.setTempTableStore(tempTableStore);
        this.dataMgr = dataMgr;
        this.bufferMgr = bufferMgr;
        this.env.initialize(context, this.dataMgr, this.bufferMgr);
    }

    @Override
    public void reset() {
        super.reset();
        this.nextBatchCount = 1;
        this.env = (XMLProcessorEnvironment)this.env.clone();
        LogManager.logTrace((String)"org.teiid.PROCESSOR.XML_PLAN", (Object[])new Object[]{"XMLPlan reset"});
    }

    public ProcessorDataManager getDataManager() {
        return this.dataMgr;
    }

    @Override
    public List getOutputElements() {
        ArrayList<ElementSymbol> output = new ArrayList<ElementSymbol>(1);
        ElementSymbol xml = new ElementSymbol("xml");
        xml.setType(DataTypeManager.DefaultDataClasses.XML);
        output.add(xml);
        return output;
    }

    @Override
    public void open() throws TeiidComponentException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TupleBatch nextBatch() throws TeiidComponentException, TeiidProcessingException, BlockedException {
        ProcessorInstruction inst = this.env.getCurrentInstruction();
        while (inst != null) {
            LogManager.logTrace((String)"org.teiid.PROCESSOR.XML_PLAN", (Object[])new Object[]{"Executing instruction", inst});
            this.context = inst.process(this.env, this.context);
            DocumentInProgress doc = this.env.getDocumentInProgress();
            if (doc != null && doc.isFinished()) {
                this.env.setDocumentInProgress(null);
                XMLType xml = new XMLType((SQLXML)doc.getSQLXML());
                if (this.getContext().validateXML()) {
                    Reader reader;
                    try {
                        reader = xml.getCharacterStream();
                    }
                    catch (SQLException e) {
                        throw new TeiidComponentException((Throwable)e);
                    }
                    try {
                        this.validateDoc(reader);
                    }
                    finally {
                        try {
                            reader.close();
                        }
                        catch (IOException e) {}
                    }
                }
                TupleBatch batch = new TupleBatch(this.nextBatchCount++, Arrays.asList(Arrays.asList(xml)));
                return batch;
            }
            inst = this.env.getCurrentInstruction();
        }
        TupleBatch batch = new TupleBatch(this.nextBatchCount++, Collections.EMPTY_LIST);
        batch.setTerminationFlag(true);
        return batch;
    }

    public void setXMLSchemas(Collection<SQLXML> xmlSchema) {
        this.xmlSchemas = xmlSchema;
    }

    public Collection<SQLXML> getXMLSchemas() {
        return this.xmlSchemas;
    }

    private void validateDoc(Reader xmlStream) throws TeiidComponentException {
        if (this.xmlSchemas == null || this.xmlSchemas.isEmpty()) {
            TeiidComponentException noSchema = new TeiidComponentException("ERR.015.006.0042", QueryPlugin.Util.getString("ERR.015.006.0042"));
            this.addWarning((TeiidException)((Object)noSchema));
            return;
        }
        HashMap nameSpaceMap = null;
        try {
            nameSpaceMap = this.getTargetNameSpaces(this.xmlSchemas);
        }
        catch (TeiidException me) {
            this.addWarning(me);
            nameSpaceMap = new HashMap();
        }
        SAXParserFactory spf = SAXParserFactory.newInstance();
        spf.setNamespaceAware(true);
        spf.setValidating(true);
        XMLReader reader = null;
        try {
            SAXParser parser = spf.newSAXParser();
            parser.setProperty("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
            parser.setProperty("http://java.sun.com/xml/jaxp/properties/schemaSource", nameSpaceMap.keySet().toArray());
            reader = parser.getXMLReader();
        }
        catch (SAXException err) {
            throw new TeiidComponentException((Throwable)err);
        }
        catch (ParserConfigurationException err) {
            throw new TeiidComponentException((Throwable)err);
        }
        MultiEntityResolver xmlEntityResolver = new MultiEntityResolver(nameSpaceMap);
        reader.setEntityResolver(xmlEntityResolver);
        MMErrorHandler errorHandler = new MMErrorHandler();
        reader.setErrorHandler(errorHandler);
        InputSource source = new InputSource(xmlStream);
        try {
            reader.parse(source);
        }
        catch (SAXException se) {
            throw new TeiidComponentException((Throwable)se);
        }
        catch (IOException io) {
            throw new TeiidComponentException((Throwable)io);
        }
        if (errorHandler.hasExceptions()) {
            List<TeiidException> exceptionList = errorHandler.getExceptionList();
            Iterator<TeiidException> i = exceptionList.iterator();
            while (i.hasNext()) {
                this.addWarning(i.next());
            }
        }
    }

    private HashMap getTargetNameSpaces(Collection<SQLXML> schemas) throws TeiidException {
        SAXParser parser;
        HashMap<String, SQLXML> nameSpaceMap = new HashMap<String, SQLXML>();
        SAXParserFactory spf = SAXParserFactory.newInstance();
        spf.setNamespaceAware(true);
        try {
            parser = spf.newSAXParser();
        }
        catch (ParserConfigurationException err) {
            throw new TeiidException((Throwable)err);
        }
        catch (SAXException err) {
            throw new TeiidException((Throwable)err);
        }
        PeekContentHandler pch = new PeekContentHandler();
        for (SQLXML schema : schemas) {
            InputStream is;
            try {
                is = schema.getBinaryStream();
            }
            catch (SQLException e) {
                throw new TeiidComponentException((Throwable)e);
            }
            InputSource source = new InputSource(is);
            pch.targetNameSpace = null;
            try {
                parser.parse(source, (DefaultHandler)pch);
            }
            catch (SAXException err) {
                throw new TeiidException((Throwable)err);
            }
            catch (IOException err) {
                throw new TeiidComponentException((Throwable)err);
            }
            finally {
                try {
                    is.close();
                }
                catch (IOException e) {}
            }
            if (pch.targetNameSpace == null) continue;
            nameSpaceMap.put(pch.targetNameSpace, schema);
        }
        return nameSpaceMap;
    }

    public void setXMLFormat(String xmlFormat) {
        this.env.setXMLFormat(xmlFormat);
    }

    @Override
    public void close() throws TeiidComponentException {
    }

    public String toString() {
        try {
            return "XMLPlan:\n" + ProgramUtil.programToString(this.originalProgram);
        }
        catch (Exception e) {
            e.printStackTrace();
            LogManager.logWarning((String)"org.teiid.PROCESSOR.XML_PLAN", (Throwable)e, (String)QueryPlugin.Util.getString("ERR.015.006.0001"));
            return "XMLPlan";
        }
    }

    @Override
    public XMLPlan clone() {
        XMLPlan xmlPlan = new XMLPlan((XMLProcessorEnvironment)this.env.clone());
        xmlPlan.xmlSchemas = this.xmlSchemas;
        return xmlPlan;
    }

    @Override
    public PlanNode getDescriptionProperties() {
        PlanNode node = this.originalProgram.getDescriptionProperties();
        node.addProperty("Output Columns", AnalysisRecord.getOutputColumnProperties(this.getOutputElements()));
        return node;
    }

    public GroupSymbol getDocumentGroup() {
        return this.env.getDocumentGroup();
    }

    public Program getOriginalProgram() {
        return this.originalProgram;
    }

    private static class MMErrorHandler
    implements ErrorHandler {
        ArrayList<TeiidException> exceptionList = null;

        private MMErrorHandler() {
        }

        private void addException(TeiidException me) {
            if (this.exceptionList == null) {
                this.exceptionList = new ArrayList();
            }
            this.exceptionList.add(me);
        }

        public List<TeiidException> getExceptionList() {
            return this.exceptionList;
        }

        public boolean hasExceptions() {
            return this.exceptionList != null && !this.exceptionList.isEmpty();
        }

        @Override
        public void error(SAXParseException ex) {
            this.addException((TeiidException)((Object)new TeiidComponentException("ERR.015.006.0049", QueryPlugin.Util.getString("ERR.015.006.0048", new Object[]{ex.getMessage()}))));
        }

        @Override
        public void fatalError(SAXParseException ex) {
            this.addException((TeiidException)((Object)new TeiidComponentException("ERR.015.006.0048", QueryPlugin.Util.getString("ERR.015.006.0048", new Object[]{ex.getMessage()}))));
        }

        @Override
        public void warning(SAXParseException ex) {
            this.addException((TeiidException)((Object)new TeiidComponentException("ERR.015.006.0049", QueryPlugin.Util.getString("ERR.015.006.0048", new Object[]{ex.getMessage()}))));
        }
    }

    private static class MultiEntityResolver
    implements EntityResolver {
        private HashMap schemaMap;

        public MultiEntityResolver(HashMap map) {
            this.schemaMap = map;
        }

        @Override
        public InputSource resolveEntity(String publicId, String systemId) {
            String xsd = (String)this.schemaMap.get(systemId);
            if (xsd != null) {
                StringReader reader = new StringReader(xsd);
                InputSource source = new InputSource(reader);
                return source;
            }
            return null;
        }
    }

    static class PeekContentHandler
    extends DefaultHandler {
        private static final String TARGETNAMESPACE = "targetNamespace";
        String targetNameSpace = null;

        PeekContentHandler() {
        }

        @Override
        public void startElement(String namespace, String name, String qualifiedName, Attributes attrs) throws SAXException {
            for (int i = 0; i < attrs.getLength(); ++i) {
                if (!attrs.getQName(i).equals(TARGETNAMESPACE)) continue;
                this.targetNameSpace = attrs.getValue(i);
            }
        }
    }
}

