/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.resolver.command;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.teiid.api.exception.query.QueryMetadataException;
import org.teiid.api.exception.query.QueryResolverException;
import org.teiid.core.TeiidComponentException;
import org.teiid.metadata.BaseColumn;
import org.teiid.metadata.Column;
import org.teiid.query.QueryPlugin;
import org.teiid.query.metadata.TempMetadataAdapter;
import org.teiid.query.metadata.TempMetadataID;
import org.teiid.query.resolver.CommandResolver;
import org.teiid.query.resolver.util.ResolverUtil;
import org.teiid.query.resolver.util.ResolverVisitor;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.lang.Create;
import org.teiid.query.sql.lang.Drop;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.GroupSymbol;

public class TempTableResolver
implements CommandResolver {
    @Override
    public void resolveCommand(Command command, TempMetadataAdapter metadata, boolean resolveNullLiterals) throws QueryMetadataException, QueryResolverException, TeiidComponentException {
        if (command.getType() == 11) {
            Create create = (Create)command;
            GroupSymbol group = create.getTable();
            if (group.getName().indexOf(".") != -1) {
                throw new QueryResolverException(QueryPlugin.Util.getString("TempTableResolver.unqualified_name_required", new Object[]{group.getName()}));
            }
            Collection exitsingGroups = metadata.getMetadata().getGroupsForPartialName(group.getName());
            if (!exitsingGroups.isEmpty()) {
                throw new QueryResolverException(QueryPlugin.Util.getString("TempTableResolver.table_already_exists", new Object[]{group.getName()}));
            }
            TempMetadataID id = metadata.getMetadataStore().getTempGroupID(group.getName());
            if (id != null && !metadata.isTemporaryTable(id)) {
                throw new QueryResolverException(QueryPlugin.Util.getString("TempTableResolver.table_already_exists", new Object[]{group.getName()}));
            }
            TempMetadataID tempTable = ResolverUtil.addTempTable(metadata, group, create.getColumnSymbols());
            ResolverUtil.resolveGroup(create.getTable(), metadata);
            HashSet<GroupSymbol> groups = new HashSet<GroupSymbol>();
            groups.add(create.getTable());
            ResolverVisitor.resolveLanguageObject(command, groups, metadata);
            TempTableResolver.addAdditionalMetadata(create, tempTable);
        } else if (command.getType() == 12) {
            ResolverUtil.resolveGroup(((Drop)command).getTable(), metadata);
        }
    }

    public static void addAdditionalMetadata(Create create, TempMetadataID tempTable) {
        if (!create.getPrimaryKey().isEmpty()) {
            ArrayList<TempMetadataID> primaryKey = new ArrayList<TempMetadataID>(create.getPrimaryKey().size());
            for (ElementSymbol symbol : create.getPrimaryKey()) {
                primaryKey.add((TempMetadataID)symbol.getMetadataID());
            }
            tempTable.setPrimaryKey(primaryKey);
        }
        for (int i = 0; i < create.getColumns().size(); ++i) {
            Column column = create.getColumns().get(i);
            TempMetadataID tid = tempTable.getElements().get(i);
            if (column.isAutoIncremented()) {
                tid.setAutoIncrement(true);
            }
            if (column.getNullType() != BaseColumn.NullType.No_Nulls) continue;
            tid.setNotNull(true);
        }
    }
}

