/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.resolver.util;

import java.util.Arrays;
import java.util.List;
import org.teiid.api.exception.query.QueryMetadataException;
import org.teiid.api.exception.query.QueryParserException;
import org.teiid.api.exception.query.QueryResolverException;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.util.ArgCheck;
import org.teiid.query.QueryPlugin;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.parser.QueryParser;
import org.teiid.query.resolver.util.ResolverUtil;
import org.teiid.query.resolver.util.ResolverVisitor;
import org.teiid.query.sql.LanguageObject;
import org.teiid.query.sql.LanguageVisitor;
import org.teiid.query.sql.lang.SPParameter;
import org.teiid.query.sql.lang.StoredProcedure;
import org.teiid.query.sql.navigator.DeepPreOrderNavigator;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.query.sql.symbol.Reference;

public class BindVariableVisitor
extends LanguageVisitor {
    private List bindings;
    private QueryMetadataInterface metadata;
    private TeiidComponentException componentException;
    private QueryResolverException resolverException;

    public BindVariableVisitor(List bindings, QueryMetadataInterface metadata) {
        ArgCheck.isNotNull((Object)bindings, (String)QueryPlugin.Util.getString("ERR.015.008.0049"));
        this.bindings = bindings;
        this.metadata = metadata;
    }

    public TeiidComponentException getComponentException() {
        return this.componentException;
    }

    public QueryResolverException getResolverException() {
        return this.resolverException;
    }

    private void handleException(TeiidComponentException e) {
        this.componentException = e;
        this.setAbort(true);
    }

    private void handleException(QueryResolverException e) {
        this.resolverException = e;
        this.setAbort(true);
    }

    @Override
    public void visit(Reference obj) {
        this.bindReference(obj);
    }

    private void bindReference(Reference obj) {
        int index = obj.getIndex();
        String binding = (String)this.bindings.get(index);
        try {
            this.bindReference(obj, binding);
        }
        catch (QueryParserException e) {
            this.handleException(new QueryResolverException(QueryPlugin.Util.getString("ERR.015.008.0022"), e.getMessage()));
        }
        catch (QueryMetadataException e) {
            this.handleException(new TeiidComponentException((Throwable)((Object)e), e.getMessage()));
        }
        catch (QueryResolverException e) {
            this.handleException(e);
        }
        catch (TeiidComponentException e) {
            this.handleException(e);
        }
    }

    @Override
    public void visit(StoredProcedure storedProcedure) {
        for (SPParameter param : storedProcedure.getParameters()) {
            if (param.getParameterType() != 1 && param.getParameterType() != 3 || !(param.getExpression() instanceof Reference)) continue;
            this.bindReference((Reference)param.getExpression());
        }
    }

    private void bindReference(Reference reference, String binding) throws QueryParserException, QueryResolverException, QueryMetadataException, TeiidComponentException {
        Expression expr = QueryParser.getQueryParser().parseExpression(binding);
        if (!(expr instanceof ElementSymbol)) {
            throw new QueryResolverException("ERR.015.008.0025", QueryPlugin.Util.getString("ERR.015.008.0025", new Object[]{expr}));
        }
        ElementSymbol element = (ElementSymbol)expr;
        GroupSymbol groupSymbol = new GroupSymbol(this.metadata.getGroupName(element.getName()));
        ResolverUtil.resolveGroup(groupSymbol, this.metadata);
        ResolverVisitor.resolveLanguageObject(element, Arrays.asList(groupSymbol), this.metadata);
        reference.setExpression(element);
    }

    public static void bindReferences(LanguageObject obj, List bindings, QueryMetadataInterface metadata) throws QueryResolverException, TeiidComponentException {
        BindVariableVisitor visitor = new BindVariableVisitor(bindings, metadata);
        DeepPreOrderNavigator.doVisit(obj, visitor);
        if (visitor.getComponentException() != null) {
            throw visitor.getComponentException();
        }
        if (visitor.getResolverException() != null) {
            throw visitor.getResolverException();
        }
    }
}

