/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.sql.lang;

import java.util.Collection;
import org.teiid.query.sql.LanguageVisitor;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.lang.FromClause;
import org.teiid.query.sql.lang.SubqueryContainer;
import org.teiid.query.sql.symbol.GroupSymbol;

public class SubqueryFromClause
extends FromClause
implements SubqueryContainer {
    private GroupSymbol symbol;
    private Command command;
    private boolean table;

    public SubqueryFromClause(String name) {
        this.setName(name);
    }

    public SubqueryFromClause(String name, Command command) {
        this(name);
        this.command = command;
    }

    public SubqueryFromClause(GroupSymbol symbol, Command command) {
        this.symbol = symbol;
        this.command = command;
    }

    public boolean isTable() {
        return this.table;
    }

    public void setTable(boolean table) {
        this.table = table;
    }

    public void setName(String name) {
        this.symbol = new GroupSymbol(name);
    }

    public void setCommand(Command command) {
        this.command = command;
    }

    public Command getCommand() {
        return this.command;
    }

    public String getName() {
        return this.symbol.getName();
    }

    public String getOutputName() {
        return this.symbol.getOutputName();
    }

    public GroupSymbol getGroupSymbol() {
        return this.symbol;
    }

    @Override
    public void collectGroups(Collection groups) {
        groups.add(this.getGroupSymbol());
    }

    @Override
    public void acceptVisitor(LanguageVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof SubqueryFromClause)) {
            return false;
        }
        SubqueryFromClause sfc = (SubqueryFromClause)obj;
        return this.getName().equalsIgnoreCase(sfc.getName()) && sfc.isOptional() == this.isOptional() && this.command.equals(sfc.command) && this.table == sfc.table;
    }

    public int hashCode() {
        return this.symbol.hashCode();
    }

    @Override
    public Object clone() {
        Command commandCopy = null;
        if (this.command != null) {
            commandCopy = (Command)this.command.clone();
        }
        SubqueryFromClause clause = new SubqueryFromClause(this.symbol.clone(), commandCopy);
        clause.setOptional(this.isOptional());
        clause.setMakeDep(this.isMakeDep());
        clause.setMakeNotDep(this.isMakeNotDep());
        clause.setTable(this.isTable());
        return clause;
    }
}

