/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.sql.navigator;

import java.util.Collection;
import org.teiid.query.sql.LanguageObject;
import org.teiid.query.sql.LanguageVisitor;

public class AbstractNavigator
extends LanguageVisitor {
    private LanguageVisitor visitor;

    public AbstractNavigator(LanguageVisitor visitor) {
        this.visitor = visitor;
    }

    public LanguageVisitor getVisitor() {
        return this.visitor;
    }

    protected void visitVisitor(LanguageObject obj) {
        if (this.visitor.shouldAbort()) {
            return;
        }
        obj.acceptVisitor(this.visitor);
    }

    protected void visitNode(LanguageObject obj) {
        if (this.visitor.shouldAbort()) {
            return;
        }
        if (obj != null) {
            obj.acceptVisitor(this);
        }
    }

    protected void visitNodes(Collection<? extends LanguageObject> nodes) {
        if (this.visitor.shouldAbort()) {
            return;
        }
        if (nodes != null && nodes.size() > 0) {
            for (LanguageObject languageObject : nodes) {
                this.visitNode(languageObject);
            }
        }
    }
}

