/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.sql.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.teiid.api.exception.query.QueryMetadataException;
import org.teiid.core.TeiidComponentException;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.metadata.TempMetadataAdapter;
import org.teiid.query.metadata.TempMetadataStore;
import org.teiid.query.sql.LanguageObject;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.lang.QueryCommand;
import org.teiid.query.sql.lang.SetQuery;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.query.sql.visitor.CommandCollectorVisitor;
import org.teiid.query.sql.visitor.ElementCollectorVisitor;
import org.teiid.query.sql.visitor.GroupCollectorVisitor;

public class ElementSymbolOptimizer {
    private ElementSymbolOptimizer() {
    }

    private static void getExposedCommands(Command command, List commandList) {
        block3: {
            block2: {
                if (!(command instanceof SetQuery)) break block2;
                SetQuery setQuery = (SetQuery)command;
                for (QueryCommand setQueryCommand : setQuery.getQueryCommands()) {
                    ElementSymbolOptimizer.getExposedCommands(setQueryCommand, commandList);
                }
                break block3;
            }
            commandList.add(command);
            List<Command> subCommands = CommandCollectorVisitor.getCommands(command);
            if (subCommands == null || subCommands.size() <= 0) break block3;
            for (int i = 0; i < subCommands.size(); ++i) {
                Command subCommand = subCommands.get(i);
                ElementSymbolOptimizer.getExposedCommands(subCommand, commandList);
            }
        }
    }

    public static void fullyQualifyElements(Command command) {
        ArrayList commandsToQualify = new ArrayList();
        ElementSymbolOptimizer.getExposedCommands(command, commandsToQualify);
        for (int i = 0; i < commandsToQualify.size(); ++i) {
            Command currentCommand = (Command)commandsToQualify.get(i);
            Collection<ElementSymbol> elements = ElementCollectorVisitor.getElements((LanguageObject)currentCommand, false);
            for (ElementSymbol element : elements) {
                ElementSymbolOptimizer.fullyQualifyElement(element);
            }
        }
    }

    private static void fullyQualifyElement(ElementSymbol element) {
        element.setDisplayFullyQualified(true);
    }

    public static void optimizeElements(Command command, QueryMetadataInterface metadata) throws QueryMetadataException, TeiidComponentException {
        ArrayList commandsToOptimize = new ArrayList();
        ElementSymbolOptimizer.getExposedCommands(command, commandsToOptimize);
        for (int i = 0; i < commandsToOptimize.size(); ++i) {
            Command currentCommand = (Command)commandsToOptimize.get(i);
            TempMetadataAdapter facade = new TempMetadataAdapter(metadata, new TempMetadataStore(currentCommand.getTemporaryMetadata()));
            List<GroupSymbol> externalGroups = currentCommand.getAllExternalGroups();
            Collection<GroupSymbol> groups = GroupCollectorVisitor.getGroups((LanguageObject)currentCommand, false);
            ElementSymbolOptimizer.optimizeElements(currentCommand, groups, externalGroups, facade);
        }
    }

    private static boolean isXMLCommand(Command command, QueryMetadataInterface metadata) throws QueryMetadataException, TeiidComponentException {
        Collection<GroupSymbol> groups = GroupCollectorVisitor.getGroups((LanguageObject)command, true);
        if (groups.size() != 1) {
            return false;
        }
        GroupSymbol group = groups.iterator().next();
        return metadata.isXMLGroup(group.getMetadataID());
    }

    private static void optimizeElements(Command command, Collection groups, Collection externalGroups, QueryMetadataInterface metadata) throws QueryMetadataException, TeiidComponentException {
        switch (command.getType()) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                ElementSymbolOptimizer.optimizeCommand(command, groups, externalGroups, metadata);
                break;
            }
        }
    }

    private static void optimizeCommand(Command command, Collection groups, Collection externalGroups, QueryMetadataInterface metadata) throws QueryMetadataException, TeiidComponentException {
        if (ElementSymbolOptimizer.isXMLCommand(command, metadata)) {
            return;
        }
        boolean REMOVE_DUPLICATES = false;
        Collection<ElementSymbol> elements = ElementCollectorVisitor.getElements((LanguageObject)command, false);
        Map shortNameMap = ElementSymbolOptimizer.mapShortNamesToGroups(groups, externalGroups, metadata);
        for (ElementSymbol element : elements) {
            String elementFullName = metadata.getFullName(element.getMetadataID());
            String shortNameKey = metadata.getShortElementName(elementFullName).toUpperCase();
            Set groupSet = (Set)shortNameMap.get(shortNameKey);
            if (groupSet == null || groupSet.size() > 1) continue;
            element.setDisplayFullyQualified(false);
        }
    }

    private static Map mapShortNamesToGroups(Collection groups, Collection externalGroups, QueryMetadataInterface metadata) throws QueryMetadataException, TeiidComponentException {
        HashMap<String, HashSet<GroupSymbol>> result = new HashMap<String, HashSet<GroupSymbol>>();
        ArrayList allGroups = new ArrayList(groups);
        allGroups.addAll(externalGroups);
        for (GroupSymbol group : allGroups) {
            Iterator elemIDs = metadata.getElementIDsInGroupID(group.getMetadataID()).iterator();
            while (elemIDs.hasNext()) {
                ElementSymbol element = new ElementSymbol(metadata.getFullName(elemIDs.next()));
                String shortNameKey = element.getShortName().toUpperCase();
                HashSet<GroupSymbol> groupSet = (HashSet<GroupSymbol>)result.get(shortNameKey);
                if (groupSet == null) {
                    groupSet = new HashSet<GroupSymbol>();
                    result.put(shortNameKey, groupSet);
                }
                groupSet.add(group);
            }
        }
        return result;
    }
}

