/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.sql.visitor;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import org.teiid.query.QueryPlugin;
import org.teiid.query.sql.LanguageObject;
import org.teiid.query.sql.LanguageVisitor;
import org.teiid.query.sql.navigator.DeepPreOrderNavigator;
import org.teiid.query.sql.navigator.PreOrderNavigator;
import org.teiid.query.sql.symbol.AllInGroupSymbol;
import org.teiid.query.sql.symbol.AllSymbol;
import org.teiid.query.sql.symbol.ElementSymbol;

public class ElementCollectorVisitor
extends LanguageVisitor {
    private Collection<ElementSymbol> elements;

    public ElementCollectorVisitor(Collection<ElementSymbol> elements) {
        if (elements == null) {
            throw new IllegalArgumentException(QueryPlugin.Util.getString("ERR.015.010.0021"));
        }
        this.elements = elements;
    }

    public Collection<ElementSymbol> getElements() {
        return this.elements;
    }

    @Override
    public void visit(ElementSymbol obj) {
        this.elements.add(obj);
    }

    @Override
    public void visit(AllInGroupSymbol obj) {
        if (obj.getElementSymbols() != null) {
            this.elements.addAll(obj.getElementSymbols());
        }
    }

    @Override
    public void visit(AllSymbol obj) {
        if (obj.getElementSymbols() != null) {
            this.elements.addAll(obj.getElementSymbols());
        }
    }

    public static final void getElements(LanguageObject obj, Collection<ElementSymbol> elements) {
        if (obj == null) {
            return;
        }
        ElementCollectorVisitor visitor = new ElementCollectorVisitor(elements);
        PreOrderNavigator.doVisit(obj, visitor);
    }

    public static final void getElements(Collection<? extends LanguageObject> objs, Collection<ElementSymbol> elements) {
        if (objs == null) {
            return;
        }
        ElementCollectorVisitor visitor = new ElementCollectorVisitor(elements);
        for (LanguageObject languageObject : objs) {
            PreOrderNavigator.doVisit(languageObject, visitor);
        }
    }

    public static final Collection<ElementSymbol> getElements(LanguageObject obj, boolean removeDuplicates) {
        return ElementCollectorVisitor.getElements(obj, removeDuplicates, false);
    }

    public static final Collection<ElementSymbol> getElements(LanguageObject obj, boolean removeDuplicates, boolean useDeepIteration) {
        if (obj == null) {
            return Collections.emptyList();
        }
        AbstractCollection elements = null;
        elements = removeDuplicates ? new HashSet() : new ArrayList();
        ElementCollectorVisitor visitor = null;
        if (useDeepIteration) {
            visitor = new ElementCollectorVisitor(elements);
            DeepPreOrderNavigator.doVisit(obj, visitor);
        } else {
            visitor = new ElementCollectorVisitor(elements);
            PreOrderNavigator.doVisit(obj, visitor);
        }
        return elements;
    }
}

