/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.tempdata;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.TreeSet;
import org.teiid.common.buffer.TupleBrowser;
import org.teiid.common.buffer.TupleSource;
import org.teiid.core.TeiidComponentException;
import org.teiid.logging.LogManager;
import org.teiid.query.processor.CollectionTupleSource;
import org.teiid.query.processor.relational.RelationalNode;
import org.teiid.query.sql.LanguageObject;
import org.teiid.query.sql.lang.CompareCriteria;
import org.teiid.query.sql.lang.Criteria;
import org.teiid.query.sql.lang.IsNullCriteria;
import org.teiid.query.sql.lang.MatchCriteria;
import org.teiid.query.sql.lang.OrderBy;
import org.teiid.query.sql.lang.OrderByItem;
import org.teiid.query.sql.lang.SetCriteria;
import org.teiid.query.sql.symbol.Constant;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.SingleElementSymbol;
import org.teiid.query.sql.visitor.ElementCollectorVisitor;
import org.teiid.query.tempdata.TempTable;

class IndexInfo {
    List<Object> lower = null;
    List<Object> upper = null;
    ArrayList<List<Object>> valueSet = new ArrayList();
    TempTable table;
    Boolean ordering;
    boolean covering;
    TupleSource valueTs;
    List<Criteria> nonCoveredCriteria = new LinkedList<Criteria>();
    List<Criteria> coveredCriteria = new LinkedList<Criteria>();

    public IndexInfo(TempTable table, List<? extends SingleElementSymbol> projectedCols, Criteria condition, OrderBy orderBy, boolean primary) {
        this.table = table;
        if (primary || this.table.getColumnMap().keySet().containsAll(projectedCols)) {
            this.covering = true;
        }
        if (table.getPkLength() > 0) {
            this.processCriteria(condition, primary);
            if (orderBy != null && (this.covering || this.table.getColumnMap().keySet().containsAll(orderBy.getSortKeys()))) {
                this.ordering = this.useIndexForOrderBy(orderBy);
            }
        }
    }

    private void processCriteria(Criteria condition, boolean primary) {
        List<Criteria> crits = Criteria.separateCriteriaByAnd(condition);
        if (!primary) {
            Iterator<Criteria> critIter = crits.iterator();
            while (critIter.hasNext()) {
                Criteria criteria = critIter.next();
                if (this.table.getColumnMap().keySet().containsAll(ElementCollectorVisitor.getElements((LanguageObject)criteria, false))) {
                    this.coveredCriteria.add(criteria);
                    continue;
                }
                this.covering = false;
                this.nonCoveredCriteria.add(criteria);
                critIter.remove();
            }
        }
        for (int i = 0; i < this.table.getPkLength(); ++i) {
            ElementSymbol keyColumn = this.table.getColumns().get(i);
            Iterator<Criteria> critIter = crits.iterator();
            while (critIter.hasNext()) {
                SetCriteria setCriteria;
                Criteria criteria = critIter.next();
                if (criteria instanceof CompareCriteria) {
                    CompareCriteria cc = (CompareCriteria)criteria;
                    if (cc.getOperator() == 2 || !(cc.getRightExpression() instanceof Constant)) {
                        critIter.remove();
                        continue;
                    }
                    if (!cc.getLeftExpression().equals(keyColumn)) continue;
                    this.addCondition(i, (Constant)cc.getRightExpression(), cc.getOperator());
                    critIter.remove();
                    continue;
                }
                if (criteria instanceof IsNullCriteria) {
                    IsNullCriteria inc = (IsNullCriteria)criteria;
                    if (inc.isNegated() || !inc.getExpression().equals(keyColumn)) continue;
                    this.addCondition(i, new Constant(null), 1);
                    critIter.remove();
                    continue;
                }
                if (i > 0) {
                    critIter.remove();
                    continue;
                }
                if (criteria instanceof MatchCriteria) {
                    MatchCriteria matchCriteria = (MatchCriteria)criteria;
                    if (matchCriteria.isNegated() || !matchCriteria.getLeftExpression().equals(keyColumn) || !(matchCriteria.getRightExpression() instanceof Constant)) continue;
                    Constant value = (Constant)matchCriteria.getRightExpression();
                    String pattern = (String)value.getValue();
                    boolean escaped = false;
                    StringBuilder prefix = new StringBuilder();
                    int j = 0;
                    while (i < pattern.length()) {
                        char character = pattern.charAt(j);
                        if (character == matchCriteria.getEscapeChar() && character != '\u0000') {
                            if (escaped) {
                                prefix.append(character);
                                escaped = false;
                            } else {
                                escaped = true;
                            }
                        } else {
                            if (character == '%' || character == '_') break;
                            prefix.append(character);
                        }
                        ++j;
                    }
                    if (prefix.length() <= 0) continue;
                    this.addCondition(i, new Constant(prefix.toString()), 6);
                    continue;
                }
                if (!(criteria instanceof SetCriteria) || !(setCriteria = (SetCriteria)criteria).getExpression().equals(keyColumn) || !setCriteria.isAllConstants()) continue;
                TreeSet values = (TreeSet)setCriteria.getValues();
                this.addSet(i, values);
            }
        }
    }

    void addCondition(int i, Constant value, int comparisionMode) {
        switch (comparisionMode) {
            case 1: {
                if (i == 0) {
                    this.valueSet.clear();
                    this.valueSet.add(new ArrayList(this.table.getPkLength()));
                }
                if (this.valueSet.size() == 1) {
                    this.valueSet.get(0).add(value.getValue());
                }
                this.lower = null;
                this.upper = null;
                break;
            }
            case 4: 
            case 6: {
                if (!this.valueSet.isEmpty()) break;
                if (i == 0) {
                    this.lower = new ArrayList<Object>(this.table.getPkLength());
                    this.lower.add(value.getValue());
                }
                if (this.lower == null || this.lower.size() != i) break;
                this.lower.add(value.getValue());
                break;
            }
            case 3: 
            case 5: {
                if (!this.valueSet.isEmpty()) break;
                if (i == 0) {
                    this.upper = new ArrayList<Object>(this.table.getPkLength());
                    this.upper.add(value.getValue());
                    break;
                }
                if (this.upper == null || this.upper.size() != i) break;
                this.upper.add(value.getValue());
            }
        }
    }

    void addSet(int i, TreeSet<Constant> values) {
        if (!this.valueSet.isEmpty()) {
            return;
        }
        if (i == 0) {
            for (Constant constant : values) {
                ArrayList<Object> value = new ArrayList<Object>(this.table.getPkLength());
                value.add(constant.getValue());
                this.valueSet.add(value);
            }
            this.lower = null;
            this.upper = null;
        }
    }

    private Boolean useIndexForOrderBy(OrderBy orderBy) {
        Boolean direction = null;
        int[] orderByIndexes = RelationalNode.getProjectionIndexes(this.table.getColumnMap(), orderBy.getSortKeys());
        for (int i = 0; i < this.table.getPkLength() && orderByIndexes.length > i; ++i) {
            if (orderByIndexes[i] == i) continue;
            return null;
        }
        for (OrderByItem item : orderBy.getOrderByItems()) {
            if (item.getNullOrdering() != null) {
                return null;
            }
            if (item.isAscending()) {
                if (direction == null) {
                    direction = true;
                    continue;
                }
                if (direction.booleanValue()) continue;
                return null;
            }
            if (direction == null) {
                direction = false;
                continue;
            }
            if (!direction.booleanValue()) continue;
            return null;
        }
        return direction;
    }

    TupleBrowser createTupleBrowser() throws TeiidComponentException {
        boolean direction = true;
        if (this.ordering != null) {
            LogManager.logDetail((String)"org.teiid.PROCESSOR", (Object[])new Object[]{"Using index for ordering"});
            direction = this.ordering;
        }
        if (this.valueTs != null) {
            LogManager.logDetail((String)"org.teiid.PROCESSOR", (Object[])new Object[]{"Using index value set"});
            return new TupleBrowser(this.table.getTree(), this.valueTs, direction);
        }
        if (!this.valueSet.isEmpty()) {
            LogManager.logDetail((String)"org.teiid.PROCESSOR", (Object[])new Object[]{"Using index value set"});
            CollectionTupleSource cts = null;
            cts = direction ? new CollectionTupleSource(this.valueSet.iterator()) : new CollectionTupleSource(new Iterator<List<Object>>(){
                ListIterator<List<Object>> iter;
                {
                    this.iter = IndexInfo.this.valueSet.listIterator(IndexInfo.this.valueSet.size());
                }

                @Override
                public boolean hasNext() {
                    return this.iter.hasPrevious();
                }

                @Override
                public List<Object> next() {
                    return this.iter.previous();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            });
            return new TupleBrowser(this.table.getTree(), cts, direction);
        }
        if (this.lower != null || this.upper != null) {
            LogManager.logDetail((String)"org.teiid.PROCESSOR", (Object[])new Object[]{"Using index for range query", this.lower, this.upper});
        }
        return new TupleBrowser(this.table.getTree(), this.lower, this.upper, direction);
    }
}

