/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.jdbc;

import java.sql.SQLException;
import java.util.Properties;
import junit.framework.TestCase;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.teiid.client.DQP;
import org.teiid.client.security.LogonResult;
import org.teiid.client.security.SessionToken;
import org.teiid.client.util.ResultsFuture;
import org.teiid.client.xa.XATransactionException;
import org.teiid.client.xa.XidImpl;
import org.teiid.jdbc.ConnectionImpl;
import org.teiid.net.ServerConnection;

public class TestConnection
extends TestCase {
    protected static final String STD_DATABASE_NAME = "QT_Ora9DS";
    protected static final int STD_DATABASE_VERSION = 1;
    static String serverUrl = "jdbc:metamatrix:QT_Ora9DS@mm://localhost:7001;version=1;user=metamatrixadmin;password=mm";

    public TestConnection(String name) {
        super(name);
    }

    public static ConnectionImpl getMMConnection() {
        ServerConnection mock = (ServerConnection)Mockito.mock(ServerConnection.class);
        DQP dqp = (DQP)Mockito.mock(DQP.class);
        try {
            Mockito.stub((Object)dqp.start((XidImpl)Mockito.anyObject(), Mockito.anyInt(), Mockito.anyInt())).toAnswer(new Answer(){

                public Object answer(InvocationOnMock invocation) throws Throwable {
                    return ResultsFuture.NULL_FUTURE;
                }
            });
            Mockito.stub((Object)dqp.rollback((XidImpl)Mockito.anyObject())).toAnswer(new Answer(){

                public Object answer(InvocationOnMock invocation) throws Throwable {
                    return ResultsFuture.NULL_FUTURE;
                }
            });
            Mockito.stub((Object)dqp.rollback()).toAnswer(new Answer(){

                public Object answer(InvocationOnMock invocation) throws Throwable {
                    return ResultsFuture.NULL_FUTURE;
                }
            });
        }
        catch (XATransactionException e) {
            throw new RuntimeException(e);
        }
        Mockito.stub((Object)mock.getService(DQP.class)).toReturn((Object)dqp);
        Properties props = new Properties();
        props.setProperty("VirtualDatabaseName", STD_DATABASE_NAME);
        props.setProperty("VirtualDatabaseVersion", String.valueOf(1));
        props.setProperty("user", "metamatrixadmin");
        Mockito.stub((Object)mock.getLogonResult()).toReturn((Object)new LogonResult(new SessionToken(1L, "metamatrixadmin"), STD_DATABASE_NAME, 1, "fake"));
        return new ConnectionImpl(mock, props, serverUrl);
    }

    public void testGetMetaData() throws Exception {
        TestConnection.assertNotNull((Object)TestConnection.getMMConnection().getMetaData());
    }

    public void testGetSchema() throws Exception {
        TestConnection.assertEquals((String)"Actual schema is not equql to the expected one. ", (String)STD_DATABASE_NAME, (String)TestConnection.getMMConnection().getVDBName());
    }

    public void testNativeSql() throws Exception {
        String sql = "SELECT * FROM BQT1.SmallA";
        TestConnection.assertEquals((String)"Actual schema is not equql to the expected one. ", (String)sql, (String)TestConnection.getMMConnection().nativeSQL(sql));
    }

    public void testGetUserName2() throws Exception {
        TestConnection.assertEquals((String)"Actual userName is not equal to the expected one. ", (String)"metamatrixadmin", (String)TestConnection.getMMConnection().getUserName());
    }

    public void testIsReadOnly() throws Exception {
        TestConnection.assertEquals((boolean)false, (boolean)TestConnection.getMMConnection().isReadOnly());
    }

    public void testSetReadOnly1() throws Exception {
        ConnectionImpl conn = TestConnection.getMMConnection();
        conn.setReadOnly(true);
        TestConnection.assertEquals((boolean)true, (boolean)conn.isReadOnly());
    }

    public void testSetReadOnly2() throws Exception {
        ConnectionImpl conn = TestConnection.getMMConnection();
        conn.setAutoCommit(false);
        try {
            conn.setReadOnly(true);
            TestConnection.fail((String)"Error Expected");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }
}

